/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.workbill.util;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.dao.DesignerData;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetaType;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.FileUtils;

public class MetaDataFileUtil {
    private static final String USER_HOME = ConfigurationUtil.getString((String)"user.home");
    private static final String DOWNLOADPATH = "KINGDEEDOWNLOAD";
    private static final Log log = LogFactory.getLog(MetaDataFileUtil.class);
    private static long LIMITSIZ = 0x500000L;
    private static final String SYSTEM_TYPE = "ssc-task-common";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZUNITID = "bizunitid";

    public static String exportMetaData(String bizAppId, String bizId, String bizNumber) {
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String bizAppNumber = appMeta.getNumber();
        String appVersion = appMeta.getAppElement().getVersion();
        String appNumberPath = USER_HOME + File.separator + DOWNLOADPATH + File.separator + bizAppNumber;
        String traceIdHash = Hashing.sha256().hashString((CharSequence)RequestContext.get().getTraceId(), Charsets.UTF_8).toString();
        String traceIdPath = appNumberPath + File.separator + traceIdHash;
        String localPath = traceIdPath + File.separator + "datamodel" + File.separator + appVersion + File.separator + "main" + File.separator + bizAppNumber;
        ArrayList fileList = new ArrayList();
        DevportalUtil.expFormMetadata((String)bizId, (String)localPath, (String)"EXPORT_PAGE");
        InputStream in = null;
        try {
            DevportalUtil.zipFiles((String)bizNumber, (String)localPath, fileList);
            String downloadFile = FileUtils.cleanString((String)(localPath + File.separator + bizNumber + ".zip"));
            Path downloadPath = Paths.get(DevportalUtil.checkFilePath((String)downloadFile), new String[0]);
            in = Files.newInputStream(downloadPath, new OpenOption[0]);
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(bizNumber + ".zip", in, 5000);
            return string;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5143\u6570\u636e\u5bfc\u51fa\u5f02\u5e38\u3002", (String)"MetaDataFileUtil_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        finally {
            try {
                String filePath;
                File traceIdFile;
                if (in != null) {
                    in.close();
                }
                if ((traceIdFile = new File(filePath = FileUtils.cleanString((String)traceIdPath.replace('.', '%').replace('/', '%')))).exists()) {
                    boolean appNumDelete;
                    AppUtils.deleteKd((File)traceIdFile);
                    String checkFilePath = FileUtils.cleanString((String)appNumberPath.replace('.', '%').replace('/', '%'));
                    File appNumberFile = new File(checkFilePath);
                    if (appNumberFile.listFiles().length == 0 && (appNumDelete = appNumberFile.delete())) {
                        log.info(appNumberFile + "delete:" + appNumDelete);
                    }
                }
            }
            catch (IOException ioExp) {
                log.error((Throwable)ioExp);
                AppUtils.addLog((String)"bos_formmeta", (String)"exportPageSource", (String)ioExp.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String importMetaData(InputStream inputStream, String bizAppId, String bizunitId) {
        String retInfo;
        ZipEntry zipEntry = null;
        String formId = null;
        String oldUnitId = null;
        String curRebuildFormId = "";
        String masterId = "";
        String pageNum = "";
        String number = "";
        JSONObject message = new JSONObject();
        long logId = DB.genGlobalLongId();
        try (TXHandle tx = TX.required((String)"mdl_MetaDataFileUtil_confirm");
             ZipInputStream zipIn = new ZipInputStream(inputStream);){
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                String metaName = zipEntry.getName();
                metaName = metaName.replace(File.separator, "/");
                log.info("metaName=" + metaName);
                int readLength = 0;
                int len = 0;
                byte[] buf = new byte[(int)LIMITSIZ];
                if (!metaName.endsWith("dym") && !metaName.endsWith("dymx")) continue;
                while ((readLength = zipIn.read()) != -1) {
                    buf[len] = (byte)readLength;
                    ++len;
                }
                String content = new String(buf, 0, len, StandardCharsets.UTF_8);
                if (metaName.endsWith("dym")) {
                    String metaType;
                    DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
                    serializer.setColloctionIgnorePKValue(true);
                    DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(content, null);
                    DesignMeta meta = (DesignMeta)deployNew.getDesignMetas().get(0);
                    String metaISV = meta.getIsv();
                    pageNum = meta.getNumber();
                    formId = deployNew.getId();
                    QFilter qFilter = new QFilter("form", "=", (Object)formId);
                    if (QueryServiceHelper.exists((String)"bos_devportal_unitrelform", (QFilter[])new QFilter[]{qFilter})) {
                        oldUnitId = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_unitrelform", (String)"bizunit", (QFilter[])new QFilter[]{qFilter}).getString("bizUnit");
                    }
                    curRebuildFormId = "2".equals(metaType = meta.getDevType()) ? (masterId = deployNew.getMasterId()) : formId;
                    if (StringUtils.isBlank((CharSequence)metaISV)) {
                        throw new KDException(new ErrorCode("devp_isv", String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u9875\u9762\"%s\"\u7684\u5f00\u53d1\u5546\u6807\u8bc6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MetaDataFileUtil_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), pageNum)), new Object[0]);
                    }
                    String appIsv = AppUtils.getIsvByAppId((String)bizAppId);
                    if (!appIsv.equals(metaISV)) {
                        throw new KDException(new ErrorCode("devp_isv", String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u9875\u9762\u201c%1$s\u201d\u7684\u5f00\u53d1\u5546\u6807\u8bc6\u4e3a\u201c%2$s\u201d\uff0c\u4e0e\u5f53\u524d\u5e94\u7528\u7684\u5f00\u53d1\u5546\u6807\u8bc6\u201c%3$s\u201d\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"MetaDataFileUtil_1", (String)SYSTEM_TYPE, (Object[])new Object[]{pageNum, metaISV, appIsv}), new Object[0])), new Object[]{ResManager.loadKDString((String)"\u90e8\u7f72\u9875\u9762\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\u3002", (String)"MetaDataFileUtil_6", (String)SYSTEM_TYPE, (Object[])new Object[0])});
                    }
                }
                List metaDataId = MetadataDao.deployMetadata((String)content, (String)bizunitId, (String)bizAppId);
                MetaDataFileUtil.writeLog(formId, pageNum, content, logId);
            }
        }
        try {
            ArrayList<String> formIdList = new ArrayList<String>();
            formIdList.add(curRebuildFormId);
            MetadataDao.clearSubRuntimeMeta(formIdList);
            MetadataDao.rebuildRuntimeMetaById((String)curRebuildFormId);
            number = MetadataDao.getNumberById((String)curRebuildFormId);
            message.put("SUCCESS", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"MetaDataFileUtil_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        catch (Exception runtimeException) {
            retInfo = String.format(ResManager.loadKDString((String)"\u8868\u5355\"%1$s\"\uff0c\u6784\u5efa\u8fd0\u884c\u671f\u5143\u6570\u636e\u5931\u8d25\uff1a%2$s", (String)"MetaDataFileUtil_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), StringUtils.isNotBlank((CharSequence)number) ? number : curRebuildFormId, runtimeException.getMessage());
            message.put("RUNTIMEERROR", (Object)retInfo);
        }
        message.put(BIZAPPID, (Object)bizAppId);
        message.put(BIZUNITID, (Object)bizunitId);
        message.put("bizpageid", formId);
        message.put("bizpagenumber", (Object)number);
        message.put("oldunitid", oldUnitId);
        return message.toJSONString();
    }

    private static void writeLog(String formId, String formNumber, String content, long logId) {
        try {
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            logService.addMetaLog(formId, formNumber, content, (int)MetaLogType.PageImport.getValue(), logId, (int)MetaType.Form.getValue());
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5143\u6570\u636e\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public static void updateTable(String workBillNum) {
        String metaDataId = MetadataDao.getIdByNumber((String)workBillNum, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)metaDataId, (MetaCategory)MetaCategory.Form);
        String lang = RequestContext.get().getLang().name();
        Map metaDataMap = formMeta.buildDesignMeta(lang);
        DesignerData designerData = new DesignerData();
        designerData.save(metaDataMap, metaDataMap);
    }
}

