/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.ssc.task.opplugin.TaskApproveSaveVoucherValidator;

public class TaskApproveSaveVoucherPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(TaskApproveSaveVoucherPlugin.class);
    private static final String APPID_FR = "0XINV40+SS9N";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new TaskApproveSaveVoucherValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        OperateOption operateOption = this.operateOption;
        this.operationResult.setShowMessage(false);
        String billnumber = operateOption.getVariableValue("billnumber");
        String billid = operateOption.getVariableValue("billid");
        Long tempid = Long.valueOf(operateOption.getVariableValue("tempid"));
        this.savevoucherop(billnumber, billid, tempid);
    }

    private void savevoucherop(String billnumber, String billid, Long tempId) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", "true");
        Map voucherOperate = null;
        try {
            if (billnumber.contains("fr_manualtallybill") && !this.isFrManualtallybillUseDap()) {
                voucherOperate = EntityMetadataCache.getDataEntityOperate((String)billnumber, (String)"genvoucher");
                option.setVariableValue("ismanualtallybill", "true");
            } else {
                if (billnumber.contains("fr_manualtallybill") && this.isFrManualtallybillUseDap()) {
                    option.setVariableValue("ismanualtallybill", "true");
                }
                voucherOperate = EntityMetadataCache.getDataEntityOperate((String)billnumber, (String)"generatevoucher");
                option.setVariableValue("ignorebillstatus", "true");
                log.info("kd.ssc.task.formplugin.voucher.TaskVoucherApproveFormPlugin.afterDoOperation\u6ce8\u5165ignorebillstatus\u53c2\u6570\uff1a" + option.getVariableValue("ignorebillstatus"));
            }
            if (null != tempId && tempId > 0L) {
                HashMap<String, List<Long>> tempids = new HashMap<String, List<Long>>(1);
                tempids.put("useTemp", Collections.singletonList(tempId));
                option.setVariableValue("tempId", SerializationUtils.toJsonString(tempids));
            }
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)((String)voucherOperate.get("key")), (String)billnumber, (Object[])new Object[]{billid}, (OperateOption)option);
            this.operationResult.setSuccess(operationResult.isSuccess());
            List allErrorInfo = operationResult.getAllErrorOrValidateInfo();
            StringBuilder sb = new StringBuilder();
            allErrorInfo.forEach(error -> sb.append(error.getMessage()));
            this.operationResult.setMessage(sb.toString());
        }
        catch (Exception e3) {
            log.info("\u751f\u6210\u51ed\u8bc1\u5931\u8d25\uff0c\u5355\u636eid\uff1a" + billid + "\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e3.getMessage() + "," + e3);
            this.operationResult.setSuccess(false);
            this.operationResult.setMessage(e3.getMessage());
        }
    }

    private boolean isFrManualtallybillUseDap() {
        boolean useDap = false;
        AppParam param = new AppParam(APPID_FR, Long.valueOf(((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId()));
        Object usedapObject = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"usedap");
        if (usedapObject instanceof Boolean) {
            useDap = (Boolean)usedapObject;
        }
        return useDap;
    }
}

