/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.cache.SscDistributeCache;
import kd.ssc.task.business.helper.TaskBillClassifyHelper;
import kd.ssc.task.opplugin.BizBillOrgValidator;
import kd.ssc.task.opplugin.TaskRuleSaveValidatorPlugin;
import kd.ssc.task.opplugin.VoucherHandlerValidator;
import kd.ssc.task.util.TaskRuleUtil;

public class TaskRuleSavePlugin
extends AbstractOperationServicePlugIn {
    private Set<Long> curChildPKs = new HashSet<Long>(3);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("ssccenter");
        fieldKeys.add("bindbill");
        fieldKeys.add("bindbill_new");
        fieldKeys.add("applycond");
        fieldKeys.add("sscbillorgpar");
        fieldKeys.add("effective");
        fieldKeys.add("group");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new TaskRuleSaveValidatorPlugin());
        e.addValidator((AbstractValidator)new BizBillOrgValidator());
        e.addValidator((AbstractValidator)new VoucherHandlerValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (DynamicObject dataEntity : e.getDataEntities()) {
            DynamicObject externalErp;
            Boolean isEmbed;
            DynamicObject bindBill = dataEntity.getDynamicObject("bindbill");
            if (bindBill == null) {
                dataEntity.set("bindbill.id", (Object)dataEntity.getString("bindbill_new.dentityid"));
            }
            if ((isEmbed = Boolean.valueOf(dataEntity.getBoolean("isembed"))) == null) {
                dataEntity.set("isembed", (Object)false);
            }
            if ((externalErp = dataEntity.getDynamicObject("externalerp")) != null) continue;
            dataEntity.set("externalerp.id", (Object)427215148743160832L);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null) {
            return;
        }
        Long taskbillId = (Long)dataEntities[0].getPkValue();
        QFilter idFil = new QFilter("id", "=", (Object)taskbillId);
        String algoKey = TaskRuleSavePlugin.class + ".beginOperationTransaction()";
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_taskbill", (String)"id, entryentity.childpkid childpkid", (QFilter[])new QFilter[]{idFil}, null);){
            for (Row row : dSet) {
                this.curChildPKs.add(row.getLong("childpkid"));
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null) {
            return;
        }
        HashSet<Long> newChildPKs = new HashSet<Long>(3);
        DynamicObjectCollection dynObjs = dataEntities[0].getDynamicObjectCollection("entryentity");
        for (DynamicObject dynObj : dynObjs) {
            newChildPKs.add(dynObj.getLong("childpkid"));
        }
        this.updateAllChildPageSomeInfo(dataEntities[0], newChildPKs);
        this.updateOpinionAndCoeff(dataEntities[0], (Long)dataEntities[0].getPkValue());
        this.curChildPKs.removeAll(newChildPKs);
        if (this.curChildPKs.size() > 0) {
            this.deleteTaskSubject(this.curChildPKs);
            QFilter childIdFil = new QFilter("id", "in", this.curChildPKs);
            DeleteServiceHelper.delete((String)"task_taskbill_child", (QFilter[])childIdFil.toArray());
        }
        String bindBill = dataEntities[0].getString("bindbill_new.number");
        Long parentId = ((DynamicObject)dataEntities[0].get("group")).getLong("parent.id");
        Map bindBillListMap = TaskBillClassifyHelper.getAllUpBindBillMapByClassify((Long)parentId);
        HashSet<Long> clearGroupIdSet = new HashSet<Long>();
        for (Map.Entry next : bindBillListMap.entrySet()) {
            Long key = (Long)next.getKey();
            List bindBillListItem = (List)next.getValue();
            if (!CollectionUtils.isNotEmpty((Collection)bindBillListItem) || bindBillListItem.contains(bindBill)) continue;
            clearGroupIdSet.add(key);
        }
        TaskBillClassifyHelper.clearBindBillByClassify(clearGroupIdSet);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        SscDistributeCache.remove((String)"ssc-task-billtype");
        SscDistributeCache.remove((String)"ssc-task-operation");
    }

    private void deleteTaskSubject(Set<Long> childPKs) {
        HashSet<Long> taskSubIds = new HashSet<Long>();
        String algoKey = TaskRuleSavePlugin.class + ".deleteTaskSubject()";
        QFilter idFil = new QFilter("id", "in", childPKs);
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_taskbill_child", (String)"id,tasksubjectid", (QFilter[])idFil.toArray(), null);){
            for (Row row : dSet) {
                taskSubIds.add(row.getLong("tasksubjectid"));
            }
        }
        if (taskSubIds.size() > 0) {
            QFilter subIdsFil = new QFilter("id", "in", taskSubIds);
            DeleteServiceHelper.delete((String)"task_tasksubject", (QFilter[])subIdsFil.toArray());
        }
    }

    private void updateAllChildPageSomeInfo(DynamicObject dataEntity, Set<Long> childPKs) {
        DynamicObject[] taskbillChildren;
        if (childPKs.size() == 0) {
            return;
        }
        String isNeed = dataEntity.getString("isneedimage");
        QFilter idFil = new QFilter("id", "in", childPKs);
        for (DynamicObject child : taskbillChildren = BusinessDataServiceHelper.load((String)"task_taskbill_child", (String)"id,needimage", (QFilter[])new QFilter[]{idFil})) {
            child.set("needimage", (Object)isNeed);
        }
        SaveServiceHelper.save((DynamicObject[])taskbillChildren);
    }

    private void updateOpinionAndCoeff(DynamicObject dataEntity, Long taskbillId) {
        DynamicObjectCollection entryCollection = dataEntity.getDynamicObjectCollection("entryentity");
        Object ssccenter = dataEntity.get("ssccenter");
        TaskRuleUtil.saveOpinionByEntryCol((Long)taskbillId, (DynamicObjectCollection)entryCollection, (Object)ssccenter);
        TaskRuleUtil.saveCoefficientsByEntry((Long)taskbillId, (DynamicObjectCollection)entryCollection, (Object)ssccenter);
    }
}

