/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.task.common.DisRuleDataSyncHelper;
import kd.ssc.task.formplugin.pojo.workcalendar.WorkCalendarTaskMessage;
import kd.ssc.task.formplugin.util.SscWorkCalendarLoadService;
import kd.ssc.task.opplugin.UserGroupSaveValidator;

public class UserGroupSavePlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new UserGroupSaveValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        List<Object> userGroupIds = Arrays.stream(dataEntities).map(dyn -> dyn.get("id")).collect(Collectors.toList());
        this.checkAndKeepDataDync(userGroupIds);
        for (DynamicObject dynamicObject : dataEntities) {
            DynamicObject createOrg = dynamicObject.getDynamicObject("createorg");
            Long groupId = dynamicObject.getLong("id");
            this.synchroData(createOrg, groupId);
        }
    }

    private void checkAndKeepDataDync(List<Object> userGroupIDs) {
        if (CollectionUtils.isEmpty(userGroupIDs)) {
            return;
        }
        Long userGroupId = (Long)userGroupIDs.get(0);
        String entityName = "task_disrule";
        String selectProperties = "id,number,name,ssccenter,priority,tasktype,entryentity.billtype,entryentity.filterrule,entryentity.filterrulejson_tag,entryentity.applycreditleveljoson_tag,entryentity1.usergroup,entryentity1.orgrange";
        QFilter userGroupFilter = new QFilter("entryentity1.usergroup", "=", (Object)userGroupId);
        DynamicObject[] disRuleDos = BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{userGroupFilter});
        DisRuleDataSyncHelper disRuleDataSyncHelper = new DisRuleDataSyncHelper();
        if (disRuleDos != null) {
            for (DynamicObject disRuleDo : disRuleDos) {
                disRuleDataSyncHelper.keepDataSyncByGroup(disRuleDo, userGroupId);
            }
        }
    }

    private void synchroData(DynamicObject ssc, Long groupId) {
        List userIds = SscWorkCalendarLoadService.getUserIdList((String)(groupId + ""));
        if (!userIds.isEmpty()) {
            try (MessagePublisher pub = MQFactory.get().createSimplePublisher("ssc", "kd.ssc.task.ssc_workcalendar_queue");){
                pub.publish((Object)new WorkCalendarTaskMessage(ssc.getPkValue() + "", groupId + "", userIds, null, null, "usergroup"));
            }
        }
    }
}

