/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.achieve;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.enums.achieve.TargetRule;

public class CalFactorDeleteValidator
extends AbstractValidator {
    public void validate() {
        Map<String, String> calFacotrAchieveTargetMap = this.usedCalFactor();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Boolean isPreset = dynamicObject.getBoolean("ispreset");
            if (isPreset.booleanValue()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u7f6e\u8ba1\u7b97\u56e0\u5b50\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CalFactorDeleteValidator_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                continue;
            }
            String number = dynamicObject.getString("number");
            String useThisAchieveTarget = calFacotrAchieveTargetMap.get(number);
            if (StringUtils.isEmpty((String)useThisAchieveTarget)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8be5\u8ba1\u7b97\u56e0\u5b50\u88ab\u7ee9\u6548\u6307\u6807%s\u6240\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"CalFactorDeleteValidator_1", (String)"ssc-task-opplugin", (Object[])new Object[0]), useThisAchieveTarget));
        }
    }

    private Map<String, String> usedCalFactor() {
        HashMap<String, String> calFacotrAchieveTargetMap = new HashMap<String, String>(10);
        QFilter calIndicator = new QFilter("targettype", "=", (Object)"0");
        DynamicObjectCollection sscAchieveTargets = QueryServiceHelper.query((String)"ssc_achievetarget", (String)"id,number,name,ruleexpjson_tag", (QFilter[])new QFilter[]{calIndicator});
        for (DynamicObject sscAchieveTarget : sscAchieveTargets) {
            String ruleexpjson = sscAchieveTarget.getString("ruleexpjson_tag");
            TargetRule targetRule = (TargetRule)SerializationUtils.fromJsonString((String)ruleexpjson, TargetRule.class);
            BOSExpression bosExpression = new BOSExpression(targetRule.getExpression());
            String name = sscAchieveTarget.getString("name");
            Set vars = bosExpression.getVars();
            for (String var : vars) {
                if (calFacotrAchieveTargetMap.containsKey(var)) continue;
                calFacotrAchieveTargetMap.put(var, name);
            }
        }
        return calFacotrAchieveTargetMap;
    }
}

