/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.achieve;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.StringUtils;
import kd.sdk.fi.ssc.extpoint.achieve.ICustomAchieveFactorPlugin;

public class CalFactorSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject calFactor = dataEntity.getDataEntity();
            String number = calFactor.getString("number");
            if (!CalFactorSaveValidator.checkEngLetter(number)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u4ee5\u82f1\u6587\u5b57\u6bcd\u5f00\u5934\uff0c\u53ef\u5305\u542b\u5927\u5c0f\u5199\u82f1\u6587\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3002", (String)"CalFactorSaveValidator_5", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                continue;
            }
            String dataSource = calFactor.getString("datasource");
            if ("1".equals(dataSource)) {
                String fieldMapping = calFactor.getString("fieldmapping");
                if (StringUtils.isEmpty((String)fieldMapping)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ee9\u6548\u8003\u6838\u65f6\u95f4\u53c2\u6570\u6620\u5c04\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CalFactorSaveValidator_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                    continue;
                }
                Map fieldMap = (Map)SerializationUtils.fromJsonString((String)fieldMapping, Map.class);
                boolean dimCheck = false;
                for (int i = 0; i <= 3; ++i) {
                    boolean mappingEmpty;
                    Map mapping = (Map)fieldMap.get(String.valueOf(i));
                    boolean bl = mappingEmpty = mapping == null || StringUtils.isEmpty((String)((String)mapping.get("fieldNumber")));
                    if (i == 0 && mappingEmpty) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ee9\u6548\u8003\u6838\u65f6\u95f4\u53c2\u6570\u6620\u5c04\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CalFactorSaveValidator_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                    }
                    if (i == 0 || mappingEmpty) continue;
                    dimCheck = true;
                }
                if (dimCheck) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7528\u6237\u53c2\u6570\u6620\u5c04\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CalFactorSaveValidator_1", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                continue;
            }
            String javaPlugin = calFactor.getString("javaplugin");
            try {
                Object javaPluginInstance = Class.forName(javaPlugin).newInstance();
                if (javaPluginInstance instanceof ICustomAchieveFactorPlugin) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u63d2\u4ef6\u672a\u5b9e\u73b0ICustomAchieveFactorPlugin\u63a5\u53e3\u3002", (String)"CalFactorSaveValidator_2", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            }
            catch (ClassNotFoundException e) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be5Java\u63d2\u4ef6\u3002", (String)"CalFactorSaveValidator_3", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b9e\u4f8b\u5316\u8be5\u7c7b\u5931\u8d25\u3002", (String)"CalFactorSaveValidator_4", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private static boolean checkEngLetter(String passengerName) {
        if (passengerName == null || passengerName.isEmpty()) {
            return true;
        }
        String eng = "^[a-zA-Z][a-zA-Z0-9_]*$";
        Pattern pattern = Pattern.compile(eng);
        Matcher matcher = pattern.matcher(passengerName);
        return matcher.matches();
    }
}

