/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.smartcs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.ssc.smartcs.dto.ExcpDto;
import kd.ssc.smartcs.enums.ExcpStateEnum;
import kd.ssc.smartcs.result.AreaResult;
import kd.ssc.smartcs.util.AIMetaDataSynchrnizedUtil;
import kd.ssc.smartcs.util.ExceptionHandler;
import kd.ssc.task.opplugin.smartcs.AreaSaveValidator;

public class AreaSavePlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(AreaSavePlugin.class);
    private static final String POWERD_ORG = "usessc";
    private static final String POWERD_ROLE = "roles";
    private static final String DESCRIPTION = "description";
    private static final String AI_AREA_ID = "aiareaid";
    private static final String AI_QA_ID = "aiqaid";
    private static final String CREATEORG_ID = "createorg_id";
    private Set<Long> updateDataIds = new HashSet<Long>(1);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fields = e.getFieldKeys();
        fields.add(POWERD_ORG);
        fields.add(POWERD_ROLE);
        fields.add(DESCRIPTION);
        fields.add(AI_AREA_ID);
        fields.add(AI_QA_ID);
        fields.add(CREATEORG_ID);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AreaSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        if (this.getOption().containsVariable("from_sync")) {
            return;
        }
        List datas = e.getValidExtDataEntities();
        for (ExtendedDataEntity data : datas) {
            boolean updateObj = data.getDataEntity().getDataEntityState().getFromDatabase();
            if (!updateObj) continue;
            this.updateDataIds.add((Long)data.getDataEntity().getPkValue());
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] saveSuccessDyn = e.getDataEntities();
        if (saveSuccessDyn == null || saveSuccessDyn.length == 0) {
            return;
        }
        ArrayList<DynamicObject> continueSaveDynList = new ArrayList<DynamicObject>(Arrays.asList(saveSuccessDyn));
        for (DynamicObject dyo : saveSuccessDyn) {
            try {
                this.synEachArea(dyo);
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
                continueSaveDynList.remove(dyo);
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setLevel(ErrorLevel.Error);
                errorInfo.setMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8bbf\u95ee\u201c\u5171\u4eab\u5ba2\u670d\u673a\u5668\u4eba>\u5f02\u5e38\u65e5\u5fd7\u201d\u67e5\u770b\u5f02\u5e38\u62a5\u9519\u4fe1\u606f\u3002", (String)"AreaSavePlugin_6", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                errorInfo.setTitle(ResManager.loadKDString((String)"\u77e5\u8bc6\u9886\u57df\u540c\u6b65", (String)"AreaSavePlugin_4", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                this.operationResult.addErrorInfo(errorInfo);
                ExceptionHandler.saveErrLog((String)dyo.getDataEntityType().getName(), (Object)dyo.getPkValue(), (Throwable)ex);
            }
        }
        e.setDataEntities(continueSaveDynList.toArray(new DynamicObject[0]));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] saveSuccessDyn = e.getDataEntities();
        if (saveSuccessDyn == null || saveSuccessDyn.length == 0) {
            return;
        }
        this.assignOrg(saveSuccessDyn);
    }

    @Deprecated
    private void rewriteAIInfo(DynamicObject[] saveSuccessDyn) {
    }

    private void synEachArea(DynamicObject dyo) {
        Long id = (Long)dyo.getPkValue();
        String number = dyo.getString("number");
        String name = dyo.getString("name");
        String description = dyo.getString(DESCRIPTION);
        Map<Long, String> useOrgs = this.getUseOrgInfo(dyo);
        Map<String, String> useRoles = this.getUseRoleInfo(dyo);
        if (this.updateDataIds.contains(id)) {
            long aiAreaId = dyo.getLong(AI_AREA_ID);
            if (aiAreaId == 0L) {
                ErrorCode code = new ErrorCode(ExcpStateEnum.DataOutOfSync.getValue(), ResManager.loadKDString((String)"\u66f4\u65b0\u9886\u57df\u65f6\uff0c\u65e0\u6cd5\u83b7\u53d6AI\u9886\u57dfID\u3002", (String)"AreaSavePlugin_5", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                throw new KDException(code, new Object[0]);
            }
            AIMetaDataSynchrnizedUtil.updateArea((Long)aiAreaId, (String)name, (String)number, (String)description, useOrgs, useRoles);
        } else {
            AreaResult result = AIMetaDataSynchrnizedUtil.addArea((String)name, (String)number, (String)description, useOrgs, useRoles);
            dyo.set(AI_AREA_ID, (Object)result.getId());
            dyo.set(AI_QA_ID, (Object)result.getQaId());
        }
    }

    private void assignOrg(DynamicObject[] saveSuccessDyn) {
        for (DynamicObject dyo : saveSuccessDyn) {
            try {
                Long pkid = (Long)dyo.getPkValue();
                this.allCancelAssign(pkid);
                this.assignOrgForSingle(dyo);
            }
            catch (Exception e) {
                this.saveAssignErrLog(dyo, e);
            }
        }
    }

    private boolean assignOrgForSingle(DynamicObject dyo) {
        boolean assignSuccess = true;
        Long pkid = (Long)dyo.getPkValue();
        String entity = this.billEntityType.getName();
        Long mainOrg = this.getMainOrgId(dyo);
        DynamicObjectCollection assignSsc = dyo.getDynamicObjectCollection(POWERD_ORG);
        ArrayList<Long> orgIds = new ArrayList<Long>(assignSsc.size() - 1);
        for (DynamicObject orgdyo : assignSsc) {
            Object orgid = orgdyo.get("fbasedataid_id");
            if (!(orgid instanceof Long) || orgid.equals(mainOrg)) continue;
            orgIds.add((Long)orgid);
        }
        ArrayList<Long> dataIds = new ArrayList<Long>(1);
        dataIds.add(pkid);
        assignSuccess = this.assign(entity, mainOrg, dataIds, orgIds);
        return assignSuccess;
    }

    private Long getMainOrgId(DynamicObject dyo) {
        String orgField = this.billEntityType.getMainOrg();
        Object mainOrg = dyo.get(orgField);
        if (mainOrg instanceof DynamicObject) {
            return (Long)((DynamicObject)mainOrg).getPkValue();
        }
        if (mainOrg instanceof Long) {
            return (Long)mainOrg;
        }
        if (mainOrg == null && (mainOrg = dyo.get(CREATEORG_ID)) instanceof Long) {
            return (Long)mainOrg;
        }
        return 0L;
    }

    private boolean assign(String entity, Long mainOrgId, List<Long> dataIds, List<Long> orgIds) {
        boolean assignSuccess = true;
        Map checkAssignRes = BaseDataServiceHelper.batchAssignWithDetail((String)entity, (Long)mainOrgId, dataIds, new ArrayList<Long>(orgIds));
        if (checkAssignRes != null && checkAssignRes.size() > 0) {
            assignSuccess = false;
            this.handleErrAssign(checkAssignRes);
        }
        return assignSuccess;
    }

    private void handleErrAssign(Map<Long, Map<Long, String>> checkAssignRes) {
        HashMap<Long, String> assignErrMap = new HashMap<Long, String>(1);
        for (Map.Entry<Long, Map<Long, String>> entry : checkAssignRes.entrySet()) {
            Long dataId = entry.getKey();
            Map<Long, String> errMsgMap = entry.getValue();
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(ResManager.loadKDString((String)"\u77e5\u8bc6\u9886\u57df(%s)", (String)"AreaSavePlugin_0", (String)"ssc-task-opplugin", (Object[])new Object[0]), dataId));
            sb.append(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u5931\u8d25", (String)"AreaSavePlugin_1", (String)"ssc-task-opplugin", (Object[])new Object[0])).append('\n');
            for (Map.Entry<Long, String> childEntry : errMsgMap.entrySet()) {
                Long orgId = childEntry.getKey();
                String errMsg = childEntry.getValue();
                sb.append(String.format(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7(%1$s)\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"AreaSavePlugin_2", (String)"ssc-task-opplugin", (Object[])new Object[0]), orgId, errMsg));
                sb.append("\n");
            }
            assignErrMap.put(dataId, sb.toString());
        }
        this.saveAssignErr(assignErrMap);
    }

    private void saveAssignErr(Map<Long, String> assignErrMap) {
        ArrayList<ExcpDto> dtos = new ArrayList<ExcpDto>(1);
        for (Map.Entry<Long, String> entry : assignErrMap.entrySet()) {
            ExcpDto dto = new ExcpDto();
            dto.setEntityNum("som_knowledge_area");
            dto.setDataId(entry.getKey() + "");
            dto.setErrorState(ExcpStateEnum.SynAuthorOrg.getValue());
            dto.setErrorInfo("");
            dto.setErrorStack(entry.getValue());
            dtos.add(dto);
        }
        ExcpDto.batchSave2DB(dtos);
    }

    private void saveAssignErrLog(DynamicObject dyo, Exception e) {
        ExcpDto dto = new ExcpDto();
        String entity = dyo.getDataEntityType().getName();
        dto.setEntityNum(entity);
        dto.setDataId(dyo.getPkValue() + "");
        dto.setErrorState(ExcpStateEnum.SynAuthorOrg.getValue());
        dto.setErrorInfo(e.getMessage());
        dto.setErrorStack(Arrays.toString(e.getStackTrace()));
        dto.save2DB();
    }

    private void allCancelAssign(Long pkid) {
        String dataTableName = this.billEntityType.getAlias();
        String dataTableUseName = dataTableName + "UseReg";
        StringBuilder assignSql = new StringBuilder("SELECT FUSEORGID FROM ");
        assignSql.append(dataTableUseName);
        assignSql.append(" WHERE FDATAID = ");
        assignSql.append(pkid);
        assignSql.append(" AND FCREATEORGID <> FUSEORGID");
        String dbRouteKey = this.billEntityType.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        List useOrgIdList = (List)DB.query((DBRoute)dbRoute, (String)assignSql.toString(), (ResultSetHandler)new /* Unavailable Anonymous Inner Class!! */);
        StringBuilder delAssignSql = new StringBuilder("DELETE FROM ");
        delAssignSql.append(dataTableUseName);
        delAssignSql.append(" WHERE FDATAID = ");
        delAssignSql.append(pkid);
        delAssignSql.append(" AND FCREATEORGID <> FUSEORGID");
        DB.execute((DBRoute)dbRoute, (String)delAssignSql.toString());
        BaseDataServiceHelper.refreshBaseDataUseRange((String)this.billEntityType.getName(), (List)useOrgIdList);
    }

    private Map<Long, String> getUseOrgInfo(DynamicObject dyo) {
        List<Long> useOrgIds = this.getSscIdList(dyo);
        HashMap<Long, String> result = new HashMap<Long, String>(useOrgIds.size());
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"bos_org", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", useOrgIds)});
        if (!dyos.isEmpty()) {
            for (DynamicObject org : dyos) {
                Long orgId = org.getLong("id");
                String orgName = org.get("name") + "";
                result.put(orgId, orgName);
            }
        }
        return result;
    }

    private Map<String, String> getUseRoleInfo(DynamicObject dyo) {
        HashMap<String, String> useRoleInfoMap = new HashMap<String, String>(4);
        List<String> roleIds = this.getRoleIdList(dyo);
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"perm_role", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", roleIds)});
        if (!dyos.isEmpty()) {
            for (DynamicObject role : dyos) {
                String roleId = role.getString("id");
                String roleName = role.getString("name");
                useRoleInfoMap.put(roleId, roleName);
            }
        }
        return useRoleInfoMap;
    }

    private List<Long> getSscIdList(DynamicObject dyo) {
        DynamicObjectCollection assignSsc = dyo.getDynamicObjectCollection(POWERD_ORG);
        ArrayList<Long> ids = new ArrayList<Long>(assignSsc.size());
        for (DynamicObject orgdyo : assignSsc) {
            Object orgid = orgdyo.get("fbasedataid_id");
            if (!(orgid instanceof Long)) continue;
            ids.add((Long)orgid);
        }
        return ids;
    }

    private List<String> getRoleIdList(DynamicObject dyo) {
        DynamicObjectCollection roles = dyo.getDynamicObjectCollection(POWERD_ROLE);
        ArrayList<String> ids = new ArrayList<String>(2);
        for (DynamicObject role : roles) {
            Object roleId = role.get("fbasedataid_id");
            if (!(roleId instanceof String)) continue;
            ids.add((String)roleId);
        }
        return ids;
    }
}

