/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.smartcs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.ssc.smartcs.enums.ExcpStateEnum;
import kd.ssc.smartcs.result.QuestionResult;
import kd.ssc.smartcs.util.AIMetaDataSynchrnizedUtil;
import kd.ssc.smartcs.util.ExceptionHandler;
import kd.ssc.task.opplugin.smartcs.InfoSaveValidator;
import kd.ssc.task.opplugin.smartcs.util.ErrorMsgBuilder;

public class InfoSavePlugin
extends AbstractOperationServicePlugIn {
    private static final String AREA = "area";
    private static final String SUBJECT = "group";
    private static final String IS_SUBJECT = "subject";
    private static final String AI_SUBJECT_ID = "aisubjectid";
    private static final String AI_QUESTION_ID = "aiquestionid";
    private static final String QUESTION = "question";
    private static final String ANSWER = "answer";
    private static final String KEYWORDS = "keyword";
    private static final String ENTRY = "quesentry";
    private static final String CREATOR = "creator";
    private static final String CREATE_TIME = "createtime";
    private static final String MODIFIER = "modifier";
    private static final String MODIFY_TIME = "modifytime";
    private static final String LINK_NAME = "linktitle";
    private static final String LINK_ADDRESS = "link";
    private static final String ATTACHMENT = "attachment";
    private static final String REBORT = "rebortuse";
    private static final String SIM_QUESTION = "similarques";
    private static final String SYNATTACHMENT = "synattachment";
    private static final String URLSUFFIX = "/index.html?formId=som_smartcs_attach&attachId=";
    private static final String URLSUFFIX_MOBILE = "/mobile.html?form=som_smartcs_attach_mb&attachId=";
    private String domainContextURL;
    private Set<Long> updateDataIds = new HashSet<Long>(1);
    private static final Log log = LogFactory.getLog((String)"InfoSavePlugin");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fields = e.getFieldKeys();
        fields.add(AREA);
        fields.add(SUBJECT);
        fields.add(IS_SUBJECT);
        fields.add(AI_SUBJECT_ID);
        fields.add(QUESTION);
        fields.add(ANSWER);
        fields.add(KEYWORDS);
        fields.add(ENTRY);
        fields.add(CREATOR);
        fields.add(CREATE_TIME);
        fields.add(MODIFIER);
        fields.add(MODIFY_TIME);
        fields.add(LINK_NAME);
        fields.add(LINK_ADDRESS);
        fields.add(ATTACHMENT);
        fields.add(REBORT);
        fields.add(AI_QUESTION_ID);
        fields.add(SYNATTACHMENT);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new InfoSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        if (this.getOption().containsVariable("from_sync")) {
            return;
        }
        List datas = e.getValidExtDataEntities();
        for (ExtendedDataEntity data : datas) {
            DynamicObject dyo;
            long aiQuestionId;
            boolean updateObj = data.getDataEntity().getDataEntityState().getFromDatabase();
            if (!updateObj || (aiQuestionId = this.getAIQuestionId(dyo = data.getDataEntity()).longValue()) <= 0L) continue;
            this.updateDataIds.add((Long)data.getDataEntity().getPkValue());
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] saveSuccessDyn = e.getDataEntities();
        if (saveSuccessDyn == null || saveSuccessDyn.length == 0) {
            return;
        }
        this.domainContextURL = UrlService.getDomainContextUrl();
        ArrayList<DynamicObject> continueSaveDynList = new ArrayList<DynamicObject>(Arrays.asList(saveSuccessDyn));
        for (DynamicObject dyo : saveSuccessDyn) {
            try {
                this.syncEachInfo(dyo);
            }
            catch (Exception ex) {
                continueSaveDynList.remove(dyo);
                this.operationResult.addErrorInfo((OperateErrorInfo)ErrorMsgBuilder.buildErrMessage((DynamicObject)dyo, (Exception)ex, (String)ResManager.loadKDString((String)"\u77e5\u8bc6\u95ee\u7b54\u540c\u6b65", (String)"", (String)"", (Object[])new Object[0])));
                ExceptionHandler.saveErrLog((String)dyo.getDataEntityType().getName(), (Object)dyo.getPkValue(), (Throwable)ex);
            }
        }
        e.setDataEntities(continueSaveDynList.toArray(new DynamicObject[0]));
    }

    private void syncEachInfo(DynamicObject dyo) {
        boolean isSub = this.isSubject(dyo);
        boolean isSyn = this.isSynchronize(dyo);
        if (!isSub) {
            Long id = (Long)dyo.getPkValue();
            Long areaId = this.getAIAreaId(this.getAreaId(dyo));
            Long qaId = this.getQAId(this.getAreaId(dyo));
            Long subjectId = this.getAISubjectId(dyo);
            Long questionId = this.getAIQuestionId(dyo);
            if (isSyn) {
                String keyword = dyo.getString(KEYWORDS) + "";
                String answer = dyo.getString(ANSWER) + "";
                List<String> questions = this.getQuestions(dyo);
                String linkTitle = dyo.getString(LINK_NAME) + "";
                String linkAddress = dyo.getString(LINK_ADDRESS) + "";
                boolean enableLinkCard = false;
                if (StringUtils.isNotBlank((CharSequence)linkAddress)) {
                    enableLinkCard = true;
                }
                Map<Long, List<String>> attachments = this.getAttachmentList(dyo);
                if (this.updateDataIds.contains(id)) {
                    if (questionId <= 0L) {
                        ErrorCode code = new ErrorCode(ExcpStateEnum.DataOutOfSync.getValue(), ResManager.loadKDString((String)"\u66f4\u65b0\u95ee\u7b54\u65f6\uff0c\u65e0\u6cd5\u83b7\u5f97AI\u95ee\u7b54id\u3002", (String)"InfoSavePlugin_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                        throw new KDException(code, new Object[0]);
                    }
                    QuestionResult result = AIMetaDataSynchrnizedUtil.updateQuestion((Long)questionId, (Long)areaId, (Long)subjectId, (Long)qaId, (String)keyword, (String)answer, questions, (boolean)enableLinkCard, (String)linkTitle, (String)linkAddress, attachments);
                    dyo.set(AI_QUESTION_ID, (Object)result.getId());
                    dyo.set(SYNATTACHMENT, (Object)Boolean.FALSE);
                } else {
                    QuestionResult result = AIMetaDataSynchrnizedUtil.addQuestion((Long)areaId, (Long)subjectId, (Long)qaId, (String)keyword, (String)answer, questions, (boolean)enableLinkCard, (String)linkTitle, (String)linkAddress, attachments);
                    dyo.set(AI_QUESTION_ID, (Object)result.getId());
                }
            } else {
                ArrayList<Long> delIds = new ArrayList<Long>(1);
                delIds.add(questionId);
                if (this.updateDataIds.contains(id)) {
                    AIMetaDataSynchrnizedUtil.deleteQuestionForBatching((Long)areaId, (Long)subjectId, delIds);
                }
            }
        }
    }

    private Long getAIQuestionId(DynamicObject dyo) {
        return this.getBaseId(dyo, AI_QUESTION_ID);
    }

    private Map<Long, List<String>> getAttachmentList(DynamicObject dyo) {
        DynamicObjectCollection attachments = dyo.getDynamicObjectCollection(ATTACHMENT);
        if (attachments == null || attachments.isEmpty()) {
            return new HashMap<Long, List<String>>(0);
        }
        HashMap<Long, List<String>> attachmentMap = new HashMap<Long, List<String>>(attachments.size());
        for (DynamicObject each : attachments) {
            DynamicObject attachment = each.getDynamicObject("fbasedataid");
            Long id = (Long)attachment.getPkValue();
            String name = attachment.get("name") + "";
            String attachPageUrl = this.domainContextURL + URLSUFFIX + id;
            String attachMobilePageUrl = this.domainContextURL + URLSUFFIX_MOBILE + id;
            log.info("\u9644\u4ef6\u5730\u5740\uff1a" + attachPageUrl + ", attachMobilePageUrl");
            attachmentMap.put(id, Arrays.asList(name, attachPageUrl, attachMobilePageUrl));
        }
        return attachmentMap;
    }

    private List<String> getQuestions(DynamicObject dyo) {
        List<String> similarQuestions = this.getSimQuestion(dyo);
        ArrayList<String> questions = new ArrayList<String>(similarQuestions.size() + 1);
        questions.add(dyo.getString(QUESTION) + "");
        questions.addAll(similarQuestions);
        return questions;
    }

    private List<String> getSimQuestion(DynamicObject dyo) {
        DynamicObjectCollection simQuestions = dyo.getDynamicObjectCollection(ENTRY);
        if (simQuestions == null || simQuestions.isEmpty()) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> simQuestionList = new ArrayList<String>(simQuestions.size());
        for (DynamicObject each : simQuestions) {
            simQuestionList.add(each.getString(SIM_QUESTION) + "");
        }
        return simQuestionList;
    }

    @Deprecated
    private List<String> getKeywords(DynamicObject dyo) {
        String keys = dyo.getString(KEYWORDS);
        if (keys == null || StringUtils.isBlank((CharSequence)keys)) {
            return new ArrayList<String>(0);
        }
        String[] keyArray = keys.split(",");
        return new ArrayList<String>(Arrays.asList(keyArray));
    }

    private Long getAIAreaId(Long areaId) {
        QFilter qFilter = new QFilter("id", "=", (Object)areaId);
        DynamicObject area = QueryServiceHelper.queryOne((String)"som_knowledge_area", (String)"aiareaid", (QFilter[])new QFilter[]{qFilter});
        if (area == null || area.getLong("aiareaid") == 0L) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.DataOutOfSync.getValue(), String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u95ee\u7b54\u672a\u83b7\u5f97\u6240\u5c5e\u9886\u57dfid\uff08AI\uff09\uff0c\u6240\u5c5e\u82cd\u7a79\u9886\u57dfID\uff1a%s\u3002", (String)"InfoSavePlugin_3", (String)"ssc-task-opplugin", (Object[])new Object[0]), areaId));
            throw new KDException(code, new Object[0]);
        }
        return area.getLong("aiareaid");
    }

    private Long getQAId(Long areaId) {
        QFilter qFilter = new QFilter("id", "=", (Object)areaId);
        DynamicObject qa = QueryServiceHelper.queryOne((String)"som_knowledge_area", (String)"aiqaid", (QFilter[])new QFilter[]{qFilter});
        if (qa == null || qa.getLong("aiqaid") == 0L) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.DataOutOfSync.getValue(), String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u95ee\u7b54\u672a\u83b7\u5f97\u6240\u5c5eQAId\uff08AI\uff09\uff0c\u6240\u5c5e\u82cd\u7a79\u9886\u57dfID\u4e3a\uff1a%s\u3002", (String)"InfoSavePlugin_2", (String)"ssc-task-opplugin", (Object[])new Object[0]), areaId));
            throw new KDException(code, new Object[0]);
        }
        return qa.getLong("aiqaid");
    }

    private Long getAISubjectId(DynamicObject dyo) {
        long subjectId = this.getSubjectId(dyo);
        DynamicObject subject = QueryServiceHelper.queryOne((String)"som_knowledge_info", (String)AI_SUBJECT_ID, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)subjectId)});
        if (subject == null || subject.getLong(AI_SUBJECT_ID) == 0L) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.DataOutOfSync.getValue(), String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u95ee\u7b54\u672a\u83b7\u5f97\u6240\u5c5e\u7c7b\u76eeID\uff08AI\uff09\uff0c\u6240\u5c5e\u82cd\u7a79\u7c7b\u76eeID\u4e3a\uff1a%s\u3002", (String)"InfoSavePlugin_1", (String)"ssc-task-opplugin", (Object[])new Object[0]), dyo.getPkValue()));
            throw new KDException(code, new Object[0]);
        }
        return subject.getLong(AI_SUBJECT_ID);
    }

    private Long getSubjectId(DynamicObject dyo) {
        return this.getBaseId(dyo, SUBJECT);
    }

    private Long getAreaId(DynamicObject dyo) {
        return this.getBaseId(dyo, AREA);
    }

    private Long getCreator(DynamicObject dyo) {
        return this.getBaseId(dyo, CREATOR);
    }

    private Long getModifier(DynamicObject dyo) {
        return this.getBaseId(dyo, MODIFIER);
    }

    private Long getBaseId(DynamicObject dyo, String field) {
        Object value = dyo.get(field);
        if (value instanceof DynamicObject) {
            return (Long)((DynamicObject)value).getPkValue();
        }
        return (Long)value;
    }

    private boolean isSubject(DynamicObject dyo) {
        return dyo.getBoolean(IS_SUBJECT);
    }

    private boolean isSynchronize(DynamicObject dyo) {
        return dyo.getBoolean(REBORT);
    }
}

