/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.sscbillmanger;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.opplugin.sscbillmanger.SynIscObjectValidatorPlugin;

public class SynIscObjectPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(SynIscObjectPlugin.class);
    private static final String ISC_ENTITY_TYPE = "ENTITY";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SynIscObjectValidatorPlugin());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        ArrayList<ExtendedDataEntity> passDataEntitys = new ArrayList<ExtendedDataEntity>();
        for (ExtendedDataEntity dataEntity : e.getValidExtDataEntities()) {
            if (!this.entityValidate(dataEntity)) continue;
            passDataEntitys.add(dataEntity);
        }
        e.getValidExtDataEntities().clear();
        if (passDataEntitys.isEmpty()) {
            e.cancel = true;
        } else {
            e.getValidExtDataEntities().addAll(passDataEntitys);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        OperationResult operationResult = this.getOperationResult();
        ValidateResultCollection collection = operationResult.getValidateResult();
        List validateResults = collection.getValidateErrors();
        List successPkIds = operationResult.getSuccessPkIds();
        ArrayList<DynamicObject> synISCObjData = new ArrayList<DynamicObject>();
        for (DynamicObject data : dataEntities) {
            if (!successPkIds.contains(data.getPkValue())) continue;
            String entityNumber = data.getString("number");
            String dataNumber = data.getDynamicObject("target_datas").getString("number");
            try {
                Object id = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"syncMetaData", (Object[])new Object[]{dataNumber, ISC_ENTITY_TYPE, entityNumber});
                data.set("targetid", id);
                synISCObjData.add(data);
            }
            catch (Exception exception) {
                String exceptionMessage = exception.getMessage();
                log.error("SynIscObjectPlugin\u540c\u6b65\u96c6\u6210\u5bf9\u8c61\u5931\u8d25\uff1a" + exceptionMessage, (Throwable)exception);
                String message = exceptionMessage.startsWith(ResManager.loadKDString((String)"\u6570\u636e\u6e90", (String)"SynIscObjectPlugin_3", (String)"ssc-task-opplugin", (Object[])new Object[0])) ? exceptionMessage : ResManager.loadKDString((String)"\u540c\u6b65\u96c6\u6210\u5bf9\u8c61\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5\u3002", (String)"SynIscObjectPlugin_0", (String)"ssc-task-opplugin", (Object[])new Object[0]);
                successPkIds.remove(data.getPkValue());
                ValidationErrorInfo info = new ValidationErrorInfo("", data.getPkValue(), 0, 0, "errorcode_001", "", message, ErrorLevel.Error);
                ValidateResult validateResult = new ValidateResult();
                validateResult.addErrorInfo((OperateErrorInfo)info);
                validateResults.add(validateResult);
            }
        }
        try (TXHandle t = TX.requiresNew((String)"SynIscObjectPlugin");){
            SaveServiceHelper.save((DynamicObject[])synISCObjData.toArray(synISCObjData.toArray(new DynamicObject[0])));
        }
        catch (Throwable throwable) {
            String numbers = synISCObjData.stream().map(dyo -> dyo.getString("number")).collect(Collectors.joining(","));
            log.error("SynIscObjectPlugin\u540c\u6b65\u96c6\u6210\u5bf9\u8c61\u6210\u529f\uff0c\u4f46\u56de\u5199\u5171\u4eab\u5de5\u5355\u7ba1\u7406-\u96c6\u6210\u5bf9\u8c61id\u5931\u8d25\uff0c\u5931\u8d25\u5de5\u5355\u7f16\u7801\uff1a" + numbers, throwable);
            throw new RuntimeException(throwable);
        }
    }

    private boolean entityValidate(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        String number = data.getString("number");
        if (number.isEmpty()) {
            return false;
        }
        if (!MetadataDao.checkNumber((String)number)) {
            ValidationErrorInfo errInfo = new ValidationErrorInfo("", dataEntity, "", ResManager.loadKDString((String)"\u662f\u5426\u751f\u6210\u5b9e\u4f53\u68c0\u67e5", (String)"SynIscObjectPlugin_1", (String)"ssc-task-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5171\u4eab\u5de5\u5355\u672a\u751f\u6210\u5355\u636e\u5b9e\u4f53\uff0c\u53d6\u6d88\u201c\u540c\u6b65\u96c6\u6210\u5bf9\u8c61\u201d\u64cd\u4f5c\u3002", (String)"SynIscObjectPlugin_2", (String)"ssc-task-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
            return false;
        }
        return true;
    }
}

