/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.ssc.eventSend.core.SscEventDistributor;

public class RuleChange4PreDis {
    public static boolean change(DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return true;
        }
        Map<String, List<Long>> groupMap = RuleChange4PreDis.groupBySscAndTasktype(dynamicObjects);
        QFilter[] filters = RuleChange4PreDis.getQFilters(groupMap);
        String selectFields = "sscid,taskid";
        HashMap<Long, List> taskIdMap = new HashMap<Long, List>();
        DynamicObjectCollection toDeals = QueryServiceHelper.query((String)"task_predis_result", (String)selectFields, (QFilter[])filters);
        if (toDeals.isEmpty()) {
            return true;
        }
        int count = 0;
        ArrayList<Long> toDealTaskIds = new ArrayList<Long>();
        for (DynamicObject task : toDeals) {
            List taskIds;
            long sscId = task.getLong("sscid");
            long taskId = task.getLong("taskid");
            if (!toDealTaskIds.contains(taskId)) {
                toDealTaskIds.add(taskId);
            }
            if ((taskIds = taskIdMap.computeIfAbsent(sscId, l -> new ArrayList())).contains(taskId)) continue;
            taskIds.add(taskId);
            ++count;
        }
        RuleChange4PreDis.deletePreDisResult(toDealTaskIds);
        if (count < 5) {
            for (Map.Entry entry : taskIdMap.entrySet()) {
                RuleChange4PreDis.sendPreDisEvent((Long)entry.getKey(), (List)entry.getValue());
            }
        }
        return true;
    }

    private static void deletePreDisResult(List<Long> toDealTaskIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("taskid", "in", toDealTaskIds)};
        DeleteServiceHelper.delete((String)"task_predis_result", (QFilter[])qFilters);
    }

    private static Map<String, List<Long>> groupBySscAndTasktype(DynamicObject[] dynamicObjects) {
        HashMap<String, List<Long>> groupMap = new HashMap<String, List<Long>>();
        for (DynamicObject rule : dynamicObjects) {
            long sscId = rule.getLong("ssccenter.id");
            long taskTypeId = rule.getLong("tasktype.id");
            String mapK = sscId + "_" + taskTypeId;
            DynamicObjectCollection taskBills = rule.getDynamicObjectCollection("entryentity");
            List taskBillList = taskBills.stream().map(k -> k.getLong("billtype.id")).collect(Collectors.toList());
            List value = groupMap.computeIfAbsent(mapK, v -> new ArrayList());
            value.addAll(taskBillList);
        }
        return groupMap;
    }

    private static void sendPreDisEvent(Long sscId, List<Long> taskIds) {
        SscEventDistributor.preDistribute((Long)sscId, taskIds);
    }

    private static QFilter[] getQFilters(Map<String, List<Long>> groupMap) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter timeFilter = new QFilter("predistime", "<=", (Object)new Date());
        ArrayList billTypeIds = new ArrayList();
        groupMap.values().forEach(billTypeIds::addAll);
        if (!billTypeIds.isEmpty()) {
            filterList.add(new QFilter("billtype", "in", billTypeIds));
        }
        filterList.add(timeFilter);
        return filterList.toArray(new QFilter[0]);
    }
}

