/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.plugin.botp.BOTPFileUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.query.CommonQuery;
import kd.sys.ricc.common.util.BatchSplitUtil;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.exception.RiccBizException;
import org.apache.commons.io.FilenameUtils;

public class DataPacketHelper {
    private static final Log logger = LogFactory.getLog(DataPacketHelper.class);
    public static final String TYPE_PERM_ROLE = "perm_role";
    public static final String TYPE_PERM_BIZROLE = "perm_bizrole";
    public static final String TYPE_PERM_OPRATIONRULE = "perm_operationruleassign";
    private static final String ERROR = "error";

    public static String getEmptyParam() {
        return ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"DataPacketHelper_0", (String)"sys-ricc-business", (Object[])new Object[0]);
    }

    private DataPacketHelper() {
        throw new IllegalStateException("Utility class");
    }

    @Deprecated
    public static SdpOutputParams exportPacket(SdpInputParams sdpInputParams, String type) {
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        sdpOutputParams.setExportFilePath("");
        if (sdpInputParams == null) {
            sdpOutputParams.append(DataPacketHelper.getEmptyParam());
            return sdpOutputParams;
        }
        Map custParam = sdpInputParams.getParam();
        String entityName = (String)custParam.get("entityname");
        Map resMap = CommonUtil.getStrArrByRowCollection((ListSelectedRowCollection)sdpInputParams.getSelectRows(), (String)entityName);
        String[] ruleIds = (String[])resMap.get("ids");
        sdpOutputParams.setSelectedInfo((String)resMap.get("selectedInfo"));
        BOTPFileUtil fileUtil = new BOTPFileUtil(type);
        JSONObject exportResult = new JSONObject();
        String exportFilePath = null;
        try {
            exportFilePath = fileUtil.exportRule(sdpInputParams.getLocalPath(), ruleIds, exportResult);
            if (exportResult.get((Object)ERROR) != null) {
                sdpOutputParams.append(exportResult.get((Object)ERROR).toString());
                sdpOutputParams.append("\n");
            }
        }
        catch (Exception e) {
            logger.error("DataPacketHelper.exportPacket \u6267\u884c\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
            sdpOutputParams.append(String.format(CommonConstant.getExportFileErrorTip(), entityName), (Throwable)e);
        }
        sdpOutputParams.setExportFilePath(exportFilePath);
        boolean success = sdpOutputParams.getError().length() <= 0;
        sdpOutputParams.setSuccess(success);
        return sdpOutputParams;
    }

    public static SdpOutputParams commonXmlExportPacket(SdpInputParams sdpInputParams, String type) {
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        if (sdpInputParams == null) {
            sdpOutputParams.append(DataPacketHelper.getEmptyParam());
            return sdpOutputParams;
        }
        Map custParam = sdpInputParams.getParam();
        ListSelectedRowCollection selectRows = sdpInputParams.getSelectRows();
        if (selectRows.isEmpty()) {
            String entityNumber = (String)custParam.get("entitynumber");
            String filters = DataPacketHelper.getFilters(custParam);
            selectRows = CommonQuery.getAllSelectData((String)entityNumber, (String)filters);
        }
        int totalSize = selectRows.size();
        AddPacketProgress addPacketProgress = sdpInputParams.getAddPacketProgress();
        String entityName = (String)custParam.get("entityname");
        BOTPFileUtil fileUtil = new BOTPFileUtil(type);
        JSONObject exportResult = new JSONObject();
        ArrayList exportFiles = new ArrayList();
        String exportFilePath = null;
        StringBuilder selectedInfo = new StringBuilder();
        selectedInfo.append(String.format(CommonConstant.getSelectedTitle(), entityName, entityName));
        try {
            for (int i = 0; i < totalSize; ++i) {
                selectedInfo.append(String.format("%1$s\t\t%2$s\t\t%3$s %n", i + 1, selectRows.get(i).getNumber(), selectRows.get(i).getName()));
                fileUtil.exportRuleFile(sdpInputParams.getLocalPath(), String.valueOf(selectRows.get(i).getPrimaryKeyValue()), exportFiles, exportResult);
                if (exportResult.get((Object)ERROR) != null) {
                    sdpOutputParams.append(exportResult.get((Object)ERROR).toString());
                    sdpOutputParams.append("\n");
                    sdpOutputParams.setSuccess(false);
                    return sdpOutputParams;
                }
                ScheduleUtil.addPacketFeedbackProgress((AddPacketProgress)addPacketProgress, (int)totalSize, (int)(i + 1));
            }
            sdpOutputParams.setSelectedInfo(selectedInfo.toString());
            String fileName = type + "_" + System.currentTimeMillis() + ".zip";
            ScheduleUtil.buildAddPacketProgressDesc((AddPacketProgress)addPacketProgress, (Log)logger, (String)ResManager.loadKDString((String)"\u6570\u636e\u5904\u7406\u5df2\u5b8c\u6210\uff0c\u6b63\u5728\u751f\u6210\u6587\u4ef6\u3002", (String)"DataPacketHelper_1", (String)"sys-ricc-business", (Object[])new Object[0]));
            exportFilePath = DataPacketHelper.zipFiles(fileName, sdpInputParams.getLocalPath());
            AppUtils.deleteFiles((String)sdpInputParams.getLocalPath());
        }
        catch (Exception e) {
            logger.error("DataPacketHelper.commonXmlExportPacket \u6267\u884c\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
            sdpOutputParams.append(String.format(CommonConstant.getExportFileErrorTip(), entityName), (Throwable)e);
        }
        sdpOutputParams.setExportFilePath(exportFilePath);
        boolean success = sdpOutputParams.getError().length() <= 0;
        sdpOutputParams.setSuccess(success);
        return sdpOutputParams;
    }

    public static SdpOutputParams importPacket(SdpInputParams sdpInputParams, String type) {
        Map param = sdpInputParams.getParam();
        DynamicObject guide = (DynamicObject)param.get("guideInfo");
        String appId = guide.getString("page.bizappid");
        String formId = guide.getString("page.number");
        String entityName = guide.getString("name");
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        boolean hashPermissions = DataPacketHelper.checkPermissions(UserServiceHelper.getCurrentUserId(), appId, formId, entityName, sdpOutputParams, "47150e89000000ac", "47156aff000000ac", "4715a0df000000ac");
        if (!hashPermissions) {
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        String fileUrl = (String)param.get("fileUrl");
        BOTPFileUtil fileUtil = new BOTPFileUtil(type);
        JSONObject importResult = new JSONObject();
        importResult.put("ERROR", (Object)"");
        try {
            String tempFileUrl = FileUtils.getTempUrlFormFileUrl((String)fileUrl, (int)18000);
            boolean success = fileUtil.uploadRule(tempFileUrl, importResult);
            if (!success) {
                String msg = StringUtils.isNotBlank((Object)importResult.get((Object)"ImportDataWarnMsg")) ? String.valueOf(importResult.get((Object)"ImportDataWarnMsg")) : String.valueOf(importResult.get((Object)"ERROR").toString());
                sdpOutputParams.append(msg);
                sdpOutputParams.append("\n");
            }
        }
        catch (Exception e) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u201c%1$s\u201d\u6587\u4ef6\u5931\u8d25\uff0c%2$s", (String)"DataPacketHelper_2", (String)"sys-ricc-business", (Object[])new Object[0]), entityName, e.getMessage());
            sdpOutputParams.append(errorMsg, (Throwable)e);
            logger.error(errorMsg, (Throwable)e);
        }
        boolean success = sdpOutputParams.getError().length() <= 0;
        sdpOutputParams.setSuccess(success);
        return sdpOutputParams;
    }

    public static SdpOutputParams roleExport(SdpInputParams sdpInputParams, String type) {
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        if (sdpInputParams == null) {
            sdpOutputParams.append(DataPacketHelper.getEmptyParam());
            return sdpOutputParams;
        }
        Map custParam = sdpInputParams.getParam();
        ListSelectedRowCollection selectRows = sdpInputParams.getSelectRows();
        HashSet<Long> riccBizPermSet = new HashSet<Long>(2);
        riccBizPermSet.add(1407809474541912064L);
        riccBizPermSet.add(1407814994422136832L);
        if (TYPE_PERM_ROLE.equals(type) && selectRows.size() == 1 && "RICC_COMMON_ROLE_S".equals(selectRows.get(0).getNumber())) {
            return sdpOutputParams.setSuccess(false).append(ResManager.loadKDString((String)"\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u9884\u7f6e\u7684\u901a\u7528\u89d2\u8272\u65e0\u9700\u8fdb\u884c\u4f20\u8f93\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DataPacketHelper_3", (String)"sys-ricc-business", (Object[])new Object[0]));
        }
        if (TYPE_PERM_BIZROLE.equals(type) && selectRows.size() == 1 && riccBizPermSet.contains(selectRows.get(0).getPrimaryKeyValue())) {
            return sdpOutputParams.setSuccess(false).append(ResManager.loadKDString((String)"\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u9884\u7f6e\u7684\u4e1a\u52a1\u89d2\u8272\u65e0\u9700\u8fdb\u884c\u4f20\u8f93\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DataPacketHelper_4", (String)"sys-ricc-business", (Object[])new Object[0]));
        }
        if (TYPE_PERM_BIZROLE.equals(type) && selectRows.size() == 2 && riccBizPermSet.contains(selectRows.get(0).getPrimaryKeyValue()) && riccBizPermSet.contains(selectRows.get(1).getPrimaryKeyValue())) {
            return sdpOutputParams.setSuccess(false).append(ResManager.loadKDString((String)"\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u9884\u7f6e\u7684\u4e1a\u52a1\u89d2\u8272\u65e0\u9700\u8fdb\u884c\u4f20\u8f93\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DataPacketHelper_4", (String)"sys-ricc-business", (Object[])new Object[0]));
        }
        if (selectRows.isEmpty()) {
            String filters = DataPacketHelper.getFilters(custParam);
            selectRows = CommonQuery.getAllSelectData((String)type, (String)filters);
        }
        int totalSize = selectRows.size();
        AddPacketProgress addPacketProgress = sdpInputParams.getAddPacketProgress();
        String entityName = (String)custParam.get("entityname");
        StringBuilder selectedInfo = new StringBuilder();
        selectedInfo.append(String.format(CommonConstant.getSelectedTitle(), entityName, entityName));
        StringBuilder roleSqls = new StringBuilder();
        int batchSize = 10;
        List splitBatchList = BatchSplitUtil.splitBatch((List)selectRows, (int)batchSize);
        int splitCount = splitBatchList.size();
        int successcount = 0;
        try {
            for (int i = 0; i < splitCount; ++i) {
                List batchSelectRows = (List)splitBatchList.get(i);
                successcount = DataPacketHelper.setRoleSelectedInfo(batchSelectRows, selectedInfo, successcount);
                if (TYPE_PERM_ROLE.equals(type) || TYPE_PERM_OPRATIONRULE.equals(type)) {
                    DataPacketHelper.getCommonRoleOrOpRuleSqlStr(batchSelectRows, type, roleSqls);
                } else if (TYPE_PERM_BIZROLE.equals(type)) {
                    DataPacketHelper.getbizRoleSqlStr(batchSelectRows, riccBizPermSet, roleSqls);
                }
                String filename = System.currentTimeMillis() + "_" + i + ".json";
                DataPacketHelper.stringToFile(sdpInputParams.getLocalPath(), filename, roleSqls);
                roleSqls.delete(0, roleSqls.length());
                ScheduleUtil.addPacketFeedbackProgress((AddPacketProgress)addPacketProgress, (int)totalSize, (int)successcount);
            }
            ScheduleUtil.addPacketProgressComplete((AddPacketProgress)addPacketProgress);
            ScheduleUtil.buildAddPacketProgressDesc((AddPacketProgress)addPacketProgress, (Log)logger, (String)ResManager.loadKDString((String)"\u6570\u636e\u5904\u7406\u5df2\u5b8c\u6210\uff0c\u6b63\u5728\u751f\u6210\u6587\u4ef6\u3002", (String)"DataPacketHelper_1", (String)"sys-ricc-business", (Object[])new Object[0]));
            sdpOutputParams.setSelectedInfo(selectedInfo.toString());
            String zipName = FileUtils.dirToZip((String)sdpInputParams.getLocalPath(), (String)entityName);
            sdpOutputParams.setExportFilePath(zipName);
        }
        catch (KDException e) {
            logger.error("DataPacketHelper.roleExport \u6267\u884c\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
            sdpOutputParams.append(String.format(CommonConstant.getExportFileErrorTip(), entityName), (Throwable)e);
        }
        boolean success = sdpOutputParams.getError().length() <= 0;
        sdpOutputParams.setSuccess(success);
        return sdpOutputParams;
    }

    public static String getFilters(Map<String, Object> custParam) {
        Object custParamObject = custParam.get("custparam");
        String filters = null;
        if (custParamObject instanceof Map) {
            Map param = (Map)custParamObject;
            filters = (String)param.get("filters");
        }
        return filters;
    }

    private static void getbizRoleSqlStr(List<ListSelectedRow> batchSelectRows, Set<Long> bizPermSet, StringBuilder roleSqls) {
        HashSet<Long> selectIdSet = new HashSet<Long>(batchSelectRows.size());
        for (int j = 0; j < batchSelectRows.size(); ++j) {
            ListSelectedRow selectedRow = batchSelectRows.get(j);
            selectIdSet.add(Long.parseLong(selectedRow.getPrimaryKeyValue().toString()));
        }
        selectIdSet.removeAll(bizPermSet);
        roleSqls.append((CharSequence)PermissionServiceHelper.generateBizRolesSql(selectIdSet));
    }

    private static void getCommonRoleOrOpRuleSqlStr(List<ListSelectedRow> batchSelectRows, String type, StringBuilder roleSqls) {
        HashSet<String> selectIdSet = new HashSet<String>(batchSelectRows.size());
        for (int j = 0; j < batchSelectRows.size(); ++j) {
            ListSelectedRow selectedRow = batchSelectRows.get(j);
            String id = String.valueOf(selectedRow.getPrimaryKeyValue());
            if ("RICC_COMMON_ROLE_S".equals(selectedRow.getNumber())) continue;
            selectIdSet.add(id);
        }
        if (TYPE_PERM_ROLE.equals(type)) {
            roleSqls.append((CharSequence)PermissionServiceHelper.generateComRolesSql(selectIdSet));
        } else {
            roleSqls.append((CharSequence)PermissionServiceHelper.generateOpRulesSql(selectIdSet, (boolean)true, (boolean)true, (boolean)true, (boolean)true));
        }
    }

    private static int setRoleSelectedInfo(List<ListSelectedRow> batchSelectRows, StringBuilder selectedInfo, int successcount) {
        for (int j = 0; j < batchSelectRows.size(); ++j) {
            ListSelectedRow selectedRow = batchSelectRows.get(j);
            selectedInfo.append(String.format("%1$s\t\t%2$s\t\t%3$s %n", successcount++ + 1, selectedRow.getNumber(), selectedRow.getName()));
        }
        return successcount;
    }

    private static void stringToFile(String filePath, String filename, StringBuilder roleSqls) {
        String fullFilePath = filePath + File.separator + filename;
        try (FileWriter fileWriter = new FileWriter(fullFilePath);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            bufferedWriter.write(roleSqls.toString());
            bufferedWriter.flush();
        }
        catch (Exception e) {
            String msgTpl = ResManager.loadKDString((String)"\u5199\u5165\u6587\u4ef6[%1$s]\u5931\u8d25\uff0c%2$s", (String)"DataPacketHelper_5", (String)"sys-ricc-business", (Object[])new Object[0]);
            throw new RiccBizException(String.format(msgTpl, fullFilePath, e.getMessage()), (Throwable)e);
        }
    }

    public static SdpOutputParams roleImport(SdpInputParams sdpInputParams, String type) {
        boolean isAdmin;
        Map param = sdpInputParams.getParam();
        String fileUrl = (String)param.get("fileUrl");
        DynamicObject guide = (DynamicObject)param.get("guideInfo");
        String entityName = guide.getString("name");
        String appId = guide.getString("page.bizappid");
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        long currentUserId = UserServiceHelper.getCurrentUserId();
        if (!TYPE_PERM_OPRATIONRULE.equals(type) && !(isAdmin = PermissionServiceHelper.isAdminUser((long)currentUserId))) {
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u624d\u53ef\u4ee5\u8bbe\u7f6e%s\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5", (String)"DataPacketHelper_9", (String)"sys-ricc-business", (Object[])new Object[0]), entityName));
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        boolean hashPermissions = DataPacketHelper.checkPermissions(currentUserId, appId, type, entityName, sdpOutputParams, "47150e89000000ac", "47156aff000000ac");
        if (!hashPermissions) {
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        String localPath = FileUtils.generateLocalPath();
        File localFile = FileUtils.checkAndCreateDir((String)localPath);
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        int totalFileNum = 0;
        int successFileNum = 0;
        try (InputStream inputStream = fileService.getInputStream(fileUrl);
             ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry entry;
            StringBuilder sqlBd = new StringBuilder();
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String line;
                ++totalFileNum;
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)zipInputStream, StandardCharsets.UTF_8));
                while ((line = br.readLine()) != null) {
                    sqlBd.append(line);
                }
                List fileList = PermissionServiceHelper.exportDataBySqlFile((StringBuilder)sqlBd, (String)localPath, (int)500000);
                boolean res = PermissionServiceHelper.importDataBySqlFile((List)fileList);
                if (res) {
                    ++successFileNum;
                } else {
                    sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u6279\u6b21\u6587\u4ef6\u3010%s\u3011,\u5bfc\u5165\u5931\u8d25\uff01", (String)"DataPacketHelper_6", (String)"sys-ricc-business", (Object[])new Object[0]), entry.getName()));
                }
                sqlBd.delete(0, sqlBd.length());
            }
        }
        catch (IOException e) {
            logger.error("DataPacketHelper.roleImport \u6267\u884c\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
            sdpOutputParams.append(String.format(CommonConstant.getImportFileErrorTip(), entityName), (Throwable)e);
        }
        if (successFileNum == totalFileNum) {
            CacheMrg.clearAllCache();
            sdpOutputParams.setSuccess(true);
        } else if (successFileNum > 0) {
            CacheMrg.clearAllCache();
            sdpOutputParams.getError().insert(0, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5bfc\u5165\u4e0d\u6210\u529f\u7684\u6587\u4ef6\uff0c\u603b\u6587\u4ef6\u6570\uff1b%1$s,\u6210\u529f\u6587\u4ef6\u6570\uff1a%2$s", (String)"DataPacketHelper_7", (String)"sys-ricc-business", (Object[])new Object[0]), totalFileNum, successFileNum));
            sdpOutputParams.setSuccess(false);
        } else {
            sdpOutputParams.getError().insert(0, String.format(ResManager.loadKDString((String)"\u5168\u90e8\u5bfc\u5165\u4e0d\u6210\u529f\u7684\u6587\u4ef6\uff0c\u603b\u6587\u4ef6\u6570\uff1b%s", (String)"DataPacketHelper_8", (String)"sys-ricc-business", (Object[])new Object[0]), totalFileNum));
            sdpOutputParams.setSuccess(false);
        }
        if (localFile.exists()) {
            AppUtils.deleteKd((File)localFile);
        }
        HashMap<String, Integer> params = new HashMap<String, Integer>(2);
        params.put("successCount", successFileNum);
        params.put("failedCount", totalFileNum - successFileNum);
        sdpOutputParams.setParam(params);
        return sdpOutputParams;
    }

    public static void exportWfToZipFile(ZipOutputStream out, DeployFile deployFile) {
        String content = deployFile.getFileContent();
        try (BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));){
            String fileName = deployFile.getFileName();
            ZipEntry entry = new ZipEntry(fileName);
            entry.setMethod(8);
            out.putNextEntry(entry);
            int n = 0;
            byte[] buf = new byte[1024];
            while ((n = in.read(buf)) != -1) {
                out.write(buf, 0, n);
            }
        }
        catch (IOException e) {
            logger.error("\u5bfc\u51fa\u5de5\u4f5c\u6d41\uff0c\u6d41\u7a0b\u65b9\u6848\u548c\u6d41\u7a0b\u7ba1\u7406\u5230zip\u5305\u5f02\u5e38", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("Error:%s.", e.getMessage())});
        }
    }

    private static String zipFiles(String zipName, String zipPath) {
        JSONArray files = new JSONArray();
        files.add((Object)zipPath);
        Path customZipPath = Paths.get(zipPath, FilenameUtils.getName((String)zipName));
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(customZipPath, new OpenOption[0]));){
            DataPacketHelper.zipFile(files, out);
        }
        catch (IOException e) {
            logger.error("DataPacketHelper.zipFiles \u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new RiccBizException((Throwable)e);
        }
        return customZipPath.toString();
    }

    private static void zipFile(JSONArray files, ZipOutputStream out) {
        for (int i = 0; i < files.size(); ++i) {
            File file = FileUtils.createFile((String)((String)files.get(i)));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                JSONArray tempFiles = new JSONArray();
                assert (listFiles != null);
                for (File tempFile : listFiles) {
                    try {
                        tempFiles.add((Object)tempFile.getCanonicalPath());
                    }
                    catch (IOException e) {
                        logger.error("DataPacketHelper.zipFile \u5f02\u5e38", (Throwable)e);
                    }
                }
                DataPacketHelper.zipFile(tempFiles, out);
                continue;
            }
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                throw new RiccBizException((Throwable)e);
            }
            Path zipPath = Paths.get(DevportalUtil.checkFilePath((String)path), new String[0]);
            if (!path.contains("metadata")) continue;
            if ((path = path.substring(path.indexOf("metadata"))).contains("\\")) {
                path = path.replace('\\', '/');
            }
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(zipPath, new OpenOption[0]));){
                ZipEntry entry = new ZipEntry(path);
                entry.setMethod(8);
                out.putNextEntry(entry);
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.closeEntry();
                continue;
            }
            catch (Exception e) {
                throw new RiccBizException((Throwable)e);
            }
        }
    }

    public static String getZipFileContent(ZipInputStream zipIn) throws IOException {
        StringBuilder sb = new StringBuilder();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int len = 0;
        while ((len = zipIn.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        byte[] buff = out.toByteArray();
        sb.append(new String(buff, 0, buff.length, StandardCharsets.UTF_8));
        return sb.toString();
    }

    public static boolean checkPermissions(long userId, String appId, String entityNumber, String entityName, SdpOutputParams sdpOutputParams, String ... permissionItems) {
        Map permMap = PermissionServiceHelper.checkMultiPermItemInfos((long)userId, (String)appId, (String)entityNumber, Arrays.stream(permissionItems).collect(Collectors.toSet()));
        HashSet noPermissionItems = new HashSet(permissionItems.length);
        for (Map.Entry permEntry : permMap.entrySet()) {
            Boolean hashPermission = (Boolean)permEntry.getValue();
            if (!Boolean.FALSE.equals(hashPermission)) continue;
            noPermissionItems.add(permEntry.getKey());
        }
        if (!noPermissionItems.isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", noPermissionItems);
            DynamicObjectCollection permItems = QueryServiceHelper.query((String)"perm_permitem", (String)"name", (QFilter[])qFilter.toArray());
            String permName = permItems.stream().map(p -> p.getString("name")).collect(Collectors.joining(","));
            String noPermTips = ResManager.loadKDString((String)"\u6ca1\u6709%1$s\u7684%2$s\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5", (String)"DataPacketHelper_10", (String)"sys-ricc-business", (Object[])new Object[0]);
            sdpOutputParams.append(String.format(noPermTips, entityName, permName));
            return false;
        }
        return true;
    }
}

