/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterReader;
import kd.bos.param.ParameterUtils;
import kd.bos.param.ParameterWriter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.business.datapacket.core.ISubDataPacket;
import kd.sys.ricc.business.datapacket.core.helper.DataPacketHelper;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;

public class BillParameterImpl
implements ISubDataPacket {
    private static final Log logger = LogFactory.getLog(BillParameterImpl.class);
    private static final String FORM_ID = "formId";

    public SdpOutputParams exportPacket(SdpInputParams sdpInputParams) {
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        ListSelectedRowCollection selectRows = sdpInputParams.getSelectRows();
        AddPacketProgress addPacketProgress = sdpInputParams.getAddPacketProgress();
        int total = selectRows.size();
        int complete = 0;
        ArrayList parameterList = new ArrayList();
        for (ListSelectedRow selectRow : selectRows) {
            String formId = (String)selectRow.getPrimaryKeyValue();
            DynamicObject billParameter = ParameterReader.getBillParameter((String)formId);
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(billParameter.getDynamicObjectType());
            binder.setOnlyDbProperty(false);
            binder.setSerializeDefaultValue(true);
            DcJsonSerializer jSer = new DcJsonSerializer((DcBinder)binder);
            String billParameterJsonString = jSer.serializeToString((Object)billParameter, null);
            HashMap<String, String> billDataMap = new HashMap<String, String>(2);
            billDataMap.put(FORM_ID, formId);
            billDataMap.put("data", billParameterJsonString);
            parameterList.add(billDataMap);
            ScheduleUtil.addPacketFeedbackProgress((AddPacketProgress)addPacketProgress, (int)total, (int)(++complete));
        }
        String parameterListStr = JSON.toJSONString(parameterList);
        String filename = System.currentTimeMillis() + ".json";
        String fullFilePath = sdpInputParams.getLocalPath() + File.separator + filename;
        logger.info("\u5355\u636e\u53c2\u6570\u5bfc\u51fa\u6570\u636e,\u672c\u5730\u6587\u4ef6\u5730\u5740\uff1a" + fullFilePath);
        try {
            logger.info("\u5355\u636e\u53c2\u6570\u5bfc\u51fa\u6570\u636e,\u5199\u5165\u6587\u4ef6\u5927\u5c0f\uff1a" + parameterList.size());
            FileUtils.writeStr2File((String)fullFilePath, (String)parameterListStr);
        }
        catch (Exception e) {
            logger.error("BillParameterImpl.exportPacket \u5355\u636e\u53c2\u6570\u5199\u5165\u6587\u4ef6\u51fa\u9519\u3002", (Throwable)e);
            sdpOutputParams.setSuccess(false);
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u53c2\u6570\u5199\u5165\u6587\u4ef6\u51fa\u9519 %1$s", (String)"BillParameterImpl_0", (String)"sys-ricc-business", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            return sdpOutputParams;
        }
        sdpOutputParams.setExportFilePath(fullFilePath);
        sdpOutputParams.setSuccess(true);
        String subData = this.writeSelectedInfo(selectRows);
        sdpOutputParams.setSelectedInfo(subData);
        return sdpOutputParams;
    }

    public SdpOutputParams importPacket(SdpInputParams sdpInputParams) {
        List parameterList;
        Map param = sdpInputParams.getParam();
        String fileUrl = (String)param.get("fileUrl");
        DynamicObject guide = (DynamicObject)param.get("guideInfo");
        String entityName = guide.getString("name");
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        try (InputStream inputStream = fileService.getInputStream(fileUrl);){
            String resStr = FileUtils.inputStreamToString((InputStream)inputStream);
            parameterList = (List)JSON.parseObject((String)resStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        }
        catch (IOException e) {
            logger.error("\u5bfc\u5165\u5355\u636e\u53c2\u6570\u8bfb\u53d6\u6587\u4ef6\u6570\u636e\u5f02\u5e38", (Throwable)e);
            sdpOutputParams.setSuccess(false);
            sdpOutputParams.append(String.format(CommonConstant.getImportFileErrorTip(), entityName), (Throwable)e);
            return sdpOutputParams;
        }
        boolean hashPermissions = DataPacketHelper.checkPermissions(UserServiceHelper.getCurrentUserId(), "cts", "bos_billparamset", entityName, sdpOutputParams, "47150e89000000ac", "4715a0df000000ac");
        if (!hashPermissions) {
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        int successCount = 0;
        int total = parameterList.size();
        for (Map parameterMap : parameterList) {
            if (!this.isRightParam(parameterMap, sdpOutputParams)) continue;
            String formId = (String)parameterMap.get(FORM_ID);
            String data = (String)parameterMap.get("data");
            try {
                ParameterWriter.saveBillParameter((String)formId, (String)data);
                ++successCount;
            }
            catch (Exception e) {
                String errTpl = ResManager.loadKDString((String)"\u4fdd\u5b58\u8868\u5355id\u4e3a%1$s\u7684\u6570\u636e\u53d1\u751f\u9519\u8bef %2$s", (String)"BillParameterImpl_9", (String)"sys-ricc-business", (Object[])new Object[0]);
                sdpOutputParams.append(String.format(errTpl, formId, e.getMessage()), (Throwable)e);
            }
        }
        if (successCount == total) {
            sdpOutputParams.setSuccess(true);
        } else if (successCount > 0) {
            sdpOutputParams.getError().insert(0, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5bfc\u5165\u4e0d\u6210\u529f\u7684\u5355\u636e\u53c2\u6570\uff0c\u603b\u6570\uff1a%1$s,\u6210\u529f\u6570\uff1a%2$s %n", (String)"BillParameterImpl_1", (String)"sys-ricc-business", (Object[])new Object[0]), total, successCount));
            sdpOutputParams.setSuccess(false);
        } else {
            sdpOutputParams.getError().insert(0, String.format(ResManager.loadKDString((String)"\u5355\u636e\u53c2\u6570\u5bfc\u5165\u5168\u90e8\u4e0d\u6210\u529f\uff0c\u603b\u6570\uff1a%s %n", (String)"BillParameterImpl_2", (String)"sys-ricc-business", (Object[])new Object[0]), total));
            sdpOutputParams.setSuccess(false);
        }
        HashMap<String, Integer> params = new HashMap<String, Integer>(2);
        params.put("successCount", successCount);
        params.put("failedCount", total - successCount);
        sdpOutputParams.setParam(params);
        return sdpOutputParams;
    }

    private String writeSelectedInfo(ListSelectedRowCollection selectRows) {
        StringBuilder selectedInfo = new StringBuilder();
        selectedInfo.append(ResManager.loadKDString((String)"\u5e8f\u53f7\t\u5355\u636e\u53c2\u6570\u8868\u5355\t\u5355\u636e\u53c2\u6570\u540d\u79f0%s", (String)"BillParameterImpl_3", (String)"sys-ricc-business", (Object[])new Object[]{System.lineSeparator()}));
        int num = 1;
        for (ListSelectedRow selectRow : selectRows) {
            selectedInfo.append(String.format("%1$s\t\t%2$s\t\t%3$s %n", num, selectRow.getPrimaryKeyValue(), selectRow.getName()));
            ++num;
        }
        return selectedInfo.toString();
    }

    private boolean isRightParam(Map<String, String> parameterMap, SdpOutputParams sdpOutputParams) {
        String formId = parameterMap.get(FORM_ID);
        if (StringUtils.isBlank((CharSequence)formId)) {
            String errTpl = ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5355\u636e\u53c2\u6570\u8868\u5355\u4fe1\u606f\uff0c\u8868\u5355id\u4e3a\u7a7a\u3002", (String)"BillParameterImpl_4", (String)"sys-ricc-business", (Object[])new Object[0]);
            sdpOutputParams.append(errTpl);
            return false;
        }
        MainEntityType entityType = null;
        try {
            entityType = EntityMetadataCache.getDataEntityType((String)formId);
        }
        catch (Exception e) {
            String errTpl = ResManager.loadKDString((String)"%1$s\u7684\u8868\u5355\u5143\u6570\u636e\u4e0d\u5b58\u5728", (String)"BillParameterImpl_8", (String)"sys-ricc-business", (Object[])new Object[0]);
            sdpOutputParams.append(String.format(errTpl, formId), (Throwable)e);
            return false;
        }
        String displayName = entityType.getDisplayName().getLocaleValue();
        if (!(entityType instanceof BillEntityType)) {
            String errTpl = ResManager.loadKDString((String)"%1$s(%2$s)\u4e0d\u662f\u5355\u636e\u5b9e\u4f53\u7c7b\u578b", (String)"BillParameterImpl_5", (String)"sys-ricc-business", (Object[])new Object[0]);
            sdpOutputParams.append(String.format(errTpl, displayName, formId));
            return false;
        }
        String billParameter = ((BillEntityType)entityType).getBillParameter();
        if (StringUtils.isBlank((CharSequence)billParameter)) {
            String errTpl = ResManager.loadKDString((String)"%1$s(%2$s)\u6ca1\u6709\u914d\u7f6e\u5355\u636e\u53c2\u6570", (String)"BillParameterImpl_6", (String)"sys-ricc-business", (Object[])new Object[0]);
            sdpOutputParams.append(String.format(errTpl, displayName, formId));
            return false;
        }
        String data = parameterMap.get("data");
        if (StringUtils.isBlank((CharSequence)data)) {
            String errTpl = ResManager.loadKDString((String)"%1$s(%2$s)\u914d\u7f6e\u7684\u5355\u636e\u53c2\u6570\u6570\u636e\u4e3a\u7a7a", (String)"BillParameterImpl_7", (String)"sys-ricc-business", (Object[])new Object[0]);
            sdpOutputParams.append(String.format(errTpl, displayName, formId));
            return false;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        if (map == null || !StringUtils.equals((String)((String)map.get("_Type_")), (String)billParameter)) {
            String errTpl = ResManager.loadKDString((String)"%1$s(%2$s)\u5355\u636e\u53c2\u6570\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff0c\u6570\u636e\u8bb0\u5f55\u7684\u7c7b\u578b\u548c\u5f53\u524d\u8868\u5355\u4e0d\u5339\u914d\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u662f\u5426\u6b63\u786e", (String)"BillParameterImpl_10", (String)"sys-ricc-business", (Object[])new Object[0]);
            sdpOutputParams.append(String.format(errTpl, displayName, formId));
            return false;
        }
        try {
            ParameterUtils.serializeToDataEntity((String)data, (String)billParameter);
        }
        catch (Exception e) {
            logger.error("\u5355\u636e\u53c2\u6570data\u6570\u636e\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            String errTpl = ResManager.loadKDString((String)"%1$s(%2$s)\u5355\u636e\u53c2\u6570\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u662f\u5426\u6b63\u786e %3$s", (String)"BillParameterImpl_11", (String)"sys-ricc-business", (Object[])new Object[0]);
            sdpOutputParams.append(String.format(errTpl, displayName, formId, e.getMessage()), (Throwable)e);
            return false;
        }
        return true;
    }
}

