/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.CustomParam;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.utils.LocalCacheUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.param.service.IParameterWriterService;
import kd.bos.permission.api.AdminAppResult;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.business.datapacket.core.ISubDataPacket;
import kd.sys.ricc.business.datapacket.core.helper.DataPacketHelper;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.exception.RiccBizException;

public class SysParameterImpl
implements ISubDataPacket {
    private static final Log logger = LogFactory.getLog(SysParameterImpl.class);
    private static final String F_ORG_ID = "FORGID";
    private static final String F_PARAM_ID = "FPARAMID";
    private static final String APP_ID = "appid";
    private static final String F_ACCT_BOOK_ID = "FACCTBOOKID";
    private static final String ORG_NUMBER = "orgnumber";
    private static final String ACCT_BOOK_NUMBER = "acctbooknumber";
    private static final String BOS_BASE_PARAMETER = "bos_base_parameter";
    private static final String BOS_ORG = "bos_org";
    private static final String BOS_SVC_SYS_PARAMETER = "bos_svc_sysparameter";
    private static final String APP_CUSTOM = "appCustom";
    private static final String BOS_CUSTOM_PARAM_APP = "bos_customparam_app";
    private static final String BOS_CUSTOM_PARAM = "bos_customparam";
    private static final String PARAM_OBJ = "paramobj";
    private static final String BOS_CUSTOM_PARAM_VIEW = "bos_customparam_view";
    private static final String SYS_PARAMETER_SELECTED_FIELDS = "ID,FORGID,FDATA,FLOCKFIELDS,FVIEWTYPEID,FPARAMID,FACCTBOOKID,FACCTINGBOOKID,FPARAMCONFIG";
    private static final String F_SELECTED_FIELDS = "FSELECTEDFIELDS";
    private static final String FIELDS = "fields";
    private static final String BD_ACCOUNT_BOOKS_TYPE = "bd_accountbookstype";
    private static final String PARAM_ID = "paramid";
    private static final String ID_NUMBER = "id,number";
    private static final String VIEW_TYP_ID = "viewtypeid";
    private static final String F_VIEW_TYPE_ID = "FVIEWTYPEID";
    private static final String F_ACCTING_BOOK_ID = "FACCTINGBOOKID";
    private static final String GROUP = "group";
    private static final String VALUE = "value";
    private static final String GL_ACCOUNT_BOOK = "gl_accountbook";
    private static final String ACCTING_BOOK_NUMBER = "acctingbooknumber";
    private static final String CUSTOM_KEY_CHECK_REGEX = "^\\w+$";
    private static final String BOS_SYS_PARAM_GROUP = "bos_sysparam_group";
    private static final String PARAM_GROUP_ID = "paramgroupid";
    private final ORM orm = ORM.create();
    private final IParameterWriterService parameterWriterService = (IParameterWriterService)ServiceSvcFactory.getService(IParameterWriterService.class);
    private final IParameterReaderService parameterReaderService = (IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class);

    public SdpOutputParams exportPacket(SdpInputParams sdpInputParams) {
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        Map customParam = (Map)sdpInputParams.getParam().get("custparam");
        HashMap<String, Map<String, String>> appParamMap = new HashMap<String, Map<String, String>>(16);
        HashMap<String, Map<String, String>> sysParamMap = new HashMap<String, Map<String, String>>(8);
        HashMap<String, Map<String, String>> customParamMap = new HashMap<String, Map<String, String>>(8);
        HashMap<String, Map<String, String>> specialAppParamMap = new HashMap<String, Map<String, String>>(8);
        for (Map.Entry sysParamEntry : customParam.entrySet()) {
            Map sysParam = (Map)sysParamEntry.getValue();
            String appId = (String)sysParam.get(APP_ID);
            String paramObj = (String)sysParam.get(PARAM_OBJ);
            if (BOS_CUSTOM_PARAM_VIEW.equals(paramObj)) {
                customParamMap.put((String)sysParamEntry.getKey(), sysParam);
                continue;
            }
            if (StringUtils.isEmpty((String)appId)) {
                sysParamMap.put((String)sysParamEntry.getKey(), sysParam);
                continue;
            }
            String sysId = (String)sysParam.get("sys_id");
            if (StringUtils.isNotEmpty((String)sysId)) {
                specialAppParamMap.put((String)sysParamEntry.getKey(), sysParam);
                continue;
            }
            appParamMap.put((String)sysParamEntry.getKey(), sysParam);
        }
        ArrayList<Map<String, Object>> parameterList = new ArrayList<Map<String, Object>>(16);
        AddPacketProgress addPacketProgress = sdpInputParams.getAddPacketProgress();
        ScheduleUtil.addPacketFeedbackProgress((AddPacketProgress)addPacketProgress, (int)customParam.size(), (int)0);
        try {
            this.exportAppParam(appParamMap, parameterList, addPacketProgress);
            this.exportSysParam(sysParamMap, parameterList, addPacketProgress);
            this.exportSysCustomParam(customParamMap, parameterList, addPacketProgress);
            this.exportInSysTabAppParam(specialAppParamMap, parameterList, addPacketProgress);
        }
        catch (RiccBizException e) {
            logger.error((Throwable)e);
            sdpOutputParams.append(e.getMessage(), e.getMessage());
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            sdpOutputParams.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u5bfc\u51fa\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u6253\u5305\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SysParameterImpl_4", (String)"sys-ricc-business", (Object[])new Object[0]), (Throwable)e);
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        String filename = System.currentTimeMillis() + ".json";
        String fullFilePath = sdpInputParams.getLocalPath() + File.separator + filename;
        logger.info("\u7cfb\u7edf\u53c2\u6570\u5bfc\u51fa\u6570\u636e,\u672c\u5730\u6587\u4ef6\u5730\u5740\uff1a" + fullFilePath);
        try {
            logger.info("\u7cfb\u7edf\u53c2\u6570\u5bfc\u51fa\u6570\u636e,\u5199\u5165\u6587\u4ef6\u5927\u5c0f\uff1a" + parameterList.size());
            String parameterListStr = JSON.toJSONString(parameterList);
            FileUtils.writeStr2File((String)fullFilePath, (String)parameterListStr);
        }
        catch (Exception e) {
            logger.error("SysParameterImpl.exportPacket \u7cfb\u7edf\u53c2\u6570\u5199\u5165\u6587\u4ef6\u51fa\u9519\u3002", (Throwable)e);
            sdpOutputParams.setSuccess(false);
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u5199\u5165\u6587\u4ef6\u51fa\u9519 %1$s", (String)"SysParameterImpl_1", (String)"sys-ricc-business", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            return sdpOutputParams;
        }
        sdpOutputParams.setExportFilePath(fullFilePath);
        sdpOutputParams.setSuccess(true);
        String subData = this.writeSelectedInfo(parameterList);
        sdpOutputParams.setSelectedInfo(subData);
        sdpOutputParams.setSuccess(true);
        return sdpOutputParams;
    }

    public SdpOutputParams importPacket(SdpInputParams sdpInputParams) {
        List parameterList;
        Map param = sdpInputParams.getParam();
        String fileUrl = (String)param.get("fileUrl");
        DynamicObject guide = (DynamicObject)param.get("guideInfo");
        String entityName = guide.getString("name");
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        int successCount = 0;
        int total = 0;
        try (InputStream inputStream = fileService.getInputStream(fileUrl);){
            String resStr = FileUtils.inputStreamToString((InputStream)inputStream);
            parameterList = (List)JSON.parseObject((String)resStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        }
        catch (IOException e) {
            logger.error("\u5bfc\u5165\u7cfb\u7edf\u53c2\u6570\u8bfb\u53d6\u6587\u4ef6\u6570\u636e\u5f02\u5e38", (Throwable)e);
            sdpOutputParams.setSuccess(false);
            sdpOutputParams.append(String.format(CommonConstant.getImportFileErrorTip(), entityName), (Throwable)e);
            return sdpOutputParams;
        }
        boolean hasSysParameter = parameterList.stream().anyMatch(p -> !StringUtils.isEmpty((String)p.get(APP_ID).toString()));
        if (hasSysParameter) {
            String sysEntityName = ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570", (String)"SysParameterImpl_12", (String)"sys-ricc-business", (Object[])new Object[0]);
            boolean hashPermissions = DataPacketHelper.checkPermissions(UserServiceHelper.getCurrentUserId(), "cts", "bos_parameterconsole", sysEntityName, sdpOutputParams, "47150e89000000ac", "4715a0df000000ac");
            if (!hashPermissions) {
                sdpOutputParams.setSuccess(false);
                return sdpOutputParams;
            }
        }
        List<String> orgNumberList = parameterList.stream().filter(p -> p.containsKey(ORG_NUMBER)).map(p -> p.get(ORG_NUMBER).toString()).collect(Collectors.toList());
        Map<String, Long> currentOrgMap = this.getCurrentEntityNumberIdMap(orgNumberList, BOS_ORG);
        List<String> acctBookNumberList = parameterList.stream().filter(p -> p.containsKey(ACCT_BOOK_NUMBER)).map(p -> p.get(ACCT_BOOK_NUMBER).toString()).collect(Collectors.toList());
        Map<String, Long> currentAcctBookMap = this.getCurrentEntityNumberIdMap(acctBookNumberList, BD_ACCOUNT_BOOKS_TYPE);
        List<String> acctingBookNumberList = parameterList.stream().filter(p -> p.containsKey(ACCTING_BOOK_NUMBER)).map(p -> p.get(ACCTING_BOOK_NUMBER).toString()).collect(Collectors.toList());
        Map<String, Long> currentAcctingBookMap = this.getCurrentEntityNumberIdMap(acctingBookNumberList, GL_ACCOUNT_BOOK);
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        for (Map parameterMap : parameterList) {
            boolean isSuccess;
            ++total;
            if (!this.isRightParam(parameterMap, currentOrgMap, currentAcctBookMap, sdpOutputParams) || !(isSuccess = this.saveSysParam(parameterMap, currentOrgMap, currentAcctBookMap, currentAcctingBookMap, sdpOutputParams, rootOrgId))) continue;
            ++successCount;
        }
        if (successCount == total) {
            sdpOutputParams.setSuccess(true);
        } else if (successCount > 0) {
            sdpOutputParams.getError().insert(0, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5bfc\u5165\u4e0d\u6210\u529f\u7684\u7cfb\u7edf\u53c2\u6570\uff0c\u603b\u6570\uff1a%1$s,\u6210\u529f\u6570\uff1a%2$s %n", (String)"SysParameterImpl_7", (String)"sys-ricc-business", (Object[])new Object[0]), total, successCount));
            sdpOutputParams.setSuccess(false);
        } else {
            sdpOutputParams.getError().insert(0, String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u5bfc\u5165\u5168\u90e8\u4e0d\u6210\u529f\uff0c\u603b\u6570\uff1a%s %n", (String)"SysParameterImpl_8", (String)"sys-ricc-business", (Object[])new Object[0]), total));
            sdpOutputParams.setSuccess(false);
        }
        HashMap<String, Integer> params = new HashMap<String, Integer>(2);
        params.put("successCount", successCount);
        params.put("failedCount", total - successCount);
        sdpOutputParams.setParam(params);
        return sdpOutputParams;
    }

    private void exportAppParam(Map<String, Map<String, String>> selectedParamMap, List<Map<String, Object>> parameterList, AddPacketProgress addPacketProgress) {
        if (selectedParamMap == null || selectedParamMap.isEmpty()) {
            logger.info("\u6682\u65e0\u9700\u8981\u5bfc\u51fa\u7684\u5e94\u7528\u53c2\u6570\u6570\u636e\u3002");
            return;
        }
        Set<String> paramIdSet = selectedParamMap.keySet();
        QFilter paramIdQf = new QFilter(F_PARAM_ID, "in", paramIdSet);
        DynamicObjectCollection sysParameterCollection = this.orm.query(BOS_SVC_SYS_PARAMETER, SYS_PARAMETER_SELECTED_FIELDS, paramIdQf.toArray());
        if (sysParameterCollection == null || sysParameterCollection.isEmpty()) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9700\u8981\u6253\u5305\u7684\u7cfb\u7edf\u53c2\u6570\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u52fe\u9009\u7684\u7cfb\u7edf\u53c2\u6570\u662f\u5426\u5df2\u7ecf\u4fdd\u5b58\u3002", (String)"SysParameterImpl_0", (String)"sys-ricc-business", (Object[])new Object[0]));
        }
        Map<String, String> selectedFieldsMap = this.getSelectedFieldsMap(paramIdSet);
        Map<Long, String> orgIdNumberMap = this.getEntityIdNumberMap(sysParameterCollection, F_ORG_ID, BOS_ORG);
        Map<Long, String> acctBookIdNumberMap = this.getEntityIdNumberMap(sysParameterCollection, F_ACCT_BOOK_ID, BD_ACCOUNT_BOOKS_TYPE);
        Map<Long, String> acctingBookNumberMap = this.getEntityIdNumberMap(sysParameterCollection, F_ACCTING_BOOK_ID, GL_ACCOUNT_BOOK);
        Set<String> appIdSet = selectedParamMap.values().stream().map(p -> (String)p.get(APP_ID)).collect(Collectors.toSet());
        Map<String, List<Map<String, Object>>> customAppParam = this.getAppCustomParam(appIdSet);
        int total = ScheduleUtil.getFeedbackProgressTotalCount((AddPacketProgress)addPacketProgress);
        int complete = ScheduleUtil.getFeedbackProgressCompleteCount((AddPacketProgress)addPacketProgress);
        for (DynamicObject sysParameter : sysParameterCollection) {
            String paramId = sysParameter.getString(F_PARAM_ID);
            Map<String, String> parameterCustomMap = selectedParamMap.get(paramId);
            String appId = parameterCustomMap.get(APP_ID);
            Map<String, Object> dataMap = this.getParameterDataMap(parameterCustomMap, selectedFieldsMap, orgIdNumberMap, acctBookIdNumberMap, acctingBookNumberMap, sysParameter);
            if (dataMap.isEmpty()) continue;
            dataMap.put(APP_CUSTOM, customAppParam.get(appId));
            parameterList.add(dataMap);
            ScheduleUtil.addPacketFeedbackProgress((AddPacketProgress)addPacketProgress, (int)total, (int)(++complete));
        }
    }

    private Map<String, List<Map<String, Object>>> getAppCustomParam(Set<String> appIds) {
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)BOS_CUSTOM_PARAM_APP, (String)"id,name,number,value,key,sort,appid", (QFilter[])new QFilter[]{new QFilter(APP_ID, "in", appIds)}, (String)"sort asc");
        HashMap<String, List<Map<String, Object>>> customAppParamMap = new HashMap<String, List<Map<String, Object>>>(dynamicObjectMap.size());
        for (DynamicObject customDy : dynamicObjectMap.values()) {
            HashMap<String, String> customMap = new HashMap<String, String>(16);
            customMap.put("key", customDy.getString("key"));
            customMap.put("number", ID.genStringId());
            customMap.put("name", customDy.getString("name"));
            customMap.put(VALUE, customDy.getString(VALUE));
            customMap.put("sort", customDy.getString("sort"));
            String appId = customDy.getString(APP_ID).trim();
            customMap.put(APP_ID, appId);
            List appParamList = customAppParamMap.computeIfAbsent(appId, p -> new ArrayList(2));
            customAppParamMap.put(appId, appParamList);
            appParamList.add(customMap);
        }
        return customAppParamMap;
    }

    private void exportSysParam(Map<String, Map<String, String>> selectedParamMap, List<Map<String, Object>> parameterList, AddPacketProgress addPacketProgress) {
        if (selectedParamMap == null || selectedParamMap.isEmpty()) {
            logger.info("\u6682\u65e0\u9700\u8981\u5bfc\u51fa\u7684\u7cfb\u7edf\u53c2\u6570\u6570\u636e\u3002");
            return;
        }
        Set paramIdSet = selectedParamMap.values().stream().map(p -> (String)p.get(PARAM_OBJ)).collect(Collectors.toSet());
        String inParamIdStr = paramIdSet.stream().map(s -> "'" + s + "'").collect(Collectors.joining(","));
        String sql = "SELECT FID, FSELECTEDFIELDS,FFORMID FROM T_BAS_SYSPARACONSOLE WHERE FENABLED = '1' AND FFORMID in (" + inParamIdStr + ")";
        List publicParamList = (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, rs -> {
            ArrayList paramList = new ArrayList(16);
            while (rs.next()) {
                HashMap<String, String> publicParam = new HashMap<String, String>(8);
                publicParam.put("id", rs.getString("FID"));
                publicParam.put("selectfields", rs.getString(F_SELECTED_FIELDS));
                publicParam.put("formid", rs.getString("FFORMID"));
                paramList.add(publicParam);
            }
            return paramList;
        });
        HashMap<String, String> selectedFieldsMap = new HashMap<String, String>(8);
        publicParamList.forEach(p -> {
            String cfr_ignored_0 = (String)selectedFieldsMap.put((String)p.get("id"), (String)p.get("selectfields"));
        });
        HashMap idFormMap = new HashMap(8);
        publicParamList.forEach(p -> {
            String cfr_ignored_0 = (String)idFormMap.put(p.get("formid"), p.get("id"));
        });
        QFilter paramIdQf = new QFilter(F_PARAM_ID, "in", selectedFieldsMap.keySet());
        DynamicObjectCollection sysParameterCol = this.orm.query(BOS_SVC_SYS_PARAMETER, SYS_PARAMETER_SELECTED_FIELDS, paramIdQf.toArray());
        if (sysParameterCol == null || sysParameterCol.isEmpty()) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9700\u8981\u6253\u5305\u7684\u7cfb\u7edf\u53c2\u6570\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u52fe\u9009\u7684\u7cfb\u7edf\u53c2\u6570\u662f\u5426\u5df2\u7ecf\u4fdd\u5b58\u3002", (String)"SysParameterImpl_0", (String)"sys-ricc-business", (Object[])new Object[0]));
        }
        HashMap dataDyMap = new HashMap(sysParameterCol.size());
        sysParameterCol.forEach(p -> dataDyMap.put(p.getString(F_PARAM_ID), p));
        int total = ScheduleUtil.getFeedbackProgressTotalCount((AddPacketProgress)addPacketProgress);
        int complete = ScheduleUtil.getFeedbackProgressCompleteCount((AddPacketProgress)addPacketProgress);
        for (Map.Entry<String, Map<String, String>> selectdParamEntry : selectedParamMap.entrySet()) {
            Map<String, String> parameterCustomMap = selectdParamEntry.getValue();
            String paramGroupId = selectdParamEntry.getKey();
            String paramFormId = parameterCustomMap.get(PARAM_OBJ);
            String paramId = (String)idFormMap.get(paramFormId);
            DynamicObject paramData = (DynamicObject)dataDyMap.get(paramId);
            if (paramData == null) {
                DynamicObject paramNameDy = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_SYS_PARAM_GROUP, (String)"name,param_formid,", (QFilter[])new QFilter[]{new QFilter("param_formid", "=", (Object)paramFormId)});
                String tpl = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9700\u8981\u6253\u5305\u7684%s\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u8be5\u6570\u636e\u662f\u5426\u5df2\u7ecf\u4fdd\u5b58\u3002", (String)"SysParameterImpl_17", (String)"sys-ricc-business", (Object[])new Object[0]);
                throw new RiccBizException(String.format(tpl, paramNameDy.getLocaleString("name").getLocaleValue()));
            }
            String sysShowFields = parameterCustomMap.get("sysShowFields");
            String fields = parameterCustomMap.get(FIELDS);
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)paramFormId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
            String transferFields = this.getTransferFields(formMetadata, fields, sysShowFields);
            parameterCustomMap.put(FIELDS, transferFields);
            Map<String, Object> dataMap = this.getParameterDataMap(parameterCustomMap, selectedFieldsMap, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), paramData);
            if (dataMap.isEmpty()) continue;
            dataMap.put(PARAM_GROUP_ID, paramGroupId);
            parameterList.add(dataMap);
            ScheduleUtil.addPacketFeedbackProgress((AddPacketProgress)addPacketProgress, (int)total, (int)(++complete));
        }
    }

    private void exportSysCustomParam(Map<String, Map<String, String>> selectedParamMap, List<Map<String, Object>> parameterList, AddPacketProgress addPacketProgress) {
        if (selectedParamMap == null || selectedParamMap.isEmpty()) {
            logger.info("\u6682\u65e0\u9700\u8981\u5bfc\u51fa\u7684\u7cfb\u7edf\u81ea\u5b9a\u4e49\u53c2\u6570\u6570\u636e\u3002");
            return;
        }
        int total = ScheduleUtil.getFeedbackProgressTotalCount((AddPacketProgress)addPacketProgress);
        int complete = ScheduleUtil.getFeedbackProgressCompleteCount((AddPacketProgress)addPacketProgress);
        for (Map.Entry<String, Map<String, String>> sysParamEntry : selectedParamMap.entrySet()) {
            String groupId = sysParamEntry.getKey();
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)BOS_CUSTOM_PARAM, (QFilter[])new QFilter[]{new QFilter(GROUP, "=", (Object)Long.parseLong(groupId))});
            if (dynamicObjectMap == null || dynamicObjectMap.isEmpty()) {
                throw new RiccBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9700\u8981\u6253\u5305\u7684\u7cfb\u7edf\u81ea\u5b9a\u4e49\u53c2\u6570\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u52fe\u9009\u7684\u81ea\u5b9a\u4e49\u53c2\u6570\u662f\u5426\u5df2\u7ecf\u4fdd\u5b58\u3002", (String)"SysParameterImpl_14", (String)"sys-ricc-business", (Object[])new Object[0]));
            }
            ArrayList customParameterList = new ArrayList(dynamicObjectMap.size());
            for (DynamicObject customDy : dynamicObjectMap.values()) {
                HashMap<String, String> customMap = new HashMap<String, String>(16);
                customMap.put("key", customDy.getString("key"));
                customMap.put("number", ID.genStringId());
                customMap.put("name", customDy.getString("name"));
                customMap.put(VALUE, customDy.getString(VALUE));
                customMap.put(GROUP, groupId);
                customMap.put("type", "sysCustomParam");
                customParameterList.add(customMap);
                ScheduleUtil.addPacketFeedbackProgress((AddPacketProgress)addPacketProgress, (int)total, (int)(++complete));
            }
            HashMap<String, Object> customDataMap = new HashMap<String, Object>(16);
            customDataMap.put("data", customParameterList);
            customDataMap.put(PARAM_GROUP_ID, groupId);
            customDataMap.put(APP_ID, "");
            customDataMap.put(PARAM_OBJ, BOS_CUSTOM_PARAM_VIEW);
            parameterList.add(customDataMap);
        }
    }

    private void exportInSysTabAppParam(Map<String, Map<String, String>> selectedParamMap, List<Map<String, Object>> parameterList, AddPacketProgress addPacketProgress) {
        if (selectedParamMap == null || selectedParamMap.isEmpty()) {
            return;
        }
        Set paramFormIdSet = selectedParamMap.values().stream().map(p -> (String)p.get(PARAM_OBJ)).collect(Collectors.toSet());
        String inParamIdStr = paramFormIdSet.stream().map(s -> "'" + s + "'").collect(Collectors.joining(","));
        String sql = "SELECT FID, FSELECTEDFIELDS,FFORMID FROM T_BAS_SYSPARACONSOLE WHERE FENABLED = '1' AND FFORMID in (" + inParamIdStr + ")";
        Map paramSelectFiledsMap = (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, rs -> {
            HashMap<String, String> selectFieldsMap = new HashMap<String, String>(2);
            while (rs.next()) {
                selectFieldsMap.put(rs.getString("FID"), rs.getString(F_SELECTED_FIELDS));
            }
            return selectFieldsMap;
        });
        QFilter paramIdQf = new QFilter(F_PARAM_ID, "in", paramSelectFiledsMap.keySet());
        DynamicObjectCollection inSysAppObjectColl = this.orm.query(BOS_SVC_SYS_PARAMETER, SYS_PARAMETER_SELECTED_FIELDS, paramIdQf.toArray());
        if (inSysAppObjectColl == null || inSysAppObjectColl.isEmpty()) {
            HashSet paramIdSet = new HashSet();
            selectedParamMap.keySet().forEach(p -> paramIdSet.add(Long.parseLong(p)));
            Map paramDyMap = BusinessDataServiceHelper.loadFromCache((String)BOS_SYS_PARAM_GROUP, (String)"id,name,param_formid,", (QFilter[])new QFilter[]{new QFilter("id", "in", paramIdSet)});
            String errorName = paramDyMap.values().stream().map(p -> p.getLocaleString("name").getLocaleValue()).collect(Collectors.joining(","));
            String tpl = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9700\u8981\u6253\u5305\u7684%s\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u8be5\u6570\u636e\u662f\u5426\u5df2\u7ecf\u4fdd\u5b58\u3002", (String)"SysParameterImpl_17", (String)"sys-ricc-business", (Object[])new Object[0]);
            throw new RiccBizException(String.format(tpl, errorName));
        }
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)BOS_BASE_PARAMETER, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        Map<Long, String> orgIdNumberMap = this.getEntityIdNumberMap(inSysAppObjectColl, F_ORG_ID, BOS_ORG);
        Map<Long, String> acctBookIdNumberMap = this.getEntityIdNumberMap(inSysAppObjectColl, F_ACCT_BOOK_ID, BD_ACCOUNT_BOOKS_TYPE);
        Map<Long, String> acctingBookNumberMap = this.getEntityIdNumberMap(inSysAppObjectColl, F_ACCTING_BOOK_ID, GL_ACCOUNT_BOOK);
        Set<String> appIdSet = selectedParamMap.values().stream().map(p -> (String)p.get(APP_ID)).collect(Collectors.toSet());
        Map<String, List<Map<String, Object>>> customAppParam = this.getAppCustomParam(appIdSet);
        int total = ScheduleUtil.getFeedbackProgressTotalCount((AddPacketProgress)addPacketProgress);
        int complete = ScheduleUtil.getFeedbackProgressCompleteCount((AddPacketProgress)addPacketProgress);
        for (Map.Entry<String, Map<String, String>> baseParamEntry : selectedParamMap.entrySet()) {
            String paramGroupId = baseParamEntry.getKey();
            Map<String, String> parameterCustomMap = baseParamEntry.getValue();
            String appId = parameterCustomMap.get(APP_ID);
            String sysShowFields = parameterCustomMap.get("sysShowFields");
            String fields = parameterCustomMap.get(FIELDS);
            String transferFields = this.getTransferFields(formMetadata, fields, sysShowFields);
            parameterCustomMap.put(FIELDS, transferFields);
            for (DynamicObject inSysAppData : inSysAppObjectColl) {
                Map<String, Object> dataMap;
                String sysId;
                String paramId = inSysAppData.getString(F_PARAM_ID);
                if (!paramId.equals(sysId = parameterCustomMap.get("sys_id")) || (dataMap = this.getParameterDataMap(parameterCustomMap, paramSelectFiledsMap, orgIdNumberMap, acctBookIdNumberMap, acctingBookNumberMap, inSysAppData)).isEmpty()) continue;
                dataMap.put(APP_CUSTOM, customAppParam.get(appId));
                dataMap.put(PARAM_GROUP_ID, paramGroupId);
                parameterList.add(dataMap);
            }
            ScheduleUtil.addPacketFeedbackProgress((AddPacketProgress)addPacketProgress, (int)total, (int)(++complete));
        }
    }

    private String getTransferFields(FormMetadata formMetadata, String fields, String sysShowPanel) {
        if (StringUtils.isNotEmpty((String)fields)) {
            return fields;
        }
        formMetadata.createIndex();
        List controlAps = formMetadata.getItems();
        Map pluginParam = Collections.emptyMap();
        if (StringUtils.isNotEmpty((String)sysShowPanel)) {
            pluginParam = (Map)SerializationUtils.fromJsonString((String)sysShowPanel, Map.class);
        }
        List showPanel = pluginParam.getOrDefault("showPanel", Collections.emptyList());
        List hidePanel = pluginParam.getOrDefault("hidePanel", Collections.emptyList());
        Set<String> showPanelIds = controlAps.stream().filter(p -> showPanel.contains(p.getKey())).map(AbstractElement::getId).collect(Collectors.toSet());
        Set<String> hidePanelIds = controlAps.stream().filter(p -> hidePanel.contains(p.getKey())).map(AbstractElement::getId).collect(Collectors.toSet());
        if (!showPanelIds.isEmpty()) {
            HashSet<String> showPanelAndChildIds = new HashSet<String>();
            this.getAllChildrenApId(formMetadata, showPanelIds, showPanelAndChildIds);
            return String.join((CharSequence)",", showPanelAndChildIds);
        }
        if (!hidePanelIds.isEmpty()) {
            HashSet<String> hidePanelAndChildIds = new HashSet<String>();
            this.getAllChildrenApId(formMetadata, hidePanelIds, hidePanelAndChildIds);
            Set allFields = controlAps.stream().filter(FieldAp.class::isInstance).map(AbstractElement::getId).collect(Collectors.toSet());
            allFields.removeAll(hidePanelAndChildIds);
            return String.join((CharSequence)",", allFields);
        }
        return "";
    }

    private void getAllChildrenApId(FormMetadata formMetadata, Set<String> parentApIdSet, Set<String> allChildAndParentIds) {
        for (String parentId : parentApIdSet) {
            this.getChildrenFieldAp(formMetadata, allChildAndParentIds, parentId);
        }
    }

    private void getChildrenFieldAp(FormMetadata formMetadata, Set<String> allChildAndParentIds, String showPanelId) {
        ControlAp item = formMetadata.getItem(showPanelId);
        String itemKey = item.getId();
        if (item instanceof FieldAp) {
            allChildAndParentIds.add(itemKey);
        } else if (item instanceof FlexPanelAp) {
            FlexPanelAp flexPanelAp = (FlexPanelAp)item;
            List items = flexPanelAp.getItems();
            if (items == null || items.isEmpty()) {
                return;
            }
            for (ControlAp controlAp : items) {
                this.getChildrenFieldAp(formMetadata, allChildAndParentIds, controlAp.getId());
            }
        }
    }

    private Map<String, String> getSelectedFieldsMap(Set<String> paramIdSet) {
        String inParamIdStr = paramIdSet.stream().map(s -> "'" + s + "'").collect(Collectors.joining(","));
        String sql = "SELECT FID, FSELECTEDFIELDS FROM T_BAS_SYSPARACONSOLE WHERE FENABLED = '1' AND FID in (" + inParamIdStr + ")";
        return (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, rs -> {
            HashMap<String, String> selectedFieldsMap = new HashMap<String, String>(16);
            while (rs.next()) {
                selectedFieldsMap.put(rs.getString("FID"), rs.getString(F_SELECTED_FIELDS));
            }
            return selectedFieldsMap;
        });
    }

    private Map<Long, String> getEntityIdNumberMap(DynamicObjectCollection parameterCollection, String fieldKey, String entityId) {
        Set entityIdSet = parameterCollection.stream().filter(parameter -> parameter.getLong(fieldKey) > 0L).map(parameter -> parameter.getLong(fieldKey)).collect(Collectors.toSet());
        if (entityIdSet.isEmpty()) {
            return Collections.emptyMap();
        }
        QFilter qFilter = new QFilter("id", "in", entityIdSet);
        DynamicObjectCollection entityColl = QueryServiceHelper.query((String)entityId, (String)ID_NUMBER, (QFilter[])qFilter.toArray());
        HashMap<Long, String> entityIdNumberMap = new HashMap<Long, String>(entityColl.size());
        entityColl.forEach(object -> entityIdNumberMap.put(object.getLong("id"), object.getString("number")));
        return entityIdNumberMap;
    }

    private Map<String, Object> getParameterDataMap(Map<String, String> parameterCustomMap, Map<String, String> selectedFieldsMap, Map<Long, String> orgIdNumberMap, Map<Long, String> acctBookIdNumberMap, Map<Long, String> acctingBookNumberMap, DynamicObject sysParameter) {
        String orgIdString = parameterCustomMap.get("org");
        Set orgIdSet = Arrays.stream(orgIdString.split(",")).filter(orgIdStr -> orgIdStr.length() > 0).collect(Collectors.toSet());
        String orgId = sysParameter.getString(F_ORG_ID);
        if (!orgIdSet.isEmpty() && !orgIdSet.contains(orgId)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        long acctBookId = sysParameter.getLong(F_ACCT_BOOK_ID);
        if (acctBookId > 0L) {
            String accountNumber = acctBookIdNumberMap.get(acctBookId);
            if (StringUtils.isEmpty((String)accountNumber)) {
                return Collections.emptyMap();
            }
            dataMap.put(ACCT_BOOK_NUMBER, accountNumber);
        }
        dataMap.put(VIEW_TYP_ID, sysParameter.get(F_VIEW_TYPE_ID));
        dataMap.put("acctbookid", acctBookId);
        long acctingBookId = sysParameter.getLong(F_ACCTING_BOOK_ID);
        dataMap.put("acctingbookid", acctingBookId);
        if (acctingBookId > 0L) {
            dataMap.put(ACCTING_BOOK_NUMBER, acctingBookNumberMap.get(acctingBookId));
        }
        String fieldsStr = parameterCustomMap.get(FIELDS);
        String parameterFormId = parameterCustomMap.get(PARAM_OBJ);
        String fData = sysParameter.getString("FDATA");
        String parameterData = this.transferFieldsFilter(fieldsStr, parameterFormId, fData);
        dataMap.put("orgid", orgId);
        dataMap.put(ORG_NUMBER, orgIdNumberMap.get(Long.parseLong(orgId)));
        dataMap.put("data", parameterData);
        dataMap.put("lockfields", sysParameter.get("FLOCKFIELDS"));
        dataMap.put("paramconfig", sysParameter.get("FPARAMCONFIG"));
        String paramId = sysParameter.get(F_PARAM_ID).toString();
        dataMap.put(PARAM_ID, paramId);
        dataMap.put(PARAM_OBJ, parameterFormId);
        dataMap.put("selectedfields", selectedFieldsMap.get(paramId));
        dataMap.put(APP_ID, parameterCustomMap.get(APP_ID));
        return dataMap;
    }

    private String transferFieldsFilter(String fieldsStr, String parameterFormId, String parameterData) {
        List<String> needTransferFieldKeyList;
        if (!StringUtils.isEmpty((String)fieldsStr) && !(needTransferFieldKeyList = this.getFieldKeyById(fieldsStr, parameterFormId)).isEmpty()) {
            needTransferFieldKeyList.add("_Type_");
            Map parameterDataMap = (Map)JSON.parseObject((String)parameterData, Map.class);
            Set parameterDataEntrySet = parameterDataMap.entrySet();
            HashMap filterDataMap = new HashMap(needTransferFieldKeyList.size());
            for (Map.Entry parameterDataEntry : parameterDataEntrySet) {
                if (!needTransferFieldKeyList.contains(parameterDataEntry.getKey())) continue;
                filterDataMap.put(parameterDataEntry.getKey(), parameterDataEntry.getValue());
            }
            parameterData = JSON.toJSONString(filterDataMap);
        }
        return parameterData;
    }

    private List<String> getFieldKeyById(String fieldsStr, String parameterFormId) {
        ArrayList<String> result = new ArrayList<String>();
        String[] fields = fieldsStr.split(",");
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)parameterFormId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)parameterFormId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        formMetadata.createIndex();
        List controlAps = formMetadata.getItems();
        block0: for (int i = 0; i < fields.length; ++i) {
            for (ControlAp ap : controlAps) {
                FieldAp fap;
                if (!(ap instanceof FieldAp) || !(fap = (FieldAp)ap).getFieldId().equals(fields[i])) continue;
                String fieldKey = ap.getKey();
                result.add(fieldKey);
                if (!(entityMetadata.getFieldByKey(fieldKey) instanceof BasedataField)) continue block0;
                result.add(fieldKey + "_id");
                continue block0;
            }
        }
        return result;
    }

    private Map<String, Long> getCurrentEntityNumberIdMap(List<String> numberList, String entityId) {
        if (numberList.isEmpty()) {
            return Collections.emptyMap();
        }
        QFilter qFilter = new QFilter("number", "in", numberList);
        DynamicObjectCollection entityColl = QueryServiceHelper.query((String)entityId, (String)ID_NUMBER, (QFilter[])qFilter.toArray());
        HashMap<String, Long> numberAndIdMap = new HashMap<String, Long>(entityColl.size());
        entityColl.forEach(p -> numberAndIdMap.put(p.getString("number"), p.getLong("id")));
        return numberAndIdMap;
    }

    private String writeSelectedInfo(List<Map<String, Object>> parameterList) {
        StringBuilder selectedInfo = new StringBuilder();
        selectedInfo.append(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"SysParameterImpl_6", (String)"sys-ricc-business", (Object[])new Object[0])).append('\t').append(ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u5e94\u7528", (String)"SysParameterImpl_26", (String)"sys-ricc-business", (Object[])new Object[0])).append('\t').append(ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u7ec4\u7ec7", (String)"SysParameterImpl_27", (String)"sys-ricc-business", (Object[])new Object[0])).append('\n');
        List appidList = parameterList.stream().map(sysParameter -> sysParameter.get(APP_ID).toString()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", appidList);
        DynamicObjectCollection entityColl = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,number,name", (QFilter[])qFilter.toArray());
        HashMap appIdNameMap = new HashMap(entityColl.size());
        entityColl.forEach(object -> appIdNameMap.put(object.getString("id"), object.getString("name")));
        List sysParamGroupIdList = parameterList.stream().filter(p -> StringUtils.isNotEmpty((String)((String)p.get(PARAM_GROUP_ID)))).map(sysParameter -> Long.parseLong((String)sysParameter.get(PARAM_GROUP_ID))).collect(Collectors.toList());
        HashMap paramGroupIdNameMap = new HashMap(sysParamGroupIdList.size());
        if (!sysParamGroupIdList.isEmpty()) {
            Map bosSysParamGroup = BusinessDataServiceHelper.loadFromCache((String)BOS_SYS_PARAM_GROUP, (String)"id,name,param_formid", (QFilter[])new QFilter[]{new QFilter("id", "in", sysParamGroupIdList)});
            bosSysParamGroup.values().forEach(p -> paramGroupIdNameMap.put(p.getString("id"), p.getLocaleString("name").getLocaleValue()));
        }
        int num = 1;
        for (Map<String, Object> sysParameter2 : parameterList) {
            String appNumber = (String)appIdNameMap.get(sysParameter2.get(APP_ID).toString());
            String paramGroupId = (String)sysParameter2.get(PARAM_GROUP_ID);
            if (!StringUtils.isEmpty((String)paramGroupId)) {
                selectedInfo.append(String.format("%1$s\t\t%2$s\t\t%3$s %n", num, paramGroupIdNameMap.get(paramGroupId), ""));
            } else {
                selectedInfo.append(String.format("%1$s\t\t%2$s\t\t%3$s %n", num, appNumber, sysParameter2.get(ORG_NUMBER)));
            }
            ++num;
        }
        return selectedInfo.toString();
    }

    private boolean isRightParam(Map<String, Object> parameterMap, Map<String, Long> currentOrgMap, Map<String, Long> currentAcctBookMap, SdpOutputParams sdpOutputParams) {
        String data = parameterMap.getOrDefault("data", "").toString();
        String appId = parameterMap.getOrDefault(APP_ID, "").toString();
        String orgNumber = parameterMap.getOrDefault(ORG_NUMBER, "").toString();
        String paramFormId = parameterMap.getOrDefault(PARAM_OBJ, "").toString();
        long acctBookId = Long.parseLong(parameterMap.getOrDefault("acctbookid", 0L).toString());
        String acctBookNumber = parameterMap.getOrDefault(ACCT_BOOK_NUMBER, "").toString();
        if (BOS_CUSTOM_PARAM_VIEW.equals(paramFormId)) {
            List customParamList = (List)JSON.parseObject((String)data, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            return this.checkCustomParams(customParamList, sdpOutputParams);
        }
        Map fileSysParamDataMap = (Map)JSON.parseObject((String)data, Map.class);
        AppInfo appInfo = StringUtils.isEmpty((String)appId) ? null : EntityMetadataCache.getAppInfo((String)appId);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)paramFormId);
        String appInfoNumber = dataEntityType.getName();
        String appInfoName = dataEntityType.getDisplayName().getLocaleValue();
        String baseDataErrorTpl = ResManager.loadKDString((String)"\u5bfc\u5165\u7cfb\u7edf\u53c2\u6570\u7f16\u7801\u201c%1$s\u201d\uff0c\u7cfb\u7edf\u53c2\u6570\u540d\u79f0\u201d%2$s\u201d\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\u5b57\u6bb5\u201c%4$s(%5$s)\u201d\u65e0\u6cd5\u901a\u8fc7id\uff1a%6$s\u5728\u76ee\u6807\u73af\u5883\u5339\u914d\u5230\u6570\u636e\uff0c\u5efa\u8bae\u624b\u5de5\u5728\u76ee\u6807\u73af\u5883\u65b0\u589e\u8be5\u6761\u7cfb\u7edf\u53c2\u6570\u6570\u636e%n", (String)"SysParameterImpl_24", (String)"sys-ricc-business", (Object[])new Object[0]);
        if (appInfo != null) {
            baseDataErrorTpl = ResManager.loadKDString((String)"\u5bfc\u5165\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\uff0c\u5e94\u7528\u540d\u79f0\u201d%2$s\u201d\uff0c\u7ec4\u7ec7\u7f16\u7801\u4e3a\u201d%3$s\u201d\u7684\u7cfb\u7edf\u53c2\u6570\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\u5b57\u6bb5\u201c%4$s(%5$s)\u201d\u65e0\u6cd5\u901a\u8fc7id\uff1a%6$s\u5728\u76ee\u6807\u73af\u5883\u5339\u914d\u5230\u6570\u636e\uff0c\u5efa\u8bae\u624b\u5de5\u5728\u76ee\u6807\u73af\u5883\u65b0\u589e\u8be5\u6761\u7cfb\u7edf\u53c2\u6570\u6570\u636e%n", (String)"SysParameterImpl_20", (String)"sys-ricc-business", (Object[])new Object[0]);
            appInfoNumber = appInfo.getNumber();
            appInfoName = appInfo.getName().getLocaleValue();
        }
        if (fileSysParamDataMap == null) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\uff0c\u5e94\u7528\u540d\u79f0\u201d%2$s\u201d\uff0c\u7ec4\u7ec7\u7f16\u7801\u4e3a\u201d%3$s\u201d\u7684\u7cfb\u7edf\u53c2\u6570\u5931\u8d25\u3002\u7cfb\u7edf\u53c2\u6570\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5c5e\u4e8e\u5f02\u5e38\u6570\u636e %n", (String)"SysParameterImpl_9", (String)"sys-ricc-business", (Object[])new Object[0]), appInfoNumber, appInfoName, orgNumber);
            sdpOutputParams.append(errorMsg);
            return false;
        }
        if (!this.checkBaseDataExists(dataEntityType, fileSysParamDataMap, appInfoNumber, appInfoName, orgNumber, baseDataErrorTpl, sdpOutputParams)) {
            return false;
        }
        if (!StringUtils.isEmpty((String)appId)) {
            boolean orgHasViewType;
            if (appInfo == null) {
                String msgTpl = ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u627e\u4e0d\u5230\u5e94\u7528id\u4e3a\u201c%s\u201d\u7684\u5e94\u7528\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4\u5e94\u7528\u5143\u6570\u636e\u662f\u5426\u5df2\u90e8\u7f72 %n", (String)"SysParameterImpl_25", (String)"sys-ricc-business", (Object[])new Object[0]);
                sdpOutputParams.append(String.format(msgTpl, appId));
                return false;
            }
            ParamPublishObject param = ParameterReader.getParameterObject(null, (String)appId);
            if (param == null) {
                String msgTpl = ResManager.loadKDString((String)"\u5bfc\u5165\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\uff0c\u5e94\u7528\u540d\u79f0\u201d%2$s\u201d\u7684\u7cfb\u7edf\u53c2\u6570\u5931\u8d25\u3002\u8be5\u5e94\u7528\u6682\u65e0\u5df2\u542f\u7528\u7684\u7cfb\u7edf\u53c2\u6570\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4\u5e94\u7528\u662f\u5426\u5df2\u7ecf\u53d1\u5e03\u7cfb\u7edf\u53c2\u6570\u3002 %n", (String)"SysParameterImpl_10", (String)"sys-ricc-business", (Object[])new Object[0]);
                sdpOutputParams.append(String.format(msgTpl, appInfoNumber, appInfoName));
                return false;
            }
            Long orgId = currentOrgMap.get(orgNumber);
            if (orgId == null) {
                String msgTpl = ResManager.loadKDString((String)"\u5bfc\u5165\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\uff0c\u5e94\u7528\u540d\u79f0\u201d%2$s\u201d\u7684\u7cfb\u7edf\u53c2\u6570\u5931\u8d25\u3002\u5f53\u524d\u7cfb\u7edf\u4e0d\u5b58\u5728\u7ec4\u7ec7\u7f16\u7801\u4e3a\u201d%3$s\u201d\u7684\u7ec4\u7ec7\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u3002 %n", (String)"SysParameterImpl_2", (String)"sys-ricc-business", (Object[])new Object[0]);
                sdpOutputParams.append(String.format(msgTpl, appInfoNumber, appInfoName, orgNumber));
                return false;
            }
            if (!this.checkAppStatusAndPermission(appInfo, appInfoNumber, appInfoName, orgNumber, sdpOutputParams)) {
                return false;
            }
            String viewTypeNumber = parameterMap.get(VIEW_TYP_ID).toString();
            if (StringUtils.isNotEmpty((String)viewTypeNumber) && !"0".equals(viewTypeNumber) && !(orgHasViewType = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)viewTypeNumber))) {
                String msgTpl = ResManager.loadKDString((String)"\u5bfc\u5165\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\uff0c\u5e94\u7528\u540d\u79f0\u201d%2$s\u201d\u7684\u7cfb\u7edf\u53c2\u6570\u5931\u8d25\u3002\u7ec4\u7ec7\u7f16\u7801\u4e3a\u201d%3$s\u201d\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\u804c\u80fd\u7f16\u7801\u4e3a\u201c%4$s\u201d\u7684\u804c\u80fd\uff0c\u8bf7\u786e\u8ba4\u3002 %n", (String)"SysParameterImpl_11", (String)"sys-ricc-business", (Object[])new Object[0]);
                sdpOutputParams.append(String.format(msgTpl, appInfoNumber, appInfoName, orgNumber, viewTypeNumber));
                return false;
            }
            if (acctBookId != 0L && currentAcctBookMap.get(acctBookNumber) == null) {
                String msgTpl = ResManager.loadKDString((String)"\u5bfc\u5165\u5e94\u7528\u7f16\u7801\u201c%1$s\u201c\uff0c\u5e94\u7528\u540d\u79f0\u201c%2$s\u201c\u7684\u7cfb\u7edf\u53c2\u6570\u5931\u8d25\u3002\u5f53\u524d\u7cfb\u7edf\u4e0d\u5b58\u5728\u8d26\u7c3f\u7f16\u7801\u4e3a\u201c%3$s\u201c\u7684\u8d26\u7c3f\u7c7b\u578b\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u3002%n", (String)"SysParameterImpl_3", (String)"sys-ricc-business", (Object[])new Object[0]);
                sdpOutputParams.append(String.format(msgTpl, appInfoNumber, appInfoName, acctBookNumber));
                return false;
            }
            String appCustom = parameterMap.getOrDefault(APP_CUSTOM, "").toString();
            if (StringUtils.isNotEmpty((String)appCustom)) {
                List parameterList = (List)JSON.parseObject((String)appCustom, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
                return this.checkCustomParams(parameterList, sdpOutputParams);
            }
        } else {
            String entityName = ResManager.loadKDString((String)"\u516c\u5171\u53c2\u6570", (String)"SysParameterImpl_13", (String)"sys-ricc-business", (Object[])new Object[0]);
            return DataPacketHelper.checkPermissions(UserServiceHelper.getCurrentUserId(), "cts", "bos_publicparametertpl", entityName, sdpOutputParams, "47150e89000000ac", "4715a0df000000ac");
        }
        return true;
    }

    private boolean checkBaseDataExists(MainEntityType dataEntityType, Map<String, Object> fileSysParamDataMap, String appInfoNumber, String appInfoName, String orgNumber, String baseDataErrorTpl, SdpOutputParams sdpOutputParams) {
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            Set baseDataSet;
            QFilter qFilter;
            DynamicObjectCollection query;
            String type;
            String key = property.getName();
            Object val = fileSysParamDataMap.get(key + "_id");
            if (property instanceof ItemClassProp && Objects.nonNull(val)) {
                String typePropName = ((ItemClassProp)property).getTypePropName();
                String type2 = (String)fileSysParamDataMap.get(typePropName);
                boolean exists = QueryServiceHelper.exists((String)type2, (Object)val);
                if (exists) continue;
                String name = property.getDisplayName().getLocaleValue();
                String errorMsg = String.format(baseDataErrorTpl, appInfoNumber, appInfoName, orgNumber, name, key, val);
                sdpOutputParams.append(errorMsg);
                return false;
            }
            if (property instanceof BasedataProp && Objects.nonNull(val)) {
                type = ((BasedataProp)property).getBaseEntityId();
                boolean exists = QueryServiceHelper.exists((String)type, (Object)val);
                if (exists) continue;
                String name = property.getDisplayName().getLocaleValue();
                String errorMsg = String.format(baseDataErrorTpl, appInfoNumber, appInfoName, orgNumber, name, key, val);
                sdpOutputParams.append(errorMsg);
                return false;
            }
            if (!(property instanceof MulBasedataProp)) continue;
            type = ((MulBasedataProp)property).getBaseEntityId();
            JSONArray valColl = fileSysParamDataMap.getOrDefault(key, null);
            if (valColl == null || valColl.isEmpty() || (query = QueryServiceHelper.query((String)type, (String)"id", (QFilter[])(qFilter = new QFilter("id", "in", baseDataSet = valColl.stream().map(p -> ((JSONObject)p).get((Object)"fbasedataid_id")).collect(Collectors.toSet()))).toArray())).size() == baseDataSet.size()) continue;
            String name = property.getDisplayName().getLocaleValue();
            String errorMsg = String.format(baseDataErrorTpl, appInfoNumber, appInfoName, orgNumber, name, key, baseDataSet);
            sdpOutputParams.append(errorMsg);
            return false;
        }
        return true;
    }

    private boolean checkAppStatusAndPermission(AppInfo appInfo, String appInfoNumber, String appInfoName, String orgNumber, SdpOutputParams sdpOutputParams) {
        Map customParameter = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        boolean isUseNewAppInfo = Boolean.parseBoolean(customParameter.getOrDefault("SVC_IS_USE_NEW_APP_INFO", "true"));
        if (isUseNewAppInfo) {
            String appId = appInfo.getId();
            boolean appIsDisabled = QueryServiceHelper.exists((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)appId).and(new QFilter("deploystatus", "=", (Object)"1"))});
            if (appIsDisabled) {
                String msgTpl = ResManager.loadKDString((String)"\u5bfc\u5165\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\uff0c\u5e94\u7528\u540d\u79f0\u201d%2$s\u201d\uff0c\u7ec4\u7ec7\u7f16\u7801\u4e3a\u201d%3$s\u201d\u7684\u7cfb\u7edf\u53c2\u6570\u5931\u8d25\u3002\u8be5\u5e94\u7528\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u4fee\u6539\u8be5\u5e94\u7528\u7cfb\u7edf\u53c2\u6570\u3002%n", (String)"SysParameterImpl_22", (String)"sys-ricc-business", (Object[])new Object[0]);
                sdpOutputParams.append(String.format(msgTpl, appInfoNumber, appInfoName, orgNumber));
                return false;
            }
            Set disabledCloudIds = ManageServiceHelper.getDisabledCloudIds();
            if (disabledCloudIds != null && disabledCloudIds.contains(appInfo.getCloudId())) {
                String msgTpl = ResManager.loadKDString((String)"\u5bfc\u5165\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\uff0c\u5e94\u7528\u540d\u79f0\u201d%2$s\u201d\uff0c\u7ec4\u7ec7\u7f16\u7801\u4e3a\u201d%3$s\u201d\u7684\u7cfb\u7edf\u53c2\u6570\u5931\u8d25\u3002\u8be5\u5e94\u7528\u6240\u5728\u4e91\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u4fee\u6539\u8be5\u5e94\u7528\u7cfb\u7edf\u53c2\u6570\u3002%n", (String)"SysParameterImpl_21", (String)"sys-ricc-business", (Object[])new Object[0]);
                sdpOutputParams.append(String.format(msgTpl, appInfoNumber, appInfoName, orgNumber));
                return false;
            }
            Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
            if (disabledAppIds != null && disabledAppIds.contains(appId)) {
                String msgTpl = ResManager.loadKDString((String)"\u5bfc\u5165\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\uff0c\u5e94\u7528\u540d\u79f0\u201d%2$s\u201d\uff0c\u7ec4\u7ec7\u7f16\u7801\u4e3a\u201d%3$s\u201d\u7684\u7cfb\u7edf\u53c2\u6570\u5931\u8d25\u3002\u8be5\u5e94\u7528\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u4fee\u6539\u8be5\u5e94\u7528\u7cfb\u7edf\u53c2\u6570\u3002%n", (String)"SysParameterImpl_22", (String)"sys-ricc-business", (Object[])new Object[0]);
                sdpOutputParams.append(String.format(msgTpl, appInfoNumber, appInfoName, orgNumber));
                return false;
            }
            AdminAppResult adminAppResult = PermissionServiceHelper.getAdminApps((Long)RequestContext.get().getCurrUserId());
            if (adminAppResult != null && adminAppResult.needAdminAppRange() && !adminAppResult.getAppIds().contains(appId)) {
                String msgTpl = ResManager.loadKDString((String)"\u5bfc\u5165\u5e94\u7528\u7f16\u7801\u201c%1$s\u201d\uff0c\u5e94\u7528\u540d\u79f0\u201d%2$s\u201d\uff0c\u7ec4\u7ec7\u7f16\u7801\u4e3a\u201d%3$s\u201d\u7684\u7cfb\u7edf\u53c2\u6570\u5931\u8d25\u3002\u8be5\u5e94\u7528\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237\u7ba1\u8f96\u8303\u56f4\uff0c\u65e0\u6743\u9650\u4fee\u6539\u8be5\u5e94\u7528\u7cfb\u7edf\u53c2\u6570\u3002%n", (String)"SysParameterImpl_23", (String)"sys-ricc-business", (Object[])new Object[0]);
                sdpOutputParams.append(String.format(msgTpl, appInfoNumber, appInfoName, orgNumber));
                return false;
            }
        }
        return true;
    }

    private boolean checkCustomParams(List<Map<String, Object>> customParamList, SdpOutputParams sdpOutputParams) {
        if (customParamList == null || customParamList.isEmpty()) {
            return true;
        }
        Set keys = customParamList.stream().map(e -> (String)e.get("key")).collect(Collectors.toSet());
        if (keys.size() < customParamList.size()) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53c2\u6570\u540d\u79f0\u5b58\u5728\u91cd\u590d\u3002", (String)"SysParameterImpl_15", (String)"sys-ricc-business", (Object[])new Object[0]));
            return false;
        }
        for (String key : keys) {
            if (Pattern.matches(CUSTOM_KEY_CHECK_REGEX, key)) continue;
            sdpOutputParams.append(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53c2\u6570\u540d\u79f0\u5fc5\u987b\u7531\u82f1\u6587\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"SysParameterImpl_16", (String)"sys-ricc-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean saveSysParam(Map<String, Object> parameterMap, Map<String, Long> currentOrgMap, Map<String, Long> currentAcctBookMap, Map<String, Long> currentAcctingBookMap, SdpOutputParams sdpOutputParams, Long rootOrgId) {
        String paramFormId = parameterMap.getOrDefault(PARAM_OBJ, "").toString();
        String data = parameterMap.getOrDefault("data", "").toString();
        String appId = parameterMap.getOrDefault(APP_ID, " ").toString();
        if (BOS_CUSTOM_PARAM_VIEW.equals(paramFormId)) {
            return this.saveSysCustomParameter(data, sdpOutputParams);
        }
        String viewTypeId = parameterMap.get(VIEW_TYP_ID).toString();
        long acctBookId = Long.parseLong(parameterMap.getOrDefault("acctbookid", 0).toString());
        String acctBookNumber = parameterMap.getOrDefault(ACCT_BOOK_NUMBER, "").toString();
        if (acctBookId > 0L) {
            acctBookId = currentAcctBookMap.get(acctBookNumber);
        }
        long acctingBookId = Long.parseLong(parameterMap.getOrDefault("acctingbookid", 0).toString());
        String acctingBookNumber = parameterMap.getOrDefault(ACCTING_BOOK_NUMBER, "").toString();
        if (acctingBookId > 0L) {
            acctingBookId = currentAcctingBookMap.get(acctingBookNumber);
        }
        String orgNumber = parameterMap.getOrDefault(ORG_NUMBER, "").toString();
        long orgId = currentOrgMap.getOrDefault(orgNumber, 0L);
        ParamPublishObject param = null;
        param = StringUtils.isEmpty((String)paramFormId) ? this.parameterReaderService.getParameterObject(null, appId) : this.parameterReaderService.getParameterObjByFormId(paramFormId);
        String paramId = param.getId();
        logger.info("\u6587\u4ef6\u4e2d\u7684paramid" + parameterMap.get(PARAM_ID) + "\u5f53\u524d\u7cfb\u7edf\u67e5\u8be2\u5230\u7684paramid" + paramId);
        Map sysParamDataMap = this.querySysParamData(orgId, viewTypeId, paramId, acctBookId, acctingBookId);
        Map fileSysParamDataMap = (Map)JSON.parseObject((String)data, Map.class);
        if (sysParamDataMap == null || sysParamDataMap.isEmpty()) {
            sysParamDataMap = fileSysParamDataMap;
        } else {
            sysParamDataMap.putAll(fileSysParamDataMap);
        }
        String sysParameterJsonData = JSON.toJSONString((Object)sysParamDataMap);
        AppParam appParam = new AppParam(null, appId, viewTypeId, Long.valueOf(orgId), Long.valueOf(acctBookId), Long.valueOf(acctingBookId));
        appParam.setFormId(param.getFormId());
        try (TXHandle h = TX.required();){
            try {
                this.parameterWriterService.saveSystemParameter(appParam, sysParameterJsonData);
                String selectedFields = parameterMap.getOrDefault("selectedfields", "").toString();
                this.saveSysParameterSelectedFields(paramId, selectedFields);
                String lockFields = parameterMap.getOrDefault("lockfields", "").toString();
                String paramConfig = parameterMap.getOrDefault("paramconfig", "").toString();
                this.saveGroupControlFields(viewTypeId, orgId, acctBookId, paramId, lockFields, paramConfig);
                String appCustom = parameterMap.getOrDefault(APP_CUSTOM, "").toString();
                this.saveAppCustom(appCustom, appId);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                h.markRollback();
                throw e;
            }
            if (orgId == rootOrgId) {
                LocalCacheUtils.remove((String)(RequestContext.get().getAccountId() + "_commonparameters"));
            }
            this.sendMqMessage(appParam, sysParamDataMap, sysParameterJsonData);
        }
        catch (Exception e) {
            AppInfo appInfo = EntityMetadataCache.getAppInfo((String)appId);
            String msg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5e94\u7528\u7f16\u7801\u201d%1$s\u201d\uff0c\u5e94\u7528\u540d\u79f0\u201d%2$s\u201d\uff0c\u7ec4\u7ec7\u7f16\u7801\u4e3a\u201d%3$s\u201d\u7684\u7cfb\u7edf\u53c2\u6570\u5931\u8d25\u3002%4$s %n", (String)"SysParameterImpl_5", (String)"sys-ricc-business", (Object[])new Object[0]), appInfo.getNumber(), appInfo.getName(), orgNumber, e.getMessage());
            sdpOutputParams.append(msg, (Throwable)e);
            logger.error(msg, (Throwable)e);
            return false;
        }
        return true;
    }

    private void saveSysParameterSelectedFields(String paramId, String selectedFields) {
        if (StringUtils.isEmpty((String)selectedFields)) {
            return;
        }
        String sql = "update T_BAS_SYSPARACONSOLE set FSELECTEDFIELDS=? where FENABLED='1' and FID=?";
        ArrayList<SqlParameter> param = new ArrayList<SqlParameter>();
        param.add(new SqlParameter(12, (Object)selectedFields));
        param.add(new SqlParameter(12, (Object)paramId));
        DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])param.toArray(new SqlParameter[param.size()]));
    }

    private void saveGroupControlFields(String viewTypeId, Long orgId, long acctBookId, String paramId, String lockFields, String paramConfig) {
        if (StringUtils.isEmpty((String)lockFields)) {
            return;
        }
        String sql = "update T_BAS_SYSPARAMETER set FLOCKFIELDS=?, fparamconfig=?  where FORGID=? and FVIEWTYPEID=? and FACCTBOOKID=? and FPARAMID=?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":FORGID", -5, (Object)orgId));
        params.add(new SqlParameter(":FVIEWTYPEID", 12, (Object)viewTypeId));
        params.add(new SqlParameter(":FACCTBOOKID", -5, (Object)acctBookId));
        params.add(new SqlParameter(":FPARAMID", 12, (Object)paramId));
        params.add(0, new SqlParameter(":FLOCKFIELDS", 12, (Object)lockFields));
        params.add(1, new SqlParameter(":FPARAMCONFIG", 12, (Object)paramConfig));
        DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
    }

    private void saveAppCustom(String appCustomString, String appId) {
        if (StringUtils.isEmpty((String)appCustomString)) {
            logger.info("\u5e94\u7528\uff1a" + appId + "\u81ea\u5b9a\u4e49\u53c2\u6570\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u9700\u4fdd\u5b58");
            return;
        }
        List parameterList = (List)JSON.parseObject((String)appCustomString, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)BOS_CUSTOM_PARAM_APP);
        DynamicObject[] existAppCustomParamArr = BusinessDataServiceHelper.load((String)BOS_CUSTOM_PARAM_APP, (String)"id,number,name,value,appid,sort,key,status,enable", (QFilter[])new QFilter[]{new QFilter(APP_ID, "=", (Object)appId)});
        HashMap existAppCustomParamMap = new HashMap(existAppCustomParamArr.length);
        Arrays.stream(existAppCustomParamArr).forEach(p -> existAppCustomParamMap.put(p.getString("key"), p));
        ArrayList<DynamicObject> editObjList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> newObjList = new ArrayList<DynamicObject>(10);
        for (Map paramMap : parameterList) {
            String key = (String)paramMap.get("key");
            DynamicObject existAppParamDy = (DynamicObject)existAppCustomParamMap.get(key);
            if (existAppParamDy == null) {
                existAppParamDy = new DynamicObject((DynamicObjectType)dataEntityType);
                newObjList.add(existAppParamDy);
            } else {
                editObjList.add(existAppParamDy);
            }
            existAppParamDy.set("key", (Object)key);
            existAppParamDy.set("number", paramMap.get("number"));
            existAppParamDy.set("name", paramMap.get("name"));
            existAppParamDy.set(VALUE, paramMap.get(VALUE));
            existAppParamDy.set(APP_ID, paramMap.get(APP_ID));
            existAppParamDy.set("sort", paramMap.get("sort"));
            existAppParamDy.set("status", (Object)"C");
            existAppParamDy.set("enable", (Object)"1");
        }
        try (TXHandle h = TX.required();){
            try {
                if (!editObjList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])editObjList.toArray(new DynamicObject[0]));
                }
                if (!newObjList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])newObjList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                h.markRollback();
                String msg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5e94\u7528\u81ea\u5b9a\u4e49\u53c2\u6570\u5931\u8d25\uff0c\u5177\u4f53\u539f\u56e0\uff1a%s", (String)"SysParameterImpl_19", (String)"sys-ricc-business", (Object[])new Object[0]), e.getMessage());
                throw new RiccBizException(msg, (Throwable)e);
            }
        }
        ThreadCache.remove((Object)("parameterCustom." + appId));
    }

    private Map<String, Object> querySysParamData(Long orgId, String viewType, String paramId, long acctBookId, long acctingBookId) {
        QFilter qViewType = new QFilter(F_VIEW_TYPE_ID, "is not null", (Object)"");
        if (viewType != null) {
            qViewType = new QFilter(F_VIEW_TYPE_ID, "=", (Object)viewType);
        }
        QFilter qParamId = new QFilter(F_PARAM_ID, "=", (Object)paramId);
        QFilter qOrgId = new QFilter(F_ORG_ID, "=", (Object)orgId);
        QFilter qAccBookId = new QFilter(F_ACCT_BOOK_ID, "=", (Object)acctBookId);
        QFilter qAcctingBookId = new QFilter(F_ACCT_BOOK_ID, "=", (Object)acctingBookId);
        QFilter[] qf = new QFilter[]{qViewType, qParamId, qOrgId, qAccBookId, qAcctingBookId};
        DynamicObject sysParameter = QueryServiceHelper.queryOne((String)BOS_SVC_SYS_PARAMETER, (String)"id,FDATA", (QFilter[])qf);
        if (sysParameter == null) {
            return Collections.emptyMap();
        }
        String sysParameterData = sysParameter.getString("FDATA");
        if (StringUtils.isEmpty((String)sysParameterData)) {
            return Collections.emptyMap();
        }
        return (Map)JSON.parseObject((String)sysParameterData, Map.class);
    }

    private boolean saveSysCustomParameter(String data, SdpOutputParams sdpOutputParams) {
        List parameterList = (List)JSON.parseObject((String)data, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)BOS_CUSTOM_PARAM);
        Set groupIdSet = parameterList.stream().map(p -> Long.parseLong(p.get(GROUP).toString())).collect(Collectors.toSet());
        DynamicObject[] existSysCustomParamArr = BusinessDataServiceHelper.load((String)BOS_CUSTOM_PARAM, (String)"id,number,name,value,group,key,status,enable", (QFilter[])new QFilter[]{new QFilter(GROUP, "in", groupIdSet)});
        HashMap existSysCustomParamMap = new HashMap(existSysCustomParamArr.length);
        Arrays.stream(existSysCustomParamArr).forEach(p -> existSysCustomParamMap.put(p.get("group_id") + p.getString("key"), p));
        ArrayList<DynamicObject> editObjList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> newObjList = new ArrayList<DynamicObject>(10);
        for (Map paramMap : parameterList) {
            String key = (String)paramMap.get("key");
            Long group = Long.parseLong((String)paramMap.get(GROUP));
            DynamicObject existSysParam = (DynamicObject)existSysCustomParamMap.get(group + key);
            if (existSysParam == null) {
                existSysParam = new DynamicObject((DynamicObjectType)dataEntityType);
                newObjList.add(existSysParam);
            } else {
                editObjList.add(existSysParam);
            }
            existSysParam.set("key", (Object)key);
            existSysParam.set("number", paramMap.get("number"));
            existSysParam.set("name", paramMap.get("name"));
            existSysParam.set(VALUE, paramMap.get(VALUE));
            existSysParam.set("status", (Object)"C");
            existSysParam.set("enable", (Object)"1");
            existSysParam.set(GROUP, (Object)group);
        }
        try (TXHandle h = TX.required();){
            try {
                if (!editObjList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])editObjList.toArray(new DynamicObject[0]));
                }
                if (!newObjList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])newObjList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                h.markRollback();
                String msg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u7cfb\u7edf\u81ea\u5b9a\u4e49\u53c2\u6570\u5931\u8d25\uff0c\u5177\u4f53\u539f\u56e0\uff1a%s", (String)"SysParameterImpl_18", (String)"sys-ricc-business", (Object[])new Object[0]), e.getMessage());
                sdpOutputParams.append(msg, (Throwable)e);
                boolean bl = false;
                if (h != null) {
                    if (var11_11 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var11_11.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return bl;
            }
        }
        ThreadCache.remove((Object)"parameterCustom");
        return true;
    }

    private void sendMqMessage(AppParam appParam, Map<String, Object> jsonStringMap, String jsonStringData) {
        String cloudId = appParam.getCloudId();
        String appId = appParam.getAppId();
        try {
            Object region = jsonStringMap.get("kdsysparametermqregion");
            Object queue = jsonStringMap.get("kdsysparametermqqueue");
            if (region != null && queue != null) {
                MessagePublisher mq = MQFactory.get().createSimplePublisher(region.toString(), queue.toString());
                HashMap<String, Object> systemParameter = new HashMap<String, Object>(8);
                systemParameter.put("cloudId", cloudId);
                systemParameter.put("appId", appId);
                systemParameter.put("viewType", appParam.getViewType());
                systemParameter.put("orgId", appParam.getOrgId());
                systemParameter.put("acctBookId", appParam.getActBookId());
                systemParameter.put("acctingBookId", appParam.getAcctingBookId());
                systemParameter.put("data", jsonStringData);
                mq.publish(systemParameter);
                logger.info("MQ\u53d1\u9001\u7cfb\u7edf\u53c2\u6570\u6d88\u606f\uff1a" + SerializationUtils.toJsonString(systemParameter));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }
}

