/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.api.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.bos.zip.io.inputstream.ZipInputStream;
import kd.sys.ricc.api.ApiArgs;
import kd.sys.ricc.api.RiccWebApiService;
import kd.sys.ricc.business.datapacket.upload.DataPackageUploader;
import kd.sys.ricc.business.log.LogRecorder;
import kd.sys.ricc.business.sync.SyncDataPacketTask;
import kd.sys.ricc.common.enums.PacketDataSourceTypeEnum;
import kd.sys.ricc.common.enums.TransferStatusEnum;
import kd.sys.ricc.common.util.Hex;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;

public class DataPkgTransferAndSynService
extends RiccWebApiService {
    private static final Log logger = LogFactory.getLog(DataPkgTransferAndSynService.class);

    @Override
    protected void checkParam(ApiArgs apiArgs) {
        StringBuilder message = new StringBuilder();
        boolean isRightMethodName = this.isRightMethodName(apiArgs, message);
        boolean isRightPacketNumber = this.isRightPacketNumber(apiArgs, message);
        boolean isRightData = this.isRightData(apiArgs, message);
        if (!(isRightMethodName && isRightPacketNumber && isRightData)) {
            this.buildParamCheckError(apiArgs, message.toString());
            return;
        }
    }

    private boolean isRightMethodName(ApiArgs apiArgs, StringBuilder message) {
        Map<String, Object> params = apiArgs.getParam();
        String methodName = (String)params.get("methodName");
        if (StringUtils.isEmpty((String)methodName)) {
            String error = ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u4ece\u53c2\u6570\u4e2d\u65e0\u6cd5\u83b7\u53d6\u4f20\u8f93\u65b9\u5f0f\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DataPkgTransferAndSynService_6", (String)"sys-ricc-platform", (Object[])new Object[0]);
            message.append(error);
            message.append('\n');
            return false;
        }
        if (!(methodName.equals("transfer") || methodName.equals("transferandsyn") || methodName.equals("onlysyn"))) {
            String error = String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u4f20\u8f93\u65b9\u5f0f\u201c%1$s\u201d\uff0c\u8bf7\u786e\u8ba4", (String)"DataPkgTransferAndSynService_7", (String)"sys-ricc-platform", (Object[])new Object[0]), methodName);
            message.append(error);
            message.append('\n');
            return false;
        }
        return true;
    }

    private boolean isRightPacketNumber(ApiArgs apiArgs, StringBuilder message) {
        Map<String, Object> params = apiArgs.getParam();
        String packetNumber = (String)params.get("packetNumber");
        if (StringUtils.isEmpty((String)packetNumber) || packetNumber.length() > 80) {
            String error = ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u7f16\u7801\u53c2\u6570\u4e3a\u7a7a\uff0c\u6216\u8005\u8d85\u8fc7\u957f\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DataPkgTransferAndSynService_8", (String)"sys-ricc-platform", (Object[])new Object[0]);
            message.append(error);
            message.append('\n');
            return false;
        }
        return true;
    }

    private boolean isRightData(ApiArgs apiArgs, StringBuilder message) {
        Map<String, Object> params = apiArgs.getParam();
        String data = (String)params.get("data");
        if (StringUtils.isEmpty((String)data)) {
            String error = ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u6570\u636e\u6587\u4ef6\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DataPkgTransferAndSynService_9", (String)"sys-ricc-platform", (Object[])new Object[0]);
            message.append(error);
            message.append('\n');
            return false;
        }
        int length = data.length();
        logger.info("\u4f20\u8f93data\u6570\u636e\u5b57\u7b26\u957f\u5ea6\uff1a" + length);
        double size = (double)length / 2097152.0;
        logger.info("\u4f20\u8f93data\u6570\u636e\u5b57\u7b26\u957f\u5ea6MB" + size);
        FormMetadata packageUpload = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"ricc_packageupload", (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        List items = packageUpload.getItems();
        int packetUploadLimit = 2000;
        for (ControlAp item : items) {
            if (!"attachmentpanelap".equals(item.getKey())) continue;
            packetUploadLimit = ((AttachmentPanelAp)item).getMaxAtmSize();
            break;
        }
        logger.info("\u4f20\u8f93\u5305\u4e0a\u4f20\u9644\u4ef6\u9762\u677f\u9650\u5236\u7684\u4e0a\u4f20\u5927\u5c0f\uff1a" + packetUploadLimit);
        Integer maxUploadSize = (Integer)SystemParamServiceHelper.getPublicParameter((String)"maxuploadsize");
        logger.info("\u516c\u5171\u53c2\u6570\u9650\u5236\u7684\u6587\u4ef6\u4e0a\u4f20\u5927\u5c0f\uff1a" + maxUploadSize);
        int limit = Math.min(packetUploadLimit, maxUploadSize);
        if (maxUploadSize <= 0) {
            limit = packetUploadLimit;
        }
        if (size > (double)limit) {
            String error = String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u4f20\u8f93\u5305\u6570\u636e\u8d85\u8fc7\u6700\u5927\u9650\u5236%1$dMB\uff0c\u8bf7\u786e\u8ba4\u7cfb\u7edf\u670d\u52a1\u4e91->\u914d\u7f6e\u5de5\u5177->\u53c2\u6570\u914d\u7f6e->\u7cfb\u7edf\u53c2\u6570\u914d\u7f6e\u7684\u201c\u9644\u4ef6\u4e0a\u4f20\u5927\u5c0f\u9650\u5236\uff08MB\uff09\u201d\u9650\u5236\u53ca\u4f20\u8f93\u5305\u4e0a\u4f20\uff08ricc_packageupload\uff09\u8868\u5355\u9644\u4ef6\u9762\u677f\u9644\u4ef6\u4e0a\u4f20\u5927\u5c0f\u9650\u5236\u662f\u5426\u5408\u7406", (String)"DataPkgTransferAndSynService_10", (String)"sys-ricc-platform", (Object[])new Object[0]), limit);
            message.append(error);
            message.append('\n');
            return false;
        }
        return true;
    }

    private void buildParamCheckError(ApiArgs apiArgs, String errorMessage) {
        ApiResult apiResult = new ApiResult();
        apiResult.setMessage(errorMessage);
        apiResult.setSuccess(false);
        apiArgs.setCancel(true);
        apiResult.setData((Object)TransferStatusEnum.SYN_FAILED.getVal());
        apiArgs.setResult(apiResult);
    }

    @Override
    protected void doService(ApiArgs apiArgs) {
        super.doService(apiArgs);
        LogRecorder msg = new LogRecorder();
        logger.info("\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u6570\u636e\u5904\u7406\u4e2d...");
        ApiResult apiResult = new ApiResult();
        Map<String, Object> params = apiArgs.getParam();
        String methodName = (String)params.get("methodName");
        logger.info("\u5f00\u59cb\u6267\u884c\u540c\u6b65\uff0c\u540c\u6b65\u7c7b\u578b\u53c2\u6570\uff1a" + methodName);
        String packetNumber = (String)params.get("packetNumber");
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)packetNumber), new QFilter("status", "=", (Object)"C")};
        boolean isExistAuditPacket = QueryServiceHelper.exists((String)"ricc_datapacket", (QFilter[])qFilters);
        if (isExistAuditPacket && methodName.equals("transferandsyn")) {
            logger.info("\u76ee\u6807\u73af\u5883\u5df2\u7ecf\u5b58\u5728\u7f16\u7801\u4e3a" + packetNumber + "\u7684\u5ba1\u6838\u72b6\u6001\u7684\u4f20\u8f93\u5305\uff0c\u76f4\u63a5\u6267\u884c\u540c\u6b65");
            this.doSync(apiArgs, msg, apiResult, params);
            return;
        }
        if (methodName.equals("transfer") || methodName.equals("transferandsyn")) {
            String data = (String)params.get("data");
            DataPackageUploader uploader = this.uploadPacket(data);
            if (!uploader.isSuccess()) {
                apiResult = ApiResult.fail((String)msg.append(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"DataPkgTransferAndSynService_0", (String)"sys-ricc-platform", (Object[])new Object[0]), uploader.getMsg())).toString());
                apiResult.setData((Object)TransferStatusEnum.FAILED.getVal());
                apiArgs.setResult(apiResult);
                return;
            }
            if (methodName.equals("transfer")) {
                logger.info("\u4f20\u8f93\u6210\u529f\uff01");
                apiResult.setMessage(msg.append(ResManager.loadKDString((String)"\u4f20\u8f93\u6210\u529f\u3002", (String)"DataPkgTransferAndSynService_1", (String)"sys-ricc-platform", (Object[])new Object[0])).toString());
                apiResult.setSuccess(true);
                apiResult.setData((Object)TransferStatusEnum.SUCCESS.getVal());
                apiArgs.setResult(apiResult);
                return;
            }
        }
        if (methodName.equals("transferandsyn") || methodName.equals("onlysyn")) {
            this.doSync(apiArgs, msg, apiResult, params);
            return;
        }
        apiResult.setMessage(msg.toString());
        apiResult.setSuccess(true);
        apiArgs.setResult(apiResult);
        logger.info(String.format("\u6267\u884c\u5b8c\u6210\uff0c\u6267\u884c\u7ed3\u679c\uff1a%1$s\uff0c\u7ed3\u679c\u4fe1\u606f\uff1a%2$s", apiResult.getData(), apiResult.getMessage()));
    }

    private DataPackageUploader uploadPacket(String data) {
        byte[] dataPacket = Hex.decode((String)data);
        String packetSecret = SysParaUtil.getPacketSecret();
        ZipInputStream zipInputStream = null;
        zipInputStream = StringUtils.isNotBlank((CharSequence)packetSecret) ? new ZipInputStream((InputStream)new ByteArrayInputStream(dataPacket), packetSecret.toCharArray(), Charset.forName("GBK")) : new ZipInputStream((InputStream)new ByteArrayInputStream(dataPacket), Charset.forName("GBK"));
        DataPackageUploader uploader = new DataPackageUploader(zipInputStream);
        if (!uploader.isSuccess()) {
            logger.info("\u6570\u636e\u63a5\u6536\u5931\u8d25\uff1a" + uploader.getMsg());
            return uploader;
        }
        uploader.setDatasourceType(PacketDataSourceTypeEnum.DATASOURCE_TRANSFER);
        uploader.doUpload();
        if (!uploader.isSuccess()) {
            logger.info("\u4e0a\u4f20\u5931\u8d25\uff1a" + uploader.getMsg());
            return uploader;
        }
        return uploader;
    }

    private void doSync(ApiArgs apiArgs, LogRecorder msg, ApiResult apiResult, Map<String, Object> params) {
        logger.info("\u5f00\u59cb\u6267\u884c\u4f20\u8f93\u5305\u540c\u6b65...");
        if (!SysParaUtil.canRemoteSync()) {
            logger.info("\u5f53\u524d\u73af\u5883\u4e0d\u652f\u6301\u8fdc\u7a0b\u540c\u6b65");
            apiResult.setMessage(msg.append(ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u5df2\u4f20\u8f93\u6210\u529f\uff0c\u4f46\u6570\u636e\u540c\u6b65\u5931\u8d25\u3002\u76ee\u6807\u73af\u5883\u7c7b\u578b\u975e\u201cSIT\u73af\u5883\u201d\uff0c\u4e3a\u4fdd\u969c\u76ee\u6807\u73af\u5883\u6570\u636e\u5b89\u5168\uff0c\u4e0d\u5141\u8bb8\u88ab\u8fdc\u7a0b\u540c\u6b65\uff0c\u8bf7\u5728\u76ee\u6807\u73af\u5883\u3010\u4f20\u8f93\u5305\u7ba1\u7406\u3011\u83dc\u5355\u4e2d\u8fdb\u884c\u540c\u6b65\u64cd\u4f5c\u3002\u8be6\u7ec6\u73af\u5883\u63a7\u5236\u53ef\u5728\u3010\u53c2\u6570\u8bbe\u7f6e\u3011 \u8fdb\u884c\u67e5\u770b", (String)"DataPkgTransferAndSynService_2", (String)"sys-ricc-platform", (Object[])new Object[0])).toString());
            apiResult.setSuccess(false);
            apiResult.setData((Object)TransferStatusEnum.SYN_FAILED.getVal());
            apiArgs.setResult(apiResult);
            return;
        }
        String packetNumber = (String)params.get("packetNumber");
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        List pks = QueryServiceHelper.queryPrimaryKeys((String)"ricc_datapacket", (QFilter[])new QFilter("number", "=", (Object)packetNumber).toArray(), (String)null, (int)1);
        if (pks.isEmpty()) {
            logger.info("\u76ee\u6807\u73af\u5883\u627e\u4e0d\u5230\u9700\u8981\u540c\u6b65\u7684\u5305\u3002");
            String data = (String)params.get("data");
            DataPackageUploader uploader = this.uploadPacket(data);
            if (!uploader.isSuccess()) {
                apiResult = ApiResult.fail((String)msg.append(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u73af\u5883\u4f20\u8f93\u5305\u4e22\u5931\uff0c\u91cd\u65b0\u4f20\u8f93\u5305\u4e0a\u4f20\u5931\u8d25\uff1a%s", (String)"DataPkgTransferAndSynService_3", (String)"sys-ricc-platform", (Object[])new Object[0]), uploader.getMsg())).toString());
                apiResult.setData((Object)TransferStatusEnum.FAILED.getVal());
                apiArgs.setResult(apiResult);
                return;
            }
            pks = QueryServiceHelper.queryPrimaryKeys((String)"ricc_datapacket", (QFilter[])new QFilter("number", "=", (Object)packetNumber).toArray(), (String)null, (int)1);
        }
        pks.forEach(pk -> listSelectedRows.add((Object)new ListSelectedRow(pk)));
        HashMap<String, Object> methodParam = new HashMap<String, Object>(3);
        methodParam.put("selectRows", listSelectedRows.serialize());
        try {
            SyncDataPacketTask syncDataPacketTask = new SyncDataPacketTask();
            syncDataPacketTask.execute(RequestContext.get(), methodParam);
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u540c\u6b65\u53d1\u751f\u5f02\u5e38 ", (Throwable)e);
            apiResult = ApiResult.fail((String)msg.append(ResManager.loadKDString((String)"\u540c\u6b65\u65f6\u53d1\u751f\u5f02\u5e38\uff1a", (String)"DataPkgTransferAndSynService_4", (String)"sys-ricc-platform", (Object[])new Object[0]), e).toString());
            apiResult.setData((Object)TransferStatusEnum.SYN_FAILED.getVal());
            apiArgs.setResult(apiResult);
            return;
        }
        apiResult.setSuccess(true);
        DynamicObject pkg = BusinessDataServiceHelper.loadSingle(pks.get(0), (String)"ricc_datapacket", (String)"syncstate");
        String synStatus = pkg.getString("syncstate");
        QFilter[] qFilters = new QFilter[]{new QFilter("taskid", "=", methodParam.get("taskId")), new QFilter("packet", "=", pks.get(0))};
        DynamicObject logs = BusinessDataServiceHelper.loadSingle((String)"ricc_log", (String)"id,billno,name,message,message_tag,devmessage,devmessage_tag,synlogentry.seq,synlogentry.synlog_tag,synlogentry.entrysynstatus,synlogentry.entrysuccesscount,synlogentry.entryfailedcount", (QFilter[])qFilters);
        DynamicObjectCollection entryLogs = logs.getDynamicObjectCollection("synlogentry");
        if (!Objects.isNull(entryLogs) && !entryLogs.isEmpty()) {
            String entryLogsStr = DynamicObjectSerializeUtil.serialize((Object[])entryLogs.toArray(), (DynamicObjectType)entryLogs.getDynamicObjectType());
            msg.setEntryLogs(entryLogsStr);
        }
        if (StringUtils.equals((String)synStatus, (String)"1")) {
            apiResult.setData((Object)TransferStatusEnum.SYN_SUCCESS.getVal());
            msg.append(TransferStatusEnum.SYN_SUCCESS.getName());
        } else {
            apiResult.setData((Object)TransferStatusEnum.SYN_FAILED.getVal());
            msg.append(TransferStatusEnum.SYN_FAILED.getName());
            msg.append(String.format(ResManager.loadKDString((String)"\u539f\u56e0\u5982\u4e0b\uff1a%s", (String)"DataPkgTransferAndSynService_5", (String)"sys-ricc-platform", (Object[])new Object[0]), logs.get("message_tag")), logs.getString("devmessage_tag"));
        }
        apiResult.setMessage(msg.toString());
        apiArgs.setResult(apiResult);
        logger.info(String.format("\u6267\u884c\u540c\u6b65\u5b8c\u6210\uff0c\u6267\u884c\u7ed3\u679c\uff1a%1$s\uff0c\u7ed3\u679c\u4fe1\u606f\uff1a%2$s", apiResult.getData(), apiResult.getMessage()));
    }
}

