/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.configitem;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.NewPortalService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.util.BatchSplitUtil;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;
import org.apache.commons.lang.StringUtils;

public class ConfigItemHelper {
    private static final Log log = LogFactory.getLog(ConfigItemHelper.class);
    public static final String PAGE_ENTER_PARAM = "pageenterparam";
    public static final String SET_CUSTOM_PARAM = "setCustomParam";
    public static final String ONK_KEY_SELECT_FIELDS = "page.basedatafield.number as entitynumber,canexportall, exportfilters_tag";
    public static final String MAIN_ORG = "mainOrg";
    public static final String NUMBER_FIELD = "numberField";

    private ConfigItemHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static void openConfigFormById(long configItemId, IFormView view, boolean needAddPacketBt) {
        DynamicObject configItem = BusinessDataServiceHelper.loadSingle((Object)configItemId, (String)"ricc_configitems");
        ConfigItemHelper.openConfigForm(configItem, view, needAddPacketBt);
    }

    public static void openConfigFormByNumber(String configItemNumber, IFormView view, boolean needAddPacketBt) {
        QFilter qFilter = new QFilter("number", "=", (Object)configItemNumber);
        List configItemId = QueryServiceHelper.queryPrimaryKeys((String)"ricc_configitems", (QFilter[])qFilter.toArray(), null, (int)1);
        ConfigItemHelper.openConfigFormById((Long)configItemId.get(0), view, needAddPacketBt);
    }

    public static void openConfigForm(DynamicObject configItem, IFormView view, boolean needAddPacketBt) {
        if (configItem == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e2d\u627e\u4e0d\u5230\u52fe\u9009\u7684\u6570\u636e\uff0c\u6709\u53ef\u80fd\u5df2\u88ab\u522b\u4eba\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u8bd5\u8bd5\u3002", (String)"ConfigItemHelper_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        String bizAppId = configItem.getString("page.bizappid");
        DynamicObject appInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)"bos_devportal_bizapp");
        if (appInfo == null) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e2d\u627e\u4e0d\u5230\u5e94\u7528id=%s\u4fe1\u606f\uff0c\u8bf7\u5237\u65b0\u8bd5\u8bd5\u3002", (String)"ConfigItemHelper_1", (String)"sys-ricc-platform", (Object[])new Object[0]), bizAppId));
            return;
        }
        String formId = configItem.getString("page.number");
        String pageType = configItem.getString("pagetype");
        if ("custom".equals(pageType)) {
            pageType = configItem.getString("custompage");
        }
        String appId = appInfo.getString("number");
        String pageCode = configItem.getString("number");
        Map<String, Object> customParams = ConfigItemHelper.prepareCustomParams(configItem, view, pageType, appId);
        String hiddenButton = configItem.getString("hiddenbuttonfield");
        customParams.put("hiddenbutton", hiddenButton);
        String caption = configItem.getString("name");
        String transTips = configItem.getString("transtips");
        customParams.put("transtips", transTips);
        String dynamicPlugin = ConfigItemHelper.getDynamicPlugin(configItem, needAddPacketBt);
        ShowType showType = ShowType.MainNewTabPage;
        RequestContext context = RequestContext.get();
        boolean isNewPortal = NewPortalService.isPersonalSettingNewPortal((long)context.getCurrUserId(), (String)context.getAccountId());
        boolean isOpenOnOtherApp = false;
        String spAppId = null;
        IFormView spAppView = null;
        if (isNewPortal && (spAppId = ConfigItemHelper.getSpAppId(configItem)) != null) {
            spAppView = ConfigItemHelper.getSpAppView(view, spAppId);
            if (spAppView != null) {
                isOpenOnOtherApp = true;
                spAppView.activate();
                view.sendFormAction(spAppView);
            } else {
                showType = ShowType.Modal;
            }
        }
        Object formShowParameter = "bos_dynamicform".equals(pageType) ? ShowParameterUtil.formShowParameter((String)formId, (ShowType)showType, customParams, (String)caption, (String)dynamicPlugin) : ShowParameterUtil.listShowParameter((String)formId, (String)pageType, (ShowType)showType, customParams, null, (String)caption, (String)dynamicPlugin);
        ConfigItemHelper.setPluginOrder(formId, formShowParameter);
        ConfigItemHelper.setServiceAppId(appId, formShowParameter);
        if (isOpenOnOtherApp) {
            String spAppViewPageId = spAppView.getPageId();
            formShowParameter.setParentPageId(spAppViewPageId);
            formShowParameter.setPageId(pageCode + spAppViewPageId);
            spAppView.showForm(formShowParameter);
            view.sendFormAction(spAppView);
        } else {
            boolean isModal = showType.equals((Object)ShowType.Modal);
            ConfigItemHelper.setParentPageId(view, formShowParameter, isModal);
            formShowParameter.setPageId(pageCode + view.getFormShowParameter().getRootPageId());
            view.showForm(formShowParameter);
        }
    }

    private static IFormView getSpAppView(IFormView view, String appId) {
        IFormView baseview = null;
        String mainPageId = ConfigItemHelper.getMainViewPageId(view);
        if (kd.sys.ricc.common.util.StringUtils.isNotEmpty((String)mainPageId)) {
            String appPageId = appId + mainPageId;
            baseview = view.getViewNoPlugin(appPageId);
        }
        return baseview;
    }

    private static String getSpAppId(DynamicObject configItem) {
        JSONObject map;
        Map appParam;
        String spAppId = null;
        String pageEnterParam = configItem.getString(PAGE_ENTER_PARAM);
        if (pageEnterParam != null && !pageEnterParam.isEmpty() && (appParam = (Map)(map = JSONObject.parseObject((String)pageEnterParam).getJSONObject("params")).get("setAppId")) != null && kd.sys.ricc.common.util.StringUtils.isEmpty((String)(spAppId = (String)appParam.get("appid")))) {
            spAppId = (String)appParam.get("appId");
        }
        return spAppId;
    }

    public static String getDynamicPlugin(DynamicObject guide, boolean needAddPacketBt) {
        String pageEntryParam = guide.getString(PAGE_ENTER_PARAM);
        String specialDynamicPlugin = ConfigItemHelper.getSpecialDynamicPlugin(pageEntryParam);
        if (kd.sys.ricc.common.util.StringUtils.isNotEmpty((String)specialDynamicPlugin)) {
            return specialDynamicPlugin;
        }
        if (!needAddPacketBt) {
            return "kd.bos.ext.imsc.ricc.form.listext.DynamicListPlugin";
        }
        return "kd.bos.ext.imsc.ricc.form.listext.DynamicButtonListPlugin";
    }

    public static String getSpecialDynamicPlugin(String pageEnterParam) {
        if (kd.sys.ricc.common.util.StringUtils.isEmpty((String)pageEnterParam)) {
            return "";
        }
        JSONObject map = JSON.parseObject((String)pageEnterParam).getJSONObject("params");
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Map tempMap = (Map)entry.getValue();
            for (Map.Entry anoentry : tempMap.entrySet()) {
                String name = (String)anoentry.getKey();
                String value = (String)anoentry.getValue();
                if (!SET_CUSTOM_PARAM.equals(key) || !"riccCustomDynamicPlugin".equals(name)) continue;
                return value;
            }
        }
        return "";
    }

    public static Map<String, Object> prepareCustomParams(DynamicObject guide, IFormView view, String pageType, String appId) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("number", guide.getString("number"));
        DynamicObjectCollection relyItems = guide.getDynamicObjectCollection("relyitementry");
        StringBuilder relyItemName = new StringBuilder();
        StringBuilder relyItemNoExportAll = new StringBuilder();
        for (DynamicObject relyItemRow : relyItems) {
            DynamicObject relyItem = (DynamicObject)relyItemRow.get("relyitem");
            if (relyItem == null) continue;
            boolean relyIsExportAll = relyItem.getBoolean("canexportall");
            if (!relyIsExportAll) {
                relyItemNoExportAll.append(relyItem.getLocaleString("name").getLocaleValue()).append(',');
            }
            relyItemName.append(relyItem.getLocaleString("name").getLocaleValue()).append(',');
        }
        customParams.put("relyitemname", relyItemName);
        customParams.put("noexportallname", relyItemNoExportAll);
        customParams.put("guideName", guide.getString("name"));
        customParams.put("canexportall", guide.getBoolean("canexportall"));
        customParams.put("riccFormId", guide.getString("page.number"));
        customParams.put("pageType", pageType);
        customParams.put("guideId", guide.get("id"));
        customParams.put("packettype", DataPacketTypeEnum.CONFIG.getVal());
        customParams.put("riccModelType", guide.getString("page.modeltype"));
        customParams.put("custParamPage", guide.getString("custparampage"));
        customParams.put("appId", appId);
        customParams.put("checkRightAppId", appId);
        customParams.put("importType", guide.getString("importtype"));
        customParams.put(PAGE_ENTER_PARAM, guide.get(PAGE_ENTER_PARAM));
        customParams.put("canAddPacket", SysParaUtil.canAddPacket());
        customParams.put("supportAddToPacket", guide.getBoolean("supportaddtopacket"));
        return customParams;
    }

    public static void setParentPageId(IFormView currentView, FormShowParameter targetShowParameter, boolean isModal) {
        String parentPageId = null;
        parentPageId = isModal ? currentView.getPageId() : ShowParameterUtil.getParentPageId((IFormView)currentView);
        targetShowParameter.setParentPageId(parentPageId);
    }

    public static String getMainViewPageId(IFormView view) {
        IFormView mainView = view.getMainView();
        if (mainView != null) {
            return mainView.getPageId();
        }
        return view.getFormShowParameter().getRootPageId();
    }

    public static void setPluginOrder(String formId, FormShowParameter formShowParameter) {
        if ("plat_quotestrategy".equals(formId) || "plat_quotescheme".equals(formId)) {
            List plugins = formShowParameter.getFormConfig().getPlugins();
            plugins.add(0, plugins.remove(plugins.size() - 1));
        }
    }

    public static void setServiceAppId(String appId, FormShowParameter formShowParameter) {
        String serviceAppId = formShowParameter.getServiceAppId();
        if (ConfigItemHelper.isRootToCurrentApp(serviceAppId) && !"ricc".equals(appId)) {
            FormConfig formConfig = null;
            formConfig = formShowParameter instanceof ListShowParameter ? FormMetadataCache.getFormConfig((String)((ListShowParameter)formShowParameter).getBillFormId()) : formShowParameter.getFormConfig();
            String bizAppNumber = formConfig.getBizAppNumber();
            formShowParameter.setCustomParam("ServiceAppId", (Object)bizAppNumber);
        }
    }

    public static boolean isRootToCurrentApp(String serviceAppId) {
        return "ricc".equals(serviceAppId) || "bos".equals(serviceAppId);
    }

    public static void openAddPacketForm(ListSelectedRowCollection listSelectedRows, String dataListPageId, Map<String, Object> customParam, IFormView view, String callBackPluginName) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("dataPacketOpenFrom", "openFromGuide");
        customParams.put("selectedData", listSelectedRows.serialize());
        customParams.putAll(view.getFormShowParameter().getCustomParams());
        customParams.put("ServiceAppId", "ricc");
        customParams.put("parentPageId", dataListPageId);
        customParams.put("custParam", customParam);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("ricc_fastaddpacket");
        formShowParameter.setSendToClient(true);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack(callBackPluginName, "addPacketClose"));
        view.showForm(formShowParameter);
    }

    public static void openAddTransferForm(ListSelectedRowCollection selectedRows, String dataListPageId, Map<String, Object> customParam, IFormView view, String callBackPluginName) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("dataPacketOpenFrom", "openFromGuide");
        customParams.put("selectedData", selectedRows.serialize());
        customParams.putAll(view.getFormShowParameter().getCustomParams());
        customParams.put("ServiceAppId", "ricc");
        customParams.put("parentPageId", dataListPageId);
        customParams.put("custParam", customParam);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("ricc_addtansfer");
        formShowParameter.setSendToClient(true);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack(callBackPluginName, "addTransferClose"));
        view.showForm(formShowParameter);
    }

    public static DynamicObject queryGuideById(Object id, String packetType) {
        QFilter qFilter = new QFilter("id", "=", id);
        if (DataPacketTypeEnum.CONFIG.getVal().equals(packetType)) {
            return QueryServiceHelper.queryOne((String)"ricc_configitems", (String)"id,number,name,page.number as formid,page.modeltype modeltype,pagetype, custompage, page.bizappid as bizappid, page.basedatafield.number as entityid,supportpreview,supportaddtopacket,custparampage,importtype,plugin,relylevel,importtemplateid,pageenterparam,dataimporttype,keyfields,isoverrideEntry,sortfield,sortway, istransferattach, attachmentfield", (QFilter[])qFilter.toArray());
        }
        if (DataPacketTypeEnum.BASEDATA.getVal().equals(packetType)) {
            return QueryServiceHelper.queryOne((String)"ricc_basedata_item", (String)"id,number,name,page.number as formid,page.modeltype modeltype,pagetype, custompage, page.bizappid.id bizappid, page.bizappid.number appid, canexcel,importtemplateid,pageenterparam", (QFilter[])qFilter.toArray());
        }
        return null;
    }

    public static DynamicObject queryGuideByNumber(Object number, String selectField) {
        QFilter qFilter = new QFilter("number", "=", number);
        return QueryServiceHelper.queryOne((String)"ricc_configitems", (String)selectField, (QFilter[])qFilter.toArray());
    }

    public static QFilter[] getExportAllFiltersByNumber(String guideNumber) {
        DynamicObject config = ConfigItemHelper.queryGuideByNumber(guideNumber, ONK_KEY_SELECT_FIELDS);
        return ConfigItemHelper.getExportAllFiltersByGuideDy(config);
    }

    public static QFilter[] getExportAllFiltersByGuideDy(DynamicObject config) {
        if (config == null) {
            return null;
        }
        QFilter[] oneKeyFitler = null;
        boolean canExportAll = config.getBoolean("canexportall");
        String entityNumber = config.getString("entitynumber");
        if (!canExportAll) {
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%s\u4e0d\u652f\u6301\u6279\u91cf\u6253\u5305", (String)"ConfigItemHelper_2", (String)"sys-ricc-platform", (Object[])new Object[0]), entityNumber));
        }
        String filterStr = config.getString("exportfilters_tag");
        if (!kd.sys.ricc.common.util.StringUtils.isEmpty((String)filterStr)) {
            CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumber), crCondition.getFilterCondition());
            fb.buildFilter();
            oneKeyFitler = fb.getQFilter().toArray();
        }
        return oneKeyFitler;
    }

    public static String disPoseKeyField(String entityNumber, String keyFields, String itemName) {
        if (kd.sys.ricc.common.util.StringUtils.isBlank((CharSequence)keyFields) || keyFields.replace(",", "").length() == 0) {
            DynamicObject initConfig = BusinessDataServiceHelper.loadSingle((Object)1367275628033736704L, (String)"ricc_initconfig");
            String defaultKeyFields = (String)initConfig.get("defaultkeyfields");
            if (kd.sys.ricc.common.util.StringUtils.equals((String)defaultKeyFields, (String)"id")) {
                keyFields = "id";
            } else {
                String numberField;
                QFilter numberFilter = new QFilter("number", "=", (Object)entityNumber);
                DynamicObject formMeta = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (QFilter[])numberFilter.toArray());
                String modelType = formMeta.getString("modeltype");
                Map<Object, Object> numberAndMainOrg = new HashMap(2);
                if (kd.sys.ricc.common.util.StringUtils.equals((String)modelType, (String)"BillFormModel") || kd.sys.ricc.common.util.StringUtils.equals((String)modelType, (String)"BaseFormModel")) {
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                    numberAndMainOrg = ConfigItemHelper.getNumberAndMainOrg(mainEntityType);
                }
                if (kd.sys.ricc.common.util.StringUtils.isBlank((CharSequence)(numberField = (String)numberAndMainOrg.get(NUMBER_FIELD)))) {
                    throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u9879%s\u672a\u8bbe\u7f6e\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\uff0c\u6839\u636e\u53c2\u6570\u8bbe\u7f6e\u4e2d\u540c\u6b65\u9ed8\u8ba4\u5339\u914d\u5b57\u6bb5\u4e3a\uff1a\u7f16\u7801+\u521b\u5efa\u7ec4\u7ec7\uff0c\u8be5\u914d\u7f6e\u9879\u672a\u8bbe\u7f6e\u7f16\u7801\u5b57\u6bb5\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\u3002", (String)"ConfigItemHelper_3", (String)"sys-ricc-platform", (Object[])new Object[0]), itemName));
                }
                String mainOrg = (String)numberAndMainOrg.get(MAIN_ORG);
                keyFields = kd.sys.ricc.common.util.StringUtils.isNotBlank((CharSequence)mainOrg) ? ',' + numberField + ',' + mainOrg + ',' : ',' + numberField + ',';
            }
        }
        return keyFields;
    }

    public static Map<String, String> getNumberAndMainOrg(MainEntityType mainEntityType) {
        HashMap<String, String> numberAndMainOrg = new HashMap<String, String>(2);
        String mainOrg = mainEntityType.getMainOrg();
        numberAndMainOrg.put(MAIN_ORG, mainOrg);
        String numberField = ((BillEntityType)mainEntityType).getBillNo();
        numberAndMainOrg.put(NUMBER_FIELD, numberField);
        return numberAndMainOrg;
    }

    public static Map<String, Object> generalProvideDataImpl(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        StringBuilder errMessage = new StringBuilder(ResManager.loadKDString((String)"\u83b7\u53d6\u9884\u89c8\u6570\u636e\u5931\u8d25\uff1a", (String)"ConfigItemHelper_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
        String entityNumber = (String)params.get("entityNumber");
        String encodeStr = (String)params.get("custparam");
        byte[] decode = Base64.getDecoder().decode(encodeStr);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(decode);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String customParam = "";
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(byteArrayInputStream);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = gzipInputStream.read(buffer)) > 0) {
                byteArrayOutputStream.write(buffer, 0, len);
            }
            customParam = byteArrayOutputStream.toString("UTF-8");
        }
        catch (IOException e) {
            return CommonUtil.fail((String)errMessage.append(e.getMessage()).toString());
        }
        Map customParamMap = (Map)JSON.parseObject((String)customParam, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        if (customParamMap == null || customParamMap.isEmpty()) {
            return CommonUtil.fail((String)errMessage.append(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"ConfigItemHelper_5", (String)"sys-ricc-platform", (Object[])new Object[0])).toString());
        }
        List previewData = (List)customParamMap.get("previewData");
        JSONArray keyFieldSet = (JSONArray)customParamMap.get("keyFields");
        if (CollectionUtils.isEmpty((Collection)previewData) || CollectionUtils.isEmpty((Collection)keyFieldSet)) {
            return CommonUtil.fail((String)errMessage.append(ResManager.loadKDString((String)"\u9884\u89c8\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ConfigItemHelper_6", (String)"sys-ricc-platform", (Object[])new Object[0])).toString());
        }
        result.put("dataCount", previewData.size());
        QFilter filterAllData = ConfigItemHelper.getCurDataFilter(previewData, keyFieldSet);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])filterAllData.toArray(), null, (int)-1);
        result.put("modifyCount", ids.size());
        HashMap<String, String> fieldMap = new HashMap<String, String>(4);
        fieldMap.put("first", "id");
        fieldMap.put("second", ResManager.loadKDString((String)"\u7f16\u7801", (String)"ConfigItemHelper_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
        fieldMap.put("third", ResManager.loadKDString((String)"\u540d\u79f0", (String)"ConfigItemHelper_8", (String)"sys-ricc-platform", (Object[])new Object[0]));
        fieldMap.put("fourth", ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"ConfigItemHelper_9", (String)"sys-ricc-platform", (Object[])new Object[0]));
        Integer pageIndex = (Integer)params.getOrDefault("pageIndex", 1);
        Integer pageSize = (Integer)params.getOrDefault("pageSize", 1000);
        result.put("fieldNames", JSON.toJSONString(fieldMap));
        Map<String, Map<String, Object>> curDataStrMap = ConfigItemHelper.getParameterDataMap(previewData, keyFieldSet);
        QFilter filter = ConfigItemHelper.getCurDataFilter(previewData, keyFieldSet);
        Map loadCurData = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (QFilter[])filter.toArray());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = entityType.getProperties();
        Map<String, DynamicObject> tarDataStrMap = ConfigItemHelper.getCurEnvDataMap(keyFieldSet, loadCurData, properties);
        List<Map<String, Object>> previewResult = ConfigItemHelper.setPreViewDataValue(curDataStrMap, tarDataStrMap);
        String filterField = (String)params.getOrDefault("filterfield", "");
        String filterValue = (String)params.getOrDefault("filtervalue", "");
        List<Map<String, Object>> filterResult = previewResult;
        if (kd.sys.ricc.common.util.StringUtils.isNotBlank((CharSequence)filterField) && kd.sys.ricc.common.util.StringUtils.isNotBlank((CharSequence)filterValue)) {
            filterResult = previewResult.stream().filter(map -> map.containsKey(filterField)).filter(map -> map.get(filterField) instanceof String && ((String)map.get(filterField)).contains(filterValue)).collect(Collectors.toList());
        }
        List splitBatch = BatchSplitUtil.splitBatch(filterResult, (int)pageSize);
        result.put("pageTotal", splitBatch.size());
        result.put("previewData", splitBatch.get(pageIndex - 1));
        result.put("success", true);
        return result;
    }

    private static Map<String, DynamicObject> getCurEnvDataMap(JSONArray keyFieldSet, Map<Object, DynamicObject> loadCurData, DataEntityPropertyCollection properties) {
        HashMap<String, DynamicObject> tarDataStrMap = new HashMap<String, DynamicObject>(8);
        for (DynamicObject value : loadCurData.values()) {
            StringBuilder tarKey = new StringBuilder();
            for (Object key : keyFieldSet) {
                IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)((String)key));
                Object keyFieldsValue = prop instanceof MuliLangTextProp ? ((Map)value.get((String)key)).get("zh_CN") : (prop instanceof BasedataProp ? ((DynamicObject)value.get((String)key)).get("id") : value.get((String)key));
                tarKey.append(keyFieldsValue).append("$$$");
            }
            tarKey.delete(tarKey.length() - 3, tarKey.length());
            tarDataStrMap.put(tarKey.toString(), value);
        }
        return tarDataStrMap;
    }

    private static QFilter getCurDataFilter(List<Map<String, Object>> previewData, JSONArray keyFieldSet) {
        QFilter filter = new QFilter("1", "!=", (Object)-1);
        for (Object key : keyFieldSet) {
            HashSet<Object> valueSet = new HashSet<Object>(4);
            for (Map<String, Object> oneData : previewData) {
                if (kd.sys.ricc.common.util.StringUtils.equals((String)"createorg", (String)((String)key))) {
                    valueSet.add(oneData.get(key + "_" + "id"));
                    continue;
                }
                valueSet.add(oneData.get(key));
            }
            filter.and(new QFilter((String)key, "in", valueSet));
        }
        return filter;
    }

    private static Map<String, Map<String, Object>> getParameterDataMap(List<Map<String, Object>> previewData, JSONArray keyFieldSet) {
        HashMap<String, Map<String, Object>> curDataStrMap = new HashMap<String, Map<String, Object>>(8);
        for (Map<String, Object> oneData : previewData) {
            StringBuilder tarKey = new StringBuilder();
            for (Object key : keyFieldSet) {
                if (kd.sys.ricc.common.util.StringUtils.equals((String)"createorg", (String)((String)key))) {
                    tarKey.append(oneData.get(key + "_" + "id")).append("$$$");
                    continue;
                }
                tarKey.append(oneData.get(key)).append("$$$");
            }
            tarKey.delete(tarKey.length() - 3, tarKey.length());
            curDataStrMap.put(tarKey.toString(), oneData);
        }
        return curDataStrMap;
    }

    private static List<Map<String, Object>> setPreViewDataValue(Map<String, Map<String, Object>> curDataStrMap, Map<String, DynamicObject> tarDataStrMap) {
        ArrayList<Map<String, Object>> previewList = new ArrayList<Map<String, Object>>(10);
        for (Map.Entry<String, Map<String, Object>> entry : curDataStrMap.entrySet()) {
            String keyDataStr = entry.getKey();
            Map<String, Object> value = entry.getValue();
            HashMap<String, Object> oneData = new HashMap<String, Object>(8);
            oneData.put("curfirst", value.get("id"));
            oneData.put("cursecond", value.get("number"));
            oneData.put("curthird", value.get("name"));
            oneData.put("curfourth", value.get("createorg"));
            DynamicObject tarData = tarDataStrMap.get(keyDataStr);
            boolean isExist = Objects.nonNull(tarData);
            oneData.put("exist", isExist ? "0" : "1");
            if (isExist) {
                ConfigItemHelper.setTarRowData("first", oneData, tarData.get("id"));
                ConfigItemHelper.setTarRowData("second", oneData, tarData.containsProperty("number") ? tarData.get("number") : "");
                ConfigItemHelper.setTarRowData("third", oneData, tarData.containsProperty("name") ? tarData.get("name") : "");
                if (kd.sys.ricc.common.util.StringUtils.isNotBlank((Object)value.get("createorg"))) {
                    ConfigItemHelper.setTarRowData("fourth", oneData, tarData.get("createorg"));
                }
            }
            previewList.add(oneData);
        }
        return previewList;
    }

    public static void setTarRowData(String fieldName, Map<String, Object> oneData, Object value) {
        Object actualValue = value instanceof OrmLocaleValue ? ((OrmLocaleValue)value).getLocaleValue() : (value instanceof DynamicObject ? ((DynamicObject)value).getString("name") : value);
        oneData.put("tar" + fieldName, actualValue);
    }

    public static FormConfig getFormConfig(Object itemId) {
        MainEntityType entityType;
        boolean isBillEntityType;
        DynamicObject dbItem = QueryServiceHelper.queryOne((String)"ricc_configitems", (String)"page,page.number,page.basedatafield.number", (QFilter[])new QFilter("id", "=", itemId).toArray());
        String entityNumber = dbItem.getString("page.basedatafield.number");
        boolean isManualSelect = kd.sys.ricc.common.util.StringUtils.equals((String)entityNumber, (String)"gl_initbalance");
        if (kd.sys.ricc.common.util.StringUtils.isEmpty((String)entityNumber) || isManualSelect) {
            return null;
        }
        if (kd.sys.ricc.common.util.StringUtils.equals((String)"ai_vchtemplate_configs", (String)entityNumber)) {
            entityNumber = "ai_vchtemplate";
        }
        if (!(isBillEntityType = (entityType = EntityMetadataCache.getDataEntityType((String)entityNumber)) instanceof BillEntityType)) {
            return null;
        }
        FormConfig listFormConfig = FormMetadataCache.getListFormConfig((String)entityNumber);
        if (listFormConfig == null) {
            return null;
        }
        if (kd.sys.ricc.common.util.StringUtils.equals((String)"al_rule_setting", (String)entityNumber)) {
            listFormConfig.setF7ListFormId("bos_treelistf7");
        }
        listFormConfig.setEntityTypeId(entityNumber);
        return listFormConfig;
    }

    public static String getEntityNumber(Object configItemPk) {
        Tuple<String, String> entityNumberAndName = ConfigItemHelper.getEntityNumberAndName(configItemPk);
        if (entityNumberAndName == null) {
            return null;
        }
        return (String)entityNumberAndName.item1;
    }

    public static Tuple<String, String> getEntityNumberAndName(Object configItemPk) {
        DynamicObject bosEntityMeta = ConfigItemHelper.getEntityMeta(configItemPk);
        if (bosEntityMeta == null) {
            return null;
        }
        DynamicObject baseDataField = (DynamicObject)bosEntityMeta.get("basedatafield");
        String entityNumber = baseDataField.getString("number");
        if (kd.sys.ricc.common.util.StringUtils.equals((String)"ai_vchtemplate_configs", (String)entityNumber)) {
            entityNumber = "ai_vchtemplate";
        }
        String entityName = baseDataField.getString("name");
        return new Tuple((Object)entityNumber, (Object)entityName);
    }

    private static DynamicObject getEntityMeta(Object configItemPk) {
        if (configItemPk == null) {
            return null;
        }
        DynamicObject item = QueryServiceHelper.queryOne((String)"ricc_configitems", (String)"id,page.basedatafield.number,rightpage", (QFilter[])new QFilter("id", "=", configItemPk).toArray());
        String rightPageId = (String)item.get("rightpage");
        QFilter rightPageFilter = new QFilter("id", "=", (Object)rightPageId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"basedatafield", (QFilter[])rightPageFilter.toArray());
    }

    public static String buildKeyFields(Long configItemId) {
        DynamicObject configItemObj = BusinessDataServiceHelper.loadSingle((Object)configItemId, (String)"ricc_configitems");
        if (configItemObj != null) {
            String keyFields = configItemObj.getString("keyfields");
            if (StringUtils.isBlank((String)keyFields) || keyFields.replace(",", "").length() == 0) {
                DynamicObject initConfig = BusinessDataServiceHelper.loadSingle((Object)1367275628033736704L, (String)"ricc_initconfig");
                String defaultKeyFields = (String)initConfig.get("defaultkeyfields");
                if (StringUtils.equals((String)defaultKeyFields, (String)"id")) {
                    keyFields = "id";
                } else {
                    String numberField;
                    DynamicObject formMeta = configItemObj.getDynamicObject("page");
                    String modelType = formMeta.getString("modeltype");
                    Map<Object, Object> numberAndMainOrg = new HashMap(2);
                    if (StringUtils.equals((String)modelType, (String)"BillFormModel") || StringUtils.equals((String)modelType, (String)"BaseFormModel")) {
                        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formMeta.getString("number"));
                        numberAndMainOrg = ConfigItemHelper.getNumberAndMainOrg(mainEntityType);
                    }
                    if (StringUtils.isBlank((String)(numberField = (String)numberAndMainOrg.get(NUMBER_FIELD)))) {
                        throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u9879%s\u672a\u8bbe\u7f6e\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\uff0c\u6839\u636e\u53c2\u6570\u8bbe\u7f6e\u4e2d\u540c\u6b65\u9ed8\u8ba4\u5339\u914d\u5b57\u6bb5\u4e3a\uff1a\u7f16\u7801+\u521b\u5efa\u7ec4\u7ec7\uff0c\u8be5\u914d\u7f6e\u9879\u672a\u8bbe\u7f6e\u7f16\u7801\u5b57\u6bb5\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\u3002", (String)"ConfigItemHelper_3", (String)"sys-ricc-platform", (Object[])new Object[0]), configItemObj.getLocaleString("name")));
                    }
                    String mainOrg = (String)numberAndMainOrg.get(MAIN_ORG);
                    keyFields = StringUtils.isNotBlank((String)mainOrg) ? ',' + numberField + ',' + mainOrg + ',' : ',' + numberField + ',';
                }
            }
            return keyFields;
        }
        return "";
    }

    public static Map<String, Object> getKeyFieldMap(String entityNumber, String keyFields) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("keyField", keyFields);
        HashSet<String> keyFieldsSet = new HashSet<String>(Arrays.asList(keyFields.trim().replaceFirst(",", "").split(",")));
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        StringBuilder displayNames = new StringBuilder();
        for (IDataEntityProperty property : entityType.getProperties()) {
            for (String keyField : keyFieldsSet) {
                if (!kd.sys.ricc.common.util.StringUtils.equals((String)keyField, (String)property.getName())) continue;
                if (kd.sys.ricc.common.util.StringUtils.equals((String)keyField, (String)"id")) {
                    displayNames.append(CommonConstant.getMsgTransferIdName()).append(';');
                    continue;
                }
                displayNames.append(property.getDisplayName()).append(';');
            }
        }
        displayNames.deleteCharAt(displayNames.length() - 1);
        result.put("displayName", displayNames);
        return result;
    }
}

