/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.configitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;

public class ConfigItemTreeHelper {
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String LEVEL = "level";
    private static final String PARENT = "parent";
    private static final String RICC_CONFIGTREE = "ricc_configtree";

    private ConfigItemTreeHelper() {
    }

    public static Collection<String> getInvisibleTreeNumbers() {
        DynamicObject[] configItemTrees;
        Map blackCloud = RunModeServiceHelper.getCloudBlacklist();
        Map blackApp = RunModeServiceHelper.getAppBlacklist();
        HashSet invisibleApps = new HashSet(blackApp.values());
        HashSet invisibleClouds = new HashSet(blackCloud.values());
        invisibleApps.addAll(ConfigItemTreeHelper.findInvisibleAndDisabledApps());
        Set<String> disabledAppNumbers = ConfigItemTreeHelper.getDisabledNumbersById("bos_devportal_bizapp", ManageServiceHelper.getDisabledAppIds());
        Set<String> disabledCloudNumbers = ConfigItemTreeHelper.getDisabledNumbersById("bos_devportal_bizcloud", ManageServiceHelper.getDisabledCloudIds());
        invisibleApps.addAll(disabledAppNumbers);
        invisibleApps.addAll(disabledCloudNumbers);
        invisibleApps.addAll(invisibleClouds);
        HashMap<String, String> invisibleMap = new HashMap<String, String>(invisibleApps.size());
        invisibleApps.forEach(s -> invisibleMap.put(s.toLowerCase(), (String)s));
        for (DynamicObject tree : configItemTrees = BusinessDataServiceHelper.load((String)RICC_CONFIGTREE, (String)"id,name,parent,number,level,ispreset", (QFilter[])new QFilter[0], (String)LEVEL)) {
            String treeNumber;
            String parentTreeNumber;
            DynamicObject parent = tree.getDynamicObject(PARENT);
            if (parent != null && invisibleMap.containsKey((parentTreeNumber = parent.getString(NUMBER)).toLowerCase())) {
                String treeNumber2 = tree.getString(NUMBER);
                invisibleMap.put(treeNumber2.toLowerCase(), treeNumber2);
            }
            if (!invisibleMap.containsKey((treeNumber = tree.getString(NUMBER)).toLowerCase())) continue;
            invisibleMap.put(treeNumber.toLowerCase(), treeNumber);
        }
        return invisibleMap.values();
    }

    private static Set<String> getDisabledNumbersById(String entityNumber, Set<String> ids) {
        if (ids != null && !ids.isEmpty()) {
            HashSet<String> disabledAppNumbers = new HashSet<String>(ids.size());
            DynamicObjectCollection disableObjs = QueryServiceHelper.query((String)entityNumber, (String)NUMBER, (QFilter[])new QFilter(ID, "in", ids).toArray());
            for (DynamicObject dyo : disableObjs) {
                disabledAppNumbers.add(dyo.getString(NUMBER));
            }
            return disabledAppNumbers;
        }
        return new HashSet<String>();
    }

    private static List<String> findInvisibleAndDisabledApps() {
        String sql = "SELECT FNUMBER FROM T_META_BIZAPP WHERE FDEPLOYSTATUS = '1' ";
        Set idSet = (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
            HashSet<String> numbers = new HashSet<String>(16);
            while (rs.next()) {
                String number = rs.getString(1);
                numbers.add(number);
            }
            return numbers;
        });
        return new ArrayList<String>(idSet);
    }
}

