/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.configitem.check;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sys.ricc.business.configitem.check.ConfigCheckProcessor;
import kd.sys.ricc.business.schedule.AbstractSerailTask;
import kd.sys.ricc.business.schedule.ProgressBack;
import kd.sys.ricc.common.util.BatchSplitUtil;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.TimeCostUtil;

public class ConfigCheckTask
extends AbstractSerailTask {
    private static final Log logger = LogFactory.getLog(ConfigCheckTask.class);
    private long checkBillId;
    private List<Long> configIds;
    private String taskNo;
    private int total;
    private int complete;
    private ConfigCheckProcessor checkProcessor;
    private ProgressBack progressBack;

    @Override
    public void realExecute(RequestContext requestContext, Map<String, Object> map) {
        this.initTaskContext(map);
        long startTime = System.currentTimeMillis();
        String progressDesc = String.format(ResManager.loadKDString((String)"\u603b\u5171\uff1a%1$s\u9879\uff0c\u5df2\u68c0\u67e50\u9879", (String)"ConfigCheckTask_0", (String)"sys-ricc-platform", (Object[])new Object[0]), this.total);
        this.initUpdateProgress(startTime, requestContext.getTraceId(), this.taskId, progressDesc);
        try {
            this.executeCheck(startTime);
        }
        catch (Exception e) {
            logger.error("\u5065\u5eb7\u68c0\u67e5\u4efb\u52a1\u65e5\u5fd7:", (Throwable)e);
            String errorMessage = this.subErrorMessage(e);
            String tagErrorMessage = e.getMessage() + CommonUtil.getExceptionDetailInfo((Throwable)e);
            long errorEndTime = System.currentTimeMillis();
            String costTime = TimeCostUtil.getUsedTime((long)startTime, (long)errorEndTime);
            this.errorUpdateProgress(errorEndTime, costTime, errorMessage, tagErrorMessage);
        }
    }

    private void executeCheck(long startTime) {
        List splitsConfigIds = BatchSplitUtil.splitBatch(this.configIds, (int)10);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"ricc_configitems");
        String taskStatus = "complete";
        block0: for (List ids : splitsConfigIds) {
            DynamicObject[] configItems;
            for (DynamicObject configItem : configItems = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)dataEntityType)) {
                if (this.isSuspend()) {
                    taskStatus = "suspend";
                    break block0;
                }
                this.checkProcessor.check(configItem, this.taskNo, this.checkBillId);
                ++this.complete;
                String progressDesc = String.format(ResManager.loadKDString((String)"\u603b\u5171\uff1a%1$s\u9879\uff0c\u5df2\u68c0\u67e5%2$s\u9879", (String)"ConfigCheckTask_1", (String)"sys-ricc-platform", (Object[])new Object[0]), this.total, this.complete);
                this.updateProgressDesc(progressDesc);
                this.getProgressBack().feedbackProgress(this.total, this.complete);
            }
        }
        long endTime = System.currentTimeMillis();
        String consumeTime = TimeCostUtil.getUsedTime((long)startTime, (long)endTime);
        this.completeOrSuspendUpdateProgress(endTime, consumeTime, taskStatus);
        this.getProgressBack().complete();
    }

    private void initTaskContext(Map<String, Object> map) {
        this.checkBillId = (Long)map.get("checkbillid");
        DynamicObject checkBillObj = BusinessDataServiceHelper.loadSingle((Object)this.checkBillId, (String)"ricc_config_checktask");
        this.checkProcessor = ConfigCheckProcessor.build(checkBillObj);
        DynamicObjectCollection checkConfigs = checkBillObj.getDynamicObjectCollection("checkconfigs");
        this.configIds = checkConfigs.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
        this.total = checkConfigs.size();
        this.complete = 0;
        this.taskNo = checkBillObj.getString("billno");
    }

    private void initUpdateProgress(long startTime, String traceId, String taskId, String progressDesc) {
        String updateSql = "UPDATE T_RICC_CONFIG_CHECKTASK SET FSTARTTIME = ?, FTRACEID = ?, FTASKID = ?, FPROGRESSDESC = ? WHERE FID = ?";
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>(5);
        paraList.add(new SqlParameter(":FSTARTTIME", 91, (Object)new Date(startTime)));
        paraList.add(new SqlParameter(":FTRACEID", 12, (Object)traceId));
        paraList.add(new SqlParameter(":FTASKID", 12, (Object)taskId));
        paraList.add(new SqlParameter(":FPROGRESSDESC", 12, (Object)progressDesc));
        paraList.add(new SqlParameter(":FID", -5, (Object)this.checkBillId));
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)updateSql, (Object[])paraList.toArray(new SqlParameter[5]));
    }

    private void errorUpdateProgress(long errorEndTime, String costTime, String displayErrorMessage, String tagErrorMessage) {
        String updateSql = "UPDATE T_RICC_CONFIG_CHECKTASK SET FENDTIME = ?, FCOSTTIME = ?, FERRORMESSAGE = ?, FERRORMESSAGE_TAG = ?, FTASKSTATUS = ? WHERE FID = ?";
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>(6);
        paraList.add(new SqlParameter(":FENDTIME", 91, (Object)new Date(errorEndTime)));
        paraList.add(new SqlParameter(":FCOSTTIME", -9, (Object)costTime));
        paraList.add(new SqlParameter(":FERRORMESSAGE", -9, (Object)displayErrorMessage));
        paraList.add(new SqlParameter(":FERRORMESSAGE_TAG", -9, (Object)tagErrorMessage));
        paraList.add(new SqlParameter(":FTASKSTATUS", 12, (Object)"error"));
        paraList.add(new SqlParameter(":FID", -5, (Object)this.checkBillId));
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)updateSql, (Object[])paraList.toArray(new SqlParameter[6]));
    }

    private void completeOrSuspendUpdateProgress(long endTime, String costTime, String taskStatus) {
        String updateSql = "UPDATE T_RICC_CONFIG_CHECKTASK SET FENDTIME = ?, FCOSTTIME = ?, FTASKSTATUS = ? WHERE FID = ?";
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>(4);
        paraList.add(new SqlParameter(":FENDTIME", 91, (Object)new Date(endTime)));
        paraList.add(new SqlParameter(":FCOSTTIME", -9, (Object)costTime));
        paraList.add(new SqlParameter(":FTASKSTATUS", -9, (Object)taskStatus));
        paraList.add(new SqlParameter(":FID", -5, (Object)this.checkBillId));
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)updateSql, (Object[])paraList.toArray(new SqlParameter[4]));
    }

    private void updateProgressDesc(String progressDesc) {
        String updateSql = "UPDATE T_RICC_CONFIG_CHECKTASK SET FPROGRESSDESC = ? WHERE FID = ?";
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>(2);
        paraList.add(new SqlParameter(":FPROGRESSDESC", 12, (Object)progressDesc));
        paraList.add(new SqlParameter(":FID", -5, (Object)this.checkBillId));
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)updateSql, (Object[])paraList.toArray(new SqlParameter[2]));
    }

    private boolean isSuspend() {
        String suspendKey = "ITEMCHECK_SUSPEND_" + this.checkBillId;
        return AppCache.get((String)"ricc").get(suspendKey, String.class) != null;
    }

    private ProgressBack getProgressBack() {
        if (this.progressBack == null) {
            this.progressBack = new ProgressBack(this.taskId);
        }
        return this.progressBack;
    }

    private String subErrorMessage(Exception e) {
        String errorMessage = e.getMessage();
        if (StringUtils.isEmpty((String)errorMessage)) {
            return "";
        }
        int maxSize = 160;
        if (errorMessage.length() > maxSize) {
            errorMessage = errorMessage.substring(0, maxSize);
        }
        return errorMessage;
    }
}

