/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.Propagation;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.sys.ricc.business.configitem.ConfigItemHelper;
import kd.sys.ricc.business.datapacket.core.ISubDataPacket;
import kd.sys.ricc.business.datapacket.core.impl.json.JsonImportHelper;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.helper.AttachAndPictureTransHelper;
import kd.sys.ricc.business.datapacket.helper.DataPacketHelper;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.impt.JsonResolveHelper;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.helper.DataCompareHelper;
import kd.sys.ricc.common.query.CommonQuery;
import kd.sys.ricc.common.util.BatchSplitUtil;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.DynamicObjectUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.exception.RiccBizException;

public class JsonDataPacketImpl
implements ISubDataPacket {
    public static final Integer NUMBER_VAL_INDEX = 3;
    private static final Log logger = LogFactory.getLog(JsonDataPacketImpl.class);
    private static final int BATCH_SIZE = 3000;
    private static final String CONTENT = "content";
    private static final String NUMBER_FIELD = "numberField";
    private static final String FILE_SUFFEX_JSON = ".json";
    private String coverInfo;

    @Override
    public SdpOutputParams exportPacket(SdpInputParams sdpInputParams) {
        return this.jsonExportPacket(sdpInputParams, true);
    }

    protected SdpOutputParams jsonExportPacket(SdpInputParams sdpInputParams, boolean isKeyFields) {
        List pkIdList;
        int totalSize;
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        if (sdpInputParams == null) {
            return sdpOutputParams;
        }
        ListSelectedRowCollection selectRows = sdpInputParams.getSelectRows();
        Map<String, Object> custParam = sdpInputParams.getParam();
        String entityName = (String)custParam.get("entityname");
        String entityNumber = this.getEntityNumber(custParam);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        boolean emptyName = false;
        String filters = DataPacketHelper.getFilters(custParam);
        DynamicObject guideInfo = (DynamicObject)custParam.get("guideId");
        boolean isTransferAttach = guideInfo.getBoolean("istransferattach");
        ArrayList<Object> attachKeys = new ArrayList(16);
        ArrayList<String> attApKeys = new ArrayList(16);
        String localAttachPath = sdpInputParams.getLocalPath() + File.separator + "attach";
        if (isTransferAttach) {
            FileUtils.checkAndCreateDir((String)localAttachPath);
            String attachFieldStr = guideInfo.getString("attachmentfield");
            if (!StringUtils.isEmpty((String)attachFieldStr) && !(attachKeys = new ArrayList<String>(Arrays.asList(attachFieldStr.trim().replaceFirst(",", "").split(",")))).isEmpty()) {
                attApKeys = AttachAndPictureTransHelper.getAttApKeys(attachKeys);
            }
        }
        if (isKeyFields) {
            String entityId = guideInfo.getString("entityid");
            String keyFieldItem = guideInfo.getString("keyfields");
            String keyFields = ConfigItemHelper.disPoseKeyField(entityId, keyFieldItem, entityName);
            HashSet<String> keyFieldSet = new HashSet<String>(Arrays.asList(keyFields.trim().replaceFirst(",", "").split(",")));
            logger.info("\u914d\u7f6e\u9879 {} \u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\u4e3a {}", (Object)entityName, (Object)keyFields);
            List<Map<String, Object>> previewData = DataPacketHelper.getCustomParam(entityNumber, selectRows.getPrimaryKeyValues(), filters, keyFieldSet);
            if (previewData.isEmpty()) {
                sdpOutputParams.setSuccess(false);
                sdpOutputParams.append(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa", (String)"JsonDataPacketImpl_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return sdpOutputParams;
            }
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("previewData", previewData);
            param.put("keyFields", keyFieldSet);
            sdpOutputParams.setParam(param);
            totalSize = previewData.size();
            if (StringUtils.isEmpty((String)((String)previewData.get(0).get("number"))) && StringUtils.isEmpty((String)((String)previewData.get(0).get("name")))) {
                emptyName = true;
            }
            pkIdList = previewData.stream().filter(y -> y.containsKey("id")).map(y -> y.get("id")).collect(Collectors.toList());
        } else {
            if (selectRows.isEmpty()) {
                logger.info("json\u52a8\u6001\u5e8f\u5217\u5316\u65b9\u5f0f\u6279\u91cf\u5bfc\u51fa\u6570\u636e\u5f00\u59cb");
                selectRows = CommonQuery.getAllSelectData((String)entityNumber, (String)filters);
                if (selectRows.isEmpty()) {
                    sdpOutputParams.setSuccess(false);
                    sdpOutputParams.append(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa", (String)"JsonDataPacketImpl_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    return sdpOutputParams;
                }
            }
            totalSize = selectRows.size();
            if (StringUtils.isEmpty((String)selectRows.get(0).getNumber()) && StringUtils.isEmpty((String)selectRows.get(0).getName())) {
                emptyName = true;
            }
            pkIdList = Arrays.stream(selectRows.getPrimaryKeyValues()).collect(Collectors.toList());
        }
        logger.info("json\u52a8\u6001\u5e8f\u5217\u5316\u65b9\u5f0f\u5bfc\u51fa\u6570\u636e,\u603b\u6570\uff1a" + totalSize);
        AddPacketProgress addPacketProgress = sdpInputParams.getAddPacketProgress();
        String sortField = (String)custParam.getOrDefault("sortfield", "");
        String sortWay = (String)custParam.getOrDefault("sortway", "");
        if (!StringUtils.isEmpty((String)sortField) && !StringUtils.isEmpty((String)sortWay)) {
            QFilter pkIdFilter = new QFilter("id", "in", pkIdList);
            pkIdList = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])pkIdFilter.toArray(), (String)(sortField + " " + sortWay), (int)-1);
        }
        List spitBatchList = BatchSplitUtil.splitBatch(pkIdList, (int)this.getExportBatchSize());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(emptyName ? String.format("%1$s\t\t%2$sid%n", CommonConstant.getSerialNumTitle(), entityName) : String.format(CommonConstant.getSelectedTitle(), entityName, entityName));
        int orderNum = 0;
        int completeCountStart = 0;
        int batchNum = 0;
        for (List oneBatchList : spitBatchList) {
            Map<String, Object> countMap;
            DynamicObject[] dyoArray = this.loadAndOrderDataByIdList(entityType, oneBatchList);
            this.beforeConvertToMap(dyoArray);
            Map<String, Object> oneSplitContentMap = this.getDataMap(dyoArray, addPacketProgress, totalSize, completeCountStart);
            this.afterBatchExport(dyoArray, oneSplitContentMap);
            orderNum = this.getSelectedInfo(entityNumber, stringBuilder, orderNum, dyoArray, emptyName);
            oneSplitContentMap.put("entityType", entityType.getName());
            completeCountStart += this.getExportBatchSize();
            long currentTimeMillis = System.currentTimeMillis();
            boolean success = this.batchDataToFile(oneSplitContentMap, sdpInputParams.getLocalPath(), batchNum, sdpOutputParams, currentTimeMillis, FILE_SUFFEX_JSON);
            if (isTransferAttach && !(countMap = AttachAndPictureTransHelper.getAllAttContentMap(dyoArray, attachKeys, attApKeys, entityNumber, localAttachPath)).isEmpty()) {
                boolean attachSuccess = this.batchDataToFile(countMap, sdpInputParams.getLocalPath(), batchNum, sdpOutputParams, currentTimeMillis, "_attach.json");
                boolean bl = success = success && attachSuccess;
            }
            if (!success) {
                sdpOutputParams.setSuccess(false);
                return sdpOutputParams;
            }
            ++batchNum;
        }
        sdpOutputParams.setSelectedInfo(stringBuilder.toString());
        ScheduleUtil.buildAddPacketProgressDesc(addPacketProgress, logger, ResManager.loadKDString((String)"\u6570\u636e\u5904\u7406\u5df2\u5b8c\u6210\uff0c\u6b63\u5728\u751f\u6210\u6587\u4ef6\u3002", (String)"JsonDataPacketImpl_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
        String fileName = entityName + System.currentTimeMillis();
        String zipPath = FileUtils.dirToZip((String)sdpInputParams.getLocalPath(), (String)fileName);
        sdpOutputParams.setExportFilePath(zipPath);
        sdpOutputParams.setSuccess(true);
        return sdpOutputParams;
    }

    private boolean batchDataToFile(Map<String, Object> contentMap, String localPath, int batchNum, SdpOutputParams sdpOutputParams, long prefix, String suffix) {
        boolean success = true;
        String fileName = prefix + "_" + batchNum + suffix;
        String fullFilePath = localPath + File.separator + fileName;
        logger.info("json\u52a8\u6001\u5e8f\u5217\u5316\u65b9\u5f0f\u5bfc\u51fa\u6570\u636e,\u672c\u5730\u6587\u4ef6\u5730\u5740\uff1a" + fullFilePath + "\u6279\u6b21\uff1a" + batchNum);
        try {
            logger.info("json\u52a8\u6001\u5e8f\u5217\u5316\u65b9\u5f0f\u5bfc\u51fa\u6570\u636e,\u5199\u5165\u6587\u4ef6map\u5927\u5c0f\uff1a" + contentMap.size());
            FileUtils.writeMap2File((String)fullFilePath, contentMap);
        }
        catch (Exception e) {
            logger.error("json\u52a8\u6001\u5e8f\u5217\u5316\u65b9\u5f0f\u5199\u5165\u6587\u4ef6\u51fa\u9519\u3002", (Throwable)e);
            success = false;
            String errMsg = String.format(ResManager.loadKDString((String)"json\u52a8\u6001\u5e8f\u5217\u5316\u65b9\u5f0f\u5199\u5165\u6587\u4ef6\u51fa\u9519\uff0c\u6587\u4ef6\u540d%s", (String)"JsonDataPacketImpl_6", (String)"sys-ricc-platform", (Object[])new Object[0]), fileName);
            sdpOutputParams.append(errMsg, e);
        }
        return success;
    }

    private DynamicObject[] loadAndOrderDataByIdList(MainEntityType entityType, List<Object> idList) {
        Object[] ids = new Object[idList.size()];
        for (int j = 0; j < idList.size(); ++j) {
            ids[j] = idList.get(j);
        }
        DynamicObject[] dyObs = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)entityType);
        HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(dyObs.length);
        for (DynamicObject obj : dyObs) {
            map.put(obj.getPkValue(), obj);
        }
        ArrayList<DynamicObject> dyObsList = new ArrayList<DynamicObject>(dyObs.length);
        for (Object id : ids) {
            DynamicObject obj = (DynamicObject)map.get(id);
            if (obj == null) continue;
            dyObsList.add(obj);
        }
        return dyObsList.toArray(new DynamicObject[0]);
    }

    public int getSelectedInfo(String entityNumber, StringBuilder stringBuilder, int orderNum, DynamicObject[] dyos, boolean emptyName) {
        if ("srm_audit_org".equals(entityNumber)) {
            for (DynamicObject dy : dyos) {
                stringBuilder.append(String.format("%1$s\t\t%2$s\t\t%3$s %n", orderNum++ + 1, dy.get("org.number"), dy.get("org.name")));
            }
        } else {
            DynamicObject d = dyos[0];
            String numberProp = null;
            String nameProp = null;
            if (d.containsProperty("number")) {
                numberProp = "number";
            } else if (d.containsProperty("billno")) {
                numberProp = "billno";
            }
            if (d.containsProperty("name")) {
                nameProp = "name";
            }
            for (DynamicObject dy : dyos) {
                if (emptyName) {
                    stringBuilder.append(String.format("%1$s\t\t%2$s\t\t", orderNum++ + 1, dy.getPkValue()));
                    continue;
                }
                stringBuilder.append(String.format("%1$s\t\t%2$s\t\t", orderNum++ + 1, numberProp != null ? dy.get(numberProp) : ""));
                if (nameProp != null) {
                    IDataEntityProperty nameProperty = (IDataEntityProperty)d.getDataEntityType().getProperties().get((Object)nameProp);
                    boolean isString = nameProperty instanceof TextProp;
                    String name = isString ? dy.getString(nameProp) : dy.getLocaleString(nameProp).getLocaleValue();
                    stringBuilder.append(name == null ? "\r\n" : name + "\r\n");
                    continue;
                }
                stringBuilder.append("\n");
            }
        }
        return orderNum;
    }

    @Override
    public SdpOutputParams importPacket(SdpInputParams sdpInputParams) {
        SdpOutputParams sdpOutputParams;
        block74: {
            sdpOutputParams = new SdpOutputParams();
            this.beforeImportPacket(sdpInputParams, sdpOutputParams);
            if (!sdpOutputParams.isSuccess()) {
                return sdpOutputParams;
            }
            String fileUrl = (String)sdpInputParams.getParam().get("fileUrl");
            fileUrl = CommonUtil.checkUrl((String)fileUrl);
            FileService fs = FileServiceFactory.getAttachmentFileService();
            if (!fs.exists(fileUrl)) {
                return sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5730\u5740%s\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684\u6587\u4ef6", (String)"JsonDataPacketImpl_10", (String)"sys-ricc-platform", (Object[])new Object[0]), fileUrl));
            }
            String keyFields = ((DynamicObject)sdpInputParams.getParam().get("guideInfo")).getString("keyfields");
            String pluginKeyFields = this.getKeyFields();
            if (StringUtils.isNotEmpty((String)pluginKeyFields)) {
                keyFields = pluginKeyFields;
            }
            this.coverInfo = ((DynamicObject)sdpInputParams.getParam().get("guideInfo")).getString("coverinfo");
            String fileName = (String)sdpInputParams.getParam().get("fileName");
            Object synMode = sdpInputParams.getParam().get("synmode");
            if (fileName.endsWith(FILE_SUFFEX_JSON)) {
                try (InputStream in = fs.getInputStream(fileUrl);){
                    this.parseFileAndImport(in, fileName, keyFields, synMode, sdpOutputParams);
                    break block74;
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    return sdpOutputParams.append(ResManager.loadKDString((String)"\u6587\u4ef6\u8bfb\u53d6\u53d1\u751f\u5f02\u5e38\u3002", (String)"JsonDataPacketImpl_8", (String)"sys-ricc-platform", (Object[])new Object[0]), e);
                }
            }
            if (fileName.endsWith(".zip")) {
                String name;
                ZipEntry nextEntry2;
                Throwable throwable;
                ZipInputStream zipInputStream2;
                Throwable throwable2;
                InputStream in;
                int totalCount = 0;
                int successCount = 0;
                try {
                    in = fs.getInputStream(fileUrl);
                    throwable2 = null;
                    try {
                        zipInputStream2 = new ZipInputStream(in, Charset.forName("GBK"));
                        throwable = null;
                        try {
                            while ((nextEntry2 = zipInputStream2.getNextEntry()) != null) {
                                name = nextEntry2.getName();
                                if (name.endsWith("_attach.json") || name.equals("attach/")) continue;
                                if (name.startsWith("attach/")) {
                                    AttachAndPictureTransHelper.uploadAttachTemp(name, zipInputStream2, sdpOutputParams);
                                    continue;
                                }
                                this.parseFileAndImport(zipInputStream2, name, keyFields, synMode, sdpOutputParams);
                                Map<String, Object> param = sdpOutputParams.getParam();
                                int batchSuccessCount = (Integer)param.getOrDefault("successCount", 0);
                                int batchTotalCount = (Integer)param.getOrDefault("totalCount", 0);
                                totalCount += batchTotalCount;
                                successCount += batchSuccessCount;
                                param.put("totalCount", 0);
                                param.put("successCount", 0);
                                param.put("failedCount", 0);
                            }
                            Map<String, Object> param = sdpOutputParams.getParam();
                            param.put("successCount", successCount);
                            param.put("failedCount", totalCount - successCount);
                        }
                        catch (Throwable nextEntry2) {
                            throwable = nextEntry2;
                            throw nextEntry2;
                        }
                        finally {
                            if (zipInputStream2 != null) {
                                if (throwable != null) {
                                    try {
                                        zipInputStream2.close();
                                    }
                                    catch (Throwable nextEntry2) {
                                        throwable.addSuppressed(nextEntry2);
                                    }
                                } else {
                                    zipInputStream2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable zipInputStream2) {
                        throwable2 = zipInputStream2;
                        throw zipInputStream2;
                    }
                    finally {
                        if (in != null) {
                            if (throwable2 != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable zipInputStream2) {
                                    throwable2.addSuppressed(zipInputStream2);
                                }
                            } else {
                                in.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                    return sdpOutputParams.append(ResManager.loadKDString((String)"\u6587\u4ef6\u8bfb\u53d6\u53d1\u751f\u5f02\u5e38\u3002", (String)"JsonDataPacketImpl_8", (String)"sys-ricc-platform", (Object[])new Object[0]), e);
                }
                try {
                    in = fs.getInputStream(fileUrl);
                    throwable2 = null;
                    try {
                        zipInputStream2 = new ZipInputStream(in, Charset.forName("GBK"));
                        throwable = null;
                        try {
                            while ((nextEntry2 = zipInputStream2.getNextEntry()) != null) {
                                name = nextEntry2.getName();
                                if (!name.endsWith("_attach.json")) continue;
                                AttachAndPictureTransHelper.importAttContent(zipInputStream2, name, sdpOutputParams);
                            }
                            break block74;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (zipInputStream2 != null) {
                                if (throwable != null) {
                                    try {
                                        zipInputStream2.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    zipInputStream2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (in != null) {
                            if (throwable2 != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                            } else {
                                in.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                    return sdpOutputParams.append(ResManager.loadKDString((String)"\u6587\u4ef6\u8bfb\u53d6\u53d1\u751f\u5f02\u5e38\u3002", (String)"JsonDataPacketImpl_8", (String)"sys-ricc-platform", (Object[])new Object[0]), e);
                }
            }
            String msgTpl = ResManager.loadKDString((String)"\u6587\u4ef6\u201c%s\u201d\u65e0\u6cd5\u8bc6\u522b\u4e3ajson\u6216\u8005zip\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u6253\u5305\u8fdb\u884c\u4f20\u8f93\u540c\u6b65\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406", (String)"JsonDataPacketImpl_23", (String)"sys-ricc-platform", (Object[])new Object[0]);
            return sdpOutputParams.append(String.format(msgTpl, fileName));
        }
        boolean success = sdpOutputParams.getError().length() <= 0;
        sdpOutputParams.setSuccess(success);
        return sdpOutputParams;
    }

    private void parseFileAndImport(InputStream fileInputStream, String name, String keyFields, Object synMode, SdpOutputParams sdpOutputParams) {
        JSONObject dataMap;
        try {
            String resStr = FileUtils.inputStreamToString((InputStream)fileInputStream);
            dataMap = (JSONObject)JSON.parseObject((String)resStr, (TypeReference)new TypeReference<JSONObject>(){}, (Feature[])new Feature[]{Feature.OrderedField});
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u6587\u4ef6%s\u5931\u8d25\u3002", (String)"JsonDataPacketImpl_9", (String)"sys-ricc-platform", (Object[])new Object[0]), name), e);
            return;
        }
        String entryentity = null;
        if (!dataMap.containsKey((Object)"entityType") || dataMap.get((Object)"entityType") == null) {
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u6587\u4ef6%s\u4e2d\u6ca1\u6709\u83b7\u53d6\u5230\u5b9e\u4f53\u7c7b\u578bentityType\uff0c\u8bf7\u68c0\u67e5\u5305\u6587\u4ef6\u662f\u5426\u88ab\u7be1\u6539\u6216\u5185\u5bb9\u635f\u574f", (String)"JsonDataPacketImpl_11", (String)"sys-ricc-platform", (Object[])new Object[0]), name));
            return;
        }
        entryentity = String.valueOf(dataMap.remove((Object)"entityType"));
        Set idSet = dataMap.keySet();
        Map<String, Object> param = sdpOutputParams.getParam();
        param.put("totalCount", dataMap.size());
        logger.info("\u5bfc\u5165\u5f00\u59cb\uff0c size\uff1a" + dataMap.size());
        BatchSaveType batchSaveType = this.getBatchSaveType();
        if (synMode != null && "RollbackOnError".equals(String.valueOf(synMode))) {
            this.synOnBatchRollbackMode(sdpOutputParams, dataMap, entryentity, idSet, keyFields, batchSaveType);
        } else {
            this.synOnBatchResumeMode(sdpOutputParams, dataMap, entryentity, idSet, keyFields, batchSaveType);
        }
    }

    public void synOnBatchRollbackMode(SdpOutputParams outputParams, JSONObject dataMap, String entityName, Set<String> idSet, String keyFields, BatchSaveType batchSaveType) {
        int totalSize = idSet.size();
        try (TXHandle h1 = TX.requiresNew();){
            try {
                this.batchProcess(outputParams, dataMap, entityName, idSet, totalSize, keyFields, batchSaveType);
                if (!StringUtils.isEmpty((String)outputParams.getErrorStr())) {
                    throw new RiccBizException();
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                h1.markRollback();
            }
        }
    }

    public void synOnBatchResumeMode(SdpOutputParams outputParams, JSONObject dataMap, String entityName, Set<String> idSet, String keyFields, BatchSaveType batchSaveType) {
        int totalSize = idSet.size();
        this.batchProcess(outputParams, dataMap, entityName, idSet, totalSize, keyFields, batchSaveType);
    }

    private void batchProcess(SdpOutputParams outputParams, JSONObject dataMap, String entityName, Set<String> idSet, int totalSize, String keyFields, BatchSaveType batchSaveType) {
        int i = 0;
        int successCount = 0;
        ArrayList<Object> ids = new ArrayList<Object>(this.getImportBatchSize());
        for (String id : idSet) {
            ids.add(JsonImportHelper.idCovert(entityName, id));
            if (++i % this.getImportBatchSize() != 0 && i != totalSize) continue;
            boolean isExsistFailed = Boolean.FALSE;
            int batchSuccessCount = 0;
            try (TXHandle h1 = this.getImportTransaction();){
                try {
                    this.beforeBatchImport(ids, dataMap, outputParams);
                    batchSuccessCount = this.batchImport(entityName, ids, dataMap, outputParams, keyFields, batchSaveType);
                    this.afterBatchImport(ids, dataMap, outputParams);
                    logger.info(String.format("\u6279\u6b21%1$s\u5904\u7406\u6210\u529f%2$s\u6761\u6570\u636e\uff01", i, successCount));
                    if (batchSuccessCount < ids.size()) {
                        isExsistFailed = true;
                        String error = batchSuccessCount == 0 ? String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u201d%1$s\u201c\u6279\u6b21\u603b\u6570 \u201d%2$s\u201c \u5bfc\u5165\u6210\u529f\u6570\u91cf\u201d%3$s\u201c\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"JsonDataPacketImpl_25", (String)"sys-ricc-platform", (Object[])new Object[0]), entityName, ids.size(), batchSuccessCount) : String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u201d%1$s\u201c\u6279\u6b21\u603b\u6570 \u201d%2$s\u201c \u5bfc\u5165\u6210\u529f\u6570\u91cf\u201d%3$s\u201c\uff0c\u5bfc\u5165\u90e8\u5206\u6210\u529f\u3002", (String)"JsonDataPacketImpl_27", (String)"sys-ricc-platform", (Object[])new Object[0]), entityName, ids.size(), batchSuccessCount);
                        throw new RiccBizException(error);
                    }
                }
                catch (RiccBizException e) {
                    isExsistFailed = true;
                    logger.error("json\u5206\u6279\u5904\u7406\u51fa\u9519", (Throwable)e);
                    h1.markRollback();
                }
                catch (Exception e) {
                    isExsistFailed = true;
                    logger.error("json\u5206\u6279\u5904\u7406\u51fa\u9519", (Throwable)e);
                    h1.markRollback();
                    outputParams.append(System.lineSeparator()).append(e.getMessage(), e);
                }
            }
            if (batchSuccessCount == ids.size()) {
                h1 = TX.requiresNew();
                var16_16 = null;
                try {
                    try {
                        this.afterBatchImportForSpecial(ids, dataMap, outputParams);
                        successCount += batchSuccessCount;
                    }
                    catch (RiccBizException e) {
                        logger.error("\u7279\u6b8a\u5904\u7406\u5904\u7406\u51fa\u9519", (Throwable)e);
                        h1.markRollback();
                    }
                    catch (Exception e) {
                        logger.error("\u7279\u6b8a\u5904\u7406\u5904\u7406\u51fa\u9519", (Throwable)e);
                        h1.markRollback();
                        outputParams.append(System.lineSeparator()).append(e.getMessage(), e);
                    }
                }
                catch (Throwable throwable) {
                    var16_16 = throwable;
                    throw throwable;
                }
                finally {
                    if (h1 != null) {
                        if (var16_16 != null) {
                            try {
                                h1.close();
                            }
                            catch (Throwable throwable) {
                                var16_16.addSuppressed(throwable);
                            }
                        } else {
                            h1.close();
                        }
                    }
                }
            } else {
                successCount += batchSuccessCount;
            }
            ids.clear();
        }
        if (totalSize != successCount) {
            StringBuilder errorMsgBuilder = new StringBuilder(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c\u5904\u7406\u6210\u529f%2$s\u6761\u6570\u636e\uff0c\u5904\u7406\u5931\u8d25%3$s\u6761\uff1b", (String)"JsonDataPacketImpl_28", (String)"sys-ricc-platform", (Object[])new Object[0]), totalSize, successCount, totalSize - successCount));
            errorMsgBuilder.append(System.lineSeparator()).append(ResManager.loadKDString((String)"\u9519\u8bef\u6570\u636e\u51fa\u9519\u539f\u56e0\u5982\u4e0b\u3002", (String)"JsonDataPacketImpl_29", (String)"sys-ricc-platform", (Object[])new Object[0])).append(System.lineSeparator());
            outputParams.getError().insert(0, errorMsgBuilder.toString());
        }
        Map<String, Object> param = outputParams.getParam();
        param.put("successCount", successCount);
        param.put("failedCount", totalSize - successCount);
    }

    public Map<String, Object> getDataMap(DynamicObject[] dyos, AddPacketProgress addPacketProgress, int totalSize, int completeCountStart) {
        int size = dyos.length;
        LinkedHashMap<String, Object> idAndContentMap = new LinkedHashMap<String, Object>(size);
        for (DynamicObject dyo : dyos) {
            HashMap<String, Object> contentMap = new HashMap<String, Object>(8);
            String name = dyo.getDataEntityType().getName();
            if ("ricc_basedata_item".equals(name) || "ricc_configitems".equals(name)) {
                dyo.getDynamicObjectCollection("ricc_schemeentry").clear();
            }
            Map dataMap = DynamicObjectUtil.object2Map((DynamicObject)dyo);
            Map<String, Object> bdMap = this.getBdPropertiesMap(dyo);
            contentMap.putAll((HashMap)bdMap.get("entry"));
            contentMap.put("data", dataMap);
            contentMap.put("bd", bdMap.get("head"));
            if (dataMap.get("id") != null) {
                idAndContentMap.put(String.valueOf(dataMap.get("id")), contentMap);
            }
            ScheduleUtil.addPacketFeedbackProgress(addPacketProgress, totalSize, ++completeCountStart);
        }
        return idAndContentMap;
    }

    private Map<String, Object> getBdPropertiesMap(DynamicObject dyo) {
        HashMap<String, Object> bdMap = new HashMap<String, Object>();
        HashMap<String, Object> bdheadMap = new HashMap<String, Object>();
        HashMap<String, Object> bdentryMap = new HashMap<String, Object>();
        if (dyo != null) {
            DataEntityPropertyCollection proptiesCol = dyo.getDataEntityType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : proptiesCol) {
                Object bd;
                String numberField;
                if (iDataEntityProperty instanceof BasedataProp) {
                    numberField = this.getBasedataPropNumberField(iDataEntityProperty);
                    bd = dyo.get(iDataEntityProperty);
                    if (bd == null) continue;
                    DynamicObject bdObj = (DynamicObject)bd;
                    String number = bdObj.containsProperty(numberField) ? bdObj.getString(numberField) : "";
                    String[] baseInfo = new String[]{((BasedataProp)iDataEntityProperty).getBaseEntityId(), numberField, bdObj.getPkValue().toString(), number};
                    bdheadMap.put(iDataEntityProperty.getName(), baseInfo);
                    continue;
                }
                if (iDataEntityProperty instanceof MulBasedataProp && !(iDataEntityProperty instanceof AttachmentProp)) {
                    DynamicObjectCollection bds;
                    numberField = ((MulBasedataProp)iDataEntityProperty).getNumberProp();
                    bd = dyo.get(iDataEntityProperty);
                    if (bd == null || (bds = (DynamicObjectCollection)bd).isEmpty()) continue;
                    HashMap<String, Object> bdContentMap = new HashMap<String, Object>();
                    String refBosType = ((MulBasedataProp)iDataEntityProperty).getBaseEntityId();
                    bdContentMap.put("type", refBosType);
                    bdContentMap.put(NUMBER_FIELD, numberField);
                    ArrayList<String[]> mulBdList = new ArrayList<String[]>(bds.size());
                    for (DynamicObject o : bds) {
                        DynamicObject refDyo = (DynamicObject)o.get((IDataEntityProperty)o.getDataEntityType().getProperties().get(1));
                        if (refDyo == null) continue;
                        String number = refDyo.containsProperty(numberField) ? refDyo.getString(numberField) : "";
                        String[] values = new String[]{String.valueOf(refDyo.getPkValue()), number};
                        mulBdList.add(values);
                    }
                    bdContentMap.put(CONTENT, mulBdList);
                    bdheadMap.put(iDataEntityProperty.getName(), bdContentMap);
                    continue;
                }
                if (!(iDataEntityProperty instanceof EntryProp)) continue;
                this.getEntryBdMap(dyo, bdentryMap, iDataEntityProperty);
            }
        }
        bdMap.put("head", bdheadMap);
        bdMap.put("entry", bdentryMap);
        return bdMap;
    }

    private String getBasedataPropNumberField(IDataEntityProperty iDataEntityProperty) {
        String numberField = ((BasedataProp)iDataEntityProperty).getNumberProp();
        IDataEntityProperty numbProp = ((BasedataProp)iDataEntityProperty).getNumbProp();
        if (!Objects.isNull(numbProp)) {
            numberField = numbProp.getName();
        }
        return numberField;
    }

    private void getEntryBdMap(DynamicObject dyo, HashMap<String, Object> bdentryMap, IDataEntityProperty iDataEntityProperty) {
        DynamicObjectCollection entrys = dyo.getDynamicObjectCollection(iDataEntityProperty);
        HashMap entrydataMap = new HashMap();
        if (entrys != null && !entrys.isEmpty()) {
            DataEntityPropertyCollection properties = ((DynamicObject)entrys.get(0)).getDataEntityType().getProperties();
            for (IDataEntityProperty entityProperty : properties) {
                if (!(entityProperty instanceof AssistantProp) && entityProperty instanceof BasedataProp) {
                    String numberField = this.getBasedataPropNumberField(entityProperty);
                    HashMap<String, Object> bdContentMap = new HashMap<String, Object>();
                    bdContentMap.put("type", ((BasedataProp)entityProperty).getBaseEntityId());
                    bdContentMap.put(NUMBER_FIELD, numberField);
                    ArrayList<String[]> entrybdvalueList = new ArrayList<String[]>(entrys.size());
                    boolean containNumber = ((BasedataProp)entityProperty).getDynamicComplexPropertyType().getProperties().containsKey((Object)numberField);
                    for (DynamicObject o : entrys) {
                        DynamicObject bd = (DynamicObject)o.get(entityProperty);
                        if (bd != null) {
                            String number = containNumber ? bd.getString(numberField) : "";
                            String[] values = entityProperty instanceof ItemClassProp ? new String[]{String.valueOf(bd.getPkValue()), number, bd.getDataEntityType().getName()} : new String[]{String.valueOf(bd.getPkValue()), number};
                            entrybdvalueList.add(values);
                            continue;
                        }
                        entrybdvalueList.add(null);
                    }
                    bdContentMap.put(CONTENT, entrybdvalueList);
                    entrydataMap.put(entityProperty.getName(), bdContentMap);
                    continue;
                }
                if (!(entityProperty instanceof SubEntryProp)) continue;
                DynamicObjectCollection subentrys = ((DynamicObject)entrys.get(0)).getDynamicObjectCollection(entityProperty);
                HashMap<String, Object> subEntryDataMap = new HashMap<String, Object>();
                if (subentrys != null && !subentrys.isEmpty()) {
                    this.getSubEntryBdProperties(entrys, entityProperty, subentrys, subEntryDataMap);
                }
                bdentryMap.put(entityProperty.getName(), subEntryDataMap);
            }
        }
        bdentryMap.put(iDataEntityProperty.getName(), entrydataMap);
    }

    private void getSubEntryBdProperties(DynamicObjectCollection entrys, IDataEntityProperty entityProperty, DynamicObjectCollection subentrys, HashMap<String, Object> subEntryDataMap) {
        DataEntityPropertyCollection subPropties = ((DynamicObject)subentrys.get(0)).getDataEntityType().getProperties();
        for (IDataEntityProperty subProperty : subPropties) {
            if (subProperty instanceof AssistantProp || !(subProperty instanceof BasedataProp)) continue;
            String numberField = this.getBasedataPropNumberField(subProperty);
            HashMap<String, Object> bdContentMap = new HashMap<String, Object>();
            bdContentMap.put("type", ((BasedataProp)subProperty).getBaseEntityId());
            bdContentMap.put(NUMBER_FIELD, numberField);
            boolean containNumber = ((BasedataProp)subProperty).getDynamicComplexPropertyType().getProperties().containsKey((Object)numberField);
            ArrayList entrybdvalueList = new ArrayList(entrys.size());
            for (DynamicObject entry : entrys) {
                DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection(entityProperty);
                ArrayList<String[]> subentrybdvalueList = new ArrayList<String[]>(entrys.size());
                if (subEntrys != null && !subEntrys.isEmpty()) {
                    for (DynamicObject subEntry : subEntrys) {
                        DynamicObject bd = (DynamicObject)subEntry.get(subProperty);
                        if (bd != null) {
                            String number = containNumber ? bd.getString(numberField) : "";
                            String[] values = subProperty instanceof ItemClassProp ? new String[]{String.valueOf(bd.getPkValue()), number, bd.getDataEntityType().getName()} : new String[]{String.valueOf(bd.getPkValue()), number};
                            subentrybdvalueList.add(values);
                            continue;
                        }
                        subentrybdvalueList.add(null);
                    }
                }
                entrybdvalueList.add(subentrybdvalueList);
            }
            bdContentMap.put(CONTENT, entrybdvalueList);
            subEntryDataMap.put(subProperty.getName(), bdContentMap);
        }
    }

    private void specialFieldFill(DynamicObject currentObj) {
        if (currentObj != null) {
            String entityName = currentObj.getDynamicObjectType().getName();
            if ("ism_interorgsettlerule".equals(entityName)) {
                if (!currentObj.getDynamicObjectCollection("entryentity").isEmpty()) {
                    currentObj.set("currencysrc", ((DynamicObject)currentObj.getDynamicObjectCollection("entryentity").get(0)).get("currencysource"));
                }
            } else if ("bd_periodoutline_tree".equals(entityName)) {
                currentObj.set("periodyear1", currentObj.get("periodyear"));
            }
        }
    }

    private int doBatchSave(String entityName, List<DynamicObject> saveDy, SdpOutputParams sdpOutputParams, BatchSaveType batchSaveType) {
        int success = 0;
        switch (batchSaveType) {
            case SAVE: {
                success = this.batchSaveByDbSave(entityName, saveDy, sdpOutputParams);
                break;
            }
            case SAVE_OPERATE: {
                success = this.batchSaveBySaveOperate(entityName, saveDy, sdpOutputParams);
                break;
            }
            default: {
                success = this.batchSaveAuto(entityName, saveDy, sdpOutputParams);
            }
        }
        return success;
    }

    private int batchSaveAuto(String entityName, List<DynamicObject> saveDy, SdpOutputParams sdpOutputParams) {
        int success = 0;
        Operations operations = EntityMetadataCache.getDataEntityOperations((String)entityName);
        success = operations.getSave() == null ? this.batchSaveByDbSave(entityName, saveDy, sdpOutputParams) : this.batchSaveBySaveOperate(entityName, saveDy, sdpOutputParams);
        return success;
    }

    private int batchSaveByDbSave(String entityName, List<DynamicObject> saveDy, SdpOutputParams sdpOutputParams) {
        int success = 0;
        try {
            Object[] saveObjects = SaveServiceHelper.save((DynamicObject[])saveDy.toArray(new DynamicObject[0]));
            success = saveObjects.length;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            String error = String.format(ResManager.loadKDString((String)"json\u901a\u8fc7SaveServiceHelper.save()\u65b9\u6cd5\u4fdd\u5b58\u5b9e\u4f53\u6807\u8bc6\u4e3a\u201c%1$s\u201d\u7684\u6570\u636e\u51fa\u73b0\u5f02\u5e38\u3002", (String)"JsonDataPacketImpl_24", (String)"sys-ricc-platform", (Object[])new Object[0]), entityName);
            sdpOutputParams.append(error, e);
        }
        return success;
    }

    private int batchSaveBySaveOperate(String entityName, List<DynamicObject> saveDy, SdpOutputParams sdpOutputParams) {
        String error;
        boolean isConfigItemsOrTree;
        int success = 0;
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        option.setVariableValue("importtag_of_datasource", "true");
        boolean bl = isConfigItemsOrTree = StringUtils.equals((String)"ricc_configitems", (String)entityName) || StringUtils.equals((String)"ricc_configtree", (String)entityName);
        if (isConfigItemsOrTree) {
            option.setVariableValue("ignorenumbeginwithc", "true");
        }
        OperationResult result = new OperationResult();
        result.setSuccess(false);
        try {
            result = SaveServiceHelper.saveOperate((String)entityName, (DynamicObject[])saveDy.toArray(new DynamicObject[0]), (OperateOption)option);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            error = String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u6807\u8bc6\u4e3a\u201c%1$s\u201d\u4fdd\u5b58\u64cd\u4f5c\u6267\u884c\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", (String)"JsonDataPacketImpl_18", (String)"sys-ricc-platform", (Object[])new Object[0]), entityName);
            sdpOutputParams.append(error, e);
        }
        if (!result.isSuccess()) {
            String message = ResManager.loadKDString((String)"\u5b9e\u4f53\u6807\u8bc6\u4e3a\u201c%1$s\u201d\u6570\u636e\u4fdd\u5b58\u64cd\u4f5c\u6267\u884c\u5931\u8d25\uff1a%2$s", (String)"JsonDataPacketImpl_19", (String)"sys-ricc-platform", (Object[])new Object[0]);
            error = String.format(message, entityName, result.getAllErrorOrValidateInfo());
            if (!StringUtils.isEmpty((String)result.getMessage())) {
                error = String.format(message, entityName, result.getMessage() + result.getAllErrorOrValidateInfo());
            }
            sdpOutputParams.append(error);
            sdpOutputParams.append(Character.valueOf('\n'));
        }
        success = result.getSuccessPkIds().size();
        return success;
    }

    protected int batchImport(String entityName, List<Object> ids, JSONObject dataMap, SdpOutputParams outputParams, String keyFields, BatchSaveType batchSaveType) {
        ArrayList<DynamicObject> saveDyList = new ArrayList<DynamicObject>();
        HashSet<String> keyFieldsSet = new HashSet<String>(Arrays.asList(keyFields.trim().replaceFirst(",", "").split(",")));
        ArrayList<String> coverFields = new ArrayList(1);
        if (!StringUtils.isEmpty((String)this.coverInfo)) {
            coverFields = Arrays.asList(this.coverInfo.trim().replaceFirst(",", "").split(","));
        }
        Map<String, DynamicObject> idsMap = this.loadDynamicObject2Map(entityName, dataMap, ids, keyFieldsSet);
        logger.info("json\u5bfc\u5165\u67e5\u5230\u76ee\u6807\u73af\u5883\u6570\u636ekeyset\uff1a{}", idsMap.keySet());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject[] tarDataIdMapArr = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[0]), (DynamicObjectType)entityType);
        Map<Object, DynamicObject> tarDataIdMap = Arrays.stream(tarDataIdMapArr).collect(Collectors.toMap(DataEntityBase::getPkValue, y -> y));
        JsonImportHelper helper = new JsonImportHelper(entityName);
        HashMap<String, DynamicObject> fillSuccessDyo = new HashMap<String, DynamicObject>();
        for (Object id : ids) {
            String msgTpl;
            boolean isNew;
            DynamicObject dyo;
            Map alldata = (Map)dataMap.get(id);
            String key = this.getDataUniqueStr(dataMap, keyFieldsSet, entityType, id);
            DynamicObject idVal = idsMap.get(key);
            DynamicObject dataIdObject = tarDataIdMap.get(id);
            if (idVal != null) {
                dyo = idVal;
                isNew = false;
            } else if (dataIdObject != null) {
                dyo = dataIdObject;
                isNew = false;
            } else {
                dyo = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                dyo.set("id", id);
                isNew = true;
            }
            StringBuilder fieldMsg = JsonDataPacketImpl.builFieldMsg(keyFieldsSet, dyo, alldata);
            boolean isSuccess = false;
            LocaleString displayName = dyo.getDynamicObjectType().getDisplayName();
            try {
                helper.setIsNew(isNew);
                ((Map)dataMap.get(id)).put("keyfieldsValue", key);
                helper.map2DynamicObject(dyo, alldata, dataMap, fillSuccessDyo, coverFields);
                this.specialFieldFill(dyo);
                isSuccess = true;
            }
            catch (RiccBizException e) {
                logger.error((Throwable)e);
                msgTpl = ResManager.loadKDString((String)"\u3010%1$s\u3011(%2$s)\u7684\u5b57\u6bb5\u8d4b\u503c\u51fa\u73b0\u5f02\u5e38 %n", (String)"JsonDataPacketImpl_20", (String)"sys-ricc-platform", (Object[])new Object[0]);
                if (StringUtils.isNotBlank((CharSequence)outputParams.getError())) {
                    outputParams.append(System.lineSeparator());
                }
                outputParams.append(fieldMsg).append(e.getMessage());
            }
            catch (Exception e) {
                logger.error(id + "\u5b57\u6bb5\u8d4b\u503c\u51fa\u73b0\u672a\u68c0\u67e5\u5230\u7684\u5f02\u5e38\uff1a", (Throwable)e);
                msgTpl = ResManager.loadKDString((String)"\u3010%1$s\u3011(%2$s)\u7684\u5b57\u6bb5\u8d4b\u503c\u51fa\u73b0\u672a\u68c0\u67e5\u7684\u5f02\u5e38 %n", (String)"JsonDataPacketImpl_21", (String)"sys-ricc-platform", (Object[])new Object[0]);
                String errorMsg = String.format(msgTpl, displayName, entityName);
                if (StringUtils.isNotBlank((CharSequence)outputParams.getError())) {
                    outputParams.append(System.lineSeparator());
                }
                outputParams.append(fieldMsg).append(e.getMessage());
            }
            if (!isSuccess) continue;
            saveDyList.add(dyo);
            fillSuccessDyo.put(key, dyo);
        }
        return this.doBatchSave(entityName, saveDyList, outputParams, batchSaveType);
    }

    private static StringBuilder builFieldMsg(Set<String> keyFieldsSet, DynamicObject dyo, Map<String, Object> allData) {
        StringBuilder fieldMsg = new StringBuilder();
        Map billMap = (Map)allData.get("data");
        Map bdMap = (Map)allData.get("bd");
        for (String keyField : keyFieldsSet) {
            if (dyo == null || dyo.getDataEntityType().getProperties().get((Object)keyField) == null) continue;
            LocaleString keyName = ((IDataEntityProperty)dyo.getDataEntityType().getProperties().get((Object)keyField)).getDisplayName();
            String keyNameString = "";
            if (keyName != null) {
                keyNameString = keyName.getLocaleValue();
            } else if (StringUtils.equals((String)keyField, (String)"id") && keyName == null) {
                keyNameString = ResManager.loadKDString((String)"\u5185\u7801", (String)"JsonDataPacketImpl_31", (String)"sys-ricc-platform", (Object[])new Object[0]);
            }
            if (!StringUtils.isNotBlank((CharSequence)keyNameString)) continue;
            String value = "";
            if (dyo != null) {
                IDataEntityProperty prop = (IDataEntityProperty)dyo.getDataEntityType().getProperties().get((Object)keyField);
                if (prop instanceof BasedataProp) {
                    List valueList;
                    if (bdMap.get(keyField) != null && CollectionUtils.isNotEmpty((Collection)(valueList = (List)bdMap.get(keyField))) && valueList.size() > 3) {
                        value = (String)valueList.get(3);
                    }
                } else {
                    String string = value = billMap.get(keyField) == null ? "" : String.valueOf(billMap.get(keyField));
                }
            }
            if (StringUtils.isBlank((CharSequence)value)) {
                value = "";
            }
            if (StringUtils.isNotBlank((CharSequence)fieldMsg)) {
                fieldMsg.append("+").append(keyNameString).append("\u3010").append(value).append("\u3011");
                continue;
            }
            fieldMsg.append(keyNameString).append("\u3010").append(value).append("\u3011");
        }
        if (StringUtils.isBlank((CharSequence)fieldMsg)) {
            fieldMsg.append(ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u672a\u53d6\u5230\u552f\u4e00\u952e\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u9879\u4fe1\u606f\u3002", (String)"JsonDataPacketImpl_30", (String)"sys-ricc-platform", (Object[])new Object[0]));
        } else {
            fieldMsg.append(":");
        }
        return fieldMsg;
    }

    private String getDataUniqueStr(JSONObject dataMap, Set<String> keyFieldsSet, MainEntityType entityType, Object id) {
        StringBuilder srcKey = new StringBuilder();
        JSONObject allData = dataMap.getJSONObject(id.toString());
        JSONObject bdObject = allData.getJSONObject("bd");
        JSONObject dataObject = allData.getJSONObject("data");
        for (String key : keyFieldsSet) {
            IDataEntityProperty property = (IDataEntityProperty)entityType.getProperties().get((Object)key);
            if (property instanceof BasedataProp) {
                JSONArray jsonArray = bdObject.getJSONArray(key);
                if (jsonArray == null || jsonArray.isEmpty()) continue;
                srcKey.append(jsonArray.toArray()[NUMBER_VAL_INDEX]);
                continue;
            }
            if (property instanceof MuliLangTextProp) {
                JSONObject jsonObject = dataObject.getJSONObject(key);
                if (jsonObject == null) continue;
                srcKey.append(jsonObject.get((Object)"zh_CN"));
                continue;
            }
            srcKey.append(dataObject.get((Object)key));
        }
        return srcKey.toString();
    }

    private Map<String, DynamicObject> loadDynamicObject2Map(String entityName, JSONObject dataMap, List<Object> ids, Set<String> keyFieldsSet) {
        Set<IDataEntityProperty> queryKeyProps = this.getQueryKeyProps(entityName, keyFieldsSet);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        QFilter filter = this.getKeyFieldFilter(dataMap, ids, queryKeyProps);
        HashMap<String, DynamicObject> idsMap = new HashMap<String, DynamicObject>(4);
        if (filter != null) {
            DynamicObject[] dynamicObjects;
            List pks = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filter.toArray(), null, (int)-1);
            for (DynamicObject dy : dynamicObjects = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName))) {
                StringBuilder tarKey = new StringBuilder();
                for (String key : keyFieldsSet) {
                    IDataEntityProperty property = (IDataEntityProperty)entityType.getProperties().get((Object)key);
                    if (property instanceof BasedataProp) {
                        tarKey.append(((DynamicObject)dy.get(key)).get("number"));
                    } else if (property instanceof MuliLangTextProp) {
                        tarKey.append(((Map)dy.get(key)).get("zh_CN"));
                    } else {
                        tarKey.append(dy.getString(key));
                    }
                    idsMap.put(tarKey.toString(), dy);
                }
            }
        }
        return idsMap;
    }

    private QFilter getKeyFieldFilter(JSONObject dataMap, List<Object> ids, Set<IDataEntityProperty> queryKeyProps) {
        QFilter filter = null;
        for (IDataEntityProperty prop : queryKeyProps) {
            HashSet<Object> valueSet = new HashSet<Object>(4);
            for (Object id : ids) {
                Object keyFieldValue = this.getPropValueFromDataMap(id.toString(), prop, dataMap);
                if (!Objects.nonNull(keyFieldValue)) continue;
                valueSet.add(keyFieldValue);
            }
            String propName = prop.getName();
            if (prop instanceof BasedataProp) {
                propName = prop.getName() + ".number";
            }
            if (filter == null) {
                filter = new QFilter(propName, "in", valueSet);
                continue;
            }
            filter.and(new QFilter(propName, "in", valueSet));
        }
        return filter;
    }

    private Set<IDataEntityProperty> getQueryKeyProps(String entityName, Set<String> keyFieldsSet) {
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)entityName).getProperties();
        HashSet<IDataEntityProperty> queryKeyProps = new HashSet<IDataEntityProperty>(4);
        for (IDataEntityProperty property : properties) {
            for (String keyField : keyFieldsSet) {
                if (!property.getName().equals(keyField)) continue;
                queryKeyProps.add(property);
            }
        }
        return queryKeyProps;
    }

    private Object getPropValueFromDataMap(String id, IDataEntityProperty prop, JSONObject dataMap) {
        Object keyFiledValue = null;
        String name = prop.getName();
        JSONObject bdObject = dataMap.getJSONObject(id).getJSONObject("bd");
        JSONObject dataObject = dataMap.getJSONObject(id).getJSONObject("data");
        if (prop instanceof MuliLangTextProp) {
            JSONObject jsonObject = dataObject.getJSONObject(name);
            if (jsonObject != null) {
                keyFiledValue = jsonObject.get((Object)"zh_CN");
            }
        } else if (prop instanceof BasedataProp) {
            JSONArray jsonArray = bdObject.getJSONArray(name);
            if (jsonArray != null && !jsonArray.isEmpty()) {
                keyFiledValue = jsonArray.toArray()[NUMBER_VAL_INDEX];
            }
        } else {
            keyFiledValue = dataObject.get((Object)name);
        }
        return keyFiledValue;
    }

    private TXHandle getImportTransaction() {
        Propagation importTransactionType = this.getImportTransactionType();
        TXHandle txHandle = null;
        switch (importTransactionType) {
            case REQUIRES_NEW: {
                txHandle = TX.requiresNew();
                break;
            }
            case REQUIRED: {
                txHandle = TX.required();
                break;
            }
            case NESTED: {
                txHandle = TX.nested();
                break;
            }
            default: {
                txHandle = TX.notSupported();
            }
        }
        return txHandle;
    }

    protected void beforeImportPacket(SdpInputParams sdpInputParams, SdpOutputParams sdpOutputParams) {
        sdpOutputParams.setSuccess(true);
    }

    protected void beforeConvertToMap(DynamicObject[] batchData) {
    }

    protected void afterBatchExport(DynamicObject[] batchData, Map<String, Object> batchContentMap) {
    }

    protected void beforeBatchImport(List<Object> idList, JSONObject dataMap, SdpOutputParams outputParams) {
    }

    protected void afterBatchImport(List<Object> idList, JSONObject dataMap, SdpOutputParams outputParams) {
    }

    protected void afterBatchImportForSpecial(List<Object> idList, JSONObject dataMap, SdpOutputParams outputParams) {
    }

    protected String getEntityNumber(Map<String, Object> customParam) {
        return (String)customParam.get("entitynumber");
    }

    protected String getKeyFields() {
        return "";
    }

    protected int getExportBatchSize() {
        return 1000;
    }

    protected int getImportBatchSize() {
        return 3000;
    }

    protected Propagation getImportTransactionType() {
        return TX.getPropagation();
    }

    protected BatchSaveType getBatchSaveType() {
        return BatchSaveType.AUTO;
    }

    @Override
    public Map<String, Object> provideData(Map<String, Object> params) {
        return ConfigItemHelper.generalProvideDataImpl(params);
    }

    @Override
    public Map<String, Object> parseUrlData(Map<String, Object> params) {
        logger.info("fileUrl:{}", params.get("fileUrl"));
        logger.info("itemId:{}", params.get("itemId"));
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        if (!params.containsKey("fileUrl") || StringUtils.isBlank((Object)params.get("fileUrl"))) {
            resultMap.put("success", false);
            resultMap.put("errMessage", ResManager.loadKDString((String)"fileUrl\u4e3a\u7a7a", (String)"JsonDataPacketImpl_32", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return resultMap;
        }
        if (!params.containsKey("itemId") || StringUtils.isBlank((Object)params.get("itemId"))) {
            resultMap.put("success", false);
            resultMap.put("errMessage", ResManager.loadKDString((String)"itemId\u4e3a\u7a7a", (String)"JsonDataPacketImpl_33", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return resultMap;
        }
        String fileUrl = (String)params.get("fileUrl");
        Long configItemId = (Long)params.get("itemId");
        try {
            List<Map<String, Object>> data = JsonResolveHelper.resolveJsonFile(fileUrl, configItemId);
            HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
            String keyFields = ConfigItemHelper.buildKeyFields(configItemId);
            dataMap.put("selectCount", data.size());
            dataMap.put("selectDatas", data);
            dataMap.put("keyFields", keyFields);
            resultMap.put("data", dataMap);
            resultMap.put("success", true);
        }
        catch (Exception e) {
            resultMap.put("success", false);
            resultMap.put("errMessage", e.getMessage());
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> compareData(Map<String, Object> params) {
        return DataCompareHelper.generalCompareDataImpl(params);
    }

    public static enum BatchSaveType {
        AUTO,
        SAVE,
        SAVE_OPERATE;

    }
}

