/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.download;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.common.enums.PacketLockEnum;
import kd.sys.ricc.common.util.TimeCostUtil;
import kd.sys.ricc.exception.RiccBizException;

public class DataPackageDownLoadBusiness {
    public static void afterDownload(List<Object> packetPks) {
        DynamicObject[] needAddCountDataPackets;
        MainEntityType datapacketType = EntityMetadataCache.getDataEntityType((String)"ricc_datapacket");
        for (DynamicObject needAddCountDataPacket : needAddCountDataPackets = BusinessDataServiceHelper.load((Object[])packetPks.toArray(), (DynamicObjectType)datapacketType)) {
            needAddCountDataPacket.set("dltrcount", (Object)(needAddCountDataPacket.getInt("dltrcount") + 1));
            String status = needAddCountDataPacket.getString("status");
            if (!StringUtils.equals((CharSequence)status, (CharSequence)"C")) continue;
            needAddCountDataPacket.set("lockedstatus", (Object)PacketLockEnum.IS_LOCKED.getVal());
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("downloadAndTransfer", Boolean.TRUE.toString());
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)"ricc_datapacket", (DynamicObject[])needAddCountDataPackets, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            String msgTpl = ResManager.loadKDString((String)"\u4e0b\u8f7d\u6b21\u6570\u589e\u52a0\u5931\u8d25\uff01%s", (String)"CommonUtil_31", (String)"sys-ricc-common", (Object[])new Object[0]);
            throw new RiccBizException(String.format(msgTpl, operationResult.getAllErrorInfo().toString()));
        }
    }

    public static void recordLog(long packetId, String msg, long opTime, boolean isSuccess) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"ricc_log");
        log.set("id", (Object)DB.genLongId((String)"ricc_log"));
        String logNumber = CodeRuleServiceHelper.getNumber((String)"ricc_log", (DynamicObject)log, null);
        log.set("billno", (Object)logNumber);
        log.set("packet", (Object)packetId);
        log.set("opuser", (Object)UserServiceHelper.getCurrentUserId());
        log.set("optime", (Object)opTime);
        long opEndTime = System.currentTimeMillis();
        log.set("opendtime", (Object)opEndTime);
        String timeCost = TimeCostUtil.getUsedTime((long)opTime, (long)opEndTime);
        log.set("usetime", (Object)timeCost);
        log.set("optype", (Object)"7");
        if (isSuccess) {
            msg = ResManager.loadKDString((String)"\u4e0b\u8f7d\u6210\u529f\u3002", (String)"DataPacketDownLoader_6", (String)"sys-ricc-platform", (Object[])new Object[0]);
            log.set("state", (Object)"1");
            log.set("successcount", (Object)1);
            log.set("failedcount", (Object)0);
        } else {
            log.set("state", (Object)"2");
            log.set("successcount", (Object)0);
            log.set("failedcount", (Object)1);
        }
        log.set("message", (Object)(msg.length() > 255 ? msg.substring(0, 200) + "..." : msg));
        log.set("message_tag", (Object)msg);
        log.set("traceid", (Object)RequestContext.get().getTraceId());
        OperateOption option = OperateOption.create();
        SaveServiceHelper.saveOperate((String)"ricc_log", (DynamicObject[])new DynamicObject[]{log}, (OperateOption)option);
    }
}

