/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.schedule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.FormView;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.sys.ricc.business.datapacket.schedule.AddDataPacketTask;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.datapacket.schedule.AddTaskClick;
import kd.sys.ricc.business.impt.ImportParamAdapter;
import kd.sys.ricc.business.log.LogRecorder;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.business.schedule.TaskHandler;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.enums.PackMode;
import kd.sys.ricc.common.util.StringUtils;

public class BatchPackTaskHandler
implements Callable<Object> {
    private final CopyOnWriteArrayList<JSONObject> configItems;
    private final AddPacketProgress allProgress;
    private boolean done;
    private final JSONObject packet;
    private AtomicInteger completeCount;
    private AtomicInteger successCount;
    private final int total;
    private final Object lock = new Object();
    private LogRecorder errMsg = new LogRecorder();

    public BatchPackTaskHandler(JSONArray configItems, AddPacketProgress allProgress, JSONObject packet) {
        this.configItems = new CopyOnWriteArrayList(configItems.toJavaList(JSONObject.class));
        this.allProgress = allProgress;
        this.packet = packet;
        this.total = configItems.size();
    }

    public void feedOnceProgress(boolean success) {
        if (success) {
            this.getSuccessCount().incrementAndGet();
        }
        this.allProgress.feedbackProgress(this.total, this.getCompleteCount().addAndGet(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() {
        while (!this.isDone()) {
            JSONObject config = null;
            Object object = this.lock;
            synchronized (object) {
                if (this.configItems.isEmpty()) {
                    this.setDone(true);
                    return null;
                }
                config = this.configItems.remove(0);
            }
            if (config == null) continue;
            String importType = config.getString("importtype");
            String pageEnterParam = config.getString("pageenterparam");
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("seq", config.get((Object)"seq"));
            params.put("guideId", config.get((Object)"id"));
            params.put("formId", config.getString("formid"));
            String pageType = config.getString("pagetype");
            if ("custom".equals(pageType)) {
                pageType = config.getString("custompage");
            }
            params.put("pagetype", pageType);
            params.put("filters", config.get((Object)"filters"));
            params.put("packettype", DataPacketTypeEnum.CONFIG.getVal());
            params.put("selectedPacket", this.packet);
            params.put("importtype", importType);
            params.put("packmode", PackMode.ONE_KEY_PACK.getValue());
            String appId = FormMetadataCache.getFormAppId((String)config.getString("formid"));
            params.put("appId", appId);
            LogRecorder result = null;
            try {
                FormView view = (FormView)BatchPackTaskHandler.createFormView(config.getString("formid"), pageType, importType);
                if (view != null) {
                    params.put("parentPageId", view.getPageId());
                }
                result = BatchPackTaskHandler.excuteAddDataPacketTask(params, view);
            }
            catch (Exception e) {
                result = new LogRecorder().append(e.getMessage(), e);
            }
            if (result != null) {
                this.getErrMsg().append(String.format(ResManager.loadKDString((String)"%n\u3010%1$s\u3011\u5bfc\u51fa\u53d1\u751f\u5f02\u5e38\uff1a%2$s", (String)"BatchPackTaskHandler_0", (String)"sys-ricc-platform", (Object[])new Object[0]), config.getString("name"), result.getMessageStr()));
                if (!StringUtils.isEmpty((String)result.getDevMessageStr())) {
                    this.getErrMsg().appendDev(String.format(ResManager.loadKDString((String)"%n\u3010%1$s\u3011\u5bfc\u51fa\u53d1\u751f\u5f02\u5e38\uff1a%2$s", (String)"BatchPackTaskHandler_0", (String)"sys-ricc-platform", (Object[])new Object[0]), config.getString("name"), result.getDevMessageStr()));
                }
                this.feedOnceProgress(false);
                continue;
            }
            this.feedOnceProgress(true);
        }
        return null;
    }

    public AtomicInteger getCompleteCount() {
        if (this.completeCount == null) {
            this.completeCount = new AtomicInteger(0);
        }
        return this.completeCount;
    }

    private void setCompleteCount(AtomicInteger completeCount) {
        this.completeCount = completeCount;
    }

    public AtomicInteger getSuccessCount() {
        if (this.successCount == null) {
            this.successCount = new AtomicInteger(0);
        }
        return this.successCount;
    }

    public int getTotal() {
        return this.total;
    }

    public LogRecorder getErrMsg() {
        return this.errMsg;
    }

    public void setSuccessCount(AtomicInteger successCount) {
        this.successCount = successCount;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    private static LogRecorder excuteAddDataPacketTask(Map<String, Object> param, FormView view) {
        Object failMessage;
        Map data;
        LogRecorder logRecorder = null;
        JobFormInfo jobFormInfo = ScheduleUtil.buildJobFormInfo(ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305", (String)"BatchPackTaskHandler_1", (String)"sys-ricc-platform", (Object[])new Object[0]), AddDataPacketTask.class.getName(), AddTaskClick.class.getName(), (IFormView)view, param);
        jobFormInfo.getJobInfo().setAppId("ricc");
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        new TaskHandler(taskId, null).wait2End();
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo.isFailure()) {
            logRecorder = new LogRecorder().append(taskInfo.getFailureReason());
        }
        if ((data = (Map)SerializationUtils.fromJsonString((String)(taskInfo.getData() == null ? "{}" : taskInfo.getData()), Map.class)) != null && (failMessage = data.get("failmessage")) != null) {
            try {
                logRecorder = (LogRecorder)SerializationUtils.fromJsonString((String)((String)failMessage), LogRecorder.class);
            }
            catch (Exception e) {
                logRecorder = new LogRecorder().append((String)failMessage, e);
            }
        }
        return logRecorder;
    }

    private static IFormView createFormView(String formId, String pageType, String importType) {
        if (!"excel".equals(importType)) {
            return null;
        }
        FormShowParameter showParameter = ImportParamAdapter.createFormShowParameter4Import(formId, pageType);
        BatchPackTaskHandler.invokeFormServiceMethod(formId, showParameter);
        return SessionManager.getCurrent().getViewNoPlugin(showParameter.getPageId());
    }

    private static void invokeFormServiceMethod(String formId, FormShowParameter parameter) {
        FormConfigFactory.createConfig((FormShowParameter)parameter);
        DispatchServiceHelper.invokeBOSServiceByFormId((String)formId, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{parameter.getPageId(), "[{\"key\":\"\",\"methodName\":\"loadData\",\"args\":[],\"postData\":[]}]"});
    }
}

