/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.upload;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sys.ricc.business.datapacket.upload.DataPackageUploader;
import kd.sys.ricc.common.enums.PacketDataSourceTypeEnum;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;

public class DataPackageUploadBusiness {
    private static final Log logger = LogFactory.getLog(DataPackageUploadBusiness.class);
    private static final String STORAGE_PATH = SysParaUtil.getSavePath();

    private DataPackageUploadBusiness() {
        throw new IllegalStateException("Utility class");
    }

    public static String packageCheck(AttachmentPanel attachmentPanel, List<Map<String, Object>> list) {
        for (Map<String, Object> map : list) {
            String url = (String)map.get("url");
            DataPackageUploader uploader = new DataPackageUploader(url);
            uploader.setDatasourceType(PacketDataSourceTypeEnum.DATASOURCE_UPLOAD);
            uploader.doUpload();
            if (!uploader.isSuccess()) {
                return uploader.getMsg();
            }
            attachmentPanel.remove(map);
        }
        return null;
    }

    public static void processCopySubPacket(long id, String packetNumber, DynamicObjectCollection subPackets) throws IOException {
        FileService fs = FileServiceFactory.getAttachmentFileService();
        String uploadPath = STORAGE_PATH + packetNumber + File.separator;
        ArrayList<Map> attachments = new ArrayList<Map>();
        logger.info("\u5f00\u59cb\u590d\u5236\u5206\u5f55\u6587\u4ef6\uff0c\u5171" + subPackets.size() + "\u4e2a");
        for (DynamicObject subPacket : subPackets) {
            String fileName = subPacket.getString("filename");
            DynamicObject file = (DynamicObject)subPacket.getDynamicObjectCollection("subdatapacketfile").get(0);
            DynamicObject fileObject = file.getDynamicObject("fbasedataid");
            String fileUrl = CommonUtil.checkUrl((String)fileObject.getString("url"));
            TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>(queryParams.length);
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
            long size = fileObject.getLong("size");
            String type = fileObject.getString("type");
            try {
                InputStream inputStream = content.getInputStream();
                Throwable throwable = null;
                try {
                    FileItem fileItem = new FileItem(fileName, uploadPath + fileName, inputStream);
                    String url = DataPackageUploadBusiness.uploadToFileService(fs, fileItem);
                    Map uploadFileMap = CommonUtil.createUploadFileMap((String)"ricc_datapacket", (Object)id, (String)"subdatapacketfile", (String)url, (String)fileName, (long)size, (String)type);
                    attachments.add(uploadFileMap);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Exception e) {
                logger.error("\u590d\u5236\u6587\u4ef6\u5931\u8d25\u3002", (Throwable)e);
                attachments.forEach(att -> fs.delete((String)att.get("url")));
                throw e;
            }
        }
        List attList = AttachmentFieldServiceHelper.saveAttachments((String)"ricc_datapacket", (String)"", attachments);
        Map<String, String> filenameAttId = DataPackageUploadBusiness.attListToNameIdMap(attList);
        for (DynamicObject subPacket : subPackets) {
            String fileName = subPacket.getString("filename");
            DynamicObjectType type = subPacket.getDynamicObjectCollection("subdatapacketfile").getDynamicObjectType();
            long fileAttId = Long.parseLong(filenameAttId.get(fileName));
            MulBasedataDynamicObjectCollection fileList = CommonUtil.createAttachmentField((DynamicObjectType)type, (long)fileAttId);
            subPacket.set("entrycreatetime", (Object)System.currentTimeMillis());
            subPacket.set("entryupdatetime", (Object)System.currentTimeMillis());
            subPacket.set("entrysyncstate", (Object)"");
            subPacket.set("subdatapacketfile", (Object)fileList);
        }
    }

    public static String uploadToFileService(FileService fs, FileItem fileItem) {
        try {
            String string = fs.upload(fileItem);
            return string;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u5931\u8d25!", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\u3002", (String)"DataPackageUploadUtil_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
            throw new RiccBizException(msg, (Throwable)e);
        }
        finally {
            fileItem.close();
        }
    }

    public static Map<String, String> attListToNameIdMap(List<DynamicObject> attList) {
        HashMap<String, String> filenameAttId = new HashMap<String, String>(attList.size());
        for (DynamicObject dyo : attList) {
            filenameAttId.put(dyo.getString("name"), dyo.getString("id"));
            dyo.set("tempfile", (Object)1);
        }
        SaveServiceHelper.save((DynamicObject[])attList.toArray(new DynamicObject[0]));
        return filenameAttId;
    }
}

