/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.impt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sys.ricc.business.datapacket.core.impl.json.JsonImportHelper;
import kd.sys.ricc.common.util.DynamicObjectUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.setter.D;

public class JsonResolveHelper {
    private static final Log logger = LogFactory.getLog(JsonResolveHelper.class);
    private static final String FILE_SUFFEX_JSON = ".json";
    private static final String ZIP = ".zip";
    public static final String MAIN_ORG = "mainOrg";
    public static final String NUMBER_FIELD = "numberField";
    public static final Integer NUMBER_VAL_INDEX = 3;
    private static final String ID = "id";
    private static final String ENTRYID = "entryid";
    private static final String MASTERID = "masterid";
    private static final String BASEDATA_ID_PROP_SUFFIX = "_id";
    private static final String CONTENT = "content";
    private static final Map<String, Map<String, DynamicObject>> bdCaches = new HashMap<String, Map<String, DynamicObject>>(8);

    public static List<Map<String, Object>> resolveJsonFile(String fileUrl, Long configItemId) throws KDException {
        LinkedList<Map<String, Object>> dataList;
        block45: {
            String fileName = FileUtils.getFileNameFromPath((String)fileUrl);
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            dataList = new LinkedList<Map<String, Object>>();
            DynamicObject configItemObj = BusinessDataServiceHelper.loadSingleFromCache((Object)configItemId, (String)"ricc_configitems");
            if (fileName.endsWith(FILE_SUFFEX_JSON)) {
                try (InputStream in = fileService.getInputStream(fileUrl);){
                    List<DynamicObject> datas = JsonResolveHelper.buildDynamicObject(in, configItemObj);
                    for (DynamicObject object : datas) {
                        Map<String, Object> compareRequiresPropMap = JsonResolveHelper.getCompareRequiresPropMap(object.getDataEntityType().getProperties());
                        dataList.add(DynamicObjectUtil.object2Map((DynamicObject)object, compareRequiresPropMap));
                    }
                    break block45;
                }
                catch (Exception e) {
                    throw new KDException(e.getMessage());
                }
            }
            if (fileName.endsWith(ZIP)) {
                try (InputStream in = fileService.getInputStream(fileUrl);
                     ZipInputStream zipInputStream = new ZipInputStream(in);){
                    ZipEntry nextEntry;
                    while ((nextEntry = zipInputStream.getNextEntry()) != null) {
                        String name = nextEntry.getName();
                        if (name.endsWith("_attach.json") || name.equals("attach/")) continue;
                        List<DynamicObject> datas = JsonResolveHelper.buildDynamicObject(zipInputStream, configItemObj);
                        for (DynamicObject object : datas) {
                            Map<String, Object> compareRequiresPropMap = JsonResolveHelper.getCompareRequiresPropMap(object.getDataEntityType().getProperties());
                            dataList.add(DynamicObjectUtil.object2Map((DynamicObject)object, compareRequiresPropMap));
                        }
                    }
                    break block45;
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                    throw new KDException(e.getMessage());
                }
            }
            String msgTpl = ResManager.loadKDString((String)"\u6587\u4ef6\u201c%s\u201d\u65e0\u6cd5\u8bc6\u522b\u4e3ajson\u6216\u8005zip\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u6253\u5305\u8fdb\u884c\u4f20\u8f93\u540c\u6b65\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406\u3002", (String)"JsonResolveHelper_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
            throw new KDException(msgTpl);
        }
        return dataList;
    }

    private static List<DynamicObject> buildDynamicObject(InputStream in, DynamicObject configItemObj) {
        String resStr = FileUtils.inputStreamToString((InputStream)in);
        JSONObject dataMap = (JSONObject)JSON.parseObject((String)resStr, (TypeReference)new TypeReference<JSONObject>(){}, (Feature[])new Feature[]{Feature.OrderedField});
        if (dataMap.containsKey((Object)"entityType") && dataMap.get((Object)"entityType") != null) {
            dataMap.remove((Object)"entityType");
        } else {
            logger.error("\u6587\u4ef6%s\u4e2d\u6ca1\u6709\u83b7\u53d6\u5230\u5b9e\u4f53\u7c7b\u578bentityType\uff0c\u8bf7\u68c0\u67e5\u5305\u6587\u4ef6\u662f\u5426\u88ab\u7be1\u6539\u6216\u5185\u5bb9\u635f\u574f", (Object)"JsonDataPacketImpl_11", (Object)"sys-ricc-platform");
        }
        String entityName = configItemObj.getDynamicObject("page").getString("number");
        Set idSet = dataMap.keySet();
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(idSet.size());
        for (Object id : idSet) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            obj.set(ID, JsonImportHelper.idCovert(entityName, id));
            Map alldata = (Map)dataMap.get(id);
            JsonResolveHelper.map2DynamicObject(obj, alldata, dataMap, entityName);
            objects.add(obj);
        }
        return objects;
    }

    private static QFilter getKeyFieldFilter(JSONObject dataMap, List<Object> ids, Set<IDataEntityProperty> queryKeyProps) {
        QFilter filter = null;
        for (IDataEntityProperty prop : queryKeyProps) {
            HashSet<Object> valueSet = new HashSet<Object>(4);
            for (Object id : ids) {
                Object keyFieldValue = JsonResolveHelper.getPropValueFromDataMap(id.toString(), prop, dataMap);
                if (!Objects.nonNull(keyFieldValue)) continue;
                valueSet.add(keyFieldValue);
            }
            String propName = prop.getName();
            if (prop instanceof BasedataProp) {
                propName = prop.getName() + ".number";
            }
            if (filter == null) {
                filter = new QFilter(propName, "in", valueSet);
                continue;
            }
            filter.and(new QFilter(propName, "in", valueSet));
        }
        return filter;
    }

    private static Set<IDataEntityProperty> getQueryKeyProps(String entityName, Set<String> keyFieldsSet) {
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)entityName).getProperties();
        HashSet<IDataEntityProperty> queryKeyProps = new HashSet<IDataEntityProperty>(4);
        for (IDataEntityProperty property : properties) {
            for (String keyField : keyFieldsSet) {
                if (!property.getName().equals(keyField)) continue;
                queryKeyProps.add(property);
            }
        }
        return queryKeyProps;
    }

    private static Object getPropValueFromDataMap(String id, IDataEntityProperty prop, JSONObject dataMap) {
        Object keyFiledValue = null;
        String name = prop.getName();
        JSONObject bdObject = dataMap.getJSONObject(id).getJSONObject("bd");
        JSONObject dataObject = dataMap.getJSONObject(id).getJSONObject("data");
        if (prop instanceof MuliLangTextProp) {
            JSONObject jsonObject = dataObject.getJSONObject(name);
            if (jsonObject != null) {
                keyFiledValue = jsonObject.get((Object)RequestContext.get().getLang().name());
            }
        } else if (prop instanceof BasedataProp) {
            JSONArray jsonArray = bdObject.getJSONArray(name);
            if (jsonArray != null && !jsonArray.isEmpty()) {
                keyFiledValue = jsonArray.toArray()[NUMBER_VAL_INDEX];
            }
        } else {
            keyFiledValue = dataObject.get((Object)name);
        }
        return keyFiledValue;
    }

    private static Map<String, DynamicObject> loadDynamicObject2Map(String entityName, JSONObject dataMap, List<Object> ids, Set<String> keyFieldsSet) {
        Set<IDataEntityProperty> queryKeyProps = JsonResolveHelper.getQueryKeyProps(entityName, keyFieldsSet);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        QFilter filter = JsonResolveHelper.getKeyFieldFilter(dataMap, ids, queryKeyProps);
        HashMap<String, DynamicObject> idsMap = new HashMap<String, DynamicObject>(4);
        if (filter != null) {
            DynamicObject[] dynamicObjects;
            List pks = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filter.toArray(), null, (int)-1);
            for (DynamicObject dy : dynamicObjects = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName))) {
                StringBuilder tarKey = new StringBuilder();
                for (String key : keyFieldsSet) {
                    IDataEntityProperty property = (IDataEntityProperty)entityType.getProperties().get((Object)key);
                    if (property instanceof BasedataProp) {
                        tarKey.append(((DynamicObject)dy.get(key)).get("number"));
                        continue;
                    }
                    if (property instanceof MuliLangTextProp) {
                        tarKey.append(((Map)dy.get(key)).get(RequestContext.get().getLang().name()));
                        continue;
                    }
                    tarKey.append(dy.getString(key));
                }
                idsMap.put(tarKey.toString(), dy);
            }
        }
        return idsMap;
    }

    private static Map<String, Object> getCompareRequiresPropMap(DataEntityPropertyCollection properties) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>(4);
        for (IDataEntityProperty property : properties) {
            String numberProp;
            String propertyKey = property.getName();
            if (property instanceof FlexProp) {
                propertyMap.put(propertyKey, "");
                continue;
            }
            if (property instanceof DynamicLocaleProperty || property instanceof AttachmentProp) continue;
            if (property instanceof BasedataProp) {
                HashMap<String, String> baseDataMap = new HashMap<String, String>(4);
                numberProp = ((BasedataProp)property).getNumberProp();
                baseDataMap.put(numberProp, "");
                baseDataMap.put("name", "");
                baseDataMap.put(ID, "");
                propertyMap.put(propertyKey, baseDataMap);
                continue;
            }
            if (property instanceof MulBasedataProp) {
                HashMap<String, String> mulBaseDataMap = new HashMap<String, String>(4);
                numberProp = ((MulBasedataProp)property).getNumberProp();
                mulBaseDataMap.put(numberProp, "");
                mulBaseDataMap.put("name", "");
                propertyMap.put(propertyKey, mulBaseDataMap);
                continue;
            }
            if (property instanceof EntryProp) {
                DataEntityPropertyCollection entryProperties = ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperties();
                Map<String, Object> entryMap = JsonResolveHelper.getCompareRequiresPropMap(entryProperties);
                propertyMap.put(propertyKey, entryMap);
                continue;
            }
            propertyMap.put(propertyKey, "");
        }
        return propertyMap;
    }

    private static void map2DynamicObject(DynamicObject currentObj, Map<String, Object> alldata, JSONObject dataMap, String entityNumber) {
        Map billMap = (Map)alldata.get("data");
        Map bdMap = (Map)alldata.get("bd");
        if (currentObj != null && billMap != null) {
            billMap.remove("$pk");
            billMap.remove("$id");
            DataEntityPropertyCollection properties = currentObj.getDataEntityType().getProperties();
            for (Map.Entry entry : billMap.entrySet()) {
                Object bdValInfo;
                String key = (String)entry.getKey();
                IDataEntityProperty prop = JsonResolveHelper.getProperty(properties, key);
                if (prop == null) continue;
                if (prop.getName().equals(ID) || prop.getName().equals(MASTERID)) {
                    currentObj.set(prop, JsonResolveHelper.idCovert(entityNumber, entry.getValue()));
                    continue;
                }
                if (prop instanceof BasedataProp) {
                    bdValInfo = bdMap.get(prop.getName());
                    if (prop instanceof CreaterProp) {
                        JsonResolveHelper.setBillCreatorObjVal(currentObj, (List)bdValInfo, (BasedataProp)prop, dataMap);
                        continue;
                    }
                    if (prop instanceof ModifierProp) continue;
                    JsonResolveHelper.setBaseDataObjVal(currentObj, (List)bdValInfo, (BasedataProp)prop, dataMap);
                    continue;
                }
                if (prop instanceof MulBasedataProp && !(prop instanceof AttachmentProp)) {
                    bdValInfo = bdMap.get(prop.getName());
                    JsonResolveHelper.setMultiBaseDataObjVal(currentObj, bdValInfo, prop, dataMap);
                    continue;
                }
                if (prop instanceof DateTimeProp) {
                    if (prop instanceof CreateDateProp) {
                        JsonResolveHelper.setBillCreateDateVal(currentObj, entry.getValue(), prop);
                        continue;
                    }
                    if (prop instanceof ModifyDateProp) continue;
                    currentObj.set(prop, (Object)D.t(entry.getValue()));
                    continue;
                }
                if (prop instanceof DecimalProp) {
                    currentObj.set(prop, (Object)D.n(entry.getValue()));
                    continue;
                }
                if (prop instanceof BooleanProp) {
                    currentObj.set(prop, (Object)D.x(entry.getValue()));
                    continue;
                }
                if (prop instanceof EntryProp) {
                    JsonResolveHelper.map2Entry(currentObj, alldata, billMap, key, dataMap, entityNumber);
                    continue;
                }
                currentObj.set(prop, entry.getValue());
            }
        }
    }

    private static void setMultiBaseDataObjVal(DynamicObject currentObj, Object bdValInfo, IDataEntityProperty prop, JSONObject dataMap) {
        if (bdValInfo != null) {
            Map bdValueMap = (Map)bdValInfo;
            String basedataEntityNumber = (String)bdValueMap.get("type");
            String numberField = (String)bdValueMap.get(NUMBER_FIELD);
            JSONArray arrays = (JSONArray)JSON.toJSON(bdValueMap.get(CONTENT));
            DynamicObjectCollection basedatas = currentObj.getDynamicObjectCollection(prop);
            basedatas.clear();
            for (int i = 0; i < arrays.size(); ++i) {
                JSONArray value = arrays.getJSONArray(i);
                String numberVal = value.getString(1);
                DynamicObject bd = JsonResolveHelper.getBdFromFilter(basedataEntityNumber, numberField, value.getString(0), numberVal, dataMap);
                if (bd == null) continue;
                DynamicObject newRow = new DynamicObject(basedatas.getDynamicObjectType());
                newRow.set("fbasedataid", (Object)bd);
                basedatas.add((Object)newRow);
            }
        }
    }

    private static IDataEntityProperty getProperty(DataEntityPropertyCollection properties, String propkey) {
        String bdKey;
        IDataEntityProperty bdProp;
        IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)propkey);
        if (propkey.endsWith(BASEDATA_ID_PROP_SUFFIX) && (bdProp = (IDataEntityProperty)properties.get((Object)(bdKey = propkey.substring(0, propkey.lastIndexOf(BASEDATA_ID_PROP_SUFFIX))))) != null) {
            prop = bdProp;
        }
        return prop;
    }

    private static Object idCovert(String entityName, Object id) {
        if ("sch_job".equals(entityName) || "sch_schedule".equals(entityName) || "bos_entityobject".equals(entityName) || "sch_taskdefine".equals(entityName)) {
            return id;
        }
        try {
            id = Long.parseLong(id.toString());
        }
        catch (NumberFormatException e) {
            logger.error("idCovert\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return id;
        }
        return id;
    }

    private static void setBillCreatorObjVal(DynamicObject currentObj, List<String> bdValInfo, BasedataProp prop, JSONObject dataMap) {
        DynamicObject user;
        if (bdValInfo != null && !bdValInfo.isEmpty() && (user = JsonResolveHelper.getBdFromFilter(bdValInfo.get(0), bdValInfo.get(1), bdValInfo.get(2), bdValInfo.get(3), dataMap)) != null) {
            currentObj.set((IDataEntityProperty)prop, (Object)user);
            currentObj.set(prop.getName() + BASEDATA_ID_PROP_SUFFIX, user.getPkValue());
        }
    }

    private static void setBillCreateDateVal(DynamicObject currentObj, Object dateObj, IDataEntityProperty prop) {
        currentObj.set(prop, (Object)D.t((Object)dateObj));
    }

    private static void setBaseDataObjVal(DynamicObject currentObj, List<String> bdValInfo, BasedataProp prop, JSONObject dataMap) {
        if (bdValInfo != null && !bdValInfo.isEmpty()) {
            String basedataEntityNumber = bdValInfo.get(0);
            String numberVal = bdValInfo.get(3);
            DynamicObject bd = JsonResolveHelper.getBdFromFilter(basedataEntityNumber, bdValInfo.get(1), bdValInfo.get(2), numberVal, dataMap);
            if (bd != null) {
                currentObj.set((IDataEntityProperty)prop, (Object)bd);
                currentObj.set(prop.getName() + BASEDATA_ID_PROP_SUFFIX, bd.getPkValue());
            }
        }
    }

    private static DynamicObject getBdFromFilter(String entityName, String numberField, Object id, String number, JSONObject dataMap) {
        String cacheKey;
        Map bdCache = bdCaches.computeIfAbsent(entityName, k -> new HashMap(8));
        DynamicObject cacheObj = (DynamicObject)bdCache.get(cacheKey = entityName + numberField + id + number);
        if (cacheObj != null) {
            return cacheObj;
        }
        QFilter filter = null;
        id = JsonResolveHelper.idCovert(entityName, id);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DataEntityPropertyCollection properties = entityType.getProperties();
        boolean containsNumber = properties.containsKey((Object)numberField);
        int bdQueryMethod = JsonResolveHelper.getBdQueryMethod();
        switch (bdQueryMethod) {
            case 0: {
                filter = new QFilter(ID, "=", id);
                break;
            }
            case 1: {
                if (!containsNumber) break;
                filter = new QFilter(numberField, "=", (Object)number);
                break;
            }
            case 2: {
                filter = new QFilter(ID, "=", id);
                if (!containsNumber || StringUtils.isEmpty((String)number)) break;
                filter.or(numberField, "=", (Object)number);
                break;
            }
            default: {
                filter = new QFilter(ID, "=", id);
                if (!containsNumber || StringUtils.isEmpty((String)number)) break;
                filter.and(numberField, "=", (Object)number);
            }
        }
        Map baseDataMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])new QFilter[]{filter});
        DynamicObject bd = JsonResolveHelper.getBdFromCacheResult(numberField, id, number, entityType, containsNumber, baseDataMap);
        if (bd != null) {
            bdCache.put(cacheKey, bd);
        }
        return bd;
    }

    private static DynamicObject getBdFromCacheResult(String numberField, Object id, String number, MainEntityType entityType, boolean containsNumber, Map<Object, DynamicObject> baseDataMap) {
        DynamicObject bd = null;
        if (baseDataMap.isEmpty()) {
            return bd;
        }
        if (baseDataMap.size() == 1) {
            bd = baseDataMap.values().iterator().next();
        } else if (containsNumber && !StringUtils.isEmpty((String)number)) {
            int numberValueCount = 0;
            for (DynamicObject bdObj : baseDataMap.values()) {
                String numberValue = bdObj.getString(numberField);
                if (!StringUtils.equals((String)numberValue, (String)number)) continue;
                bd = bdObj;
                if (id.equals(bdObj.getPkValue())) {
                    return bdObj;
                }
                ++numberValueCount;
            }
        } else {
            bd = baseDataMap.get(id);
        }
        return bd;
    }

    private static void map2Entry(DynamicObject currentObj, Map<String, Object> allData, Map<String, Object> billMap, String entryKey, JSONObject dataMap, String entityNumber) {
        Map entryBdMap = (Map)allData.get(entryKey);
        DynamicObjectCollection entrys = currentObj.getDynamicObjectCollection(entryKey);
        entrys.clear();
        List packetEntryDataList = (List)billMap.get(entryKey);
        DataEntityPropertyCollection properties = entrys.getDynamicObjectType().getProperties();
        for (int i = 0; i < packetEntryDataList.size(); ++i) {
            Map map = (Map)packetEntryDataList.get(i);
            map.remove("$pk");
            map.remove("$id");
            DynamicObject newEntry = entrys.addNew();
            for (Map.Entry entry : map.entrySet()) {
                List<String> bdValInfo;
                String propkey = (String)entry.getKey();
                IDataEntityProperty prop = JsonResolveHelper.getProperty(properties, propkey);
                if (prop == null) continue;
                if (prop.getName().equals(ID) || prop.getName().equals(ENTRYID)) {
                    newEntry.set(prop, JsonResolveHelper.idCovert(entityNumber, entry.getValue()));
                    continue;
                }
                if (prop instanceof BasedataProp) {
                    bdValInfo = JsonResolveHelper.getEntryBdValInfo(entryBdMap, i, prop);
                    if (prop instanceof CreaterProp) {
                        JsonResolveHelper.setBillCreatorObjVal(newEntry, bdValInfo, (BasedataProp)prop, dataMap);
                        continue;
                    }
                    if (prop instanceof ModifierProp) continue;
                    JsonResolveHelper.setBaseDataObjVal(newEntry, bdValInfo, (BasedataProp)prop, dataMap);
                    continue;
                }
                if (prop instanceof MulBasedataProp && !(prop instanceof AttachmentProp)) {
                    bdValInfo = entry.getValue();
                    if (bdValInfo == null) continue;
                    JSONArray bdValInfoList = (JSONArray)bdValInfo;
                    DynamicObjectCollection basedatas = newEntry.getDynamicObjectCollection(prop);
                    basedatas.clear();
                    for (Object id : bdValInfoList) {
                        DynamicObject newRow = new DynamicObject(basedatas.getDynamicObjectType());
                        newRow.set("fbasedataid", ((JSONObject)id).get((Object)ID));
                        basedatas.add((Object)newRow);
                    }
                    newEntry.set(prop, (Object)basedatas);
                    continue;
                }
                if (prop instanceof MulBasedataProp) continue;
                Object value = entry.getValue();
                if (prop instanceof DateTimeProp) {
                    if (prop instanceof CreateDateProp) {
                        JsonResolveHelper.setBillCreateDateVal(newEntry, value, prop);
                        continue;
                    }
                    if (prop instanceof ModifyDateProp) continue;
                    newEntry.set(prop, (Object)D.t(value));
                    continue;
                }
                if (prop instanceof DecimalProp) {
                    newEntry.set(prop, (Object)D.n(value));
                    continue;
                }
                if (prop instanceof BooleanProp) {
                    newEntry.set(prop, (Object)D.x(value));
                    continue;
                }
                if (prop instanceof EntryProp) {
                    JsonResolveHelper.map2SubEntry(currentObj, allData, (List)value, newEntry, propkey, i, dataMap);
                    continue;
                }
                newEntry.set(prop, value);
            }
        }
    }

    private static void map2SubEntry(DynamicObject currentObj, Map<String, Object> allData, List<Map<String, Object>> packetSubEntryDataList, DynamicObject newEntry, String subEntryKey, int entryLine, JSONObject dataMap) {
        DynamicObjectCollection subEntrys = newEntry.getDynamicObjectCollection(subEntryKey);
        subEntrys.clear();
        DataEntityPropertyCollection properties = subEntrys.getDynamicObjectType().getProperties();
        for (int subEntryIndex = 0; subEntryIndex < packetSubEntryDataList.size(); ++subEntryIndex) {
            Map<String, Object> subEntryData = packetSubEntryDataList.get(subEntryIndex);
            subEntryData.remove("$pk");
            subEntryData.remove("$id");
            DynamicObject newSubEntry = subEntrys.addNew();
            for (Map.Entry<String, Object> entryData : subEntryData.entrySet()) {
                String subEntryFieldKey = entryData.getKey();
                IDataEntityProperty prop = JsonResolveHelper.getProperty(properties, subEntryFieldKey);
                if (prop == null) continue;
                Object value = entryData.getValue();
                if (prop instanceof BasedataProp) {
                    List<String> bdValInfo = JsonResolveHelper.getSubEntryBdValInfo(allData, subEntryKey, entryLine, subEntryIndex, prop);
                    if (prop instanceof CreaterProp) {
                        JsonResolveHelper.setBillCreatorObjVal(newSubEntry, bdValInfo, (BasedataProp)prop, dataMap);
                        continue;
                    }
                    if (prop instanceof ModifierProp) continue;
                    JsonResolveHelper.setBaseDataObjVal(newSubEntry, bdValInfo, (BasedataProp)prop, dataMap);
                    continue;
                }
                if (prop instanceof MulBasedataProp) continue;
                if (prop instanceof DateTimeProp) {
                    newSubEntry.set(prop, (Object)D.t((Object)value));
                    continue;
                }
                if (prop instanceof DecimalProp) {
                    newSubEntry.set(prop, (Object)D.n((Object)value));
                    continue;
                }
                if (prop instanceof BooleanProp) {
                    newSubEntry.set(prop, (Object)D.x((Object)value));
                    continue;
                }
                newSubEntry.set(prop, value);
            }
        }
    }

    private static List<String> getEntryBdValInfo(Map<String, Object> bdMap, int i, IDataEntityProperty prop) {
        JSONArray arrays;
        Map bdValueMap = (Map)bdMap.get(prop.getName());
        ArrayList<String> bdValInfo = new ArrayList<String>(4);
        if (bdValueMap != null && (arrays = (JSONArray)JSON.toJSON(bdValueMap.get(CONTENT))).get(i) != null) {
            JSONArray value = arrays.getJSONArray(i);
            if (value.size() > 2) {
                bdValInfo.add(value.getString(2));
            } else {
                bdValInfo.add((String)bdValueMap.get("type"));
            }
            bdValInfo.add((String)bdValueMap.get(NUMBER_FIELD));
            bdValInfo.add(value.getString(0));
            bdValInfo.add(value.getString(1));
        }
        return bdValInfo;
    }

    private static List<String> getSubEntryBdValInfo(Map<String, Object> allData, String subEntryKey, int entryLine, int subEntryIndex, IDataEntityProperty prop) {
        JSONArray v;
        Map packetSubBdMap = (Map)allData.get(subEntryKey);
        Map bdValueMap = (Map)packetSubBdMap.get(prop.getName());
        ArrayList<String> bdValInfo = new ArrayList<String>(4);
        JSONArray arrays = (JSONArray)JSON.toJSON(bdValueMap.get(CONTENT));
        if ((arrays = arrays.getJSONArray(entryLine)).get(subEntryIndex) != null) {
            v = arrays.getJSONArray(subEntryIndex);
            if (v.size() > 2) {
                bdValInfo.add(v.getString(2));
            } else {
                bdValInfo.add((String)bdValueMap.get("type"));
            }
        } else {
            return Collections.emptyList();
        }
        bdValInfo.add((String)bdValueMap.get(NUMBER_FIELD));
        bdValInfo.add(v.getString(0));
        bdValInfo.add(v.getString(1));
        return bdValInfo;
    }

    private static int getBdQueryMethod() {
        int key = -1;
        DynamicObject data = BusinessDataServiceHelper.loadSingleFromCache((String)"ricc_initconfig", (String)"id,comparekey", (QFilter[])new QFilter[0]);
        if (data != null) {
            key = data.getInt("comparekey");
        }
        return key;
    }

    static interface BaseDataQueryMethods {
        public static final int ONLY_ID = 0;
        public static final int ONLY_NUMBER = 1;
        public static final int ID_OR_NUMBER = 2;
        public static final int ID_AND_NUMBER = 3;
    }
}

