/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.isc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sys.ricc.common.isc.IscJson;
import kd.sys.ricc.common.util.ShowParameterUtil;

public class IscSyncHelper {
    private static final Log logger = LogFactory.getLog(IscSyncHelper.class);
    public static final String EVENT = "event";
    public static final String TRIGGER_TYPE = "trigger_type";
    public static final String TRIGGER_ID = "triggerId";
    public static final String PARAMS_ENTRY_ENTITY = "params_entryentity";
    public static final String SUCCESS = "success";
    public static final String ISC_SERVICE_FLOW_R = "isc_service_flow_r";
    public static final String EXECUTE_FLOW_EVENT = "execute_flow_event";
    public static final String FLOW_ID = "flow_id";
    public static final String GET_FLOW_PARAMS = "get_flow_params";
    public static final String CATEGORY = "category";

    public static void startDataCopyTrigger(IFormView view, DynamicObject trigger) {
        if (EVENT.equals(trigger.getString(TRIGGER_TYPE))) {
            IscSyncHelper.eventTrigger(view, trigger);
        } else {
            IscSyncHelper.manualTrigger(view, trigger);
        }
    }

    public static void eventTrigger(IFormView view, DynamicObject trigger) {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put(TRIGGER_ID, trigger.getPkValue());
        FormShowParameter formShowParameter = ShowParameterUtil.formShowParameter((String)"isc_event_trigger_param", (ShowType)ShowType.Modal, params, null, null);
        view.showForm(formShowParameter);
    }

    public static void manualTrigger(IFormView view, DynamicObject trigger) {
        block5: {
            String number = trigger.getString("number");
            HashMap<String, Object> params = new HashMap<String, Object>(1);
            params.put(TRIGGER_ID, trigger.getPkValue());
            if (trigger.getDynamicObjectCollection(PARAMS_ENTRY_ENTITY).isEmpty()) {
                try {
                    Map resMap = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"start", (Object[])new Object[]{number, params, null});
                    if (Boolean.parseBoolean(resMap.get(SUCCESS).toString())) {
                        view.showSuccessNotification((String)resMap.get("msg"));
                        String executionNumber = (String)resMap.get("execution_number");
                        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
                        qFilterList.add(new QFilter("number", "=", (Object)executionNumber));
                        ListShowParameter listShowParameter = ShowParameterUtil.listShowParameter((String)"isc_data_copy_execution", (String)"bos_list", (ShowType)ShowType.Modal, null, qFilterList, (String)"", (String)"");
                        StyleCss style = new StyleCss();
                        style.setWidth("1200");
                        style.setHeight("600");
                        listShowParameter.getOpenStyle().setInlineStyleCss(style);
                        view.showForm((FormShowParameter)listShowParameter);
                        break block5;
                    }
                    view.showErrorNotification((String)resMap.get("msg"));
                }
                catch (Exception e) {
                    logger.error("IscSyncHelper.manualTrigger \u6267\u884c\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
                    view.showErrorNotification(e.getMessage());
                }
            } else {
                BillShowParameter p = new BillShowParameter();
                p.setFormId("isc_data_copy_execution");
                p.setCustomParams(params);
                p.getOpenStyle().setShowType(ShowType.Modal);
                p.setStatus(OperationStatus.ADDNEW);
                view.showForm((FormShowParameter)p);
            }
        }
    }

    public static void startFlow(IFormView view, String plugin, DynamicObject scheme) {
        long pk = scheme.getLong("id");
        DynamicObject releasedFlow = IscSyncHelper.findReleasedFlow(pk);
        if (Objects.isNull(releasedFlow)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u6d41\u7a0b\u672a\u53d1\u5e03\u3002", (String)"IscSyncHelper_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        long releasedFlowId = releasedFlow.getLong("id");
        if (releasedFlowId <= 0L) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u6d41\u7a0b\u672a\u53d1\u5e03\u3002", (String)"IscSyncHelper_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        DynamicObject cfg = BusinessDataServiceHelper.loadSingle((Object)releasedFlowId, (String)ISC_SERVICE_FLOW_R);
        String type = cfg.getString("init_mode");
        String json = cfg.getString("define_json_tag");
        Map define = (Map)IscJson.toObject((String)json);
        if (EVENT.equalsIgnoreCase(type)) {
            IscSyncHelper.executeFlowEvent(view, pk, define, plugin);
        } else {
            IscSyncHelper.executeFlowManual(view, releasedFlowId, define, plugin);
        }
    }

    public static void parseAndStartFlow(Object returnData, IFormView view) {
        if (returnData instanceof Map) {
            Map resMap = (Map)returnData;
            long flowId = Long.parseLong((String)resMap.get(FLOW_ID));
            List values = (List)resMap.get("values");
            DynamicObject flowDy = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)ISC_SERVICE_FLOW_R);
            if (Objects.isNull(flowDy)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u670d\u52a1\u6d41\u7a0b\u6ca1\u627e\u5230\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\u3002", (String)"IscSyncHelper_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            String number = flowDy.getString("number");
            Object[] objects = new Object[]{number, values};
            IscSyncHelper.invokeFlowService(objects, view);
        }
    }

    public static DynamicObject findReleasedFlow(long flowId) {
        DynamicObject releaseFlow = null;
        QFilter[] qFilters = new QFilter[]{new QFilter("flow", "=", (Object)flowId)};
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ISC_SERVICE_FLOW_R, (String)"id,init_mode,name,number", (QFilter[])qFilters, (String)"createtime DESC, version DESC", (int)1);
        if (dynamicObjects.length > 0) {
            releaseFlow = dynamicObjects[0];
        }
        return releaseFlow;
    }

    public static void executeFlowEvent(IFormView view, Long pk, Map<String, Object> define, String plugin) {
        Map<String, Object> params = IscSyncHelper.getOpenEventParamFromDiagram(define, pk);
        FormShowParameter formShowParameter = ShowParameterUtil.formShowParameter((String)"isc_sf_event_param", (ShowType)ShowType.Modal, params, null, null);
        formShowParameter.setCloseCallBack(new CloseCallBack(plugin, EXECUTE_FLOW_EVENT));
        view.showForm(formShowParameter);
    }

    public static Map<String, Object> getOpenEventParamFromDiagram(Map<String, Object> define, long releasedFlowId) {
        Map diagram = (Map)define.get("diagram");
        Collection nodes = ((Map)diagram.get("nodes")).values();
        Iterator nodeIterator = nodes.iterator();
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put(FLOW_ID, releasedFlowId);
        params.put("meta", 0L);
        params.put("node", null);
        while (nodeIterator.hasNext()) {
            Map item = (Map)nodeIterator.next();
            String type = (String)item.get("type");
            if (!"EventStarter".equalsIgnoreCase(type)) continue;
            params.put("meta", item.get("data_schema"));
            params.put("node", item);
            break;
        }
        return params;
    }

    public static void executeFlowManual(IFormView view, long releasedFlowId, Map<String, Object> define, String plugin) {
        List<Map<String, Object>> inputList = IscSyncHelper.getInputVariablesFromDiagram(define);
        if (!inputList.isEmpty()) {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put(FLOW_ID, releasedFlowId);
            params.put("params", inputList);
            FormShowParameter formShowParameter = ShowParameterUtil.formShowParameter((String)"isc_sf_manual_params", (ShowType)ShowType.Modal, params, (String)ResManager.loadKDString((String)"\u8bbe\u7f6e\u53c2\u6570\u503c", (String)"IscSyncHelper_2", (String)"sys-ricc-platform", (Object[])new Object[0]), null);
            formShowParameter.setCloseCallBack(new CloseCallBack(plugin, GET_FLOW_PARAMS));
            view.showForm(formShowParameter);
        } else {
            DynamicObject flowDy = BusinessDataServiceHelper.loadSingle((Object)releasedFlowId, (String)ISC_SERVICE_FLOW_R);
            if (Objects.isNull(flowDy)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u670d\u52a1\u6d41\u7a0b\u6ca1\u627e\u5230\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\u3002", (String)"IscSyncHelper_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            String number = flowDy.getString("number");
            Object[] objects = new Object[]{number};
            IscSyncHelper.invokeFlowService(objects, view);
            view.showSuccessNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u89e6\u53d1\u3002", (String)"IscSyncHelper_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
    }

    public static List<Map<String, Object>> getInputVariablesFromDiagram(Map<String, Object> define) {
        ArrayList variables = (ArrayList)define.get("variables");
        Iterator variablesIterator = variables.iterator();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(variables.size());
        while (variablesIterator.hasNext()) {
            Map item = (Map)variablesIterator.next();
            Boolean input = (Boolean)item.get("is_input");
            if (!Boolean.TRUE.equals(input)) continue;
            HashMap<String, Object> m = new HashMap<String, Object>(6);
            m.put("name", item.get("name"));
            m.put("class_type", String.valueOf(item.get(CATEGORY)).toLowerCase());
            m.put("type", item.get("type"));
            m.put(CATEGORY, String.valueOf(item.get(CATEGORY)).toLowerCase());
            m.put("is_array", item.get("is_array"));
            m.put("init_value", new String[]{(String)item.get("init_value")});
            list.add(m);
        }
        return list;
    }

    public static void invokeFlowService(Object[] objects, IFormView view) {
        try {
            Long restId = (Long)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"start", (Object[])objects);
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
            qFilterList.add(new QFilter("id", "=", (Object)restId));
            IscSyncHelper.openFlowInstList(qFilterList, view);
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u63d0\u4ea4\u6d41\u7a0b\u6267\u884c\u3002", (String)"IscSyncHelper_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.error("IscSyncHelper.invokeFlowService \u6267\u884c\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
            view.showErrorNotification(e.getMessage());
        }
    }

    public static void openFlowInstList(List<QFilter> qFilterList, IFormView view) {
        ListShowParameter listShowParameter = ShowParameterUtil.listShowParameter((String)"isc_sf_proc_inst", (String)"bos_list", (ShowType)ShowType.Modal, null, qFilterList, (String)"", (String)"");
        StyleCss style = new StyleCss();
        style.setWidth("1200");
        style.setHeight("600");
        listShowParameter.getOpenStyle().setInlineStyleCss(style);
        view.showForm((FormShowParameter)listShowParameter);
    }

    public static void recordLog(DynamicObject scheme, String iscType, String itemType, Object itemId) {
        DynamicObject bizObject = BusinessDataServiceHelper.loadSingleFromCache((Object)itemId, (String)itemType);
        DynamicObject baseDataLog = BusinessDataServiceHelper.newDynamicObject((String)"ricc_basedata_log");
        baseDataLog.set("logtype", (Object)itemType);
        baseDataLog.set("bizobject", (Object)bizObject);
        baseDataLog.set("scheme", (Object)scheme);
        baseDataLog.set("isctype", (Object)iscType);
        baseDataLog.set("billno", (Object)scheme.getString("number"));
        baseDataLog.set("optime", (Object)System.currentTimeMillis());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{baseDataLog});
    }
}

