/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.metadata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.devportal.util.AppPackageUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.billtype.BillTypeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.exception.RiccBizException;

public class MetaDataDeployHandler {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String PARENTID = "parentid";
    public static final String ROOTNODE = "rootnode";
    private static final String PAGE = "_page";
    private static final String SCRIPT = "_script";
    private static final String SECPAGE = "#secpage";
    private static final String SECSCRIPT = "#secscript";
    private static final String TEXT = "text";
    public static final String BIZAPP = "bizapp";
    public static final String BIZAPPID = "bizappid";
    public static final String APP_NUM = "appnum";
    public static final String CLOUD_NUM = "cloudnum";
    public static final String SCRIPT_NUM = "scriptnum";
    public static final String BILLTYPE_NUM = "billtypenum";
    public static final String CODERULE_NUM = "coderulenum";
    public static final String PAGE_NUM = "pagenum";
    public static final String WORKBENCH_NUM = "workbenchnum";
    private static final String PAGE_ID = "pagemeta#firmenu";
    private static final String SCRIPT_ID = "scriptmeta#firmenu";
    private static final String WORKBENCH_ID = "workbench#firmenu";
    private static final String BOS_DEVP_INDUSTRY = "bos_devp_industry";
    private static final String BOS_DEVPORTAL_BIZCLOUD = "bos_devportal_bizcloud";
    public static final String BOS_DEVPORTAL_UNITRELFORM = "bos_devportal_unitrelform";
    private Map<String, Map<String, Object>> rootCloudInfo = new HashMap<String, Map<String, Object>>(4);
    private Map<String, Map<String, Object>> rootAppInfos = new HashMap<String, Map<String, Object>>();
    private List<Map<String, Object>> cloudMenu = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> appMenu = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> pageMenu = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> scriptMenu = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> codeRuleMenu = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> billTypeMenu = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> workbenchMenu = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> selectNodes;
    private List<String> selectAppIdList = new ArrayList<String>();
    private List<String> selectCloudIdList = new ArrayList<String>();
    private StringBuilder detailErrorLogInfo = new StringBuilder();
    private StringBuilder detailErrorMsg = new StringBuilder();
    private Map<String, String> treeNodeMap = new LinkedHashMap<String, String>();

    public MetaDataDeployHandler(List<Map<String, Object>> selectNodes) {
        this.selectNodes = selectNodes;
    }

    public MetaDataDeployHandler() {
    }

    public Map<String, String> getTreeNodeMap() {
        return this.treeNodeMap;
    }

    public StringBuilder getDetailErrorLogInfo() {
        return this.detailErrorLogInfo;
    }

    public StringBuilder getDetailErrorMsg() {
        return this.detailErrorMsg;
    }

    public List<String> getSelectedAppList(List<Object> bizAppIds) {
        for (Map<String, Object> selectNode : this.selectNodes) {
            String bizAppId;
            String bizId = (String)selectNode.get("id");
            String bizParent = (String)selectNode.get(PARENTID);
            if (bizParent.equals(ROOTNODE)) {
                this.rootCloudInfo.put(bizId, selectNode);
                this.selectCloudIdList.add(bizId);
            } else if (bizId.endsWith("#cld")) {
                AppPackageUtil.pushSourceToCollection(this.cloudMenu, selectNode, (String)bizParent, this.selectAppIdList, (int)2);
            } else if (bizId.endsWith("#app")) {
                AppPackageUtil.pushSourceToCollection(this.appMenu, selectNode, (String)bizId, this.selectAppIdList, (int)0);
            } else if (bizId.endsWith(PAGE)) {
                AppPackageUtil.pushSourceToCollection(this.pageMenu, selectNode, (String)bizId, this.selectAppIdList, (int)0);
            } else if (bizId.endsWith(SCRIPT)) {
                AppPackageUtil.pushSourceToCollection(this.scriptMenu, selectNode, (String)bizId, this.selectAppIdList, (int)0);
            } else if (bizId.endsWith("bt")) {
                AppPackageUtil.pushSourceToCollection(this.billTypeMenu, selectNode, (String)bizParent, this.selectAppIdList, (int)2);
            } else if (bizId.endsWith("cr")) {
                AppPackageUtil.pushSourceToCollection(this.codeRuleMenu, selectNode, (String)bizParent, this.selectAppIdList, (int)2);
            } else if (bizId.endsWith("bench")) {
                AppPackageUtil.pushSourceToCollection(this.workbenchMenu, selectNode, (String)bizParent, this.selectAppIdList, (int)2);
            } else if (this.selectCloudIdList.contains(bizParent) || bizAppIds.contains(bizId)) {
                this.rootAppInfos.put(bizId, selectNode);
                this.selectAppIdList.add(bizId);
            }
            JSONArray firNodesArr = AppPackageUtil.getFirNodes();
            for (Object firNodeObj : firNodesArr) {
                String bizAppId2;
                JSONObject firNode = (JSONObject)firNodeObj;
                String firNodeId = firNode.getString("id");
                if (!bizId.contains(firNodeId) || this.selectAppIdList.contains(bizAppId2 = bizId.split("#")[2])) continue;
                this.selectAppIdList.add(bizAppId2);
            }
            if (!bizId.endsWith(SECPAGE) && !bizId.endsWith(SECSCRIPT) && !bizId.startsWith("workbench#sysmenu") && !bizId.startsWith("workbench#permenu") || this.selectAppIdList.contains(bizAppId = bizParent.split("#")[2])) continue;
            this.selectAppIdList.add(bizAppId);
        }
        return this.selectAppIdList;
    }

    public List<TreeNode> getNodeList() {
        ArrayList<TreeNode> addNodeList = new ArrayList<TreeNode>(this.selectAppIdList.size());
        for (String bizAppId : this.selectAppIdList) {
            this.getOneAppNodeList(addNodeList, bizAppId);
        }
        return addNodeList;
    }

    public void getOneAppNodeList(List<TreeNode> addNodeList, String bizAppId) {
        TreeNode appNode = this.getAppTreeNode(addNodeList, bizAppId);
        if (appNode == null) {
            return;
        }
        this.getCloudTreeNode(bizAppId, appNode);
        this.getAppTreeNode(bizAppId, appNode);
        if (!this.pageMenu.isEmpty()) {
            String pageNodeId = "pagemeta#firmenu#" + bizAppId;
            this.chooseNode(this.pageMenu, bizAppId, appNode, ResManager.loadKDString((String)"\u9875\u9762", (String)"MetaDataDeployHandler_0", (String)"sys-ricc-platform", (Object[])new Object[0]), pageNodeId, SECPAGE);
        }
        if (!this.scriptMenu.isEmpty()) {
            String scriptNodeId = "scriptmeta#firmenu#" + bizAppId;
            this.chooseNode(this.scriptMenu, bizAppId, appNode, ResManager.loadKDString((String)"\u811a\u672c", (String)"MetaDataDeployHandler_1", (String)"sys-ricc-platform", (Object[])new Object[0]), scriptNodeId, SECSCRIPT);
        }
        this.getBillTypeTreeNode(bizAppId, appNode);
        this.getCodeRuleTreeNode(bizAppId, appNode);
        this.getWorkBenchTreeNode(bizAppId, appNode);
        this.treeNodeMap.put(bizAppId, SerializationUtils.toJsonString((Object)appNode));
    }

    public TreeNode getAppTreeNode(List<TreeNode> addNodeList, String bizAppId) {
        TreeNode appNode;
        Map<String, Object> rootAppInfo = this.rootAppInfos.get(bizAppId);
        if (rootAppInfo == null) {
            AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
            if (appMeta == null) {
                return null;
            }
            String industryName = MetaDataDeployHandler.getIndustryName(appMeta.getIndustryId());
            String firNodeText = MetaDataDeployHandler.getFirstNodeText(appMeta.getName().getLocaleValue(), appMeta.getNumber(), industryName);
            appNode = new TreeNode(ROOTNODE, bizAppId, firNodeText);
            addNodeList.add(appNode);
        } else {
            appNode = new TreeNode(ROOTNODE, bizAppId, (String)rootAppInfo.get(TEXT), true);
            addNodeList.add(appNode);
        }
        return appNode;
    }

    public void getCloudTreeNode(String bizAppId, TreeNode appNode) {
        this.cloudMenu.forEach(cloudInfo -> {
            String cloudParentId = (String)cloudInfo.get(PARENTID);
            if (cloudParentId.indexOf(bizAppId) != -1) {
                String cloudId = (String)cloudInfo.get("id");
                String cloudName = (String)cloudInfo.get(TEXT);
                String cloudNodeId = cloudId + "#cld";
                TreeNode cloudFirMenu = new TreeNode(bizAppId, cloudParentId, ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"MetaDataDeployHandler_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
                appNode.addChild(cloudFirMenu);
                TreeNode cloudSecMenu = new TreeNode(cloudParentId, cloudNodeId, cloudName);
                cloudFirMenu.addChild(cloudSecMenu);
            }
        });
    }

    public void getAppTreeNode(String bizAppId, TreeNode appNode) {
        this.appMenu.forEach(appInfo -> {
            String appParentId = (String)appInfo.get(PARENTID);
            if (appParentId.indexOf(bizAppId) != -1) {
                String appId = (String)appInfo.get("id");
                String appName = (String)appInfo.get(TEXT);
                TreeNode appFirMenu = new TreeNode(bizAppId, appParentId, ResManager.loadKDString((String)"\u5e94\u7528\u4fe1\u606f(\u5305\u62ec\u83dc\u5355\u3001\u529f\u80fd\u5206\u7ec4)", (String)"MetaDataDeployHandler_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
                appNode.addChild(appFirMenu);
                TreeNode appSecMenu = new TreeNode(appParentId, appId, appName);
                appFirMenu.addChild(appSecMenu);
            }
        });
    }

    public void getBillTypeTreeNode(String bizAppId, TreeNode appNode) {
        if (!this.billTypeMenu.isEmpty()) {
            boolean billTypeFlag = true;
            TreeNode billFirMenu = new TreeNode();
            for (Map<String, Object> billTypeInfo : this.billTypeMenu) {
                String secParentId = (String)billTypeInfo.get(PARENTID);
                if (secParentId.indexOf(bizAppId) == -1) continue;
                if (billTypeFlag) {
                    billFirMenu = new TreeNode(bizAppId, secParentId, ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"MetaDataDeployHandler_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    appNode.addChild(billFirMenu);
                    billTypeFlag = false;
                }
                String secId = (String)billTypeInfo.get("id");
                String secText = (String)billTypeInfo.get(TEXT);
                TreeNode billSecMenu = new TreeNode(secParentId, secId, secText);
                billFirMenu.addChild(billSecMenu);
            }
        }
    }

    public void getCodeRuleTreeNode(String bizAppId, TreeNode appNode) {
        if (!this.codeRuleMenu.isEmpty()) {
            TreeNode codeFirMenu = new TreeNode();
            boolean codeRuleFlag = true;
            for (Map<String, Object> codeRuleInfo : this.codeRuleMenu) {
                String secParentId = (String)codeRuleInfo.get(PARENTID);
                if (secParentId.indexOf(bizAppId) == -1) continue;
                if (codeRuleFlag) {
                    codeFirMenu = new TreeNode(bizAppId, secParentId, ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219", (String)"MetaDataDeployHandler_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    appNode.addChild(codeFirMenu);
                    codeRuleFlag = false;
                }
                String secId = (String)codeRuleInfo.get("id");
                String secText = (String)codeRuleInfo.get(TEXT);
                TreeNode codeSecMenu = new TreeNode(secParentId, secId, secText);
                codeFirMenu.addChild(codeSecMenu);
            }
        }
    }

    public void getWorkBenchTreeNode(String bizAppId, TreeNode appNode) {
        if (this.workbenchMenu.isEmpty()) {
            return;
        }
        ArrayList<String> thirdParentIds = new ArrayList<String>();
        for (Map<String, Object> workbenchInfo2 : this.workbenchMenu) {
            String thirdParentId = (String)workbenchInfo2.get(PARENTID);
            if (thirdParentIds.contains(thirdParentId) || thirdParentId.indexOf(bizAppId) == -1) continue;
            thirdParentIds.add(thirdParentId);
        }
        boolean workbencFirFlag = true;
        TreeNode workbencFirMenu = new TreeNode();
        for (String secMenuId : thirdParentIds) {
            String workbenchFirNodeId = "workbench#firmenu#" + bizAppId;
            if (workbencFirFlag) {
                workbencFirMenu = new TreeNode(bizAppId, workbenchFirNodeId, ResManager.loadKDString((String)"\u5e94\u7528\u5de5\u4f5c\u53f0", (String)"MetaDataDeployHandler_6", (String)"sys-ricc-platform", (Object[])new Object[0]));
                appNode.addChild(workbencFirMenu);
                workbencFirFlag = false;
            }
            String secMenuName = "";
            if (secMenuId.startsWith("workbench#sysmenu")) {
                secMenuName = ResManager.loadKDString((String)"\u9ed8\u8ba4\u65b9\u6848", (String)"MetaDataDeployHandler_7", (String)"sys-ricc-platform", (Object[])new Object[0]);
            } else if (secMenuId.startsWith("workbench#permenu")) {
                secMenuName = ResManager.loadKDString((String)"\u4e2a\u6027\u65b9\u6848", (String)"MetaDataDeployHandler_8", (String)"sys-ricc-platform", (Object[])new Object[0]);
            }
            TreeNode workbencSecMenu = new TreeNode(workbenchFirNodeId, secMenuId, secMenuName);
            workbencFirMenu.addChild(workbencSecMenu);
            this.workbenchMenu.forEach(workbenchInfo -> {
                String thirdId = (String)workbenchInfo.get("id");
                String thirdParentId = (String)workbenchInfo.get(PARENTID);
                String thirdText = (String)workbenchInfo.get(TEXT);
                if (secMenuId.equals(thirdParentId)) {
                    TreeNode workbencThiMenu = new TreeNode(thirdParentId, thirdId, thirdText);
                    workbencSecMenu.addChild(workbencThiMenu);
                }
            });
        }
    }

    private void chooseNode(List<Map<String, Object>> tirMenu, String bizAppId, TreeNode appNode, String firMenuName, String firMenuId, String secNum) {
        ArrayList<String> tirParentIds = new ArrayList<String>();
        for (int i = 0; i < tirMenu.size(); ++i) {
            Map<String, Object> tirMap = tirMenu.get(i);
            String sourceId = (String)tirMap.get("id");
            String tirParentId = (String)tirMap.get(PARENTID);
            if (tirParentIds.contains(tirParentId) || !sourceId.contains(bizAppId)) continue;
            tirParentIds.add(tirParentId);
        }
        boolean sourceFlag = true;
        TreeNode firMetaMenu = new TreeNode();
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        List functionPacketElements = appMeta.getAppFunctionPackets();
        for (String sectId : tirParentIds) {
            String unitId = sectId.substring(0, sectId.indexOf(secNum));
            for (AppFunctionPacketElement functionElement : functionPacketElements) {
                String functionId;
                String funcType = functionElement.getType();
                if ("1".equals(funcType) || !unitId.equals(functionId = functionElement.getId())) continue;
                if (sourceFlag) {
                    firMetaMenu = new TreeNode(bizAppId, firMenuId, firMenuName);
                    appNode.addChild(firMetaMenu);
                    sourceFlag = false;
                }
                String bizUnitName = functionElement.getName().getLocaleValue();
                TreeNode secMetaMenu = new TreeNode(firMenuId, sectId, bizUnitName);
                firMetaMenu.addChild(secMetaMenu);
                tirMenu.forEach(thiMenuInfo -> {
                    String tirId = (String)thiMenuInfo.get("id");
                    String tirParentId = (String)thiMenuInfo.get(PARENTID);
                    String tirText = (String)thiMenuInfo.get(TEXT);
                    String sourceAppId = tirId.split("#")[0];
                    if (sectId.equals(tirParentId) && sourceAppId.equals(bizAppId)) {
                        TreeNode thiMetaMenu = new TreeNode(tirParentId, tirId, tirText);
                        secMetaMenu.addChild(thiMetaMenu);
                    }
                });
            }
        }
    }

    public static String getIndustryName(Object industryId) {
        DynamicObject industryObject;
        String industryName = "";
        if (StringUtils.isNotBlank((Object)industryId) && StringUtils.isNotBlank((Object)(industryObject = BusinessDataServiceHelper.loadSingleFromCache((Object)industryId, (String)BOS_DEVP_INDUSTRY, (String)"name")))) {
            industryName = industryObject.getLocaleString("name").getLocaleValue();
        }
        return industryName;
    }

    public List<TreeNode> getOneAppTreeNodes(String bizAppId) {
        AppMetadata appMeta;
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>();
        try {
            appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u5e94\u7528id\u4e3a\u3010%s\u3011\u52a0\u8f7d\u5f02\u5e38\uff01", (String)"MetaDataDeployHandler_9", (String)"sys-ricc-platform", (Object[])new Object[0]), bizAppId);
            this.detailErrorMsg.append(msg);
            this.logger.error(msg, (Throwable)e);
            return treeNodeList;
        }
        String appType = appMeta.getDevType();
        String masterAppId = appMeta.getMasterId();
        String appName = appMeta.getName().getLocaleValue();
        String inheritPath = appMeta.getInheritPath();
        JSONArray firNodesArr = AppPackageUtil.getFirNodes();
        String industryName = MetaDataDeployHandler.getIndustryName(appMeta.getIndustryId());
        for (Object firNodeObj : firNodesArr) {
            QFilter appFilter;
            List appIdList;
            JSONObject firNode = (JSONObject)firNodeObj;
            String firNodeName = firNode.getString("name");
            String firNodeId = firNode.getString("id") + "#" + bizAppId;
            String firNumber = firNode.getString("number");
            if (CLOUD_NUM.equals(firNumber)) {
                String bizCloudId = appMeta.getBizCloudID();
                DynamicObject cloudObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bizCloudId, (String)BOS_DEVPORTAL_BIZCLOUD, (String)"baseapp,name");
                if (Objects.isNull(cloudObject)) {
                    throw new RiccBizException(String.format(ResManager.loadKDString((String)"%1$s\u6240\u5728\u7684\u4e1a\u52a1\u4e91\u3010%2$s\u3011\u4e0d\u5b58\u5728\u3002", (String)"MetaDataDeployHandler_10", (String)"sys-ricc-platform", (Object[])new Object[0]), appName, bizCloudId));
                }
                String cloudBaseAppId = cloudObject.getString("baseapp_id");
                QFilter qFilter = new QFilter("id", "=", (Object)cloudBaseAppId);
                QFilter[] filters = new QFilter[]{qFilter};
                Boolean cloudBaseAppExist = QueryServiceHelper.exists((String)"bos_devportal_bizapp", (QFilter[])filters);
                if (Boolean.TRUE.equals(cloudBaseAppExist) && bizAppId.equals(cloudBaseAppId)) {
                    String cloudName = cloudObject.getLocaleString("name").getLocaleValue();
                    TreeNode cloudFirMenu = new TreeNode(bizAppId, firNodeId, firNodeName);
                    treeNodeList.add(cloudFirMenu);
                    String cloudNodeId = bizCloudId + "#cld";
                    TreeNode cloudSecMenu = new TreeNode(firNodeId, cloudNodeId, cloudName);
                    cloudFirMenu.addChild(cloudSecMenu);
                }
            }
            if (APP_NUM.equals(firNumber)) {
                TreeNode appFirMenu = new TreeNode(bizAppId, firNodeId, firNodeName);
                treeNodeList.add(appFirMenu);
                String bizAppNodeId = bizAppId + "#app";
                String appNodeText = appName;
                if (StringUtils.isNotBlank((CharSequence)industryName)) {
                    appNodeText = appName + "\uff08" + industryName + "\uff09";
                }
                TreeNode appSecMenu = new TreeNode(firNodeId, bizAppNodeId, appNodeText);
                appFirMenu.addChild(appSecMenu);
            }
            if (BILLTYPE_NUM.equals(firNumber)) {
                appIdList = DevportalUtil.getAllAppIds((String)inheritPath, (String)bizAppId);
                List billTypeList = Collections.emptyList();
                try {
                    billTypeList = BillTypeServiceHelper.getBillTypesByAppId((List)appIdList);
                }
                catch (Exception exception) {
                    this.logger.error("BillTypeServiceHelper.getBillTypesByAppId\u51fa\u9519", (Throwable)exception);
                    if (StringUtils.isNotBlank((CharSequence)this.detailErrorMsg)) {
                        this.detailErrorMsg.append(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u83b7\u53d6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u83b7\u53d6\u5355\u636e\u7c7b\u578b\u63a5\u53e3\u3010BillTypeServiceHelper.getBillTypesByAppId\u3011\u51fa\u9519", (String)"MetaDataDeployHandler_11", (String)"sys-ricc-platform", (Object[])new Object[0]));
                        this.detailErrorMsg.append(System.lineSeparator());
                    } else {
                        this.detailErrorMsg.append(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u83b7\u53d6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u83b7\u53d6\u5355\u636e\u7c7b\u578b\u63a5\u53e3\u3010BillTypeServiceHelper.getBillTypesByAppId\u3011\u51fa\u9519", (String)"MetaDataDeployHandler_11", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    }
                    String exceptionMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u83b7\u53d6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u83b7\u53d6\u5355\u636e\u7c7b\u578b\u63a5\u53e3\u3010BillTypeServiceHelper.getBillTypesByAppId\u3011\u51fa\u9519\uff0c\u9519\u8bef\u8be6\u60c5\uff1a%s", (String)"MetaDataDeployHandler_12", (String)"sys-ricc-platform", (Object[])new Object[0]), exception.getMessage());
                    this.detailErrorLogInfo.append(exceptionMsg);
                    this.detailErrorLogInfo.append(System.lineSeparator());
                }
                if (billTypeList != null && !billTypeList.isEmpty()) {
                    TreeNode billFirMenu = new TreeNode(bizAppId, firNodeId, firNodeName);
                    treeNodeList.add(billFirMenu);
                    for (Map billType : billTypeList) {
                        String billTypeNodeId = billType.get("id") + "#bt";
                        String billTypeNodeText = billType.get("name").toString();
                        TreeNode billSecMenu = new TreeNode(firNodeId, billTypeNodeId, billTypeNodeText);
                        billFirMenu.addChild(billSecMenu);
                    }
                }
            }
            if (CODERULE_NUM.equals(firNumber)) {
                appIdList = DevportalUtil.getAllAppIds((String)inheritPath, (String)bizAppId);
                List codeRules = Collections.emptyList();
                try {
                    codeRules = CodeRuleServiceHelper.getAllCodeRuleByAppId((List)appIdList);
                }
                catch (Exception exception) {
                    this.logger.error("CodeRuleServiceHelper.getAllCodeRuleByAppId\u51fa\u9519", (Throwable)exception);
                    if (StringUtils.isNotBlank((CharSequence)this.detailErrorMsg)) {
                        this.detailErrorMsg.append(ResManager.loadKDString((String)"\uff1b\u7f16\u7801\u89c4\u5219\u83b7\u53d6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u83b7\u53d6\u7f16\u7801\u89c4\u5219\u4fe1\u606f\u63a5\u53e3\u3010CodeRuleServiceHelper.getAllCodeRuleByAppId\u3011\u51fa\u9519%s", (String)"MetaDataDeployHandler_13", (String)"sys-ricc-platform", (Object[])new Object[]{System.lineSeparator()}));
                    } else {
                        this.detailErrorMsg.append(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u83b7\u53d6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u83b7\u53d6\u7f16\u7801\u89c4\u5219\u4fe1\u606f\u63a5\u53e3\u3010CodeRuleServiceHelper.getAllCodeRuleByAppId\u3011\u51fa\u9519", (String)"MetaDataDeployHandler_14", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    }
                    this.detailErrorLogInfo.append(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u83b7\u53d6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u83b7\u53d6\u7f16\u7801\u89c4\u5219\u4fe1\u606f\u63a5\u53e3\u3010CodeRuleServiceHelper.getAllCodeRuleByAppId\u3011\u51fa\u9519\uff0c\u9519\u8bef\u8be6\u60c5\uff1a%1$s%2$s", (String)"MetaDataDeployHandler_15", (String)"sys-ricc-platform", (Object[])new Object[]{exception.getMessage(), System.lineSeparator()}));
                }
                if (codeRules != null && !codeRules.isEmpty()) {
                    TreeNode codeFirMenu = new TreeNode(bizAppId, firNodeId, firNodeName);
                    treeNodeList.add(codeFirMenu);
                    for (CodeRuleInfo codeRule : codeRules) {
                        String codeRuleNodeId = codeRule.getId() + "#cr";
                        TreeNode codesecMenu = new TreeNode(firNodeId, codeRuleNodeId, codeRule.getName());
                        codeFirMenu.addChild(codesecMenu);
                    }
                }
            }
            if (PAGE_NUM.equals(firNumber)) {
                appFilter = new QFilter(BIZAPP, "=", (Object)bizAppId);
                QFilter[] pageFilters = new QFilter[]{appFilter};
                boolean pageExist = QueryServiceHelper.exists((String)BOS_DEVPORTAL_UNITRELFORM, (QFilter[])pageFilters);
                if (!pageExist) continue;
                TreeNode pageFirMenu = new TreeNode(bizAppId, firNodeId, firNodeName);
                treeNodeList.add(pageFirMenu);
                ArrayList formIds = new ArrayList();
                ArrayList formAndUnitIds = new ArrayList();
                Map unitreForms = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_UNITRELFORM, (String)"bizunit,form", (QFilter[])pageFilters);
                unitreForms.forEach((unitreKey, unitreVal) -> {
                    String formId = unitreVal.getString("form");
                    String bizUnitId = unitreVal.getString("bizunit");
                    formIds.add(formId);
                    String formAndUnitId = formId + "\u224c" + bizUnitId;
                    formAndUnitIds.add(formAndUnitId);
                });
                QFilter[] metaFilters = new QFilter[]{new QFilter("id", "in", formIds)};
                Map fromMetaResult = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,name,number", (QFilter[])metaFilters);
                ArrayList formInfos = new ArrayList();
                fromMetaResult.forEach((metaKey, metaValue) -> formAndUnitIds.forEach(form -> {
                    String formId;
                    String[] formAndUnitInfo = form.split("\u224c");
                    if (formAndUnitInfo.length == 2 && (formId = formAndUnitInfo[0]).equals(metaKey)) {
                        String unitId = formAndUnitInfo[1];
                        String formName = metaValue.getLocaleString("name").getLocaleValue();
                        String formNum = metaValue.getString("number");
                        String formInfo = unitId + "\u224c" + formId + "\u224c" + formName + "\u224c" + formNum;
                        formInfos.add(formInfo);
                    }
                }));
                List functionElements = appMeta.getAppFunctionPackets();
                for (AppFunctionPacketElement functionElement : functionElements) {
                    String nodeId = functionElement.getId();
                    String text = (String)functionElement.getName().getDefaultItem();
                    boolean unitFlag = true;
                    TreeNode pageSecMenu = new TreeNode();
                    for (String formInfo : formInfos) {
                        AbstractMetadata abstractMetadata;
                        String bizUnitId = formInfo.split("\u224c")[0];
                        String bizFormId = formInfo.split("\u224c")[1];
                        String bizFormName = formInfo.split("\u224c")[2];
                        String bizFormNum = formInfo.split("\u224c")[3];
                        if ((bizFormName == null || "null".equals(bizFormName)) && (abstractMetadata = MetadataDao.readMeta((String)bizFormId, (MetaCategory)MetaCategory.Form)) instanceof FormMetadata) {
                            FormMetadata metadata = (FormMetadata)abstractMetadata;
                            bizFormName = metadata.getName().getLocaleValue();
                        }
                        if (!bizUnitId.equals(nodeId)) continue;
                        if (unitFlag) {
                            pageSecMenu = new TreeNode(firNodeId, nodeId + SECPAGE, text);
                            pageFirMenu.addChild(pageSecMenu);
                            unitFlag = false;
                        }
                        String pageNodeParentId = nodeId + SECPAGE;
                        String pageNodeId = bizFormId + PAGE;
                        TreeNode pageThiMenu = new TreeNode(pageNodeParentId, bizAppId + "#" + pageNodeId, bizFormName + "-" + bizFormNum);
                        pageSecMenu.addChild(pageThiMenu);
                    }
                }
            }
            if (SCRIPT_NUM.equals(firNumber)) {
                appFilter = new QFilter(BIZAPPID, "=", (Object)bizAppId);
                QFilter[] scriptFiltersExist = new QFilter[]{appFilter};
                boolean scriptExist = QueryServiceHelper.exists((String)"ide_pluginscript", (QFilter[])scriptFiltersExist);
                if (!scriptExist) continue;
                String scriptFields = "id, txt_scriptnumber, txt_scriptname,bizunitid";
                String scriptOrderBy = "txt_scriptnumber";
                Map scriptInfos = BusinessDataServiceHelper.loadFromCache((String)"ide_pluginscript", (String)scriptFields, (QFilter[])scriptFiltersExist, (String)scriptOrderBy);
                TreeNode scriptFirMenu = new TreeNode(bizAppId, firNodeId, firNodeName);
                treeNodeList.add(scriptFirMenu);
                List functionElements = appMeta.getAppFunctionPackets();
                for (AppFunctionPacketElement functionElement : functionElements) {
                    String nodeId = functionElement.getId();
                    String text = (String)functionElement.getName().getDefaultItem();
                    if (scriptInfos.isEmpty()) continue;
                    boolean scriptFlag = true;
                    TreeNode scriptSecMenu = new TreeNode();
                    for (Map.Entry entry : scriptInfos.entrySet()) {
                        DynamicObject scriptInfo = (DynamicObject)entry.getValue();
                        String bizScriptUnitId = scriptInfo.getString("bizunitid");
                        String bizScriptId = scriptInfo.getString("id");
                        String bizScriptName = scriptInfo.getString("txt_scriptname");
                        String bizScriptNum = scriptInfo.getString("txt_scriptnumber");
                        if (!bizScriptUnitId.equals(nodeId)) continue;
                        if (scriptFlag) {
                            scriptSecMenu = new TreeNode(firNodeId, nodeId + SECSCRIPT, text);
                            scriptFirMenu.addChild(scriptSecMenu);
                            scriptFlag = false;
                        }
                        String scriptNodeParentId = nodeId + SECSCRIPT;
                        String scriptNodeId = bizScriptId + SCRIPT;
                        TreeNode scriptThiMenu = new TreeNode(scriptNodeParentId, bizAppId + "#" + scriptNodeId, bizScriptName + "-" + bizScriptNum);
                        scriptSecMenu.addChild(scriptThiMenu);
                    }
                }
            }
            if (!WORKBENCH_NUM.equals(firNumber)) continue;
            QFilter qApp = null;
            String selectFields = "id,number,name,schemetype";
            qApp = "2".equals(appType) ? new QFilter(BIZAPP, "=", (Object)masterAppId) : new QFilter(BIZAPP, "=", (Object)bizAppId);
            QFilter[] filters = new QFilter[]{qApp};
            DynamicObject[] protalSchemaObjects = BusinessDataServiceHelper.load((String)"portal_scheme", (String)selectFields, (QFilter[])filters, (String)"schemetype");
            if (protalSchemaObjects == null || protalSchemaObjects.length <= 0) continue;
            TreeNode workBenchFirMenu = new TreeNode(bizAppId, firNodeId, firNodeName);
            treeNodeList.add(workBenchFirMenu);
            boolean sysWorkBench = true;
            boolean personalWorkBench = true;
            TreeNode workBenchSecMenu = new TreeNode();
            for (DynamicObject protalSchemaObject : protalSchemaObjects) {
                TreeNode workBenchThirMenu;
                String pageSchemeKey = protalSchemaObject.getString("id");
                String pageSchemeName = protalSchemaObject.getLocaleString("name").getLocaleValue();
                String pageSchemeType = protalSchemaObject.getString("schemetype");
                if ("1".equals(pageSchemeType)) {
                    if (sysWorkBench) {
                        workBenchSecMenu = new TreeNode(firNodeId, "workbench#sysmenu#" + bizAppId, ResManager.loadKDString((String)"\u9ed8\u8ba4\u65b9\u6848", (String)"MetaDataDeployHandler_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
                        workBenchFirMenu.addChild(workBenchSecMenu);
                        sysWorkBench = false;
                    }
                    workBenchThirMenu = new TreeNode("workbench#sysmenu#" + bizAppId, pageSchemeKey + "#bench", pageSchemeName);
                    workBenchSecMenu.addChild(workBenchThirMenu);
                    continue;
                }
                if (!"3".equals(pageSchemeType)) continue;
                if (personalWorkBench) {
                    workBenchSecMenu = new TreeNode(firNodeId, "workbench#permenu#" + bizAppId, ResManager.loadKDString((String)"\u4e2a\u6027\u65b9\u6848", (String)"MetaDataDeployHandler_8", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    workBenchFirMenu.addChild(workBenchSecMenu);
                    personalWorkBench = false;
                }
                workBenchThirMenu = new TreeNode("workbench#permenu#" + bizAppId, pageSchemeKey + "#bench", pageSchemeName);
                workBenchSecMenu.addChild(workBenchThirMenu);
            }
        }
        return treeNodeList;
    }

    public static String getFirstNodeText(String appName, String appNumber, String industryName) {
        StringBuilder firNodeText = new StringBuilder("\u3010");
        firNodeText.append(appName);
        firNodeText.append('-');
        firNodeText.append(appNumber);
        if (StringUtils.isNotBlank((CharSequence)industryName)) {
            firNodeText.append('(');
            firNodeText.append(industryName);
            firNodeText.append(')');
        }
        firNodeText.append('\u3011');
        firNodeText.append(ResManager.loadKDString((String)"\u5143\u6570\u636e", (String)"MetaDataDeployHandler_16", (String)"sys-ricc-platform", (Object[])new Object[0]));
        return firNodeText.toString();
    }
}

