/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.metadata;

import com.alibaba.fastjson.JSONArray;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipOutputStream;
import kd.bos.coderule.api.CoderuleFile;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.AppPackageUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.billtype.entity.BillTypeFile;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.sys.ricc.business.configitem.ConfigItemHelper;
import kd.sys.ricc.business.datapacket.core.SubDataPacketDispatch;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;
import org.apache.commons.io.FilenameUtils;

public class MetaDataExportHelper {
    private static final Log logger = LogFactory.getLog(MetaDataExportHelper.class);
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String BOS_DEVPORTAL_BIZCLOUD = "bos_devportal_bizcloud";
    private static final String BIZCLOUD = "bizcloud";
    private static final String KEY_SPLIT = "'-'";
    private static final String DETAILERRORINFO = "detailerrorinfo";
    private static final String DATAMODEL = "datamodel";
    private static final String ZIP_PATH = "zippath";
    private static final String SELECT_APP_PATH = "selectapppath";
    private static final String PREINSDATA = "preinsdata";
    private static final StringBuilder SELECTED_META_INFO = new StringBuilder();
    private IFormView view;
    private AddPacketProgress addPacketProgress;
    private int complete = 0;
    private int total = 0;
    private List<String> crIdList = new ArrayList<String>();

    public MetaDataExportHelper(IFormView view, AddPacketProgress addPacketProgress) {
        this.view = view;
        this.addPacketProgress = addPacketProgress;
    }

    public String exportMetadataByCloud(ListSelectedRow selectedPacket, List<String> selectAppList, Map<String, List<String>> bizIdToIdMap) {
        QFilter idFilter = new QFilter("id", "in", selectAppList);
        DynamicObject[] appInfos = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZAPP, (String)"id,number,isv,name,version,bizcloud.id as cloudid,bizcloud", (QFilter[])new QFilter[]{idFilter});
        if (appInfos.length <= 0) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5e94\u7528\u4fe1\u606f\u5f02\u5e38\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"MetaDataExportHelper_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        this.total = selectAppList.size();
        ScheduleUtil.addPacketFeedbackProgress(this.addPacketProgress, this.total, 0);
        String defaultCloudNum = ((DynamicObject)appInfos[0].get(BIZCLOUD)).getString("number");
        String defaultAppNum = appInfos[0].getString("number");
        String defaultAppVersion = "1.5";
        ArrayList<String> appNums = new ArrayList<String>(16);
        Map<String, List<String>> cloudAppListMap = this.appListGroupByCloud(appInfos, appNums);
        DynamicObject guide = ConfigItemHelper.queryGuideByNumber("ricc_metadata_export", "id,name,number");
        Set<Map.Entry<String, List<String>>> entrySet = cloudAppListMap.entrySet();
        ArrayList<DynamicObject> subdataPackets = new ArrayList<DynamicObject>(entrySet.size());
        try {
            this.complete = 0;
            for (Map.Entry<String, List<String>> entry : entrySet) {
                DynamicObject subdataPacket = this.exportMetadata(selectedPacket, entry.getKey(), defaultCloudNum, defaultAppNum, defaultAppVersion, guide, entry.getValue(), bizIdToIdMap);
                if (subdataPacket == null) {
                    throw new RiccBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u5143\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"MetaDataExportHelper_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                }
                subdataPackets.add(subdataPacket);
            }
            SubDataPacketDispatch.saveBatchSubDataPacket(selectedPacket.getPrimaryKeyValue(), subdataPackets);
        }
        catch (RiccBizException e) {
            logger.error("\u5bfc\u51fa\u5143\u6570\u636e\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5143\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\uff01%s", (String)"MetaDataExportHelper_2", (String)"sys-ricc-platform", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        return "success";
    }

    private Map<String, List<String>> appListGroupByCloud(DynamicObject[] appInfos, List<String> appNums) {
        HashMap<String, List<String>> cloudAppListMap = new HashMap<String, List<String>>(appInfos.length);
        for (DynamicObject oneApp : appInfos) {
            String cloudId = ((DynamicObject)oneApp.get(BIZCLOUD)).getString("id");
            String cloudNumber = ((DynamicObject)oneApp.get(BIZCLOUD)).getString("number");
            String key = cloudId + KEY_SPLIT + cloudNumber;
            String appId = oneApp.getString("id");
            appNums.add(oneApp.getString("number"));
            List<String> appIdList = new ArrayList<String>();
            List keyVal = (List)cloudAppListMap.get(key);
            if (keyVal != null) {
                appIdList = keyVal;
            }
            appIdList.add(appId);
            cloudAppListMap.put(key, appIdList);
        }
        return cloudAppListMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObject exportMetadata(ListSelectedRow selectedPacket, String cloudInfo, String defaultCloudNum, String defaultAppNum, String defaultAppVersion, DynamicObject guide, List<String> selectAppList, Map<String, List<String>> bizIdToIdMap) {
        DynamicObject subDataPacket;
        String appName;
        if (selectAppList == null || selectAppList.isEmpty()) {
            return null;
        }
        String localPath = FileUtils.generateLocalPath();
        String defaultAppPackageName = defaultCloudNum + "-" + defaultAppNum + "-dm";
        String defaultDmPath = localPath + File.separator + defaultAppPackageName;
        String traceIdHash = RequestContext.get().getTraceId();
        String defaultZipPath = defaultDmPath + File.separator + traceIdHash;
        this.view.getPageCache().put(ZIP_PATH, defaultZipPath);
        String defaultAppPath = defaultZipPath + File.separator + DATAMODEL + File.separator + defaultAppVersion + File.separator + "main";
        try {
            File defaultAppFile = FileUtils.createFile((String)defaultAppPath).getCanonicalFile();
            defaultAppFile.mkdirs();
        }
        catch (Exception e) {
            logger.error("\u5b89\u88c5\u5305\u521b\u5efa\u5931\u8d25", (Throwable)e);
            return null;
        }
        ArrayList<String> appZipNames = new ArrayList<String>();
        String detailErrorInfoStr = this.view.getPageCache().get(DETAILERRORINFO);
        StringBuilder detailErrorInfo = new StringBuilder();
        detailErrorInfo.append(detailErrorInfoStr == null ? "" : detailErrorInfoStr);
        List<String> appNumberList = new ArrayList(selectAppList.size());
        SELECTED_META_INFO.delete(0, SELECTED_META_INFO.length());
        AtomicInteger count = new AtomicInteger();
        for (String selectAppId : selectAppList) {
            block42: {
                AppMetadata selectAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)selectAppId, (boolean)false);
                if (selectAppMeta == null) continue;
                JSONArray dbschemaMsg = new JSONArray();
                JSONArray preinsdataMsg = new JSONArray();
                appName = selectAppMeta.getName().getLocaleValue();
                String appNum = selectAppMeta.getNumber();
                SELECTED_META_INFO.append("\n------");
                SELECTED_META_INFO.append(MetaDataExportHelper.getfirstNodeText(appName, appNum, ""));
                SELECTED_META_INFO.append("------");
                String selectAppNum = selectAppMeta.getNumber().toLowerCase();
                appNumberList.add(selectAppNum);
                String selectCloudId = selectAppMeta.getBizCloudID();
                DynamicObject selectCloudObject = BusinessDataServiceHelper.loadSingleFromCache((Object)selectCloudId, (String)BOS_DEVPORTAL_BIZCLOUD, (String)"number");
                String selectCloudNum = selectCloudObject.getString("number").toLowerCase();
                String selectAppPath = defaultAppPath + File.separator + selectAppNum;
                this.view.getPageCache().put(SELECT_APP_PATH, selectAppPath);
                String appPackageName = selectCloudNum + "-" + selectAppNum + "-dm";
                InputStream appMd5Input = null;
                try {
                    DynamicObject cloudObject;
                    File selectAppFile = FileUtils.createFile((String)selectAppPath).getCanonicalFile();
                    if (!selectAppFile.exists()) {
                        selectAppFile.mkdirs();
                    }
                    if (Objects.isNull(cloudObject = BusinessDataServiceHelper.loadSingleFromCache((Object)selectCloudId, (String)BOS_DEVPORTAL_BIZCLOUD, (String)"baseapp,name"))) {
                        detailErrorInfo.append(String.format(ResManager.loadKDString((String)"%1$s\u6240\u5728\u7684\u4e1a\u52a1\u4e91\u3010%2$s\u3011\u4e0d\u5b58\u5728\u3002", (String)"MetaDataExportHelper_3", (String)"sys-ricc-platform", (Object[])new Object[0]), appName, selectCloudId));
                        continue;
                    }
                    DevportalUtil.expCloudMetadata((String)selectCloudId, (String)selectAppPath, (String)"EXPORT_CLOUD");
                    SELECTED_META_INFO.append('\n').append(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91\uff1a", (String)"MetaDataExportHelper_4", (String)"sys-ricc-platform", (Object[])new Object[0])).append('\n');
                    SELECTED_META_INFO.append(cloudObject.getString("name"));
                    SELECTED_META_INFO.append('-');
                    SELECTED_META_INFO.append(selectCloudId);
                    DevportalUtil.expAppMetadata((String)selectAppId, (String)selectAppPath, (String)"EXPORT_APP");
                    SELECTED_META_INFO.append("\n\n").append(ResManager.loadKDString((String)"\u5e94\u7528\u4fe1\u606f(\u5305\u62ec\u83dc\u5355\u3001\u529f\u80fd\u5206\u7ec4)\u5982\u4e0b\u3002", (String)"MetaDataExportHelper_5", (String)"sys-ricc-platform", (Object[])new Object[0])).append('\n');
                    SELECTED_META_INFO.append(appName);
                    SELECTED_META_INFO.append('\n');
                    SELECTED_META_INFO.append('\n').append(ResManager.loadKDString((String)"\u9875\u9762\uff1a", (String)"MetaDataExportHelper_6", (String)"sys-ricc-platform", (Object[])new Object[0])).append('\n');
                    if (!bizIdToIdMap.get(selectAppId).isEmpty()) {
                        for (String pageId : bizIdToIdMap.get(selectAppId)) {
                            if (!QueryServiceHelper.exists((String)"bos_formmeta", (Object)pageId)) continue;
                            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)pageId, (String)"bos_formmeta");
                            DevportalUtil.expFormMetadata((String)pageId, (String)selectAppPath, (String)"EXPORT_PAGE");
                            SELECTED_META_INFO.append(obj.getLocaleString("name").getLocaleValue());
                            SELECTED_META_INFO.append('-');
                            SELECTED_META_INFO.append(obj.getString("number"));
                            SELECTED_META_INFO.append('\n');
                        }
                    }
                    ArrayList sqlNameList = new ArrayList();
                    boolean hasXmlFlag = false;
                    AppPackageUtil.createDataModelXML((String)selectAppId, (String)selectAppNum, (String)selectCloudNum, (String)defaultAppVersion, (String)defaultZipPath);
                    AppPackageUtil.createAppXML((String)selectAppId, (String)selectAppNum, (String)selectAppPath, (JSONArray)dbschemaMsg, (JSONArray)preinsdataMsg, sqlNameList, (boolean)hasXmlFlag);
                    this.view.getPageCache().remove(SELECT_APP_PATH);
                    ArrayList fileList = new ArrayList();
                    String datamodelPath = defaultZipPath + File.separator + DATAMODEL;
                    List appSourceList = DevportalUtil.recursiveFiles((String)datamodelPath, fileList);
                    count.getAndAdd(appSourceList.size());
                    StringBuilder appRelPathBuilder = new StringBuilder();
                    appSourceList.forEach(appSource -> {
                        int datamodelIndex = appSource.indexOf(DATAMODEL);
                        String appRelPath = appSource.substring(datamodelIndex + DATAMODEL.length());
                        if (!appRelPath.endsWith("filelist.txt")) {
                            appRelPathBuilder.append(appRelPath);
                            appRelPathBuilder.append(System.lineSeparator());
                        }
                    });
                    String appInfoPath = datamodelPath + File.separator + "filelist.txt";
                    this.createLogInfo(appRelPathBuilder.toString(), appInfoPath);
                    this.zipDmFile(appPackageName);
                    appZipNames.add(appPackageName);
                    String dmPath = defaultZipPath + File.separator + "dm" + File.separator + appPackageName + ".zip";
                    Path zipPath = Paths.get(DevportalUtil.checkFilePath((String)dmPath), new String[0]);
                    appMd5Input = Files.newInputStream(zipPath, new OpenOption[0]);
                    if (!selectAppFile.exists()) break block42;
                    AppUtils.deleteKd((File)selectAppFile);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    DynamicObject dynamicObject = null;
                    return dynamicObject;
                }
                finally {
                    if (appMd5Input == null) continue;
                    try {
                        appMd5Input.close();
                    }
                    catch (Exception exception) {
                        logger.error((Throwable)exception);
                        AppUtils.addLog((String)BOS_DEVPORTAL_BIZAPP, (String)"io", (String)exception.getMessage());
                    }
                    continue;
                }
            }
            ScheduleUtil.addPacketFeedbackProgress(this.addPacketProgress, this.total, ++this.complete);
        }
        try {
            String packagePath;
            String appSequenceInfo = this.view.getPageCache().get("appsequenceinfo");
            if (StringUtils.isNotBlank((CharSequence)appSequenceInfo)) {
                appNumberList = (List)SerializationUtils.fromJsonString((String)appSequenceInfo, List.class);
            }
            if (appNumberList != null && !appNumberList.isEmpty()) {
                packagePath = defaultZipPath + File.separator + "appInfo.xml";
                AppPackageUtil.createAppInfo((String)defaultZipPath, appNumberList, (String)packagePath);
                count.getAndIncrement();
            }
            if (detailErrorInfo.length() > 0) {
                packagePath = defaultZipPath + File.separator + "errorInfo.txt";
                this.createLogInfo(detailErrorInfo.toString(), packagePath);
            }
            DevportalUtil.zipFiles(appZipNames, (String)defaultZipPath, (String)defaultAppPackageName);
            String downloadPath = defaultZipPath + File.separator + defaultAppPackageName + ".zip";
            String fileName = guide.getString("number") + "_" + System.currentTimeMillis() + ".zip";
            String uploadPath = SysParaUtil.getSavePath() + selectedPacket.getNumber();
            List list = CommonUtil.uploadDataPacket((Object)selectedPacket.getPrimaryKeyValue(), (String)localPath, (String)downloadPath, (String)uploadPath, (String)fileName);
            if (list.isEmpty()) {
                logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
                appName = null;
                return appName;
            }
            HashMap<String, Object> custParam = new HashMap<String, Object>();
            String[] cloudInfoArr = cloudInfo.split(KEY_SPLIT);
            custParam.put("cloudId", cloudInfoArr[0]);
            custParam.put("cloudNumber", cloudInfoArr[1]);
            subDataPacket = SubDataPacketDispatch.createEntryRow(DataPacketTypeEnum.CONFIG.getVal(), guide.getLong("id"), -1, ((DynamicObject)list.get(0)).getLong("id"), fileName, custParam, SELECTED_META_INFO.toString(), count.get());
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5143\u6570\u636e\u5f02\u5e38\u3002", (Throwable)e);
            DynamicObject dynamicObject = null;
            return dynamicObject;
        }
        finally {
            try {
                File zipFile = FileUtils.createFile((String)defaultZipPath).getCanonicalFile();
                if (zipFile.exists()) {
                    boolean deleteFlag;
                    AppUtils.deleteKd((File)zipFile);
                    String appNumberStr = localPath + File.separator + defaultAppPackageName;
                    File appNumberPath = FileUtils.createFile((String)appNumberStr);
                    if (appNumberPath.listFiles().length == 0 && !(deleteFlag = appNumberPath.delete())) {
                        logger.warn("delete file" + appNumberPath.getAbsolutePath() + "fail.");
                    }
                }
            }
            catch (Exception ioExp) {
                logger.error((Throwable)ioExp);
                AppUtils.addLog((String)BOS_DEVPORTAL_BIZAPP, (String)"io", (String)ioExp.getMessage());
            }
        }
        return subDataPacket;
    }

    public void exportSource(Object objectFile, String appPath) {
        block32: {
            String fileName = "";
            List dataList = Collections.emptyList();
            if (objectFile instanceof CoderuleFile) {
                fileName = ((CoderuleFile)objectFile).getFileName();
                dataList = ((CoderuleFile)objectFile).getFileContent();
            } else if (objectFile instanceof BillTypeFile) {
                fileName = ((BillTypeFile)objectFile).getFileName();
                dataList = ((BillTypeFile)objectFile).getFileContent();
            }
            Path filePath = Paths.get(FileUtils.cleanString((String)appPath), PREINSDATA, FilenameUtils.getName((String)(fileName + ".sql")));
            File file = FileUtils.createFile((String)filePath.toString());
            File coderuleAboveFile = file.getParentFile();
            if (!coderuleAboveFile.exists()) {
                coderuleAboveFile.mkdirs();
            }
            if (!file.exists()) {
                try {
                    boolean fileCreate = file.createNewFile();
                    if (!fileCreate) break block32;
                    Path customZipPath = Paths.get(DevportalUtil.checkFilePath((String)filePath.toString()), new String[0]);
                    try (OutputStream outputStream = Files.newOutputStream(customZipPath, new OpenOption[0]);
                         OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                        for (String data : dataList) {
                            writer.write(data + System.lineSeparator());
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLogInfo(String detailErrorInfo, String packagePath) {
        String checkPackagePath = DevportalUtil.checkFilePath((String)packagePath);
        File packageFile = FileUtils.createFile((String)packagePath);
        OutputStream fos = null;
        try {
            boolean packageCreate;
            boolean delete;
            if (packageFile.exists() && !(delete = packageFile.delete())) {
                logger.warn("delete file" + packageFile.getAbsolutePath() + "fail.");
            }
            if (packageCreate = packageFile.createNewFile()) {
                Path customZipPath = Paths.get(checkPackagePath, new String[0]);
                fos = Files.newOutputStream(customZipPath, new OpenOption[0]);
                fos.write(detailErrorInfo.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            AppUtils.addLog((String)BOS_DEVPORTAL_BIZAPP, (String)"createLogInfo", (String)e.getMessage());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {
                    logger.error((Throwable)exception);
                    AppUtils.addLog((String)BOS_DEVPORTAL_BIZAPP, (String)"createLogInfo", (String)exception.getMessage());
                }
            }
        }
    }

    public void zipDmFile(String appPackageName) {
        File dmFile;
        String zipPath = this.view.getPageCache().get(ZIP_PATH);
        JSONArray files = new JSONArray();
        File file = FileUtils.createFile((String)zipPath);
        if (file.exists()) {
            files.add((Object)zipPath);
        }
        if (!(dmFile = FileUtils.createFile((String)(zipPath + File.separator + "dm"))).exists()) {
            dmFile.mkdirs();
        }
        String zipFilePath = zipPath + File.separator + "dm" + File.separator + appPackageName + ".zip";
        Path customZipPath = Paths.get(DevportalUtil.checkFilePath((String)zipFilePath), new String[0]);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(customZipPath, new OpenOption[0]));){
            DevportalUtil.zipFile((JSONArray)files, (ZipOutputStream)out, (String)"");
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new RiccBizException((Throwable)e);
        }
    }

    public static String getfirstNodeText(String appName, String appNumber, String industryName) {
        StringBuilder firNodeText = new StringBuilder("\u3010");
        firNodeText.append(appName);
        firNodeText.append('-');
        firNodeText.append(appNumber);
        if (StringUtils.isNotBlank((CharSequence)industryName)) {
            firNodeText.append('(');
            firNodeText.append(industryName);
            firNodeText.append(')');
        }
        firNodeText.append('\u3011');
        firNodeText.append(ResManager.loadKDString((String)"\u5143\u6570\u636e", (String)"MetaDataExportHelper_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
        return firNodeText.toString();
    }
}

