/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.metadata.compare;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IFormView;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sys.ricc.business.metadata.compare.RuntimeMetaInfo;
import kd.sys.ricc.common.util.FormViewUtil;
import kd.sys.ricc.common.util.StringUtils;

public class MetaDataCompareHelper {
    public static final String META_DATA_COMPARE_ENTRY = "metadatacompareentry";
    private static final String HAS_DIFF = "hasdiff";
    private static final String SRC_ID = "srcid";
    private static final String SRC_NUMBER = "srcnumber";
    private static final String SRC_NAME = "srcname";
    private static final String SRC_VERSION = "srcversion";
    private static final String SRC_MODIFY_TIME = "srcmodifytime";
    private static final String TAR_ID = "tarid";
    private static final String TAR_NUMBER = "tarnumber";
    private static final String TAR_NAME = "tarname";
    private static final String TAR_VERSION = "tarversion";
    private static final String TAR_MODIFY_TIME = "tarmodifytime";
    private static final String ISV = "isv";
    private static final String TAR_ISV = "tarisv";
    private static final String SRC_ISV = "srcisv";
    public static final String HASDIFF = "1";

    private MetaDataCompareHelper() {
    }

    public static RuntimeMetaInfo getRuntimeMetaInfoByNumber(String number) {
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        DynamicObject bosFormMeta = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id,number,name,isv,version,parentid,modifydate", (QFilter[])qFilter.toArray());
        if (bosFormMeta == null) {
            return null;
        }
        RuntimeMetaInfo parentRuntimeMetaInfo = MetaDataCompareHelper.buildRuntimeMetaInfo(bosFormMeta);
        MetaDataCompareHelper.getExtendRuntimeMetaInfo(parentRuntimeMetaInfo);
        return parentRuntimeMetaInfo;
    }

    public static List<RuntimeMetaInfo> getRuntimeMetaInfoByNumbers(List<String> numbers, boolean isCompareExt) {
        QFilter qFilter = new QFilter("number", "in", numbers);
        Map bosFormmetaMap = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,number,name,isv,version,parentid,modifydate", (QFilter[])qFilter.toArray());
        if (bosFormmetaMap == null) {
            return null;
        }
        List<RuntimeMetaInfo> parentRuntimeMetaInfos = bosFormmetaMap.values().stream().map(o -> MetaDataCompareHelper.buildRuntimeMetaInfo(o)).collect(Collectors.toList());
        if (isCompareExt) {
            MetaDataCompareHelper.getExtendRuntimeMetaInfo(parentRuntimeMetaInfos);
        }
        return parentRuntimeMetaInfos;
    }

    public static List<DynamicObject> getRuntimeMetaInfoByNumbers(List<String> numbers) {
        QFilter qFilter = new QFilter("number", "in", numbers);
        Map bosFormmetaMap = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,number,name,isv,version,parentid,modifydate,bizappid", (QFilter[])qFilter.toArray());
        if (bosFormmetaMap == null) {
            return null;
        }
        return bosFormmetaMap.values().stream().collect(Collectors.toList());
    }

    public static void getExtendRuntimeMetaInfo(RuntimeMetaInfo parentRuntimeMetaInfo) {
        String pid = parentRuntimeMetaInfo.getId();
        QFilter qFilter = new QFilter("parentid", "=", (Object)pid);
        qFilter.and(new QFilter("type", "=", (Object)Character.valueOf('2')));
        Map extendMetaMap = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,number,name,isv,version,parentid,modifydate", (QFilter[])qFilter.toArray());
        if (extendMetaMap == null) {
            return;
        }
        Collection extendMetas = extendMetaMap.values();
        for (DynamicObject extendMeta : extendMetas) {
            RuntimeMetaInfo runtimeMetaInfo = MetaDataCompareHelper.buildRuntimeMetaInfo(extendMeta);
            parentRuntimeMetaInfo.addExtendMeta(runtimeMetaInfo);
            MetaDataCompareHelper.getExtendRuntimeMetaInfo(runtimeMetaInfo);
        }
    }

    public static void getExtendRuntimeMetaInfo(List<RuntimeMetaInfo> parentRuntimeMetaInfos) {
        List ids = parentRuntimeMetaInfos.stream().map(o -> o.getId()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("parentid", "in", ids);
        qFilter.and(new QFilter("type", "=", (Object)Character.valueOf('2')));
        Map extendMetaMap = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,number,name,isv,version,parentid,modifydate", (QFilter[])qFilter.toArray());
        if (extendMetaMap == null) {
            return;
        }
        Collection extendMetas = extendMetaMap.values();
        for (RuntimeMetaInfo parentRuntimeMetaInfo : parentRuntimeMetaInfos) {
            for (DynamicObject extendMeta : extendMetas) {
                if (!StringUtils.equals((String)extendMeta.getDynamicObject("parentid").getString("id"), (String)parentRuntimeMetaInfo.getId())) continue;
                RuntimeMetaInfo runtimeMetaInfo = MetaDataCompareHelper.buildRuntimeMetaInfo(extendMeta);
                parentRuntimeMetaInfo.addExtendMeta(runtimeMetaInfo);
                MetaDataCompareHelper.getExtendRuntimeMetaInfo(Collections.singletonList(runtimeMetaInfo));
            }
        }
    }

    public static RuntimeMetaInfo buildRuntimeMetaInfo(DynamicObject bosFormMeta) {
        RuntimeMetaInfo runtimeMetaInfo = new RuntimeMetaInfo();
        runtimeMetaInfo.setId(bosFormMeta.getString("id"));
        runtimeMetaInfo.setNumber(bosFormMeta.getString("number"));
        runtimeMetaInfo.setName(bosFormMeta.getLocaleString("name").getLocaleValue());
        runtimeMetaInfo.setIsv(bosFormMeta.getString(ISV));
        runtimeMetaInfo.setVersion(bosFormMeta.getString("version"));
        runtimeMetaInfo.setModifyDate(DateUtils.formatDateTime((Date)bosFormMeta.getDate("modifydate")));
        runtimeMetaInfo.setParentId(bosFormMeta.getString("parentid"));
        return runtimeMetaInfo;
    }

    public static void buildMetaEntry(RuntimeMetaInfo srcRuntimeMetaInfo, RuntimeMetaInfo tarRuntimeMetaInfo, int rowIndex, int insertIndex, IFormView formView, List<CellStyle> cellStyles) {
        Map<Object, Object> srcExtendMeta = Collections.emptyMap();
        Map<Object, Object> tarExtendMeta = Collections.emptyMap();
        IDataModel model = formView.getModel();
        if (tarRuntimeMetaInfo != null) {
            model.setValue("number", (Object)tarRuntimeMetaInfo.getNumber(), insertIndex);
            model.setValue("name", (Object)tarRuntimeMetaInfo.getName(), insertIndex);
            model.setValue(TAR_ISV, (Object)tarRuntimeMetaInfo.getIsv(), insertIndex);
            model.setValue(TAR_ID, (Object)tarRuntimeMetaInfo.getId(), insertIndex);
            model.setValue(TAR_NUMBER, (Object)tarRuntimeMetaInfo.getNumber(), insertIndex);
            model.setValue(TAR_NAME, (Object)tarRuntimeMetaInfo.getName(), insertIndex);
            model.setValue(TAR_VERSION, (Object)tarRuntimeMetaInfo.getVersion(), insertIndex);
            model.setValue(TAR_MODIFY_TIME, (Object)tarRuntimeMetaInfo.getModifyDate(), insertIndex);
            tarExtendMeta = tarRuntimeMetaInfo.getExtendMeta();
        }
        if (srcRuntimeMetaInfo != null) {
            model.setValue("number", (Object)srcRuntimeMetaInfo.getNumber(), insertIndex);
            model.setValue("name", (Object)srcRuntimeMetaInfo.getName(), insertIndex);
            model.setValue(SRC_ISV, (Object)srcRuntimeMetaInfo.getIsv(), insertIndex);
            model.setValue(SRC_ID, (Object)srcRuntimeMetaInfo.getId(), insertIndex);
            model.setValue(SRC_NUMBER, (Object)srcRuntimeMetaInfo.getNumber(), insertIndex);
            model.setValue(SRC_NAME, (Object)srcRuntimeMetaInfo.getName(), insertIndex);
            model.setValue(SRC_VERSION, (Object)srcRuntimeMetaInfo.getVersion(), insertIndex);
            model.setValue(SRC_MODIFY_TIME, (Object)srcRuntimeMetaInfo.getModifyDate(), insertIndex);
            srcExtendMeta = srcRuntimeMetaInfo.getExtendMeta();
        }
        MetaDataCompareHelper.setDiffStatus(srcRuntimeMetaInfo, tarRuntimeMetaInfo, rowIndex, insertIndex, formView, cellStyles);
        if (!srcExtendMeta.isEmpty() || !tarExtendMeta.isEmpty()) {
            int insertRowNum;
            Set entries = srcExtendMeta.entrySet();
            for (Map.Entry entry : entries) {
                String isv = (String)entry.getKey();
                RuntimeMetaInfo srcExRuntimeMetaInfo = (RuntimeMetaInfo)entry.getValue();
                RuntimeMetaInfo tarExRuntimeMetaInfo = (RuntimeMetaInfo)tarExtendMeta.remove(isv);
                insertRowNum = model.insertEntryRow(META_DATA_COMPARE_ENTRY, insertIndex);
                MetaDataCompareHelper.buildMetaEntry(srcExRuntimeMetaInfo, tarExRuntimeMetaInfo, rowIndex, insertRowNum, formView, cellStyles);
            }
            if (!tarExtendMeta.isEmpty()) {
                Set tarEntries = tarExtendMeta.entrySet();
                for (Map.Entry tarEntry : tarEntries) {
                    RuntimeMetaInfo tarExRuntimeMetaInfo = (RuntimeMetaInfo)tarEntry.getValue();
                    insertRowNum = model.insertEntryRow(META_DATA_COMPARE_ENTRY, insertIndex);
                    MetaDataCompareHelper.buildMetaEntry(null, tarExRuntimeMetaInfo, rowIndex, insertRowNum, formView, cellStyles);
                }
            }
        }
    }

    public static void setDiffStatus(RuntimeMetaInfo srcRuntimeMetaInfo, RuntimeMetaInfo tarRuntimeMetaInfo, int rowIndex, int insertIndex, IFormView formView, List<CellStyle> cellStyles) {
        if (srcRuntimeMetaInfo == null && tarRuntimeMetaInfo == null) {
            return;
        }
        IDataModel model = formView.getModel();
        if (srcRuntimeMetaInfo == null && tarRuntimeMetaInfo != null) {
            model.setValue(HAS_DIFF, (Object)HASDIFF, insertIndex);
            model.setValue(HAS_DIFF, (Object)HASDIFF, rowIndex);
            MetaDataCompareHelper.buildDiffCellStyle(TAR_ID, insertIndex, cellStyles);
            MetaDataCompareHelper.buildDiffCellStyle(TAR_NUMBER, insertIndex, cellStyles);
            MetaDataCompareHelper.buildDiffCellStyle(TAR_NAME, insertIndex, cellStyles);
            MetaDataCompareHelper.buildDiffCellStyle(TAR_VERSION, insertIndex, cellStyles);
            MetaDataCompareHelper.buildDiffCellStyle(TAR_MODIFY_TIME, insertIndex, cellStyles);
            MetaDataCompareHelper.buildDiffCellStyle(TAR_ISV, insertIndex, cellStyles);
            return;
        }
        if (srcRuntimeMetaInfo != null && tarRuntimeMetaInfo == null) {
            model.setValue(HAS_DIFF, (Object)HASDIFF, insertIndex);
            model.setValue(HAS_DIFF, (Object)HASDIFF, rowIndex);
            MetaDataCompareHelper.buildDiffCellStyle(SRC_ID, insertIndex, cellStyles);
            MetaDataCompareHelper.buildDiffCellStyle(SRC_NUMBER, insertIndex, cellStyles);
            MetaDataCompareHelper.buildDiffCellStyle(SRC_NAME, insertIndex, cellStyles);
            MetaDataCompareHelper.buildDiffCellStyle(SRC_VERSION, insertIndex, cellStyles);
            MetaDataCompareHelper.buildDiffCellStyle(SRC_MODIFY_TIME, insertIndex, cellStyles);
            MetaDataCompareHelper.buildDiffCellStyle(SRC_ISV, insertIndex, cellStyles);
            return;
        }
        if (!srcRuntimeMetaInfo.getId().equals(tarRuntimeMetaInfo.getId())) {
            model.setValue(HAS_DIFF, (Object)HASDIFF, insertIndex);
            model.setValue(HAS_DIFF, (Object)HASDIFF, rowIndex);
            MetaDataCompareHelper.buildDiffCellStyle(TAR_ID, insertIndex, cellStyles);
            MetaDataCompareHelper.buildDiffCellStyle(SRC_ID, insertIndex, cellStyles);
        }
        if (!srcRuntimeMetaInfo.getNumber().equals(tarRuntimeMetaInfo.getNumber())) {
            model.setValue(HAS_DIFF, (Object)HASDIFF, insertIndex);
            model.setValue(HAS_DIFF, (Object)HASDIFF, rowIndex);
            MetaDataCompareHelper.buildDiffCellStyle(TAR_NUMBER, insertIndex, cellStyles);
            MetaDataCompareHelper.buildDiffCellStyle(SRC_NUMBER, insertIndex, cellStyles);
        }
        if (!srcRuntimeMetaInfo.getVersion().equals(tarRuntimeMetaInfo.getVersion())) {
            model.setValue(HAS_DIFF, (Object)HASDIFF, insertIndex);
            model.setValue(HAS_DIFF, (Object)HASDIFF, rowIndex);
            MetaDataCompareHelper.buildDiffCellStyle(TAR_VERSION, insertIndex, cellStyles);
            MetaDataCompareHelper.buildDiffCellStyle(SRC_VERSION, insertIndex, cellStyles);
        }
        if (!srcRuntimeMetaInfo.getIsv().equals(tarRuntimeMetaInfo.getIsv())) {
            model.setValue(HAS_DIFF, (Object)HASDIFF, insertIndex);
            model.setValue(HAS_DIFF, (Object)HASDIFF, rowIndex);
            MetaDataCompareHelper.buildDiffCellStyle(TAR_ISV, insertIndex, cellStyles);
            MetaDataCompareHelper.buildDiffCellStyle(SRC_ISV, insertIndex, cellStyles);
        }
        FormViewUtil.setCellStyle(cellStyles, (String)META_DATA_COMPARE_ENTRY, (IFormView)formView);
    }

    public static void buildDiffCellStyle(String key, int rowIndex, List<CellStyle> cellStyles) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setForeColor("red");
        cellStyle.setRow(rowIndex);
        cellStyle.setFieldKey(key);
        cellStyles.add(cellStyle);
    }
}

