/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.training;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.sysint.servicehelper.service.impl.CloudUserRelationServiceImpl;
import kd.bos.util.StringUtils;

public class KdCloudUtils {
    public static String getCurKdCloudUId() {
        return KdCloudUtils.getKdCloudUId(UserServiceHelper.getCurrentUserId());
    }

    public static String getKdCloudUId(Long userId) {
        return KdCloudUtils.getKdCloudField(userId, "uid", () -> "");
    }

    public static DynamicObject getKdCloudInfo(Long userId) {
        CloudUserRelationServiceImpl cloudUserRelationService = new CloudUserRelationServiceImpl();
        DynamicObject[] data = cloudUserRelationService.getCloudUserRelation(userId);
        return data != null && data.length > 0 ? data[0] : null;
    }

    public static <T> T getKdCloudField(Long userId, String field, Supplier<T> supplier) {
        CloudUserRelationServiceImpl cloudUserRelationService = new CloudUserRelationServiceImpl();
        DynamicObject[] data = cloudUserRelationService.getCloudUserRelation(userId);
        return (T)(data != null && data.length > 0 ? data[0].get(field) : supplier.get());
    }

    public static List<Long> getBindingCloudUserIds() {
        DynamicObject[] data;
        ArrayList<Long> cloudUserIds = new ArrayList<Long>(16);
        for (DynamicObject datum : data = BusinessDataServiceHelper.load((String)"bos_cloud_user_relation", (String)"user, uid", null)) {
            DynamicObject user;
            String uid = datum.getString("uid");
            if (StringUtils.isEmpty((String)uid) || (user = datum.getDynamicObject("user")) == null) continue;
            cloudUserIds.add(user.getLong("id"));
        }
        return cloudUserIds;
    }

    public static <T> List<String> getBindingCloudUserUIds(Collection<T> userIds) {
        DynamicObject[] data;
        ArrayList<String> cloudUserUIds = new ArrayList<String>(16);
        QFilter qFilter = new QFilter("user", "in", userIds);
        for (DynamicObject datum : data = BusinessDataServiceHelper.load((String)"bos_cloud_user_relation", (String)"user, uid", (QFilter[])qFilter.toArray())) {
            String uid = datum.getString("uid");
            if (StringUtils.isEmpty((String)uid)) continue;
            cloudUserUIds.add(uid);
        }
        return cloudUserUIds;
    }

    public static DynamicObject[] getKdCloudUserRelation(List<String> uIds) {
        QFilter qFilter = new QFilter("uid", "in", uIds);
        return BusinessDataServiceHelper.load((String)"bos_cloud_user_relation", (String)"user, uid, identity", (QFilter[])qFilter.toArray());
    }
}

