/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.training;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.util.Pair;
import kd.sys.ricc.business.training.CommonMethod;
import kd.sys.ricc.business.training.KdCloudUtils;
import kd.sys.ricc.business.training.TrainConfigUtils;
import kd.sys.ricc.business.training.TrainCourseUtils;
import kd.sys.ricc.common.entity.InvokeParam;

public interface TrainCommonMethod
extends CommonMethod {
    public Map<String, Supplier<String>> getExecMap();

    default public void invokeSaveCheck(IFormPlugin plugin, String execKey) {
        Pair<String, String> envConfigPair = TrainConfigUtils.getEnvConfig();
        if (StringUtils.isEmpty((CharSequence)((CharSequence)envConfigPair.getKey())) || StringUtils.isEmpty((CharSequence)((CharSequence)envConfigPair.getValue()))) {
            this.showSaveCheckPage(plugin, execKey);
            return;
        }
        Supplier<String> exec = this.getExecMap().get(execKey);
        if (exec != null) {
            exec.get();
        }
    }

    default public void showSaveCheckPage(IFormPlugin plugin, String execKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ricc_consumerconfig");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "SaveCheck#" + execKey));
        this.getView().showForm(showParameter);
    }

    default public void invokeCloudCheck(IFormPlugin plugin, String execKey) {
        String kdCloudUId = KdCloudUtils.getCurKdCloudUId();
        if (StringUtils.isEmpty((CharSequence)kdCloudUId)) {
            this.showCloudBindingPage(plugin, execKey);
            return;
        }
        Supplier<String> exec = this.getExecMap().get(execKey);
        if (exec != null) {
            exec.get();
        }
    }

    default public void showCloudBindingPage(IFormPlugin plugin, String execKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_account_binding");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "CloudBinding#" + execKey));
        this.getView().showForm(showParameter);
    }

    default public void dealClosedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Object retData = event.getReturnData();
        String[] split = actionId.split("#");
        if (split.length != 2 || this.checkIsFail(split, retData)) {
            this.dealFailClosedBack(actionId);
            return;
        }
        Map<String, Supplier<String>> execMap = this.getExecMap();
        Supplier<String> exec = execMap.get(split[1]);
        if (exec != null) {
            exec.get();
        }
    }

    default public boolean checkIsFail(String[] actionStrArray, Object retData) {
        if ("SaveCheck".equals(actionStrArray[0])) {
            return !"success".equals(retData);
        }
        if ("CloudBinding".equals(actionStrArray[0])) {
            String kdCloudUId = KdCloudUtils.getCurKdCloudUId();
            return StringUtils.isEmpty((CharSequence)kdCloudUId);
        }
        return true;
    }

    default public void dealFailClosedBack(String actionId) {
    }

    default public void invokeFrontMethod(String controlKey, String frontMethod, Object dataObj, String callbackEndMethod) {
        InvokeParam invokeParam = new InvokeParam();
        invokeParam.setUuidString(TrainCourseUtils.getUuidIdWithDataString());
        invokeParam.setFrontMethod(frontMethod);
        if (dataObj != null) {
            invokeParam.setDataObject(dataObj);
        }
        if (StringUtils.isNotEmpty((CharSequence)callbackEndMethod)) {
            invokeParam.setCallbackEndMethod(callbackEndMethod);
        }
        this.updateFrontData(controlKey, invokeParam);
    }

    default public void updateFrontData(String controlKey, Object frontData) {
        IFormView view = this.getView();
        if (view == null) {
            return;
        }
        CustomControl customControl = (CustomControl)view.getControl(controlKey);
        customControl.setData(frontData);
    }

    default public void viewLearningDetails(Long userId, String type) {
        this.viewLearningDetails(Collections.singletonList(userId), type);
    }

    default public void viewLearningDetails(List<Long> userIds, String type) {
        IFormView view = this.getView();
        if (view == null) {
            return;
        }
        this.checkPermission("ricc_learningrecord", "learndetail");
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("ricc_learningdetail");
        showParameter.setFormId("bos_list");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setHasRight(true);
        showParameter.setCustomParam("user", (Object)JSON.toJSONString(userIds));
        showParameter.setCustomParam("type", (Object)type);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

