/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.training;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class TrainRoleUserUtils {
    static Map<String, Set<Long>> getRoleUserMap() {
        HashMap<String, Set<Long>> roleUserMap = new HashMap<String, Set<Long>>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FBASEDATAID,FUSERSTR FROM T_RICC_ASSIGN_ROLE WHERE FID = 0", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"queryAssignRole", (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                String roleId = row.getString("FBASEDATAID");
                String userStr = row.getString("FUSERSTR");
                if (!StringUtils.isNotEmpty((String)userStr)) continue;
                roleUserMap.put(roleId, (Set<Long>)JSON.parseObject((String)userStr, (TypeReference)new TypeReference<Set<Long>>(){}, (Feature[])new Feature[0]));
            }
        }
        return roleUserMap;
    }

    public static void saveRoleUserMap(List<String> toSaveRoles, Map<String, Set<Long>> roleUserMap) {
        if (CollectionUtils.isEmpty(toSaveRoles)) {
            return;
        }
        String sql = "UPDATE T_RICC_ASSIGN_ROLE SET FUSERSTR = ? WHERE FID = 0 AND FBASEDATAID = ?";
        ArrayList params = new ArrayList(16);
        toSaveRoles.forEach(roleId -> {
            Set userIds = (Set)roleUserMap.get(roleId);
            params.add(new Object[]{JSON.toJSONString((Object)userIds), roleId});
        });
        int[] result = DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)sql, params);
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(16);
        for (int i = 0; i < result.length; ++i) {
            int count = result[i];
            if (count != 0 || i >= params.size()) continue;
            Object[] param = (Object[])params.get(i);
            insertParams.add(new Object[]{DB.genGlobalLongId(), param[1], param[0]});
        }
        if (insertParams.size() != 0) {
            sql = "INSERT INTO T_RICC_ASSIGN_ROLE(FPKID,FID,FBASEDATAID,FUSERSTR) VALUES (?,0,?,?)";
            DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)sql, insertParams);
        }
    }
}

