/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.training.task;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sys.ricc.business.training.TrainCourseUtils;

public class LearnRecordUpdateTask
implements Runnable {
    private static final Log log = LogFactory.getLog(LearnRecordUpdateTask.class);
    private final List<Long> courseLists;
    private long sleepTimes = 0L;
    private CountDownLatch countDownLatch;

    public LearnRecordUpdateTask() {
        this.courseLists = TrainCourseUtils.getOwnCourseLists();
    }

    public LearnRecordUpdateTask(List<Long> courseLists, long sleepTimes, CountDownLatch countDownLatch) {
        this.courseLists = courseLists;
        this.sleepTimes = sleepTimes;
        this.countDownLatch = countDownLatch;
    }

    @Override
    public void run() {
        try {
            if (this.sleepTimes != 0L) {
                Thread.sleep(this.sleepTimes);
            }
            TrainCourseUtils.updateCloudLearnRecords(this.courseLists);
        }
        catch (Exception ex) {
            log.error("LearnRecordUpdateTask_updateError", (Throwable)ex);
        }
        finally {
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
        }
    }
}

