/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.batchdatacompare;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.business.configitem.ConfigItemHelper;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.enums.DataSelectWayEnum;
import kd.sys.ricc.common.enums.PacketEntryStatusEnum;
import kd.sys.ricc.common.helper.DataCompareHelper;
import kd.sys.ricc.common.query.CommonQuery;
import kd.sys.ricc.common.util.OpenFilterFormUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.exception.RiccBizException;

public class DataComparePlanPlugin
extends AbstractBasePlugIn
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final String MANUAL_SELECT_CLOSE_ACTION = "manualselectcloseaction";
    private static final String COMPARE = "compare";
    private static final String COMPARE_REPORT = "comparereport";
    private static final String FILTER_TERM_L = "filterterm_l";
    private static final String DATA_COMPARE_TASK = "kd.sys.ricc.formplugin.batchdatacompare.task.BatchDataCompareTask";
    private static final String RICC_COMPARE_ENTRY = "ricc_compare_entry";
    private static final String ITEM_ENTRY = "itemid";
    private static final String FILTER_TERM = "filterterm";
    private static final String MANUAL_SEL_ITEM = "manualselitem";
    private static final String CLICK_ROW_INDEX_CACHE = "clickRowIndexCache";
    private static final String DATA_SELECT_TYPE_CACHE = "dataSelectTypeCache";
    private static final String DATA_SELECT_ACTION = "dataSelectAction";
    private static final String KEY_FIELDS_ENTRY = "keyfieldsentry";
    private static final String KEY_FIELDS_ENTRY_SHOW = "keyfieldshow";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FILTER_TERM, MANUAL_SEL_ITEM, KEY_FIELDS_ENTRY_SHOW});
        this.getEntryGrid().addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("datapacket");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setBeforeCenterAndUser();
        this.setEntryFieldVisible();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String keyField = (String)this.getModel().getValue("keyfields");
        if (StringUtils.isNotBlank((CharSequence)keyField)) {
            String tip = ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u6bd4\u65b9\u6848\u5df2\u5347\u7ea7\u4e3a\u652f\u6301\u591a\u914d\u7f6e\u9879\u5bf9\u6bd4\uff0c\u539f\u65b9\u6848\u4fe1\u606f\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u65b9\u6848\u3002", (String)"DataComparePlanPlugin_24", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.getView().showTipNotification(tip);
        }
        this.setEntryFieldVisible();
        DynamicObjectCollection packEntry = this.getModel().getEntryEntity(RICC_COMPARE_ENTRY);
        for (int i = 0; i < packEntry.size(); ++i) {
            String exportFiltersDescMultilingual = ((OrmLocaleValue)this.getModel().getValue(FILTER_TERM_L, i)).getLocaleValue();
            this.getModel().setValue(FILTER_TERM, (Object)exportFiltersDescMultilingual, i);
        }
        this.getModel().setDataChanged(false);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("keyfields", null);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(RICC_COMPARE_ENTRY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            String exportFiltersDescMultilingual = ((OrmLocaleValue)this.getModel().getValue(FILTER_TERM_L, i)).getLocaleValue();
            this.getModel().setValue(FILTER_TERM, (Object)exportFiltersDescMultilingual, i);
        }
        this.setEntryFieldVisible();
    }

    private void setBeforeCenterAndUser() {
        Object td = this.getView().getModel().getValue("targetdatacenter");
        if (td == null) {
            long currentUserId = UserServiceHelper.getCurrentUserId();
            long dataCenter = this.getBeforeDataCenter(currentUserId);
            this.getView().getModel().setValue("targetdatacenter", (Object)dataCenter);
            String phone = (String)this.getView().getModel().getValue("targetdatacenteruser");
            if (StringUtils.isEmpty((String)phone)) {
                this.getView().getModel().setValue("targetdatacenteruser", (Object)this.getLatestUserPhone(dataCenter, currentUserId));
            }
        }
    }

    private long getBeforeDataCenter(long currentUserId) {
        DynamicObject center;
        QFilter creatorFilter = new QFilter("creator.id", "=", (Object)currentUserId);
        DynamicObject[] rptDyo = BusinessDataServiceHelper.load((String)"ricc_datacompare_rpt", (String)"targetdatacenter", (QFilter[])creatorFilter.toArray(), (String)"starttime desc", (int)1);
        long beforeDataCenter = rptDyo != null && rptDyo.length > 0 ? ((center = (DynamicObject)rptDyo[0].get("targetdatacenter")) != null ? center.getLong("id") : CommonQuery.getDefaultDataCenter()) : CommonQuery.getDefaultDataCenter();
        return beforeDataCenter;
    }

    private String getLatestUserPhone(long centerId, long currentUserId) {
        String phone = "";
        QFilter[] idFilter = new QFilter[]{new QFilter("creator.id", "=", (Object)currentUserId), new QFilter("targetdatacenter", "=", (Object)centerId)};
        DynamicObject[] currentUser = BusinessDataServiceHelper.load((String)"ricc_datacompare_rpt", (String)"targetdatacenteruser", (QFilter[])idFilter, (String)"createtime desc", (int)1);
        phone = Objects.nonNull(currentUser) && currentUser.length > 0 ? currentUser[0].getString("targetdatacenteruser") : CommonQuery.getCurrentUserPhone();
        return phone;
    }

    private void setEntryFieldVisible() {
        String compareType = (String)this.getModel().getValue("comparetype");
        boolean isPacket = StringUtils.equals((String)compareType, (String)"item");
        List fieldEdits = this.getEntryGrid().getFieldEdits();
        for (FieldEdit fieldEdit : fieldEdits) {
            String fieldKey = fieldEdit.getFieldKey();
            if (!"dataselection".equals(fieldKey) && !FILTER_TERM.equals(fieldKey)) continue;
            fieldEdit.setVisible("", isPacket);
        }
        this.getView().setVisible(Boolean.valueOf(isPacket), new String[]{"advconbaritemap"});
        this.getView().setEnable(Boolean.valueOf(isPacket), new String[]{RICC_COMPARE_ENTRY});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int focusRow = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        if (StringUtils.equals((String)fieldKey, (String)"comparetype")) {
            this.setEntryFieldVisible();
            this.getModel().setValue("datapacket", null);
            this.getModel().deleteEntryData(RICC_COMPARE_ENTRY);
        } else if (StringUtils.equals((String)fieldKey, (String)"datapacket")) {
            this.packetChanged(newValue);
        } else if (StringUtils.equals((String)fieldKey, (String)ITEM_ENTRY)) {
            this.itemEntryChanged(focusRow, newValue);
        } else if (StringUtils.equals((String)fieldKey, (String)"dataselection")) {
            String dataSelectWay = (String)newValue;
            this.dataSelectionChanged(dataSelectWay, focusRow);
        } else if (StringUtils.equals((String)fieldKey, (String)FILTER_TERM) && StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue(FILTER_TERM_L, null, focusRow);
            this.getModel().setValue("datastore", null, focusRow);
            this.getModel().setValue("datastore_tag", null, focusRow);
        }
    }

    private void itemEntryChanged(int focusRow, Object newValue) {
        String noChangeCache = this.getView().getPageCache().get("noChangeCache");
        if (StringUtils.equals((String)noChangeCache, (String)"true")) {
            return;
        }
        if (newValue == null) {
            this.setEntryStoreIsNull(focusRow);
        } else {
            DynamicObject configItem = (DynamicObject)newValue;
            if (!this.isCompare(configItem)) {
                String itemName = configItem.getString("name");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u3010%s\u3011\u4e0d\u652f\u6301\u6570\u636e\u5bf9\u6bd4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataComparePlanPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]), itemName));
                this.getModel().setValue(ITEM_ENTRY, null, focusRow);
                this.setEntryStoreIsNull(focusRow);
                return;
            }
            DynamicObject itemConfig = BusinessDataServiceHelper.loadSingleFromCache((Object)configItem.getPkValue(), (String)"ricc_configitems");
            this.setKeyFields(focusRow, itemConfig);
            this.getModel().setValue(FILTER_TERM, itemConfig.get("exportfiltersdesc_l"), focusRow);
            this.getModel().setValue(FILTER_TERM_L, itemConfig.get("exportfiltersdesc_l"), focusRow);
            this.getModel().setValue("datastore", itemConfig.get("exportfilters"), focusRow);
            this.getModel().setValue("datastore_tag", itemConfig.get("exportfilters_tag"), focusRow);
        }
        this.getView().setEnable(Boolean.TRUE, focusRow, new String[]{FILTER_TERM});
        this.getModel().beginInit();
        this.getModel().setValue("dataselection", (Object)DataSelectWayEnum.FILTER_SELECT_WAY.getVal(), focusRow);
        this.getModel().endInit();
        this.getView().updateView("dataselection", focusRow);
        this.getModel().setValue(MANUAL_SEL_ITEM, null, focusRow);
    }

    private void setEntryStoreIsNull(int focusRow) {
        this.getModel().setValue(FILTER_TERM, null, focusRow);
        this.getModel().setValue(FILTER_TERM_L, null, focusRow);
        this.getModel().setValue(KEY_FIELDS_ENTRY, null, focusRow);
        this.getModel().setValue(KEY_FIELDS_ENTRY_SHOW, null, focusRow);
        this.getModel().setValue("datastore_tag", null, focusRow);
    }

    private void setKeyFields(int focusRow, DynamicObject itemConfig) {
        boolean isGeneral;
        String importType = itemConfig.getString("importtype");
        boolean bl = isGeneral = StringUtils.equals((String)importType, (String)"excel") || StringUtils.equals((String)importType, (String)"json");
        if (isGeneral) {
            try {
                String itemKeyFields = ConfigItemHelper.buildKeyFields(itemConfig.getLong("id"));
                this.getModel().setValue(KEY_FIELDS_ENTRY, (Object)itemKeyFields, focusRow);
                String entityNumber = ConfigItemHelper.getEntityNumber(itemConfig.getPkValue());
                this.getModel().setValue(KEY_FIELDS_ENTRY_SHOW, ConfigItemHelper.getKeyFieldMap(entityNumber, itemKeyFields).get("displayName"), focusRow);
            }
            catch (Exception e) {
                this.getView().showTipNotification(e.getMessage());
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, focusRow, new String[]{KEY_FIELDS_ENTRY_SHOW});
        }
    }

    private void packetChanged(Object newValue) {
        this.getModel().deleteEntryData(RICC_COMPARE_ENTRY);
        if (newValue == null) {
            return;
        }
        DynamicObject packetData = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)newValue).getPkValue(), (String)"ricc_datapacket");
        DynamicObjectCollection subDataPackets = packetData.getDynamicObjectCollection("subdatapacket");
        List bizObjectPk = subDataPackets.stream().map(y -> y.getDynamicObject("bizobject").getPkValue()).collect(Collectors.toList());
        Map configMap = BusinessDataServiceHelper.loadFromCache((String)"ricc_configitems", (String)"id,number,name,supportcompare,importtype,keyfields", (QFilter[])new QFilter[]{new QFilter("id", "in", bizObjectPk)});
        StringBuilder noCompareStr = new StringBuilder();
        int index = 0;
        for (DynamicObject subDataPacket : subDataPackets) {
            ++index;
            DynamicObject configItem = (DynamicObject)configMap.get(subDataPacket.get("bizobject_id"));
            String entryStatus = (String)subDataPacket.get("entrystatus");
            String subPacketType = (String)subDataPacket.get("subpackettype");
            if (configItem == null || StringUtils.equals((String)PacketEntryStatusEnum.INVALID.getVal(), (String)entryStatus) || !StringUtils.equals((String)subPacketType, (String)"ricc_configitems")) continue;
            if (this.isCompare(configItem)) {
                int newEntryRow = this.getModel().createNewEntryRow(RICC_COMPARE_ENTRY);
                this.getView().getPageCache().put("noChangeCache", "true");
                this.getModel().setValue("packindex", (Object)index, newEntryRow);
                this.getModel().setValue("dataselection", (Object)DataSelectWayEnum.MANUAL_SELECT_WAY.getVal(), newEntryRow);
                this.getModel().setValue(ITEM_ENTRY, configItem.getPkValue(), newEntryRow);
                this.getView().getPageCache().remove("noChangeCache");
                int packetNum = subDataPacket.getInt("packetnum");
                this.getModel().setValue(MANUAL_SEL_ITEM, (Object)String.format(ResManager.loadKDString((String)"\u5df2\u9009%s\u6761", (String)"DataComparePlanPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]), packetNum), newEntryRow);
                this.setKeyFields(newEntryRow, configItem);
                String customParam = (String)subDataPacket.get("custparam_tag");
                this.setDataStore(newEntryRow, customParam);
                continue;
            }
            String itemName = configItem.getString("name");
            noCompareStr.append(itemName).append(',');
        }
        if (noCompareStr.length() > 0) {
            noCompareStr.deleteCharAt(noCompareStr.lastIndexOf(","));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u3010%s\u3011\u4e0d\u652f\u6301\u6570\u636e\u5bf9\u6bd4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataComparePlanPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]), noCompareStr));
        }
    }

    private void setDataStore(int rowIndex, String customParam) {
        List previewData;
        Map customParamMap;
        if (StringUtils.isNotBlank((CharSequence)customParam) && !StringUtils.equals((String)customParam, (String)"null") && (customParamMap = (Map)JSON.parseObject((String)customParam, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0])) != null && !customParamMap.isEmpty() && (previewData = (List)customParamMap.get("previewData")) != null && !previewData.isEmpty()) {
            HashMap dataIdNumberMaps = new HashMap(previewData.size());
            for (Map oneData : previewData) {
                Object id = oneData.get("id");
                String number = (String)oneData.get("number");
                dataIdNumberMaps.put(id, number);
            }
            this.getModel().setValue("datastore_tag", (Object)JSON.toJSONString(dataIdNumberMaps), rowIndex);
        }
    }

    private boolean isCompare(DynamicObject configItem) {
        return configItem.getBoolean("supportcompare");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        super.beforeDoOperation(event);
        AbstractOperate operate = (AbstractOperate)event.getSource();
        String opKey = operate.getOperateKey();
        if (StringUtils.equals((String)opKey, (String)COMPARE) && !this.beforeCompareCheck()) {
            event.setCancel(true);
        }
    }

    private void previewData() {
        boolean forbiddenPreview;
        boolean isPacket;
        String compareType = (String)this.getModel().getValue("comparetype");
        boolean bl = isPacket = !StringUtils.equals((String)compareType, (String)"item");
        if (isPacket) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u5bf9\u6bd4\u65f6\u6682\u4e0d\u652f\u6301\u6570\u636e\u9884\u89c8\u3002", (String)"DataComparePlanPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        int rowKey = this.getEntryGrid().getEntryState().getFocusRow();
        Object selectRowItem = this.getModel().getValue(ITEM_ENTRY, rowKey);
        if (selectRowItem == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u914d\u7f6e\u9879", (String)"DataComparePlanPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        DynamicObject rowItem = (DynamicObject)selectRowItem;
        FormConfig listFormConfig = ConfigItemHelper.getFormConfig(rowItem.getPkValue());
        if (listFormConfig == null) {
            String showMessage = ResManager.loadKDString((String)"\u8be5\u914d\u7f6e\u9879\u6682\u4e0d\u652f\u6301\u624b\u5de5\u9009\u62e9\u548c\u6570\u636e\u9884\u89c8", (String)"DataComparePlanPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.getView().showTipNotification(showMessage);
            return;
        }
        String entityNumber = listFormConfig.getEntityTypeId();
        boolean bl2 = forbiddenPreview = StringUtils.equals((String)entityNumber, (String)"botp_crlist") || StringUtils.equals((String)entityNumber, (String)"bos_manageprinttpl") || StringUtils.equals((String)entityNumber, (String)"botp_wrlistcheckin") || StringUtils.equals((String)entityNumber, (String)"perm_role") || StringUtils.equals((String)entityNumber, (String)"gl_initbalance");
        if (forbiddenPreview) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u914d\u7f6e\u9879\u6682\u4e0d\u652f\u6301\u6570\u636e\u9884\u89c8", (String)"DataComparePlanPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String number = null;
        String name = null;
        if (entityType instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)entityType;
            number = basedataEntityType.getNumberProperty();
            name = basedataEntityType.getNameProperty();
        } else if (entityType instanceof BillEntityType) {
            BillEntityType billEntityType = (BillEntityType)entityType;
            number = billEntityType.getBillNo();
            name = billEntityType.getBillNo();
        }
        if (StringUtils.isBlank(number) && StringUtils.isBlank(name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u914d\u7f6e\u9879\u7684\u914d\u7f6e\u8868\u5355\u5b9e\u4f53\u6ca1\u6709\u7f16\u7801\u548c\u540d\u79f0\uff0c\u6682\u4e0d\u652f\u6301\u6570\u636e\u9884\u89c8", (String)"DataComparePlanPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        this.executePreview(listFormConfig, rowKey);
    }

    private void executePreview(FormConfig listFormConfig, int rowKey) {
        String dataStore;
        String dataSelection;
        String entityNumber = listFormConfig.getEntityTypeId();
        QFilter filters = DataCompareHelper.getEntryRowFilters(entityNumber, dataSelection = (String)this.getModel().getValue("dataselection", rowKey), dataStore = (String)this.getModel().getValue("datastore_tag", rowKey));
        QFilter[] filtersArr = filters == null ? new QFilter[]{} : filters.toArray();
        String f7ListFormId = listFormConfig.getF7ListFormId();
        HashMap<String, String> customParams = new HashMap<String, String>(2);
        if (filters != null) {
            customParams.put("filter", filters.toSerializedString());
        }
        ListShowParameter listShowParameter = ShowParameterUtil.listShowParameter((String)entityNumber, (String)f7ListFormId, (ShowType)ShowType.Modal, customParams, Arrays.asList(filtersArr), (String)"", (String)"kd.bos.ext.imsc.ricc.form.f7ext.DataPreviewListPlugin");
        listShowParameter.setMultiSelect(false);
        listShowParameter.setShowApproved(false);
        listShowParameter.setF7Style(0);
        DynamicObject itemConfig = (DynamicObject)this.getModel().getValue(ITEM_ENTRY, rowKey);
        String pageParam = (String)itemConfig.get("pageenterparam");
        ShowParameterUtil.setPageEnterParam((ListShowParameter)listShowParameter, (String)pageParam);
        StyleCss style = new StyleCss();
        style.setWidth("1000");
        style.setHeight("600");
        listShowParameter.getOpenStyle().setInlineStyleCss(style);
        listShowParameter.setShowTitle(false);
        listShowParameter.setLookUp(true);
        listShowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private List<Object> getManualSelectedPks(int rowIndex) {
        String dataStr = (String)this.getModel().getValue("datastore_tag", rowIndex);
        if (StringUtils.isEmpty((String)dataStr)) {
            return new ArrayList<Object>();
        }
        JSONObject selectDatas = JSON.parseObject((String)dataStr);
        if (selectDatas.isEmpty()) {
            return new ArrayList<Object>();
        }
        DynamicObjectCollection packEntity = this.getModel().getEntryEntity(RICC_COMPARE_ENTRY);
        DynamicObject row = (DynamicObject)packEntity.get(rowIndex);
        DynamicObject item = row.getDynamicObject(ITEM_ENTRY);
        String entityNumber = ConfigItemHelper.getEntityNumber(item.getPkValue());
        if (entityNumber == null) {
            return Collections.emptyList();
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        ISimpleProperty idProperty = dataEntityType.getPrimaryKey();
        if (idProperty instanceof LongProp) {
            return selectDatas.keySet().stream().map(Long::parseLong).collect(Collectors.toList());
        }
        if (idProperty instanceof VarcharProp) {
            return new ArrayList<Object>(selectDatas.keySet());
        }
        String msgTpl = ResManager.loadKDString((String)"\u914d\u7f6e\u9879%s\u7684\u4e3b\u952e\u6570\u636e\u7c7b\u578b\u4e0d\u7b26\u5408\u82cd\u7a79\u7684\u89c4\u8303\uff0c\u8bf7\u4fee\u6539\u4e3b\u952e\u7684\u6570\u636e\u7c7b\u578b\u4e3along\u6216\u8005varchar", (String)"DataComparePlanPlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0]);
        throw new RiccBizException(String.format(msgTpl, entityNumber));
    }

    private boolean beforeCompareCheck() {
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (!fromDatabase) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u5bf9\u6bd4\u5931\u8d25\uff0c\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u5bf9\u6bd4\u65b9\u6848\u3002", (String)"DataComparePlanPlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        boolean dataChanged = this.getView().getModel().getDataChanged();
        if (dataChanged) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u5df2\u53d1\u751f\u503c\u6539\u53d8\uff0c\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u6267\u884c\u5bf9\u6bd4\u3002", (String)"DataComparePlanPlugin_9", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void openDataCompareRpt() {
        String planNumber = (String)this.getModel().getValue("number");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (fromDatabase) {
            long planId = (Long)this.getModel().getDataEntity().getPkValue();
            qFilterList.add(new QFilter("datacompareplan.id", "=", (Object)planId));
        }
        ListShowParameter showParam = ShowParameterUtil.listShowParameter((String)"ricc_datacompare_rpt", (String)"bos_list", (ShowType)ShowType.MainNewTabPage, null, qFilterList, null, null);
        String pageId = this.getView().getFormShowParameter().getRootPageId();
        showParam.setPageId(planNumber + pageId);
        String parentPageId = ShowParameterUtil.getParentPageId((IFormView)this.getView());
        showParam.setParentPageId(parentPageId);
        this.getView().showForm((FormShowParameter)showParam);
    }

    private void dataSelectionChanged(String selection, int rowIndex) {
        this.getPageCache().put(CLICK_ROW_INDEX_CACHE, String.valueOf(rowIndex));
        String filter = ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6", (String)"DataComparePlanPlugin_15", (String)"sys-ricc-platform", (Object[])new Object[0]);
        String manual = ResManager.loadKDString((String)"\u624b\u5de5\u9009\u62e9", (String)"DataComparePlanPlugin_16", (String)"sys-ricc-platform", (Object[])new Object[0]);
        String datastoreTag = (String)this.getModel().getValue("datastore_tag", rowIndex);
        boolean isFilterWay = StringUtils.equals((String)selection, (String)DataSelectWayEnum.FILTER_SELECT_WAY.getVal());
        if (StringUtils.isBlank((CharSequence)datastoreTag)) {
            this.selectMethodChangedClearData(rowIndex, isFilterWay, true);
        } else {
            this.getPageCache().put(DATA_SELECT_TYPE_CACHE, selection);
            String tip = isFilterWay ? ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\u9009\u62e9\u65b9\u5f0f\u4e3a\u3010%1$s\u3011,\u5c06\u6e05\u7a7a\u3010%2$s\u3011\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\uff1f", (String)"DataComparePlanPlugin_17", (String)"sys-ricc-platform", (Object[])new Object[]{filter, manual}) : ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\u9009\u62e9\u65b9\u5f0f\u4e3a\u3010%1$s\u3011,\u5c06\u6e05\u7a7a\u3010%2$s\u3011\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\uff1f", (String)"DataComparePlanPlugin_17", (String)"sys-ricc-platform", (Object[])new Object[]{manual, filter});
            this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DATA_SELECT_ACTION, (IFormPlugin)this));
        }
    }

    private void selectMethodChangedClearData(int rowIndex, boolean isFilterWay, boolean isDeleteTag) {
        String changedType = isFilterWay ? FILTER_TERM : MANUAL_SEL_ITEM;
        String changedBeforeType = isFilterWay ? MANUAL_SEL_ITEM : FILTER_TERM;
        this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{changedType});
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{changedBeforeType});
        this.getModel().beginInit();
        this.getModel().setValue("dataselection", (Object)(isFilterWay ? DataSelectWayEnum.FILTER_SELECT_WAY.getVal() : DataSelectWayEnum.MANUAL_SELECT_WAY.getVal()), rowIndex);
        this.getModel().endInit();
        this.getView().updateView("dataselection", rowIndex);
        this.getModel().setValue(changedBeforeType, null, rowIndex);
        if (isDeleteTag) {
            this.getModel().setValue("datastore", null, rowIndex);
            this.getModel().setValue("datastore_tag", null, rowIndex);
            if (!isFilterWay) {
                this.getModel().setValue(MANUAL_SEL_ITEM, (Object)this.getManualSelConditionMes(), rowIndex);
            }
        }
    }

    private int getEntryClickIndexFromCache() {
        String indexStr = this.getView().getPageCache().get(CLICK_ROW_INDEX_CACHE);
        return Integer.parseInt(indexStr);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        boolean isSuccess = event.getResult().equals((Object)MessageBoxResult.Yes);
        if (StringUtils.equals((String)callBackId, (String)DATA_SELECT_ACTION)) {
            String dataSelectRow = this.getPageCache().get(CLICK_ROW_INDEX_CACHE);
            String dataSelectType = this.getPageCache().get(DATA_SELECT_TYPE_CACHE);
            boolean isFilterWay = StringUtils.equals((String)dataSelectType, (String)DataSelectWayEnum.FILTER_SELECT_WAY.getVal());
            if (isSuccess) {
                this.selectMethodChangedClearData(Integer.parseInt(dataSelectRow), isFilterWay, true);
            } else {
                this.selectMethodChangedClearData(Integer.parseInt(dataSelectRow), !isFilterWay, false);
            }
        }
    }

    private void showDataFilterCondition() {
        int row = this.getEntryGrid().getEntryState().getFocusRow();
        DynamicObject item = (DynamicObject)this.getModel().getValue(ITEM_ENTRY, row);
        if (item == null) {
            this.getView().showTipNotification(this.getItemIsNullMessage());
            return;
        }
        DynamicObject configItem = BusinessDataServiceHelper.loadSingleFromCache((Object)item.getPkValue(), (String)"ricc_configitems");
        String formId = configItem.getString("page.basedatafield.number");
        if (StringUtils.equals((String)"ai_vchtemplate_configs", (String)formId)) {
            formId = "ai_vchtemplate";
        }
        String conditionJson = (String)this.getModel().getValue("datastore_tag", row);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)dataEntityType, null);
        String flsNodes = SerializationUtils.toJsonString((Object)treeNode);
        OpenFilterFormUtil.showConditionForm((IFormView)this.getView(), (String)conditionJson, (String)formId, (String)flsNodes, (String)this.getPluginName(), (String)"filtereditaction");
    }

    private void showConfigItemListF7() {
        String compareType = (String)this.getModel().getValue("comparetype");
        if (StringUtils.equals((String)compareType, (String)"packet")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u6bd4\u7c7b\u578b\u4e3a\u4f20\u8f93\u5305\u65f6\u4e0d\u5141\u8bb8\u624b\u5de5\u9009\u62e9\u6570\u636e\u3002", (String)"DataComparePlanPlugin_25", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        int rowKey = this.getEntryGrid().getEntryState().getFocusRow();
        this.getView().getPageCache().put(CLICK_ROW_INDEX_CACHE, String.valueOf(rowKey));
        Object selectRowItem = this.getModel().getValue(ITEM_ENTRY, rowKey);
        if (selectRowItem == null) {
            this.getView().showTipNotification(this.getItemIsNullMessage());
            return;
        }
        DynamicObject rowItem = (DynamicObject)selectRowItem;
        FormConfig listFormConfig = ConfigItemHelper.getFormConfig(rowItem.getPkValue());
        if (listFormConfig == null) {
            String showMessage = ResManager.loadKDString((String)"\u8be5\u914d\u7f6e\u9879\u6682\u4e0d\u652f\u6301\u624b\u5de5\u9009\u62e9\u548c\u6570\u636e\u9884\u89c8", (String)"DataComparePlanPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.getView().showTipNotification(showMessage);
            return;
        }
        String entityNumber = listFormConfig.getEntityTypeId();
        String f7ListFormId = listFormConfig.getF7ListFormId();
        if ("cts_layoutscheme_listf7".equals(f7ListFormId)) {
            f7ListFormId = "bos_listf7";
        }
        ListShowParameter listShowParameter = ShowParameterUtil.listShowParameter((String)entityNumber, (String)f7ListFormId, (ShowType)ShowType.Modal, null, null, (String)"", (String)"kd.bos.ext.imsc.ricc.form.f7ext.ManualSelectDataLimitPlugin");
        String pageParam = (String)rowItem.get("pageenterparam");
        ShowParameterUtil.setPageEnterParam((ListShowParameter)listShowParameter, (String)pageParam);
        listShowParameter.setMultiSelect(true);
        listShowParameter.setShowApproved(false);
        listShowParameter.setF7Style(0);
        StyleCss style = new StyleCss();
        style.setWidth("1000");
        style.setHeight("600");
        listShowParameter.getOpenStyle().setInlineStyleCss(style);
        listShowParameter.setShowTitle(false);
        listShowParameter.setLookUp(true);
        List<Object> selectPks = null;
        selectPks = this.getManualSelectedPks(rowKey);
        ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
        selectPks.forEach(pk -> selectedRows.add((Object)new ListSelectedRow(pk)));
        listShowParameter.setListSelectedRowCollection(selectedRows);
        listShowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MANUAL_SELECT_CLOSE_ACTION));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equals((String)actionId, (String)"filtereditaction")) {
            String conditionJson = (String)event.getReturnData();
            OpenFilterFormUtil.receiveCondition((IDataModel)this.getModel(), (String)conditionJson, (String)RICC_COMPARE_ENTRY, (String)"datastore_tag", (String)FILTER_TERM, (String)FILTER_TERM_L);
        } else if (StringUtils.equals((String)actionId, (String)MANUAL_SELECT_CLOSE_ACTION)) {
            this.setManualSelectData(event);
        } else if (StringUtils.equals((String)actionId, (String)"keyFieldClose") && (returnData = (Map)event.getReturnData()) != null && !returnData.isEmpty()) {
            this.getModel().setValue(KEY_FIELDS_ENTRY, returnData.get("keyField"), this.getEntryClickIndexFromCache());
            this.getModel().setValue(KEY_FIELDS_ENTRY_SHOW, returnData.get("displayName"), this.getEntryClickIndexFromCache());
        }
    }

    private void setManualSelectData(ClosedCallBackEvent event) {
        int rowIndex = this.getEntryClickIndexFromCache();
        Object returnData = event.getReturnData();
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            this.setManualSelectData(rowIndex, selectedRows);
        }
    }

    private void setManualSelectData(int rowIndex, ListSelectedRowCollection selectedRows) {
        String numberField = null;
        int size = selectedRows.size();
        if (size > 0) {
            ListSelectedRow row2 = selectedRows.get(0);
            if (StringUtils.isNotEmpty((String)row2.getBillNo())) {
                numberField = "billno";
            }
            if (StringUtils.isNotEmpty((String)row2.getNumber())) {
                numberField = "number";
            }
        }
        HashMap dataIdNumberMaps = new HashMap(size);
        if ("number".equals(numberField)) {
            if (StringUtils.equals((String)"", (String)"ai_vchtemplate_configs")) {
                selectedRows.forEach(row -> dataIdNumberMaps.put(Long.parseLong(String.valueOf(row.getPrimaryKeyValue())), row.getNumber()));
            } else {
                selectedRows.forEach(row -> dataIdNumberMaps.put(row.getPrimaryKeyValue(), row.getNumber()));
            }
        } else if ("billno".equals(numberField)) {
            selectedRows.forEach(row -> dataIdNumberMaps.put(row.getPrimaryKeyValue(), row.getBillNo()));
        } else {
            selectedRows.forEach(row -> dataIdNumberMaps.put(row.getPrimaryKeyValue(), " "));
        }
        String dataStr = JSON.toJSONString(dataIdNumberMaps);
        this.getModel().setValue(MANUAL_SEL_ITEM, (Object)String.format(ResManager.loadKDString((String)"\u5df2\u9009%d\u6761", (String)"DataComparePlanPlugin_18", (String)"sys-ricc-platform", (Object[])new Object[0]), size), rowIndex);
        this.getModel().setValue("datastore_tag", (Object)dataStr, rowIndex);
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String operateKey = event.getOperateKey();
        if (StringUtils.equals((String)operateKey, (String)COMPARE)) {
            String compareType = (String)this.getModel().getValue("comparetype");
            DynamicObject dataPacket = (DynamicObject)this.getModel().getValue("datapacket");
            OperationResult operationResult = event.getOperationResult();
            Map customData = operationResult.getCustomData();
            String rptId = (String)customData.get("rptId");
            if (StringUtils.isEmpty((String)rptId)) {
                return;
            }
            this.startCompareTask(compareType, dataPacket, Long.parseLong(rptId));
            this.openDataCompareRpt(Long.parseLong(rptId), compareType);
        } else if (StringUtils.equals((String)operateKey, (String)COMPARE_REPORT)) {
            this.openDataCompareRpt();
        } else if (StringUtils.equals((String)operateKey, (String)"datapreview")) {
            this.previewData();
        }
    }

    private void startCompareTask(String compareType, DynamicObject dataPacket, Long dataCompareRptId) {
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("planId", this.getModel().getDataEntity().getPkValue());
        param.put("compareType", compareType);
        param.put("dataPacketId", dataPacket == null ? "" : dataPacket.getPkValue());
        param.put("dataCompareRptId", dataCompareRptId);
        String jobName = ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u6bd4\u4efb\u52a1", (String)"DataComparePlanPlugin_19", (String)"sys-ricc-platform", (Object[])new Object[0]);
        JobFormInfo jobFormInfo = ScheduleUtil.buildJobFormInfo(jobName, DATA_COMPARE_TASK, "", this.getView(), param);
        jobFormInfo.getJobInfo().setAppId("ricc");
        ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
    }

    private void openDataCompareRpt(Long dataCompareRptId, String compareType) {
        BaseShowParameter billShowDataDetail = new BaseShowParameter();
        billShowDataDetail.setPkId((Object)dataCompareRptId);
        billShowDataDetail.setFormId("ricc_datacompare_rpt");
        billShowDataDetail.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowDataDetail.setHasRight(false);
        billShowDataDetail.setCustomParam("compareType", (Object)compareType);
        this.getView().showForm((FormShowParameter)billShowDataDetail);
        String pageId = billShowDataDetail.getPageId();
        IFormView view = this.getView().getView(pageId);
        view.showSuccessNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u6570\u636e\u5bf9\u6bd4,\u8bf7\u624b\u5de5\u70b9\u51fb\u5237\u65b0\u6309\u94ae\u67e5\u770b\u5bf9\u6bd4\u8fdb\u5ea6", (String)"DataComparePlanPlugin_20", (String)"sys-ricc-platform", (Object[])new Object[0]), Integer.valueOf(5000));
        this.getView().sendFormAction(view);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (StringUtils.equals((String)controlKey, (String)FILTER_TERM)) {
            this.showDataFilterCondition();
        } else if (StringUtils.equals((String)controlKey, (String)KEY_FIELDS_ENTRY_SHOW)) {
            int focusRow = this.getEntryGrid().getEntryState().getFocusRow();
            this.getView().getPageCache().put(CLICK_ROW_INDEX_CACHE, String.valueOf(focusRow));
            DynamicObject item = (DynamicObject)this.getModel().getValue(ITEM_ENTRY, focusRow);
            String entityNumber = ConfigItemHelper.getEntityNumber(item == null ? null : item.getPkValue());
            if (entityNumber == null) {
                this.getView().showTipNotification(this.getItemIsNullMessage());
                return;
            }
            String keyFieldsEntry = (String)this.getModel().getValue(KEY_FIELDS_ENTRY);
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("entityNumber", entityNumber);
            param.put(KEY_FIELDS_ENTRY, keyFieldsEntry);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "keyFieldClose");
            FormShowParameter formShowParameter = ShowParameterUtil.formShowParameter((String)"ricc_select_keyfields", (ShowType)ShowType.Modal, param, null, null, (CloseCallBack)closeCallBack);
            this.getView().showForm(formShowParameter);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (StringUtils.equals((String)fieldName, (String)MANUAL_SEL_ITEM)) {
            this.showConfigItemListF7();
        }
    }

    private EntryGrid getEntryGrid() {
        return (EntryGrid)this.getView().getControl(RICC_COMPARE_ENTRY);
    }

    private String getItemIsNullMessage() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u914d\u7f6e\u9879\u3002", (String)"DataComparePlanPlugin_22", (String)"sys-ricc-platform", (Object[])new Object[0]);
    }

    private String getManualSelConditionMes() {
        return ResManager.loadKDString((String)"\u5f85\u9009\u62e9", (String)"DataComparePlanPlugin_23", (String)"sys-ricc-platform", (Object[])new Object[0]);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldName = evt.getProperty().getName();
        if (StringUtils.equals((String)fieldName, (String)"datapacket")) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.setShowApproved(false);
        }
    }
}

