/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.batchdatacompare;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.sys.ricc.common.enums.CompareStatusEnum;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;

public class DataCompareRptPlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    private static final String CONFIG_ITEM = "configitem";
    private static final String PAGE_NUMBER = "page.number";
    private static final String RICC_DATA_COMPARE_ENTRY = "ricc_datacompare_entry";
    private static final String RICC_DIFF_DETAIL_ENTRY = "ricc_diffdetail_entry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid compareEntry = (EntryGrid)this.getControl(RICC_DATA_COMPARE_ENTRY);
        compareEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl(RICC_DATA_COMPARE_ENTRY);
        entryGrid.addPackageDataListener(pkEvent -> {
            boolean hasRelevancyData = StringUtils.isNotBlank((Object)pkEvent.getRowData().get("relevancydata_tag"));
            if (pkEvent.getSource() instanceof OperationColumn && "operate".equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    if (!"viewrelevancy".equalsIgnoreCase(operationColItem.getOperationKey())) continue;
                    operationColItem.setVisible(hasRelevancyData);
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setTabAndColumnName();
    }

    private void setTabAndColumnName() {
        String curName;
        String curCount;
        String compareType = (String)this.getView().getFormShowParameter().getCustomParam("compareType");
        if (StringUtils.isBlank((CharSequence)compareType)) {
            compareType = (String)this.getModel().getValue("comparetype");
        }
        if (StringUtils.equals((String)compareType, (String)"item")) {
            curCount = ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u6570\u91cf", (String)"DataCompareRptPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
            curName = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3", (String)"DataCompareRptPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
        } else {
            curCount = ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u6570\u91cf", (String)"DataCompareRptPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]);
            curName = ResManager.loadKDString((String)"\u4f20\u8f93\u5305", (String)"DataCompareRptPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]);
        }
        EntryGrid gridPlan = (EntryGrid)this.getControl("ricc_plandata_entry");
        gridPlan.setColumnProperty("curcount", "header", (Object)new LocaleString(curCount));
        EntryGrid gridData = (EntryGrid)this.getControl(RICC_DATA_COMPARE_ENTRY);
        gridData.setColumnProperty("currentdcentry", "header", (Object)new LocaleString(curName));
        EntryGrid gridDetail = (EntryGrid)this.getControl(RICC_DIFF_DETAIL_ENTRY);
        String value = String.format(ResManager.loadKDString((String)"%s\u503c", (String)"DataCompareRptPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]), curName);
        gridDetail.setColumnProperty("currentvalue", "header", (Object)new LocaleString(value));
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String keyField = (String)this.getModel().getValue("keyfields");
        if (StringUtils.isNotBlank((CharSequence)keyField)) {
            String tip = ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u6bd4\u65b9\u6848\u5df2\u5347\u7ea7\u4e3a\u652f\u6301\u591a\u914d\u7f6e\u9879\u5bf9\u6bd4\uff0c\u539f\u65b9\u6848\u4fe1\u606f\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u65b9\u6848\u3002", (String)"DataCompareRptPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.getView().showTipNotification(tip);
        }
        this.setTabAndColumnName();
        DynamicObjectCollection compareInfoEntity = this.getModel().getEntryEntity(RICC_DATA_COMPARE_ENTRY);
        DynamicObjectCollection diffDetailEntity = this.getModel().getEntryEntity(RICC_DIFF_DETAIL_ENTRY);
        if (compareInfoEntity == null || compareInfoEntity.isEmpty() || !diffDetailEntity.isEmpty()) {
            return;
        }
        this.setDifferenceEntry(this.findFirstDifferenceData(compareInfoEntity));
    }

    private String findFirstDifferenceData(DynamicObjectCollection compareInfoEntity) {
        for (int i = 0; i < compareInfoEntity.size(); ++i) {
            DynamicObject entryRow = (DynamicObject)compareInfoEntity.get(i);
            String firstDifferenceData = (String)entryRow.get("differencedata_tag");
            if (!StringUtils.isNotBlank((CharSequence)firstDifferenceData)) continue;
            this.getView().getPageCache().put("entryCurIndex", String.valueOf(i));
            return firstDifferenceData;
        }
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if (StringUtils.equals((String)opKey, (String)"refresh")) {
            DynamicObjectCollection diffDetailEntity;
            String status;
            Object taskId;
            TaskInfo initTask;
            String compareStatus = (String)this.getModel().getValue("comparestatus");
            if (StringUtils.equals((String)compareStatus, (String)CompareStatusEnum.BEGINNING.getVal()) && (initTask = ScheduleServiceHelper.queryTask((String)((String)(taskId = this.getModel().getValue("taskid"))))) != null && (status = initTask.getStatus()) != null && (status.equals("FAILED") || status.equals("ABORTED") || status.equals("TIMEOUT"))) {
                this.getModel().setValue("comparestatus", (Object)CompareStatusEnum.UNUSUAL_STOP.getVal());
                this.getView().invokeOperation("save");
            }
            if (!(diffDetailEntity = this.getModel().getEntryEntity(RICC_DIFF_DETAIL_ENTRY)).isEmpty()) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String operateKey = event.getOperateKey();
        EntryGrid dataCompareEntry = (EntryGrid)this.getControl(RICC_DATA_COMPARE_ENTRY);
        int focusRow = dataCompareEntry.getEntryState().getFocusRow();
        if (StringUtils.equals((String)"refresh", (String)operateKey)) {
            DynamicObjectCollection compareInfoEntity = this.getModel().getEntryEntity(RICC_DATA_COMPARE_ENTRY);
            this.setDifferenceEntry(this.findFirstDifferenceData(compareInfoEntity));
        } else if (StringUtils.equals((String)"viewrelevancy", (String)operateKey)) {
            String relevancyData = (String)this.getModel().getValue("relevancydata_tag", focusRow);
            HashMap<String, Object> param = new HashMap<String, Object>(4);
            param.put("relevancyData", relevancyData);
            param.put("compareType", this.getModel().getValue("comparetype"));
            FormShowParameter formShowParameter = ShowParameterUtil.formShowParameter((String)"ricc_releation_compare", (ShowType)ShowType.MainNewTabPage, param, null, null);
            this.getView().showForm(formShowParameter);
        } else if ("viewscheme".equals(operateKey)) {
            DynamicObject plan = (DynamicObject)this.getModel().getValue("datacompareplan");
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            if (plan != null) {
                baseShowParameter.setPkId(plan.getPkValue());
                baseShowParameter.setFormId("ricc_datacompare_plan");
                baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)baseShowParameter);
            }
        } else if ("save".equals(operateKey)) {
            event.getOperationResult().setShowMessage(false);
        }
    }

    private void setDifferenceEntry(String differenceData) {
        this.getModel().deleteEntryData(RICC_DIFF_DETAIL_ENTRY);
        if (!StringUtils.isBlank((CharSequence)differenceData)) {
            List dataFromDb = (List)JSON.parseObject((String)differenceData, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter setter = new TableValueSetter(new String[0]);
            int index = 0;
            for (Map oneDataRow : dataFromDb) {
                setter.set("fieldname", oneDataRow.get("fieldName"), index);
                setter.set("fieldkey", oneDataRow.get("fieldKey"), index);
                setter.set("currentvalue", oneDataRow.get("curValue"), index);
                setter.set("targetvalue", oneDataRow.get("tarValue"), index);
                setter.set("differenttype", oneDataRow.get("diffType"), index);
                setter.set("seq", (Object)(index + 1), index++);
            }
            model.batchCreateNewEntryRow(RICC_DIFF_DETAIL_ENTRY, setter);
            model.endInit();
        }
        this.getView().updateView(RICC_DIFF_DETAIL_ENTRY);
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        String entryCurIndex;
        String pageNumber;
        QFilter numberFilter;
        DynamicObject formMeta;
        String modelType;
        super.afterBindData(e);
        DynamicObject configItem = (DynamicObject)this.getModel().getValue(CONFIG_ITEM);
        if (configItem != null && StringUtils.equals((String)(modelType = (formMeta = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (QFilter[])(numberFilter = new QFilter("number", "=", (Object)(pageNumber = configItem.getString(PAGE_NUMBER)))).toArray())).getString("modeltype")), (String)"BillFormModel")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"curdataname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tardataname"});
        }
        if (StringUtils.isNotBlank((CharSequence)(entryCurIndex = this.getView().getPageCache().get("entryCurIndex")))) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(RICC_DATA_COMPARE_ENTRY);
            entryGrid.selectRows(Integer.parseInt(entryCurIndex));
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int row = evt.getRow();
        String differenceData = (String)this.getModel().getValue("differencedata_tag", row);
        this.setDifferenceEntry(differenceData);
    }
}

