/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.batchpackscheme;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.PictureProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.StringUtils;

public class BatchAddFilterFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(BatchAddFilterFormPlugin.class);
    private static final String DEFAULT_CONFIG = "defaultconfig";
    private static final String BATCH_ADD_FILTER_CONFIRM = "batchAddFilterConfirm";
    private static final String FILTERGRIDAP = "ffiltergrid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit defaultConfig = (BasedataEdit)this.getControl(DEFAULT_CONFIG);
        String itemIdListStr = (String)this.getView().getFormShowParameter().getCustomParam("itemIdList");
        List itemIdList = (List)JSON.parseObject((String)itemIdListStr, List.class);
        defaultConfig.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter filter = new QFilter("id", "in", (Object)itemIdList);
            beforeF7SelectEvent.addCustomQFilter(filter);
        });
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String itemIdListStr = (String)this.getView().getFormShowParameter().getCustomParam("itemIdList");
        List itemIdList = (List)JSON.parseObject((String)itemIdListStr, List.class);
        if (!itemIdList.isEmpty()) {
            this.getModel().setValue(DEFAULT_CONFIG, itemIdList.get(0));
        }
    }

    public void beforeBindData(EventObject e) {
        String entityNumber;
        super.beforeBindData(e);
        DynamicObject defaultConfig = (DynamicObject)this.getModel().getValue(DEFAULT_CONFIG);
        if (defaultConfig == null) {
            entityNumber = "";
        } else {
            entityNumber = defaultConfig.getString("page.number");
            if (StringUtils.equals((String)"ai_vchtemplate_configs", (String)entityNumber)) {
                entityNumber = "ai_vchtemplate";
            }
        }
        this.setFilterFridValue(entityNumber);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        filterGrid.SetValue(new FilterCondition());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((String)key, (String)"btnok")) {
            FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            boolean isNotHasFilter = filterGridState.getFilterCondition().getFilterRow().isEmpty();
            if (isNotHasFilter) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"BatchAddFilterFormPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return;
            }
            String msg = ResManager.loadKDString((String)"\u5c06\u628a\u8be5\u8fc7\u6ee4\u6761\u4ef6\u8ffd\u52a0\u81f3\u6570\u636e\u9009\u62e9\u65b9\u5f0f\u4e3a\u201c\u8fc7\u6ee4\u6761\u4ef6\u9009\u62e9\u201d\u7684\u5206\u5f55\u8fc7\u6ee4\u6761\u4ef6\u4e2d\uff0c\u8ffd\u52a0\u540e\u4e3a\u539f\u8fc7\u6ee4\u6761\u4ef6\u201d\u4e14\u201c\u8ffd\u52a0\u8fc7\u6ee4\u6761\u4ef6\u3002\u5982\u914d\u7f6e\u9879\u6ca1\u6709\u8ffd\u52a0\u8fc7\u6ee4\u6761\u4ef6\u4e2d\u4efb\u610f\u4e00\u4e2a\u5b57\u6bb5\u5219\u4f1a\u5ffd\u7565\u8df3\u8fc7\u8be5\u914d\u7f6e\u9879\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6279\u91cf\u8ffd\u52a0\u3002", (String)"BatchAddFilterFormPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BATCH_ADD_FILTER_CONFIRM, (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)callBackId, (String)BATCH_ADD_FILTER_CONFIRM) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            FilterCondition filterCondition = filterGridState.getFilterCondition();
            HashMap<String, Object> returnData = new HashMap<String, Object>(2);
            returnData.put("filterCondition", filterCondition);
            DynamicObject defaultConfig = (DynamicObject)this.getModel().getValue(DEFAULT_CONFIG);
            String entityNumber = (String)defaultConfig.get("page.number");
            returnData.put("entityNumber", entityNumber);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (StringUtils.equals((String)key, (String)DEFAULT_CONFIG)) {
            this.getView().updateView();
        }
    }

    private void setFilterFridValue(String entityNumber) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            filterGrid.setFilterColumns(new ArrayList());
            return;
        }
        MainEntityType entityType = CommonUtil.getEntityTypeByFormId((String)entityNumber);
        if (entityType == null) {
            filterGrid.setFilterColumns(new ArrayList());
            return;
        }
        FilterFieldBuildOption option = new FilterFieldBuildOption();
        option.setCompatibleProductMode(true);
        List cols = FormTreeBuilder.buildFilterColumns((MainEntityType)entityType, (FilterFieldBuildOption)option);
        this.removeInvalidFilterColumns(entityType, cols);
        filterGrid.setFilterColumns(cols);
        filterGrid.setEntityNumber(entityType.getName());
    }

    private void removeInvalidFilterColumns(MainEntityType entityType, List<Map<String, Object>> cols) {
        Map fields = entityType.getAllFields();
        cols.removeIf(col -> col == null || col.get("fieldName") == null || fields.get(col.get("fieldName")) instanceof PictureProp);
    }
}

