/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.bccenter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.instance.Instance;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.sys.ricc.business.log.AbstractLogRecord;
import kd.sys.ricc.business.log.ConfigLog;
import kd.sys.ricc.business.log.LogRecorder;
import kd.sys.ricc.business.log.impl.ConfigLogImpl;
import kd.sys.ricc.business.metadata.MetaDataCloudTransHelper;
import kd.sys.ricc.business.metadata.MetaDataDeployHandler;
import kd.sys.ricc.business.metadata.MetaDataExportHandler;
import kd.sys.ricc.business.schedule.TaskSerailHelper;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.enums.PacketDataSourceTypeEnum;
import kd.sys.ricc.common.enums.PacketLockEnum;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.PermissionUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;

public class MetaDataExportFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
UploadListener,
TreeNodeQueryListener {
    private static final String TREE_VIEW_AP = "treeviewap";
    private static final String TREE_VIEW_SELECT = "treeviewselect";
    private static final String DETAIL_ERROR_INFO_CACHE = "detailerrorinfo";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String SELECTAPPIDS_CACHE = "selectappids";
    private static final String SQLENTRYENTITY = "sqlentryentity";
    public static final String ADDAPPMETA = "addappmeta";
    public static final String KINGDEE = "kingdee";
    public static final String BTN_ADDNODE = "btn_addnode";
    public static final String BTN_DELNODE = "btn_delnode";
    public static final String NEXTSTEP = "nextstep";
    public static final String BEFORESTEP = "beforestep";
    public static final String ROOTNODE = "rootnode";
    public static final String UPLOADTAB = "uploadtab";
    public static final String TABPANEL = "tabpanel";
    private static final String LEFT_ROOT = "leftroot";
    private static final String APP_SEQ_BUTTON = "appseqbutton";
    private static final String META_CONFIRM = "metaconfirm";
    private static final String META_CONFIRM_COMPARE = "packageandcompare";
    private static final String ATTACHMENT_CONFIRM = "attachmentconfirm";
    private final ConfigLog configLog = new ConfigLogImpl();
    protected static final String DBSCHEMA = "dbschema";
    protected static final String PREINSDATA = "preinsdata";

    private String getNeedSelectedAppTip() {
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u5143\u6570\u636e\u3002", (String)"MetaDataExportFormPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (!SysParaUtil.canMetaPacket()) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u914d\u7f6e\u7ba1\u63a7\u6a21\u5f0f\u4e0d\u80fd\u8bbf\u95ee\u8be5\u754c\u9762\uff0c\u5982\u8981\u8bbf\u95ee\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u3010\u57fa\u7840\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u4fee\u6539\u914d\u7f6e\u7ba1\u63a7\u6a21\u5f0f\uff0c\u6253\u5f00\u652f\u6301\u5143\u6570\u636e\u6253\u5305\u5f00\u5173\u3002", (String)"MetaDataExportFormPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        boolean isHasPermisson = PermissionUtil.checkPagePermission((String)"bos_devportal_bizapplist", (String)"4730fc9f000004ae");
        if (!isHasPermisson) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u5f00\u53d1\u5e73\u53f0\u5bfc\u51fa\u6743\u9650\uff0c\u8bf7\u5148\u6dfb\u52a0\u5bfc\u51fa\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"MetaDataExportFormPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void registerListener(EventObject e) {
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        tree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        TreeView selectTree = (TreeView)this.getView().getControl(TREE_VIEW_SELECT);
        selectTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        selectTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        this.addClickListeners(new String[]{BTN_ADDNODE, BTN_DELNODE, NEXTSTEP, "nextsource", "nextinfo", BEFORESTEP, "beforesql", "beforesource", ATTACHMENT_CONFIRM, "sourceconfirm", "infoconfirm", ADDAPPMETA, APP_SEQ_BUTTON});
        this.addItemClickListeners(new String[]{"sqltoolbarap", "sourcetoolbarap", "sqlappid", "toolbarap"});
        Search searchleftap = (Search)this.getControl("searchleftap");
        searchleftap.addEnterListener(k -> {
            String text = k.getText();
            if (StringUtils.isNotEmpty((String)text)) {
                this.initAppMeta(text);
            } else {
                this.initAppMeta(null);
            }
        });
        Vector switchVector = (Vector)this.getControl("switch");
        switchVector.addClickListener((ClickListener)this);
        Vector logoutVector = (Vector)this.getControl("logout");
        logoutVector.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        TreeNode leftRoot = this.renderNewTreeRoot("left");
        this.getPageCache().put(LEFT_ROOT, SerializationUtils.toJsonString((Object)leftRoot));
        TreeNode rightRoot = this.renderNewTreeRoot("right");
        this.getPageCache().put("rightroot", SerializationUtils.toJsonString((Object)rightRoot));
        TreeView rightTree = (TreeView)this.getView().getControl(TREE_VIEW_SELECT);
        rightTree.addNode(rightRoot);
        this.initAppMeta(null);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        long currUserId = RequestContext.get().getCurrUserId();
        clientViewProxy.getClientLocalStorage("ricc_gitmsg_" + currUserId);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        String encryptUserName;
        Map param;
        long currUserId = RequestContext.get().getCurrUserId();
        String key = "ricc_gitmsg_" + currUserId;
        if (key.equals(e.getName()) && (param = e.getParam()).containsKey("actonResult") && StringUtils.isNotEmpty((String)(encryptUserName = (String)param.get("actonResult")))) {
            this.getPageCache().put(key, encryptUserName);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("ispush".equals(key) && ((Boolean)newValue).booleanValue()) {
            MetaDataCloudTransHelper.initGitInfo(this.getView());
        }
    }

    private TreeNode renderNewTreeRoot(String type) {
        String text = "";
        if ("left".equals(type)) {
            text = ResManager.loadKDString((String)"\u4e91\u5143\u6570\u636e", (String)"MetaDataExportFormPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]);
        } else if ("right".equals(type)) {
            text = ResManager.loadKDString((String)"\u5df2\u9009\u5143\u6570\u636e", (String)"MetaDataExportFormPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]);
        }
        TreeNode root = new TreeNode("", ROOTNODE, text);
        root.setIsOpened(true);
        return root;
    }

    private void initAppMeta(String searchText) {
        String sourceIsv = ISVServiceHelper.getISVInfo().getId();
        QFilter appFilter = null;
        QFilter kingdeeIsv = new QFilter("isv", "!=", (Object)KINGDEE);
        if (StringUtils.isNotEmpty((String)searchText)) {
            DynamicObject[] cloudDataArr;
            QFilter searchFilter = new QFilter("name", "ftlike", (Object)searchText).or(new QFilter("number", "ftlike", (Object)searchText));
            appFilter = new QFilter("isv", "=", (Object)sourceIsv).and(searchFilter).and(kingdeeIsv).and("deploystatus", "=", (Object)"2");
            QFilter qFilter = new QFilter("number", "ftlike", (Object)searchText).or(new QFilter("name", "ftlike", (Object)searchText));
            DynamicObject[] meteDataArr = BusinessDataServiceHelper.load((String)"bos_entitymeta", (String)"id,name,number,bizapp", (QFilter[])qFilter.toArray());
            if (meteDataArr.length > 0) {
                Set appSet = Arrays.stream(meteDataArr).filter(Objects::nonNull).map(y -> {
                    DynamicObject dynamicObject = y.getDynamicObject("bizapp");
                    if (dynamicObject != null) {
                        return dynamicObject.getString("id");
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toSet());
                appFilter = new QFilter("isv", "=", (Object)sourceIsv).and(new QFilter("id", "in", appSet)).and(kingdeeIsv);
            }
            if ((cloudDataArr = BusinessDataServiceHelper.load((String)"bos_devportal_bizcloud", (String)"id,name,number", (QFilter[])qFilter.toArray())).length > 0) {
                Set cloudIdSet = Arrays.stream(cloudDataArr).filter(Objects::nonNull).map(y -> y.get("id")).collect(Collectors.toSet());
                appFilter = new QFilter("isv", "=", (Object)sourceIsv).and(new QFilter("bizcloud", "in", cloudIdSet)).and(kingdeeIsv);
            }
        } else {
            appFilter = new QFilter("isv", "=", (Object)sourceIsv).and(kingdeeIsv).and("deploystatus", "=", (Object)"2");
        }
        DynamicObject[] appInfo = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZAPP, (String)"id,isv,number,name,bizcloud,industry", (QFilter[])new QFilter[]{appFilter});
        if (appInfo.length <= 0) {
            this.updateLeftTreeNode(Collections.emptyList());
            if (StringUtils.isEmpty((String)searchText)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u4ee5\u5bfc\u51fa\u7684\u5b9a\u5236\u5316\u5f00\u53d1\u5e94\u7528\u548c\u62d3\u5c55\u5e94\u7528\uff0c\u8bf7\u5148\u53bb\u5f00\u53d1\u5e73\u53f0\u521b\u5efa\u5b9a\u5236\u5316\u5f00\u53d1\u5e94\u7528\u3002", (String)"MetaDataExportFormPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
            return;
        }
        List bizCloudIdList = Arrays.stream(appInfo).map(y -> y.getDynamicObject("bizcloud")).map(l -> l.getString("id")).collect(Collectors.toList());
        DynamicObject[] cloudsInfo = BusinessDataServiceHelper.load((String)"bos_devportal_bizcloud", (String)"id,isv,number,name,industry", (QFilter[])new QFilter[]{new QFilter("id", "in", bizCloudIdList)});
        Map cloudsInfoMap = Arrays.stream(cloudsInfo).collect(Collectors.toMap(y -> y.getString("id"), Function.identity()));
        StringBuilder appNames = new StringBuilder();
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(appInfo.length);
        HashMap<String, TreeNode> cloudNodes = new HashMap<String, TreeNode>(4);
        for (int i = 0; i < appInfo.length; ++i) {
            String appId = appInfo[i].getString("id");
            String appNumber = appInfo[i].getString("number");
            String appName = appInfo[i].getLocaleString("name").getLocaleValue();
            String appIsv = appInfo[i].getString("isv");
            if (sourceIsv.equals(appIsv) && !KINGDEE.equalsIgnoreCase(appIsv)) {
                DynamicObject bizCloud = appInfo[i].getDynamicObject("bizcloud");
                String cloudId = bizCloud.getString("id");
                String cloudName = bizCloud.getString("name");
                String cloudNumber = bizCloud.getString("number");
                DynamicObject cloudIndustry = ((DynamicObject)cloudsInfoMap.get(cloudId)).getDynamicObject("industry");
                String cloudIndustryName = this.getIndustryName(cloudIndustry);
                if (!cloudNodes.containsKey(cloudId)) {
                    String cloudNodeText = MetaDataDeployHandler.getFirstNodeText(cloudName, cloudNumber, cloudIndustryName);
                    TreeNode cloudNode = new TreeNode(ROOTNODE, cloudId, cloudNodeText, true);
                    nodeList.add(cloudNode);
                    cloudNodes.put(cloudId, cloudNode);
                }
                DynamicObject appIndustry = appInfo[i].getDynamicObject("industry");
                String appIndustryName = this.getIndustryName(appIndustry);
                String appNodeText = MetaDataDeployHandler.getFirstNodeText(appName, appNumber, appIndustryName);
                TreeNode appNode = new TreeNode(cloudId, appId, appNodeText, true);
                ((TreeNode)cloudNodes.get(cloudId)).addChild(appNode);
                continue;
            }
            appNames.append(" , ");
            appNames.append('\u3010');
            appNames.append(appName);
            appNames.append('\u3011');
        }
        this.updateLeftTreeNode(nodeList);
        if (StringUtils.isNotBlank((CharSequence)appNames)) {
            String notificationBuilder = String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bfc\u51fa\u975e\u672c\u5f00\u53d1\u5546\u4e0b\u7684\u5e94\u7528\uff1a%s", (String)"MetaDataExportFormPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]), appNames);
            this.getView().showTipNotification(notificationBuilder);
        }
    }

    private String getIndustryName(DynamicObject industry) {
        String industryName = "";
        if (StringUtils.isNotBlank((Object)industry)) {
            industryName = industry.getLocaleString("name").getLocaleValue();
        }
        return industryName;
    }

    private void updateLeftTreeNode(List<TreeNode> nodeList) {
        TreeNode leftRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(LEFT_ROOT), TreeNode.class);
        leftRoot.addChildren(nodeList);
        TreeView leftTree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        leftTree.addNode(leftRoot);
        leftTree.updateNode(leftRoot);
    }

    public void queryTreeNodeChildren(TreeNodeEvent e) {
        TreeView treeView = (TreeView)e.getSource();
        if (e.getNodeId() != null) {
            String nodeId = e.getNodeId().toString();
            if (ROOTNODE.equals(nodeId)) {
                return;
            }
            List<TreeNode> treeNodeList = this.getOneAppTreeNodes(nodeId);
            treeView.addNodes(treeNodeList);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((String)BTN_ADDNODE, (String)key)) {
            this.addNode();
        }
        if (StringUtils.equals((String)BTN_DELNODE, (String)key)) {
            this.deleteNode();
        }
        if (StringUtils.equals((String)NEXTSTEP, (String)key)) {
            this.nextstepMethod(key);
        }
        if (StringUtils.equals((String)BEFORESTEP, (String)key)) {
            this.beforeStepMethod(key);
        }
        if (StringUtils.equals((String)APP_SEQ_BUTTON, (String)key)) {
            this.appSequenceConfirm();
        }
        if (StringUtils.equals((String)META_CONFIRM, (String)key)) {
            this.openAddPacketForm(key);
        }
        if (StringUtils.equals((String)ATTACHMENT_CONFIRM, (String)key)) {
            this.openAddPacketForm(key);
        }
        if (StringUtils.equals((String)"switch", (String)key)) {
            this.showGitLoginPage();
        }
        if (StringUtils.equals((String)"logout", (String)key)) {
            this.logOut();
        }
    }

    private void showGitLoginPage() {
        long currUserId = RequestContext.get().getCurrUserId();
        String key = "ricc_gitmsg_" + currUserId;
        IPageCache pageCache = this.getView().getPageCache();
        HashMap<String, String> paramMap = new HashMap<String, String>(1);
        String encryptUserName = pageCache.get(key);
        if (StringUtils.isNotBlank((CharSequence)encryptUserName)) {
            paramMap.put("username", encryptUserName);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "gitloginback");
        FormShowParameter showParameter = ShowParameterUtil.formShowParameter((String)"ricc_dipperlogin", (ShowType)ShowType.Modal, paramMap, null, null, (CloseCallBack)closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void logOut() {
        Label accountLabel = (Label)this.getView().getControl("account");
        Label branchLabel = (Label)this.getView().getControl("branch");
        accountLabel.setText("");
        branchLabel.setText("");
        long currUserId = RequestContext.get().getCurrUserId();
        String key = "ricc_gitmsg_" + currUserId;
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setClientLocalStorage(key, "");
        IPageCache pageCache = this.getView().getPageCache();
        String encryptUserName = pageCache.get(key);
        String distributeKey = Instance.getClusterName() + "." + RequestContext.get().getAccountId() + ".git." + encryptUserName;
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ricc_git_userInfo", new DistributeCacheHAPolicy());
        cache.remove(distributeKey);
        pageCache.remove(key);
    }

    private void addNode() {
        TreeView rightTree = (TreeView)this.getView().getControl(TREE_VIEW_SELECT);
        TreeView leftTree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        List leftSelectIds = leftTree.getTreeState().getCheckedNodeIds();
        if (leftSelectIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5236\u4f5c\u7684\u5143\u6570\u636e\u3002", (String)"MetaDataExportFormPlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
        } else {
            List<TreeNode> deployAppList = this.newGetRightNodesList();
            if (deployAppList.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5236\u4f5c\u7684\u6570\u636e\u3002", (String)"MetaDataExportFormPlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]));
            } else {
                AtomicInteger totalNodes = new AtomicInteger();
                this.countNodes(deployAppList, totalNodes);
                if (totalNodes.get() > 1000) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u9009\u62e91000\u4e2a\u5143\u6570\u636e\u3002", (String)"MetaDataExportFormPlugin_25", (String)"sys-ricc-platform", (Object[])new Object[0]));
                }
                this.getPageCache().put("configDataNodes", SerializationUtils.toJsonString(deployAppList));
                rightTree.addNodes(deployAppList);
                rightTree.updateNodes(deployAppList);
            }
        }
    }

    private List<TreeNode> newGetRightNodesList() {
        TreeView leftTree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        List selectNodes = leftTree.getTreeState().getSelectedNodes();
        MetaDataDeployHandler metaDataDeployHandler = new MetaDataDeployHandler(selectNodes);
        List bizAppIds = QueryServiceHelper.queryPrimaryKeys((String)BOS_DEVPORTAL_BIZAPP, null, null, (int)-1);
        List<String> nowSelectAppIdList = metaDataDeployHandler.getSelectedAppList(bizAppIds);
        List<TreeNode> addNodeList = metaDataDeployHandler.getNodeList();
        Map<String, String> treeNodeMap = metaDataDeployHandler.getTreeNodeMap();
        String hasSelectedAppIds = this.getPageCache().get(SELECTAPPIDS_CACHE);
        List<String> hasSelectedAppList = new ArrayList(10);
        if (!StringUtils.isEmpty((String)hasSelectedAppIds)) {
            hasSelectedAppList = (List)SerializationUtils.fromJsonString((String)hasSelectedAppIds, List.class);
        }
        for (String appid : nowSelectAppIdList) {
            if (hasSelectedAppList.contains(appid)) continue;
            hasSelectedAppList.add(appid);
        }
        this.getPageCache().put(SELECTAPPIDS_CACHE, SerializationUtils.toJsonString(hasSelectedAppList));
        if (!treeNodeMap.isEmpty()) {
            this.getPageCache().put(treeNodeMap);
        }
        return addNodeList;
    }

    private void deleteNode() {
        int sqlRowCount = this.getModel().getEntryRowCount(SQLENTRYENTITY);
        if (sqlRowCount > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u4e0a\u4f20SQL\u6587\u4ef6\u4e0d\u53ef\u4ee5\u79fb\u9664\u5143\u6570\u636e\u5e94\u7528\u4fe1\u606f\u3002", (String)"MetaDataExportFormPlugin_9", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        TreeView selectTree = (TreeView)this.getView().getControl(TREE_VIEW_SELECT);
        List ids = selectTree.getTreeState().getCheckedNodeIds();
        if (ids.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u79fb\u9664\u7684\u5143\u6570\u636e\u3002", (String)"MetaDataExportFormPlugin_10", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        String selectAppIds = this.getPageCache().get(SELECTAPPIDS_CACHE);
        List selectAppList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)selectAppIds)) {
            selectAppList = (List)SerializationUtils.fromJsonString((String)selectAppIds, List.class);
            if (StringUtils.isNotBlank((Object)ids)) {
                ListIterator listIterator = selectAppList.listIterator();
                while (listIterator.hasNext()) {
                    String selectAppId = (String)listIterator.next();
                    String selectAppNode = this.getPageCache().get(selectAppId);
                    TreeNode selectAppTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)selectAppNode, TreeNode.class);
                    for (String selectTreeNodeId : ids) {
                        selectAppTreeNode.deleteChildNode(selectTreeNodeId);
                    }
                    this.getPageCache().put(selectAppId, SerializationUtils.toJsonString((Object)selectAppTreeNode));
                    if (!ids.contains(selectAppId)) continue;
                    listIterator.remove();
                    this.getPageCache().remove(selectAppId);
                }
            }
        }
        if (selectAppList.isEmpty()) {
            this.getPageCache().remove(SELECTAPPIDS_CACHE);
        } else {
            this.getPageCache().put(SELECTAPPIDS_CACHE, SerializationUtils.toJsonString(selectAppList));
        }
        List selectNodes = selectTree.getTreeState().getSelectedNodes();
        MetaDataDeployHandler metaDataDeployHandler = new MetaDataDeployHandler(selectNodes);
        List bizAppIds = QueryServiceHelper.queryPrimaryKeys((String)BOS_DEVPORTAL_BIZAPP, null, null, (int)-1);
        List<String> deleteAppIdList = metaDataDeployHandler.getSelectedAppList(bizAppIds);
        String configDataNodes = this.getPageCache().get("configDataNodes");
        List configDataList = (List)SerializationUtils.fromJsonString((String)configDataNodes, List.class);
        ArrayList<Map> newConfigDataList = new ArrayList<Map>(16);
        for (Map configDataMap : configDataList) {
            String appId = (String)configDataMap.get("id");
            if (deleteAppIdList.contains(appId)) continue;
            newConfigDataList.add(configDataMap);
        }
        this.getPageCache().put("configDataNodes", SerializationUtils.toJsonString(newConfigDataList));
        ids.remove(ROOTNODE);
        selectTree.deleteNodes(ids);
        selectTree.uncheckNode(ROOTNODE);
    }

    private void beforeStepMethod(String key) {
        Tab tab = (Tab)this.getView().getControl(TABPANEL);
        if (BEFORESTEP.equals(key)) {
            tab.activeTab("metatab");
        } else if ("beforesql".equals(key)) {
            tab.activeTab(UPLOADTAB);
        } else if ("beforesource".equals(key)) {
            tab.activeTab("sourceupload");
        }
    }

    private void nextstepMethod(String key) {
        Tab tab = (Tab)this.getView().getControl(TABPANEL);
        if (NEXTSTEP.equals(key)) {
            tab.activeTab(UPLOADTAB);
        } else if ("nextsource".equals(key)) {
            tab.activeTab("sourceupload");
        } else if ("nextinfo".equals(key)) {
            tab.activeTab("packageinfo");
        }
    }

    private void appSequenceConfirm() {
        String selectAppIds = this.getPageCache().get(SELECTAPPIDS_CACHE);
        if (StringUtils.isBlank((CharSequence)selectAppIds)) {
            this.getView().showTipNotification(this.getNeedSelectedAppTip());
        } else {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_devp_installseq");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam(SELECTAPPIDS_CACHE, (Object)selectAppIds);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "appsequencecallback");
            parameter.setCloseCallBack(callBack);
            this.getView().showForm(parameter);
        }
    }

    public void itemClick(ItemClickEvent e) {
        String key;
        switch (key = e.getItemKey()) {
            case "uploaddbsql": {
                this.upLoadResourceMethod(DBSCHEMA);
                break;
            }
            case "uploadpresql": {
                this.upLoadResourceMethod(PREINSDATA);
                break;
            }
            case "metaconfirm": 
            case "packageandcompare": {
                this.openAddPacketForm(key);
                break;
            }
            case "commitmeta": {
                if (!this.checkSelectedAppIds()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u8981\u63d0\u4ea4\u7684\u5143\u6570\u636e\u3002", (String)"MetaDataExportFormPlugin_23", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    return;
                }
                long currUserId = RequestContext.get().getCurrUserId();
                String gitUsername = this.getPageCache().get("ricc_gitmsg_" + currUserId);
                if (StringUtils.isEmpty((String)gitUsername)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u767b\u5f55KingCode\u8d26\u53f7\u3002", (String)"MetaDataExportFormPlugin_24", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    return;
                }
                String msg = ResManager.loadKDString((String)"\u662f\u5426\u5c06\u9009\u4e2d\u5143\u6570\u636e\u6253\u5305\u4e3a\u4f20\u8f93\u5305\u5e76\u63a8\u9001\u81f3\u8fdc\u7a0b\u4ee3\u7801\u4ed3\u5e93\uff1f", (String)"MetaDataExportFormPlugin_19", (String)"sys-ricc-platform", (Object[])new Object[0]);
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("commitmetaback", (IFormPlugin)this));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String key = source.getOperateKey();
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)key, (CharSequence)"deleteentry")) {
            this.deleteSqlEntry();
        }
    }

    private void deleteSqlEntry() {
        int[] selectedRows;
        String selectAppIdStr = this.getPageCache().get(SELECTAPPIDS_CACHE);
        List selectIdList = (List)SerializationUtils.fromJsonString((String)selectAppIdStr, List.class);
        String configDataNodes = this.getPageCache().get("configDataNodes");
        List configDataList = (List)SerializationUtils.fromJsonString((String)configDataNodes, List.class);
        MetaDataDeployHandler metaDataDeployHandler = new MetaDataDeployHandler(configDataList);
        List bizAppIds = QueryServiceHelper.queryPrimaryKeys((String)BOS_DEVPORTAL_BIZAPP, null, null, (int)-1);
        List<String> configAppIdList = metaDataDeployHandler.getSelectedAppList(bizAppIds);
        EntryGrid entryGrid = (EntryGrid)this.getControl(SQLENTRYENTITY);
        for (int selectedRow : selectedRows = entryGrid.getEntryState().getSelectedRows()) {
            String rowAppId = (String)this.getModel().getValue("sqlappid", selectedRow);
            if (configAppIdList.contains(rowAppId)) continue;
            selectIdList.remove(rowAppId);
        }
        this.getPageCache().put(SELECTAPPIDS_CACHE, SerializationUtils.toJsonString((Object)selectIdList));
    }

    private void upLoadResourceMethod(String sourceType) {
        String selectedAppIds = this.getPageCache().get(SELECTAPPIDS_CACHE);
        if (StringUtils.isBlank((CharSequence)selectedAppIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u3010\u914d\u7f6e\u5143\u6570\u636e\u3011\u73af\u8282\u9009\u4e2d\u8981\u5bfc\u51fa\u7684\u5e94\u7528\u4fe1\u606f", (String)"MetaDataExportFormPlugin_11", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        List leftAppList = (List)SerializationUtils.fromJsonString((String)selectedAppIds, List.class);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_uploadinfo_inh");
        parameter.setCustomParam("uploadsourcetype", (Object)sourceType);
        parameter.setCustomParam(SELECTAPPIDS_CACHE, (Object)leftAppList);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "uploadcallback"));
        this.getView().showForm(parameter);
    }

    private List<TreeNode> getOneAppTreeNodes(String bizAppId) {
        StringBuilder detailErrorMsg;
        MetaDataDeployHandler metaDataDeployHandler = new MetaDataDeployHandler();
        List<TreeNode> treeNodeList = metaDataDeployHandler.getOneAppTreeNodes(bizAppId);
        StringBuilder detailErrorLogInfo = metaDataDeployHandler.getDetailErrorLogInfo();
        if (StringUtils.isNotBlank((CharSequence)detailErrorLogInfo)) {
            String detailerrorinfoStr = this.getPageCache().get(DETAIL_ERROR_INFO_CACHE);
            if (detailerrorinfoStr != null) {
                detailErrorLogInfo.insert(0, detailerrorinfoStr);
            }
            detailerrorinfoStr = detailErrorLogInfo.toString();
            this.getPageCache().put(DETAIL_ERROR_INFO_CACHE, detailerrorinfoStr);
        }
        if (StringUtils.isNotBlank((CharSequence)(detailErrorMsg = metaDataDeployHandler.getDetailErrorMsg()))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5e94\u7528\u5143\u6570\u636e\u4e0d\u5b8c\u6574\u3002", (String)"MetaDataExportFormPlugin_12", (String)"sys-ricc-platform", (Object[])new Object[0]), detailErrorMsg.toString(), MessageTypes.Default);
        }
        return treeNodeList;
    }

    private void openAddPacketForm(String key) {
        if (!this.checkSelectedAppIds()) {
            String tips = ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u8981\u6253\u5305\u7684\u5143\u6570\u636e\u3002", (String)"MetaDataExportFormPlugin_13", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            return;
        }
        this.getPageCache().put("button_key", key);
        HashMap<String, String> customParams = new HashMap<String, String>(2);
        customParams.put("addDataPacketOpenFrom", "openFromMetadata");
        FormShowParameter listShowParameter = ShowParameterUtil.formShowParameter((String)"ricc_fastaddpacket", (ShowType)ShowType.Modal, customParams, null, (String)"");
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addPacketClose"));
        this.getView().showForm(listShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("commitmetaback".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            ListSelectedRow selectedRow = this.createPacket();
            this.exportMetadataByCloud(selectedRow, true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map params;
        if ("uploadcallback".equals(evt.getActionId()) && evt.getReturnData() != null) {
            List<String> selectAppList;
            Map returnInfo = (Map)evt.getReturnData();
            JSONArray urlArr = (JSONArray)returnInfo.get("urlinfo");
            String belongAppId = (String)returnInfo.get("belongappid");
            String selectAppIds = this.getPageCache().get(SELECTAPPIDS_CACHE);
            if (StringUtils.isBlank((CharSequence)selectAppIds)) {
                selectAppList = new ArrayList(1);
                selectAppList.add(belongAppId);
                this.getPageCache().put(SELECTAPPIDS_CACHE, SerializationUtils.toJsonString(selectAppList));
            } else {
                selectAppList = (List)SerializationUtils.fromJsonString((String)selectAppIds, List.class);
                if (!selectAppList.contains(belongAppId)) {
                    selectAppList.add(belongAppId);
                }
                this.getPageCache().put(SELECTAPPIDS_CACHE, SerializationUtils.toJsonString(selectAppList));
            }
            String sourceType = (String)returnInfo.get("sourcetype");
            String sourceTypeStr = StringUtils.equals((String)sourceType, (String)DBSCHEMA) ? ResManager.loadKDString((String)"\u5efa\u8868SQL", (String)"MetaDataExportFormPlugin_14", (String)"sys-ricc-platform", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9884\u7f6eSQL", (String)"MetaDataExportFormPlugin_15", (String)"sys-ricc-platform", (Object[])new Object[0]);
            String dataBase = (String)returnInfo.get("database");
            String belongAppName = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)belongAppId, (boolean)false).getName().getLocaleValue();
            if (kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)DBSCHEMA, (CharSequence)sourceType) || kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)PREINSDATA, (CharSequence)sourceType)) {
                int sqlRowCount = this.getModel().getEntryRowCount(SQLENTRYENTITY);
                this.getModel().batchCreateNewEntryRow(SQLENTRYENTITY, urlArr.size());
                for (int i = 0; i < urlArr.size(); ++i) {
                    JSONObject urlInfo = (JSONObject)urlArr.get(i);
                    int limit = i + sqlRowCount;
                    urlInfo.forEach((urlName, url) -> {
                        this.getModel().setValue("sqlname", urlName, limit);
                        this.getModel().setValue("sqlappname", (Object)belongAppName, limit);
                        this.getModel().setValue("sqltype", (Object)sourceTypeStr, limit);
                        this.getModel().setValue("urlpath", url, limit);
                        this.getModel().setValue("sqlappid", (Object)belongAppId, limit);
                        this.getModel().setValue("databasetype", (Object)dataBase, limit);
                    });
                }
            }
        } else if ("appsequencecallback".equals(evt.getActionId()) && evt.getReturnData() != null) {
            Map returnInfo = (Map)evt.getReturnData();
            ArrayList<String> appIdList = new ArrayList<String>(returnInfo.size());
            ArrayList<String> appNumList = new ArrayList<String>(returnInfo.size());
            for (Map.Entry entry : returnInfo.entrySet()) {
                String bizAppId = (String)entry.getKey();
                String bizAppNmber = (String)entry.getValue();
                appIdList.add(bizAppId);
                appNumList.add(bizAppNmber);
            }
            this.getPageCache().put(SELECTAPPIDS_CACHE, SerializationUtils.toJsonString(appIdList));
            this.getPageCache().put("appsequenceinfo", SerializationUtils.toJsonString(appNumList));
        } else if ("gitloginback".equals(evt.getActionId()) && evt.getReturnData() != null) {
            Map returnInfo = (Map)evt.getReturnData();
            String gitUsername = (String)returnInfo.get("username");
            String gitBranch = (String)returnInfo.get("gitbranch");
            IPageCache pageCache = this.getView().getPageCache();
            long currUserId = RequestContext.get().getCurrUserId();
            pageCache.put("ricc_gitmsg_" + currUserId, Encrypters.encode((String)gitUsername));
            Label accountLabel = (Label)this.getView().getControl("account");
            Label branchLabel = (Label)this.getView().getControl("branch");
            accountLabel.setText(gitUsername);
            branchLabel.setText(gitBranch);
        } else if ("metadataclose".equals(evt.getActionId()) && (params = (Map)evt.getReturnData()) != null) {
            String selectedPacketId = this.getPageCache().get("packetid");
            String key = this.getPageCache().get("button_key");
            boolean isNeedOpenForm = StringUtils.equals((String)key, (String)META_CONFIRM_COMPARE);
            if (((Boolean)params.get("isSuccess")).booleanValue() && StringUtils.isNotBlank((CharSequence)selectedPacketId) && isNeedOpenForm) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                paramMap.put("packetId", Long.valueOf(selectedPacketId));
                paramMap.put("datatype", "package");
                FormShowParameter showParameter = ShowParameterUtil.formShowParameter((String)"ricc_metadatacompare", (ShowType)ShowType.MainNewTabPage, paramMap, null, null);
                this.getView().showForm(showParameter);
            }
            this.getPageCache().remove("packetid");
        }
        if ("addPacketClose".equalsIgnoreCase(evt.getActionId())) {
            this.afterReturnPacketForm(evt);
        }
    }

    private boolean checkSelectedAppIds() {
        String selectAppIds = this.getPageCache().get(SELECTAPPIDS_CACHE);
        if (StringUtils.isBlank((CharSequence)selectAppIds)) {
            return false;
        }
        List selectAppList = (List)SerializationUtils.fromJsonString((String)selectAppIds, List.class);
        return selectAppList != null && !selectAppList.isEmpty();
    }

    private void afterReturnPacketForm(ClosedCallBackEvent closedCallBackEvent) {
        Map params = (Map)closedCallBackEvent.getReturnData();
        if (params != null) {
            ListSelectedRow selectedPacket = (ListSelectedRow)params.get("selectedPacket");
            this.exportMetadataByCloud(selectedPacket, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportMetadataByCloud(ListSelectedRow selectedPacket, boolean isPush) {
        boolean isNeedOpenForm;
        String selectAppIds = this.getPageCache().get(SELECTAPPIDS_CACHE);
        if (StringUtils.isBlank((CharSequence)selectAppIds)) {
            this.getView().showTipNotification(this.getNeedSelectedAppTip());
            return;
        }
        List selectAppList = (List)SerializationUtils.fromJsonString((String)selectAppIds, List.class);
        if (selectAppList == null || selectAppList.isEmpty()) {
            this.getView().showTipNotification(this.getNeedSelectedAppTip());
            return;
        }
        if (selectAppList.size() > 5) {
            this.getPageCache().put("packetid", String.valueOf(selectedPacket.getPrimaryKeyValue()));
            if (TaskSerailHelper.taskExist("ricc_metadata_packet_task")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u6709\u4efb\u52a1\u5728\u6267\u884c\u5143\u6570\u636e\u6253\u5305\u4e86\uff0c\u8bf7\u7b49\u5f85\u4efb\u52a1\u6267\u884c\u7ed3\u675f\u4e4b\u540e\u518d\u53d1\u8d77\u3002", (String)"MetaDataExportFormPlugin_16", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> allParam = new HashMap<String, Object>();
            allParam.put("custParam", this.getPageCache().getAll());
            allParam.put("formId", "ricc_metadata_export");
            allParam.put("parentPageId", this.getView().getPageId());
            allParam.put("selectedPacket", selectedPacket);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ricc_addpacketprogress");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u5143\u6570\u636e\u6dfb\u52a0\u5230\u4f20\u8f93\u5305", (String)"MetaDataExportFormPlugin_17", (String)"sys-ricc-platform", (Object[])new Object[0]));
            formShowParameter.setCustomParams(allParam);
            HashSet<String> taskKeySet = new HashSet<String>();
            taskKeySet.add("ricc_metadata_packet_task");
            formShowParameter.setCustomParam("ricconcekey", taskKeySet);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "metadataclose"));
            this.getView().showForm(formShowParameter);
            return;
        }
        this.configLog.preWriteLog("3", "0", (Long)selectedPacket.getPrimaryKeyValue(), 0L, "", null);
        MetaDataExportHandler metaDataExportHandler = new MetaDataExportHandler(this.getView(), null);
        LogRecorder message = new LogRecorder();
        String gitResult = "";
        try {
            gitResult = metaDataExportHandler.exportMetadataByCloud(selectedPacket, selectAppList);
            message.setEndTime(System.currentTimeMillis());
            this.addLog(selectAppList.size(), message);
        }
        catch (Exception e) {
            message.append(CommonUtil.getExceptionDetailInfo((Throwable)e), e);
            this.getView().showErrorNotification(CommonUtil.getExceptionDetailInfo((Throwable)e));
            message.setEndTime(System.currentTimeMillis());
            this.addLog(selectAppList.size(), message);
            return;
        }
        finally {
            if (!gitResult.contains("success")) {
                QFilter filter = new QFilter("id", "=", selectedPacket.getPrimaryKeyValue());
                DeleteServiceHelper.delete((String)"ricc_datapacket", (QFilter[])filter.toArray());
            }
        }
        String key = this.getPageCache().get("button_key");
        boolean bl = isNeedOpenForm = StringUtils.equals((String)key, (String)META_CONFIRM_COMPARE);
        if (isPush && "success".equals(gitResult)) {
            String number = selectedPacket.getNumber();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6253\u5305\u5e76\u63d0\u4ea4\u4ee3\u7801\u4ed3\u6210\u529f\uff0c\u6784\u5efa\u4f20\u8f93\u5305\u7f16\u7801\u4e3a%s", (String)"MetaDataExportFormPlugin_22", (String)"sys-ricc-platform", (Object[])new Object[]{number}));
        } else if (isPush) {
            this.getView().showErrorNotification(gitResult);
        } else if (isNeedOpenForm) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("packetId", selectedPacket.getPrimaryKeyValue());
            paramMap.put("datatype", "package");
            FormShowParameter showParameter = ShowParameterUtil.formShowParameter((String)"ricc_metadatacompare", (ShowType)ShowType.MainNewTabPage, paramMap, null, null);
            this.getView().showForm(showParameter);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u6210\u529f\u3002", (String)"MetaDataExportFormPlugin_18", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
    }

    private void addLog(int total, AbstractLogRecord logRecord) {
        int successCount = 0;
        if (logRecord.getMessageStr() == null || logRecord.getMessageStr().length() <= 0) {
            successCount = total;
        }
        this.configLog.afterWriteLog(total, successCount, logRecord);
    }

    private ListSelectedRow createPacket() {
        ListSelectedRow selectPacket = new ListSelectedRow();
        String timestamp = new SimpleDateFormat("MMddHHmm").format(new Date());
        String name = ResManager.loadKDString((String)"\u5143\u6570\u636e\u6253\u5305", (String)"MetaDataExportFormPlugin_20", (String)"sys-ricc-platform", (Object[])new Object[0]);
        String packetName = String.format("%1$s-%2$s", name, timestamp);
        DynamicObject newPacket = BusinessDataServiceHelper.newDynamicObject((String)"ricc_datapacket");
        long packetId = DB.genLongId((String)"ricc_datapacket");
        newPacket.set("id", (Object)packetId);
        newPacket.set("status", (Object)"A");
        newPacket.set("creator", (Object)RequestContext.get().getCurrUserId());
        newPacket.set("createtime", (Object)System.currentTimeMillis());
        newPacket.set("dltrcount", (Object)0);
        newPacket.set("enable", (Object)"1");
        newPacket.set("packettype", (Object)DataPacketTypeEnum.METADATA.getVal());
        newPacket.set("name", (Object)packetName);
        String readNumber = CodeRuleServiceHelper.getNumber((String)"ricc_datapacket", (DynamicObject)newPacket, null);
        newPacket.set("number", (Object)readNumber);
        newPacket.set("datasource", (Object)PacketDataSourceTypeEnum.DATASOURCE_NEW.getVal());
        newPacket.set("lockedstatus", (Object)PacketLockEnum.NOT_LOCKED.getVal());
        String configDataNodes = this.getPageCache().get("configDataNodes");
        newPacket.set("committree_tag", (Object)configDataNodes);
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newPacket});
        }
        catch (Exception e) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u521b\u5efa\u4f20\u8f93\u5305\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MetaDataExportFormPlugin_21", (String)"sys-ricc-platform", (Object[])new Object[0]), (Throwable)e);
        }
        selectPacket.setName(packetName);
        selectPacket.setNumber(readNumber);
        selectPacket.setPrimaryKeyValue((Object)packetId);
        return selectPacket;
    }

    private void countNodes(List<TreeNode> deployAppList, AtomicInteger totalNodes) {
        for (TreeNode treeNode : deployAppList) {
            List children = treeNode.getChildren();
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                this.countNodes(children, totalNodes);
                continue;
            }
            totalNodes.getAndAdd(1);
        }
    }
}

