/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.bccenter.guide;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.sys.ricc.business.configitem.ConfigItemHelper;
import kd.sys.ricc.business.configitem.ConfigItemTreeHelper;
import kd.sys.ricc.common.util.ImplOrderUtil;
import kd.sys.ricc.common.util.ImportTemplateChangeUtil;
import kd.sys.ricc.common.util.OpenFilterFormUtil;
import kd.sys.ricc.common.util.PageChangeUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;

public class ImplProjectGuidePlugin
extends AbstractBasePlugIn
implements IDataModelChangeListener,
BeforeF7SelectListener {
    private static final String FIELD_GROUP = "group";
    private static final String FIELD_ORDER = "orderfield";
    private static final String ENTITYID_TREE = "ricc_configtree";
    private static final String MARKDOWN = "markdownap";
    private static final String HELP_TEXT = "helptext";
    private static final String SUPPORT_ADDTOPACKET = "supportaddtopacket";
    private static final String IMPORTTYPE = "importtype";
    private static final String PLUGIN = "plugin";
    private static final String PAGE_ENTER_PARAM = "pageenterparam";
    private static final String PAGE_ENTER_PARAM_BILL = "ricc_pageenterparam";
    public static final String PAGE = "page";
    public static final String DATA_IMPORT_TYPE = "dataimporttype";
    private static final String KEY_FIELDS = "keyfields";
    private static final String RICC_ITEM_SCHEME = "ricc_schemeentry";
    private static final String SCHEME = "scheme";
    private static final String RELYITEMENTRY = "relyitementry";
    private static final String RELYITEM = "relyitem";
    private static final String RELYRELATIONFIELD = "relyrelationfield";
    private static final String FASTADDRELY = "fastaddrely";
    private static final String RIGHTPAGE = "rightpage";
    private static final String SAVE_CONFIG_ITEM_CALLBACK_ID = "saveconfigitemcallbackid";
    private static final String CONFIG_ITEM_PAGE_TYPE = "configitempagetype";
    private static final String EXTEND_MODEL = "extendmodel";
    private static final String EXTEND_MODEL_KEY = "extendmodelkey";
    private static final String NO_SAVE_FIELD_ENTRY = "nosavefieldentry";
    private static final String NO_SAVE_FIELD_ENTRY_TAG = "nosavefieldentry_tag";
    private static final String HAVE_SAVE_OP = "havesaveop";
    private static final String HAVE_IMP_AND_EXP = "haveimpandexp";
    private static final String LIST_SUPPORT_IMP_AND_EXP = "listsupportimpandexp";
    private static final String DEFAULT_DATA_STATUS = "defaultdatastatus";
    private static final String MASTER_ID = "masterid";
    private static final String DEFAULT_KEY_FIELDS = "defaultkeyfields";
    private static final String NEI_MA = "id";
    private static final String NUMBER = "number";
    private static final String CONDITION_MUST_FIELD = "conditionmustfield";
    private static final String HIDDEN_BUTTON_FIELD = "hiddenbuttonfield";
    private static final String COVERINFO_FIELD = "coverinfo";
    private static final String SAVE_UNIQUE_FIELD = "saveuniquefield";
    private static final String SAVE_UNIQUE_FIELD_TAG = "saveuniquefield_tag";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"exportfiltersdesc", PLUGIN, PAGE_ENTER_PARAM, RELYRELATIONFIELD});
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("importtemplate");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit relyItem = (BasedataEdit)this.getView().getControl(RELYITEM);
        relyItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit pageFieldEdit = (BasedataEdit)this.getView().getControl(PAGE);
        pageFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit groupFieldEdit = (BasedataEdit)this.getView().getControl(FIELD_GROUP);
        groupFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        if (param != null) {
            Object treeNode = param.getCustomParam("treeNode");
            if (treeNode != null) {
                this.getModel().setValue(FIELD_GROUP, treeNode);
            }
            Markdown mk = (Markdown)this.getView().getControl(MARKDOWN);
            mk.setText("");
            String pageNumber = (String)param.getCustomParam("pagenumber");
            if (pageNumber != null) {
                Object entityId = QueryServiceHelper.queryPrimaryKeys((String)"bos_formmeta", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)pageNumber)}, null, (int)-1).get(0);
                this.getModel().setValue(PAGE, entityId);
                this.getModel().setValue(RIGHTPAGE, entityId);
                DynamicObject page = (DynamicObject)this.getModel().getValue(PAGE);
                PageChangeUtil.pageChangeEvent((DynamicObject)page, (IFormView)this.getView());
                this.pageChange();
                boolean isSupportAddToPacket = (Boolean)this.getModel().getValue(SUPPORT_ADDTOPACKET);
                String importType = (String)this.getModel().getValue(IMPORTTYPE);
                if (importType != null) {
                    boolean isImportTypeExcelOrJson;
                    boolean bl = isImportTypeExcelOrJson = StringUtils.equals((String)"excel", (String)importType) || StringUtils.equals((String)"json", (String)importType);
                    if (isSupportAddToPacket && isImportTypeExcelOrJson) {
                        this.getModel().setValue("canexportall", (Object)Boolean.TRUE);
                    }
                }
            }
        }
        this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"ImplProjectGuidePlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0])));
        ImplOrderUtil.groupChange((IFormView)this.getView(), (String)FIELD_ORDER, (String)FIELD_ORDER, (String)ENTITYID_TREE);
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity(RICC_ITEM_SCHEME);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryOne = (DynamicObject)entryEntity.get(i);
            DynamicObject scheme = (DynamicObject)entryOne.get(SCHEME);
            if (Objects.isNull(scheme)) continue;
            this.setEntryRowStatus(scheme, i);
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        String environmentLanguage;
        boolean supportImport = (Boolean)this.getModel().getValue(SUPPORT_ADDTOPACKET);
        ComboEdit importtype = (ComboEdit)this.getView().getControl(IMPORTTYPE);
        importtype.setMustInput(supportImport);
        String importType = (String)this.getModel().getValue(IMPORTTYPE);
        if (StringUtils.equals((String)"custom", (String)importType) || StringUtils.equals((String)"microService", (String)importType)) {
            TextEdit serviceConfig = (TextEdit)this.getView().getControl(PLUGIN);
            serviceConfig.setMustInput(true);
        }
        this.modifyKeyFieldsTips();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"copy_button"});
        }
        if (!"zh_CN".equals(environmentLanguage = RequestContext.get().getLang().toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        }
    }

    private void modifyKeyFieldsTips() {
        MainEntityType mainEntityType;
        String entityNumber;
        QFilter numberFilter;
        DynamicObject formMeta;
        String modelType;
        DynamicObject page = (DynamicObject)this.getModel().getValue(PAGE);
        if (page != null && (StringUtils.equals((String)(modelType = (formMeta = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (QFilter[])(numberFilter = new QFilter(NUMBER, "=", (Object)(entityNumber = page.getString("basedatafield.number")))).toArray())).getString("modeltype")), (String)"BillFormModel") || StringUtils.equals((String)modelType, (String)"BaseFormModel")) && (mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber)) != null) {
            DynamicObject initConfig = BusinessDataServiceHelper.loadSingleFromCache((Object)1367275628033736704L, (String)"ricc_initconfig");
            String defaultKeyFields = (String)initConfig.get(DEFAULT_KEY_FIELDS);
            StringBuilder defaultTipsContentSb = new StringBuilder();
            defaultTipsContentSb.append(ResManager.loadKDString((String)"\u7528\u4e8e\u8bc6\u522b\u6570\u636e\u4e3a\u8986\u76d6\u6216\u65b0\u589e\uff0c\u53ef\u53c2\u8003\u4eba\u5de5\u5904\u7406\u65f6\u5bfc\u5165\u754c\u9762\u8bbe\u7f6e\u3002", (String)"ImplProjectGuidePlugin_9", (String)"sys-ricc-platform", (Object[])new Object[0])).append('\n').append(ResManager.loadKDString((String)"\u8bbe\u7f6e\u4e3a\u7a7a\u65f6\u9ed8\u8ba4\u53d6\u3010\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u3011-\u3010\u53c2\u6570\u8bbe\u7f6e\u3011-\u3010\u540c\u6b65\u9ed8\u8ba4\u5339\u914d\u5b57\u6bb5\u3011\u8bbe\u7f6e", (String)"ImplProjectGuidePlugin_13", (String)"sys-ricc-platform", (Object[])new Object[0]));
            String tipsContent = StringUtils.equals((String)defaultKeyFields, (String)NEI_MA) ? String.valueOf(defaultTipsContentSb.append("\uff0c").append(ResManager.loadKDString((String)"\u5f53\u524d\u540c\u6b65\u9ed8\u8ba4\u5b57\u6bb5\u4e3a\uff1a\u5185\u7801\u3002", (String)"ImplProjectGuidePlugin_10", (String)"sys-ricc-platform", (Object[])new Object[0]))) : ImplProjectGuidePlugin.getTips(mainEntityType, defaultTipsContentSb);
            Tips tips = new Tips();
            tips.setContent(new LocaleString(tipsContent));
            tips.setType("text");
            MulComboEdit keyFieldsControl = (MulComboEdit)this.getControl(KEY_FIELDS);
            keyFieldsControl.addTips(tips);
        }
    }

    private static String getTips(MainEntityType mainEntityType, StringBuilder defaultTipsContentSb) {
        Map<String, String> numberAndMainOrg = ConfigItemHelper.getNumberAndMainOrg(mainEntityType);
        String mainOrg = numberAndMainOrg.get("mainOrg");
        String mainOrgName = "";
        if (StringUtils.isNotBlank((CharSequence)mainOrg)) {
            mainOrgName = mainEntityType.getProperty(mainOrg).getDisplayName().getLocaleValue();
        }
        String numberField = numberAndMainOrg.get("numberField");
        String numberFieldName = "";
        if (StringUtils.isNotBlank((CharSequence)numberField)) {
            numberFieldName = mainEntityType.getProperty(numberField).getDisplayName().getLocaleValue();
        }
        String tipsContent = StringUtils.isBlank((CharSequence)numberFieldName) && StringUtils.isNotBlank((CharSequence)mainOrgName) ? String.valueOf(defaultTipsContentSb.append("\uff0c").append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u540c\u6b65\u9ed8\u8ba4\u5b57\u6bb5\u4e3a\uff1a%s\u3002", (String)"ImplProjectGuidePlugin_11", (String)"sys-ricc-platform", (Object[])new Object[0]), mainOrgName))) : (StringUtils.isBlank((CharSequence)numberFieldName) && StringUtils.isBlank((CharSequence)mainOrgName) ? defaultTipsContentSb.toString() : (StringUtils.isBlank((CharSequence)mainOrgName) ? String.valueOf(defaultTipsContentSb.append("\uff0c").append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u540c\u6b65\u9ed8\u8ba4\u5b57\u6bb5\u4e3a\uff1a%s\u3002", (String)"ImplProjectGuidePlugin_11", (String)"sys-ricc-platform", (Object[])new Object[0]), numberFieldName))) : String.valueOf(defaultTipsContentSb.append("\uff0c").append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u540c\u6b65\u9ed8\u8ba4\u5b57\u6bb5\u4e3a\uff1a%1$s+%2$s\u3002", (String)"ImplProjectGuidePlugin_12", (String)"sys-ricc-platform", (Object[])new Object[0]), numberFieldName, mainOrgName)))));
        return tipsContent;
    }

    public void afterLoadData(EventObject e) {
        this.initMarkdown();
        ImportTemplateChangeUtil.importTemplateIdChange((IFormView)this.getView());
        DynamicObject rightPage = (DynamicObject)this.getView().getModel().getValue(RIGHTPAGE);
        if (rightPage == null) {
            return;
        }
        String entityNumber = (String)rightPage.get("basedatafield.number");
        PageChangeUtil.getKeyFields((IFormView)this.getView(), (String)entityNumber);
        this.setConfigItemInfo(entityNumber, false, true);
        this.setRelyItemField();
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity(RICC_ITEM_SCHEME);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryOne = (DynamicObject)entryEntity.get(i);
            DynamicObject scheme = (DynamicObject)entryOne.get(SCHEME);
            if (Objects.isNull(scheme)) continue;
            this.setEntryRowStatus(scheme, i);
        }
        this.getModel().setDataChanged(false);
        String exportFiltersDescMultilingual = ((OrmLocaleValue)this.getModel().getValue("exportfiltersdesc_l")).getLocaleValue();
        this.getModel().setValue("exportfiltersdesc", (Object)exportFiltersDescMultilingual);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setRelyItemField();
        String entityNumber = (String)((DynamicObject)this.getView().getModel().getValue(RIGHTPAGE)).get("basedatafield.number");
        PageChangeUtil.getKeyFields((IFormView)this.getView(), (String)entityNumber);
        this.setConfigItemInfo(entityNumber, true, false);
        IDataModel model = this.getModel();
        PageChangeUtil.copyNumberAndName((IDataModel)model);
        String exportFiltersDescMultilingual = ((OrmLocaleValue)this.getModel().getValue("exportfiltersdesc_l")).getLocaleValue();
        this.getModel().setValue("exportfiltersdesc", (Object)exportFiltersDescMultilingual);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if ("exportfiltersdesc".equals(controlKey)) {
            this.showFilterCondition();
        } else if (PLUGIN.equals(controlKey)) {
            String formId;
            String importType;
            switch (importType = (String)this.getView().getModel().getValue(IMPORTTYPE)) {
                case "microService": {
                    formId = "ricc_microservice";
                    break;
                }
                case "custom": {
                    formId = "ricc_pluginservice";
                    break;
                }
                case "json": {
                    formId = "ricc_jsonservice";
                    break;
                }
                default: {
                    formId = "ricc_microservice";
                }
            }
            FormShowParameter parameter = ShowParameterUtil.simpleFormShowParameter((String)formId, null);
            parameter.setCustomParam("config", this.getModel().getValue(PLUGIN));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "configCloseCallBack"));
            this.getView().showForm(parameter);
        } else if (PAGE_ENTER_PARAM.equals(controlKey)) {
            FormShowParameter parameter = ShowParameterUtil.simpleFormShowParameter((String)PAGE_ENTER_PARAM_BILL, null);
            parameter.setCustomParam("enterParams", this.getModel().getValue(PAGE_ENTER_PARAM));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pageenterparamCloseCallBack"));
            this.getView().showForm(parameter);
        }
    }

    private void showFilterCondition() {
        DynamicObject page = (DynamicObject)this.getModel().getValue(PAGE);
        if (page == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u914d\u7f6e\u8868\u5355\u3002", (String)"ImplProjectGuidePlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
        } else {
            String formId = page.getString("basedatafield.number");
            String conditionJson = (String)this.getModel().getValue("exportfilters_tag");
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
            TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)dataEntityType, null);
            String flsNodes = SerializationUtils.toJsonString((Object)treeNode);
            OpenFilterFormUtil.showConditionForm((IFormView)this.getView(), (String)conditionJson, (String)formId, (String)flsNodes, (String)this.getPluginName(), (String)"filtereditaction");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        switch (fieldKey) {
            case "group": {
                ImplOrderUtil.groupChange((IFormView)this.getView(), (String)FIELD_ORDER, (String)FIELD_ORDER, (String)ENTITYID_TREE);
                break;
            }
            case "supportaddtopacket": {
                boolean supportImport = (Boolean)e.getChangeSet()[0].getNewValue();
                ComboEdit importtype = (ComboEdit)this.getView().getControl(IMPORTTYPE);
                importtype.setMustInput(supportImport);
                if (supportImport) break;
                this.getModel().setValue(IMPORTTYPE, null);
                this.getModel().setValue(CONDITION_MUST_FIELD, null);
                this.getModel().setValue(COVERINFO_FIELD, null);
                this.getModel().setValue("istransferattach", (Object)false);
                this.getModel().setValue("transtips", null);
                this.getView().getModel().setValue("canexportall", (Object)Boolean.FALSE);
                break;
            }
            case "importtype": {
                String importType = (String)e.getChangeSet()[0].getNewValue();
                this.importTypeCheck(importType);
                this.getModel().setValue("importtemplate", null);
                this.getModel().setValue(DATA_IMPORT_TYPE, null);
                this.getModel().setValue(KEY_FIELDS, null);
                this.getModel().setValue(PLUGIN, null);
                this.getModel().setValue("sortfield", null);
                this.getModel().setValue("sortway", null);
                this.getModel().setValue(CONDITION_MUST_FIELD, null);
                break;
            }
            case "exportfiltersdesc": {
                if (!StringUtils.isBlank((Object)changeData.getNewValue())) break;
                this.getModel().setValue("exportfilters", null);
                this.getModel().setValue("exportfilters_tag", null);
                break;
            }
            case "page": {
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                PageChangeUtil.pageChangeEvent((DynamicObject)newValue, (IFormView)this.getView());
                this.getModel().setValue("importtemplate", null);
                this.getModel().setValue("sortfield", null);
                this.getModel().setValue("sortway", null);
                this.pageChange();
                this.modifyKeyFieldsTips();
                break;
            }
            case "rightpage": {
                this.getModel().deleteEntryData(RELYITEMENTRY);
                ComboEdit comboEdit = (ComboEdit)this.getView().getControl(RELYRELATIONFIELD);
                comboEdit.setComboItems(new ArrayList(10));
                if (this.getView().getModel().getValue(PAGE) == null) {
                    return;
                }
                this.setRelyItemField();
                break;
            }
            case "importtemplate": {
                DynamicObject importChange = (DynamicObject)e.getChangeSet()[0].getNewValue();
                ImportTemplateChangeUtil.importTemplateChangeId((DynamicObject)importChange, (IFormView)this.getView());
                break;
            }
            case "dataimporttype": {
                if (this.getView().getModel().getValue(PAGE) == null) {
                    return;
                }
                String billFormId = ((DynamicObject)this.getModel().getValue(PAGE)).getString(NUMBER);
                String keyFields = PageChangeUtil.getBillUniqueKeys((String)billFormId);
                String dataImportType = (String)e.getChangeSet()[0].getNewValue();
                if ("new".equals(dataImportType)) {
                    this.getModel().setValue(KEY_FIELDS, null);
                    break;
                }
                this.getModel().setValue(KEY_FIELDS, (Object)keyFields);
                break;
            }
            case "scheme": {
                DynamicObject selectScheme = (DynamicObject)changeData.getNewValue();
                if (Objects.isNull(selectScheme)) {
                    return;
                }
                this.setEntryRowStatus(selectScheme, rowIndex);
                break;
            }
            case "sortfield": {
                String sortField = (String)this.getModel().getValue("sortfield");
                if (!StringUtils.isEmpty((String)sortField)) break;
                this.getModel().setValue("sortway", null);
                break;
            }
            case "istransferattach": {
                this.getModel().setValue("attachmentfield", null);
            }
        }
    }

    private void pageChange() {
        this.getModel().setValue(KEY_FIELDS, null);
        this.getModel().setValue(CONDITION_MUST_FIELD, null);
        this.getModel().setValue(COVERINFO_FIELD, null);
        this.getModel().setValue("attachmentfield", (Object)false);
        DynamicObject rightPage = (DynamicObject)this.getModel().getValue(RIGHTPAGE);
        if (rightPage != null) {
            boolean isExcelOrJson;
            String entityNumber = (String)rightPage.get("basedatafield.number");
            this.setNumberAndName(rightPage);
            PageChangeUtil.getKeyFields((IFormView)this.getView(), (String)entityNumber);
            this.setConfigItemInfo(entityNumber, false, false);
            String importType = (String)this.getModel().getValue(IMPORTTYPE);
            boolean bl = isExcelOrJson = StringUtils.equals((String)importType, (String)"excel") || StringUtils.equals((String)importType, (String)"json");
            if (isExcelOrJson) {
                String keyFields = PageChangeUtil.getBillUniqueKeys((String)entityNumber);
                this.getModel().setValue(KEY_FIELDS, (Object)keyFields);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            DynamicObject pageValue;
            AbstractOperate operate = (AbstractOperate)args.getSource();
            String opKey = operate.getOperateKey();
            if ("save".equals(opKey)) {
                Markdown mk = (Markdown)this.getView().getControl(MARKDOWN);
                if (!StringUtils.isEmpty((String)mk.getText())) {
                    this.getModel().setValue(HELP_TEXT, (Object)mk.getText().replaceAll("\n", "<br>"));
                }
                this.getModel().setValue("status", (Object)"C");
                DynamicObjectCollection relyEntity = this.getModel().getEntryEntity(RELYITEMENTRY);
                int maxLevel = 0;
                ArrayList<Long> itemIdList = new ArrayList<Long>();
                for (DynamicObject relyRow : relyEntity) {
                    DynamicObject reyItem = (DynamicObject)relyRow.get(RELYITEM);
                    if (reyItem == null) continue;
                    itemIdList.add((Long)reyItem.get(NEI_MA));
                    int relyItemLevel = reyItem.getInt("relylevel");
                    maxLevel = Integer.max(maxLevel, relyItemLevel);
                }
                int size = itemIdList.size();
                List distinctList = itemIdList.stream().distinct().collect(Collectors.toList());
                if (distinctList.size() < size) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u914d\u7f6e\u4f9d\u8d56\u5206\u5f55\u4e2d\u4f9d\u8d56\u914d\u7f6e\u9879\u5b57\u6bb5\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"ImplProjectGuidePlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.getModel().setValue("relylevel", (Object)(maxLevel + 1));
            }
            if (FASTADDRELY.equals(opKey) && (pageValue = (DynamicObject)this.getModel().getValue(PAGE)) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u914d\u7f6e\u8868\u5355", (String)"ImplProjectGuidePlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if ("modify".equals(opKey)) {
            Markdown mk = (Markdown)this.getView().getControl(MARKDOWN);
            mk.setModelType(Markdown.Edit);
        } else if (StringUtils.equals((String)FASTADDRELY, (String)opKey) && args.getOperationResult().isSuccess()) {
            this.fastAddRelyItem();
        }
    }

    private void fastAddRelyItem() {
        DynamicObject pageValue = (DynamicObject)this.getModel().getValue(PAGE);
        String page = pageValue.getString(NUMBER);
        String configItemPageType = PageChangeUtil.getConfigItemPageType((String)page);
        MainEntityType entityType = null;
        if ("PCLayout".equals(configItemPageType)) {
            String entityTypeId = FormMetadataCache.getFormConfig((String)page).getEntityTypeId();
            entityType = EntityMetadataCache.getDataEntityType((String)entityTypeId);
        } else {
            entityType = EntityMetadataCache.getDataEntityType((String)page);
        }
        HashMap<String, String> disPlayNameMap = new HashMap<String, String>(16);
        HashMap<String, String> baseFieldMap = new HashMap<String, String>(16);
        HashMap<String, String> itemClassPropMap = new HashMap<String, String>(16);
        DataEntityPropertyCollection properties = entityType.getProperties();
        this.getFieldMapping(properties, baseFieldMap, disPlayNameMap, itemClassPropMap);
        if (baseFieldMap.isEmpty() && itemClassPropMap.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u68c0\u6d4b\u5230\u76f8\u5173\u4f9d\u8d56\u9879\uff0c\u8bf7\u624b\u5de5\u6dfb\u52a0\u3002", (String)"ImplProjectGuidePlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put("itemClassPropMap", JSON.toJSONString(itemClassPropMap));
        this.getPageCache().put("baseFieldMap", JSON.toJSONString(baseFieldMap));
        DynamicObject[] relyItems = this.getConfigItems(baseFieldMap, itemClassPropMap);
        ArrayList<String> pageNumberList = new ArrayList<String>();
        LinkedHashSet repetitionItemSet = new LinkedHashSet();
        for (DynamicObject item : relyItems) {
            String pageNumber = (String)item.get("page.number");
            if (pageNumberList.contains(pageNumber)) {
                for (Map.Entry entry : baseFieldMap.entrySet()) {
                    if (!StringUtils.equals((String)pageNumber, (String)((String)entry.getValue()))) continue;
                    repetitionItemSet.add(disPlayNameMap.get(entry.getKey()));
                }
                if (itemClassPropMap.isEmpty()) continue;
                for (Map.Entry itemClassEntry : itemClassPropMap.entrySet()) {
                    if (!StringUtils.equals((String)pageNumber, (String)((String)itemClassEntry.getKey()))) continue;
                    repetitionItemSet.add(disPlayNameMap.get(itemClassEntry.getValue()));
                }
                continue;
            }
            pageNumberList.add(pageNumber);
        }
        String tip = "";
        if (!repetitionItemSet.isEmpty()) {
            StringBuilder repetitionItemStr = new StringBuilder();
            for (String field : repetitionItemSet) {
                repetitionItemStr.append(field).append('\uff0c');
            }
            repetitionItemStr.deleteCharAt(repetitionItemStr.lastIndexOf("\uff0c"));
            tip = ResManager.loadKDString((String)"\u201c%s\u201d\u5b57\u6bb5\u7684\u7c7b\u578b\u5339\u914d\u5230\u591a\u4e2a\u914d\u7f6e\u9879\uff0c\u5c06\u5168\u90e8\u586b\u5145\u81f3\u914d\u7f6e\u4f9d\u8d56\u5217\u8868\uff0c\u8bf7\u68c0\u67e5\u540e\u5220\u9664\u65e0\u6548\u884c\u3002", (String)"ImplProjectGuidePlugin_4", (String)"sys-ricc-platform", (Object[])new Object[]{repetitionItemStr});
        }
        String msg = String.format(ResManager.loadKDString((String)"\u6839\u636e\u201c\u914d\u7f6e\u8868\u5355\u201d\u4e2d\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u7684\u7c7b\u578b\u548c\u914d\u7f6e\u9879\u8fdb\u884c\u5339\u914d\u81ea\u52a8\u751f\u6210\u4f9d\u8d56\u5217\u8868\u3002%s\u672c\u64cd\u4f5c\u4f1a\u8986\u76d6\u914d\u7f6e\u4f9d\u8d56\u5217\u8868\uff0c\u8bf7\u786e\u8ba4", (String)"ImplProjectGuidePlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]), tip);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("fastaddrelyclick", (IFormPlugin)this));
    }

    private void getFieldMapping(DataEntityPropertyCollection properties, Map<String, String> baseFieldMap, Map<String, String> disPlayNameMap, Map<String, String> itemClassPropMap) {
        for (IDataEntityProperty property : properties) {
            boolean condition;
            if (property instanceof EntryProp) {
                EntryProp p = (EntryProp)property;
                DataEntityPropertyCollection entryProperties = p.getDynamicCollectionItemPropertyType().getProperties();
                this.getFieldMapping(entryProperties, baseFieldMap, disPlayNameMap, itemClassPropMap);
                continue;
            }
            boolean bl = condition = (property instanceof BasedataProp || property instanceof MulBasedataProp) && !(property instanceof ItemClassProp);
            if (condition) {
                disPlayNameMap.put(property.getName(), property.getDisplayName().getLocaleValue());
                baseFieldMap.put(property.getName(), ((IBasedataField)property).getBaseEntityId());
            }
            if (!(property instanceof ItemClassProp)) continue;
            ItemClassProp p = (ItemClassProp)property;
            ItemClassTypeProp type = (ItemClassTypeProp)properties.get((Object)p.getTypePropName());
            for (String key : type.getItemTypes().keySet()) {
                itemClassPropMap.put(key, p.getName());
            }
            disPlayNameMap.put(p.getName(), p.getDisplayName().getLocaleValue());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("fastaddrelyclick".equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            this.getModel().deleteEntryData(RELYITEMENTRY);
            this.addRelyToEntry();
        } else if (SAVE_CONFIG_ITEM_CALLBACK_ID.equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("save");
        }
    }

    private void addRelyToEntry() {
        Map fieldBaseMap = (Map)JSON.parseObject((String)this.getPageCache().get("baseFieldMap"), Map.class);
        Map itemClassPropMap = (Map)JSON.parseObject((String)this.getPageCache().get("itemClassPropMap"), Map.class);
        DynamicObject[] relyItems = this.getConfigItems(fieldBaseMap, itemClassPropMap);
        HashMap<String, DynamicObject> relyItemsMap = new HashMap<String, DynamicObject>(16);
        LinkedHashMap<String, String> numberPageNumberMappingMap = new LinkedHashMap<String, String>(16);
        HashSet<String> pageNumberSet = new HashSet<String>(16);
        for (DynamicObject relyItem : relyItems) {
            String string = (String)relyItem.get(NUMBER);
            String pageNumber = (String)relyItem.get("page.number");
            pageNumberSet.add(pageNumber);
            numberPageNumberMappingMap.put(string, pageNumber);
            relyItemsMap.put(string, relyItem);
        }
        HashMap<String, String> existBaseItemMap = new HashMap<String, String>(16);
        fieldBaseMap.forEach((key, value) -> {
            if (pageNumberSet.contains(value)) {
                existBaseItemMap.put((String)key, (String)value);
            }
        });
        HashMap<String, String> existItemClassMap = new HashMap<String, String>(16);
        if (!itemClassPropMap.isEmpty()) {
            itemClassPropMap.forEach((key, value) -> {
                if (pageNumberSet.contains(key)) {
                    existItemClassMap.put((String)key, (String)value);
                }
            });
        }
        HashMap<String, Integer> row = new HashMap<String, Integer>(16);
        for (Map.Entry entry : numberPageNumberMappingMap.entrySet()) {
            String key2 = (String)entry.getKey();
            int newEntryRow = this.getModel().createNewEntryRow(RELYITEMENTRY);
            this.getModel().setValue(RELYITEM, relyItemsMap.get(key2), newEntryRow);
            row.put(key2, newEntryRow);
        }
        StringBuilder relationFields = new StringBuilder();
        for (Map.Entry rowEntry : row.entrySet()) {
            String key3 = (String)rowEntry.getKey();
            String fieldName = (String)numberPageNumberMappingMap.get(key3);
            existBaseItemMap.forEach((existKey, value) -> {
                if (StringUtils.equals((String)fieldName, (String)value)) {
                    relationFields.append(',').append((String)existKey);
                }
            });
            existItemClassMap.forEach((itemClassKey, itemClassValue) -> {
                if (StringUtils.equals((String)fieldName, (String)itemClassKey)) {
                    relationFields.append(',').append((String)itemClassValue);
                }
            });
            this.getModel().setValue(RELYRELATIONFIELD, (Object)relationFields, ((Integer)rowEntry.getValue()).intValue());
            relationFields.delete(0, relationFields.length());
        }
    }

    private DynamicObject[] getConfigItems(Map<String, String> baseFieldMap, Map<String, String> itemClassPropMap) {
        ArrayList<String> query = new ArrayList<String>(10);
        for (String value : baseFieldMap.values()) {
            query.add(value);
        }
        for (String key : itemClassPropMap.keySet()) {
            query.add(key);
        }
        QFilter qFilter = new QFilter("page.number", "in", query);
        return BusinessDataServiceHelper.load((String)"ricc_configitems", (String)"id,number,name,group,relylevel,page", (QFilter[])qFilter.toArray(), (String)"page.number");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("filtereditaction".equals(actionId)) {
            String data = (String)evt.getReturnData();
            if (!StringUtils.isEmpty((String)data)) {
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)data, CRCondition.class);
                String exprTran = condition.getExprDesc();
                this.getModel().setValue("exportfilters", (Object)exprTran);
                this.getModel().setValue("exportfilters_tag", (Object)data);
                this.getModel().setValue("exportfiltersdesc", (Object)exprTran);
                this.getModel().setValue("exportfiltersdesc_l", (Object)exprTran);
            }
        } else if ("configCloseCallBack".equals(actionId)) {
            Object returnData2 = evt.getReturnData();
            if (returnData2 != null) {
                this.getModel().setValue(PLUGIN, evt.getReturnData());
            }
        } else if ("pageenterparamCloseCallBack".equals(actionId) && (returnData = evt.getReturnData()) != null) {
            String data = returnData.toString();
            if ("isEmpty".equals(data)) {
                this.getModel().setValue(PAGE_ENTER_PARAM, null);
            } else {
                this.getModel().setValue(PAGE_ENTER_PARAM, returnData);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldName = event.getProperty().getName();
        if (StringUtils.equals((String)fieldName, (String)"importtemplate")) {
            DynamicObject page = (DynamicObject)this.getModel().getValue(PAGE);
            if (page == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u914d\u7f6e\u8868\u5355", (String)"ImplProjectGuidePlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            String billNumber = page.getString("basedatafield.number");
            QFilter filter = new QFilter("bizobject.number", "=", (Object)billNumber);
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(filter);
        } else if (StringUtils.equals((String)fieldName, (String)RELYITEM)) {
            ArrayList<Object> idList = new ArrayList<Object>(10);
            DynamicObjectCollection relyItemEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(RELYITEMENTRY);
            for (DynamicObject itemRow : relyItemEntry) {
                DynamicObject relyItem = (DynamicObject)itemRow.get(RELYITEM);
                if (relyItem == null) continue;
                idList.add(relyItem.get(NEI_MA));
            }
            Iterator filter = new QFilter(NEI_MA, "not in", idList);
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter((QFilter)filter);
            int row = event.getRow();
            DynamicObject rely = (DynamicObject)this.getModel().getValue(RELYITEM, row);
            if (rely != null) {
                ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
                selectedRows.add((Object)new ListSelectedRow(rely.getPkValue()));
                showParameter.setListSelectedRowCollection(selectedRows);
            }
        } else if (StringUtils.equals((String)fieldName, (String)PAGE)) {
            QFilter mstIsNUll = new QFilter(MASTER_ID, "=", (Object)"null");
            QFilter mstEmpty = new QFilter(MASTER_ID, "=", (Object)" ");
            QFilter[] appIdFilter = new QFilter[]{mstIsNUll.or(mstEmpty)};
            List ids = QueryServiceHelper.queryPrimaryKeys((String)"bos_formmeta", (QFilter[])appIdFilter, null, (int)-1);
            QFilter idFilter = new QFilter(NEI_MA, "in", (Object)ids);
            QFilter appBlackFilter = null;
            Map appBlacklist = RunModeServiceHelper.getAppBlacklist();
            if (!appBlacklist.isEmpty()) {
                appBlackFilter = new QFilter(NEI_MA, "in", appBlacklist.keySet());
            }
            QFilter cloudBlackFilter = null;
            Map cloudBlacklist = RunModeServiceHelper.getCloudBlacklist();
            if (!cloudBlacklist.isEmpty()) {
                cloudBlackFilter = new QFilter("bizcloud", "in", cloudBlacklist.keySet());
            }
            QFilter[] blackListFilter = new QFilter[]{appBlackFilter, cloudBlackFilter};
            List appBlackListId = QueryServiceHelper.queryPrimaryKeys((String)"bos_devportal_bizapp", (QFilter[])blackListFilter, null, (int)-1);
            QFilter blackIdsFilter = new QFilter("bizappid", "in", (Object)appBlackListId);
            List formmetaId = QueryServiceHelper.queryPrimaryKeys((String)"bos_formmeta", (QFilter[])blackIdsFilter.toArray(), null, (int)-1);
            QFilter formmetaIdFilter = new QFilter(NEI_MA, "not in", (Object)formmetaId);
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(idFilter);
            showParameter.getListFilterParameter().setFilter(formmetaIdFilter);
        } else if (StringUtils.equals((String)fieldName, (String)FIELD_GROUP)) {
            QFilter filter = new QFilter(NUMBER, "not in", ConfigItemTreeHelper.getInvisibleTreeNumbers());
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }

    private void setRelyItemField() {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(RELYRELATIONFIELD);
        DynamicObject pageValue = (DynamicObject)this.getModel().getValue(RIGHTPAGE);
        String page = pageValue.getString("basedatafield.number");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)page);
        ArrayList<ComboItem> keyFieldItems = new ArrayList<ComboItem>(10);
        this.setAllField(entityType.getProperties(), keyFieldItems);
        if (!keyFieldItems.isEmpty()) {
            comboEdit.setComboItems(keyFieldItems);
        }
    }

    private void setAllField(DataEntityPropertyCollection properties, List<ComboItem> keyField) {
        for (IDataEntityProperty property : properties) {
            if (property instanceof EntryProp) {
                EntryProp p = (EntryProp)property;
                DataEntityPropertyCollection entryProperties = p.getDynamicCollectionItemPropertyType().getProperties();
                this.setAllField(entryProperties, keyField);
                continue;
            }
            if (!StringUtils.isNotBlank((Object)property.getDisplayName())) continue;
            keyField.add(new ComboItem(property.getDisplayName(), property.getName()));
        }
    }

    private void importTypeCheck(String importType) {
        if (StringUtils.equals((String)"custom", (String)importType) || StringUtils.equals((String)"microService", (String)importType)) {
            TextEdit serviceConfig = (TextEdit)this.getView().getControl(PLUGIN);
            this.getModel().setValue(PLUGIN, (Object)"");
            this.getModel().setValue(COVERINFO_FIELD, null);
            this.getModel().setValue("istransferattach", (Object)false);
            serviceConfig.setMustInput(true);
        } else {
            if (this.getView().getModel().getValue(PAGE) == null) {
                return;
            }
            TextEdit serviceConfig = (TextEdit)this.getView().getControl(PLUGIN);
            this.getView().getModel().setValue(PLUGIN, (Object)"");
            serviceConfig.setMustInput(false);
            String entityNumber = (String)((DynamicObject)this.getView().getModel().getValue(RIGHTPAGE)).get("basedatafield.number");
            PageChangeUtil.getKeyFields((IFormView)this.getView(), (String)entityNumber);
        }
    }

    private void setEntryRowStatus(DynamicObject selectedScheme, int rowIndex) {
        DynamicObject schemeDy = BusinessDataServiceHelper.loadSingleFromCache((Object)selectedScheme.getPkValue(), (String)selectedScheme.getDynamicObjectType().getName());
        String status = schemeDy.getString("enable");
        this.getView().getModel().setValue("schemestatus", (Object)status, rowIndex);
    }

    private void initMarkdown() {
        Markdown mk = (Markdown)this.getView().getControl(MARKDOWN);
        String text = "";
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            mk.setModelType(Markdown.Edit);
        } else {
            text = (String)this.getModel().getValue(HELP_TEXT);
            text = text.replace("<br>", "\n");
            mk.setModelType(Markdown.Edit);
        }
        mk.setText(text);
    }

    private void setConfigItemInfo(String entityNumber, boolean isCopyOp, boolean isViewOp) {
        String importDataOpKey;
        QFilter numberFilter;
        DynamicObject formMeta;
        String modelType;
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        String pageNumber = ((DynamicObject)this.getModel().getValue(PAGE)).getString(NUMBER);
        String configItemPageType = PageChangeUtil.getConfigItemPageType((String)pageNumber);
        this.getModel().setValue(CONFIG_ITEM_PAGE_TYPE, (Object)configItemPageType);
        boolean isExtendModel = PageChangeUtil.isExtendModel((FormMetadata)formMetadata);
        this.getModel().setValue(EXTEND_MODEL, (Object)isExtendModel);
        String parentId = formMetadata.getParentId();
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            String parentNumber = MetadataDao.getNumberById((String)parentId);
            this.getModel().setValue(EXTEND_MODEL_KEY, (Object)parentNumber);
        }
        if (StringUtils.equals((String)(modelType = (formMeta = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (QFilter[])(numberFilter = new QFilter(NUMBER, "=", (Object)entityNumber)).toArray())).getString("modeltype")), (String)"BillFormModel") || StringUtils.equals((String)modelType, (String)"BaseFormModel")) {
            List conditionMustItems = PageChangeUtil.getConditionMustItems((String)entityNumber);
            String noSaveFieldsOrEntry = PageChangeUtil.getNoSaveFieldsOrEntry((String)entityNumber);
            this.getModel().setValue(NO_SAVE_FIELD_ENTRY_TAG, (Object)noSaveFieldsOrEntry);
            int maxSize = 14;
            if (noSaveFieldsOrEntry.length() > maxSize) {
                noSaveFieldsOrEntry = noSaveFieldsOrEntry.substring(0, maxSize) + "...";
            }
            this.getModel().setValue(NO_SAVE_FIELD_ENTRY, (Object)noSaveFieldsOrEntry);
            PageChangeUtil.setFieldComboItem((List)conditionMustItems, (String)CONDITION_MUST_FIELD, (IFormView)this.getView());
            String importType = this.getModel().getDataEntity().getString(IMPORTTYPE);
            List coverInfoItems = PageChangeUtil.getCoverInformationItems((String)entityNumber, (String)importType);
            PageChangeUtil.setFieldComboItem((List)coverInfoItems, (String)COVERINFO_FIELD, (IFormView)this.getView());
            List attachmentItems = PageChangeUtil.getAttachmentItems((String)entityNumber);
            PageChangeUtil.setFieldComboItem((List)attachmentItems, (String)"attachmentfield", (IFormView)this.getView());
        } else {
            this.getModel().setValue(NO_SAVE_FIELD_ENTRY, (Object)"");
            this.getModel().setValue(COVERINFO_FIELD, (Object)"");
            this.getModel().setValue("attachmentfield", (Object)"");
        }
        List buttonItems = PageChangeUtil.getButtonItems((String)entityNumber, (IFormView)this.getView());
        PageChangeUtil.setFieldComboItem((List)buttonItems, (String)HIDDEN_BUTTON_FIELD, (IFormView)this.getView());
        String saveOpKey = PageChangeUtil.getOpKey((String)entityNumber, (String)"save");
        if (StringUtils.isNotBlank((CharSequence)saveOpKey)) {
            String uniqueFieldStr = PageChangeUtil.getUniqueFieldStr((String)entityNumber);
            if (StringUtils.isNotEmpty((String)uniqueFieldStr)) {
                this.getModel().setValue(SAVE_UNIQUE_FIELD_TAG, (Object)uniqueFieldStr);
                int maxSize = 14;
                if (uniqueFieldStr.length() > maxSize) {
                    uniqueFieldStr = uniqueFieldStr.substring(0, maxSize) + "...";
                }
                this.getModel().setValue(SAVE_UNIQUE_FIELD, (Object)uniqueFieldStr);
            }
            this.getModel().setValue(HAVE_SAVE_OP, (Object)Boolean.TRUE);
        }
        if (StringUtils.isNotBlank((CharSequence)(importDataOpKey = PageChangeUtil.getOpKey((String)entityNumber, (String)"importdata")))) {
            this.getModel().setValue(HAVE_IMP_AND_EXP, (Object)Boolean.TRUE);
        }
        boolean listHaveImportDataOp = PageChangeUtil.isListHaveImportDataOp((String)entityNumber, (String)importDataOpKey);
        boolean isHidden = PageChangeUtil.itemIsHidden((String)entityNumber, (String)importDataOpKey);
        if (listHaveImportDataOp && !isHidden) {
            if (!isCopyOp && !isViewOp) {
                this.getModel().setValue(SUPPORT_ADDTOPACKET, (Object)Boolean.TRUE);
                this.getModel().setValue(IMPORTTYPE, (Object)"excel");
            }
            this.getModel().setValue(LIST_SUPPORT_IMP_AND_EXP, (Object)"yes");
        } else if (listHaveImportDataOp) {
            this.getModel().setValue(LIST_SUPPORT_IMP_AND_EXP, (Object)"unknown");
        } else {
            if (!isCopyOp && !isViewOp) {
                this.getModel().setValue(SUPPORT_ADDTOPACKET, (Object)Boolean.FALSE);
                this.getModel().setValue(IMPORTTYPE, null);
                this.getModel().setValue(KEY_FIELDS, null);
                ComboEdit control = (ComboEdit)this.getView().getControl(KEY_FIELDS);
                control.setComboItems(null);
                PageChangeUtil.getKeyFields((IFormView)this.getView(), (String)entityNumber);
            }
            this.getModel().setValue(LIST_SUPPORT_IMP_AND_EXP, (Object)"no");
        }
        String defaultDataStatus = PageChangeUtil.getDefaultDataStatus((String)modelType, (String)entityNumber);
        this.getModel().setValue(DEFAULT_DATA_STATUS, (Object)defaultDataStatus);
    }

    private void setNumberAndName(DynamicObject page) {
        String pageNumber = page.getString(NUMBER);
        this.getModel().setValue(NUMBER, (Object)("c_" + pageNumber));
        String pageName = page.getLocaleString("name").getLocaleValue();
        this.getModel().setValue("name", (Object)pageName);
    }

    private void showSaveMessageBox(BeforeItemClickEvent evt) {
        String importType = (String)this.getModel().getValue(IMPORTTYPE);
        if (importType != null) {
            String noSaveFieldEntry = this.getModel().getValue(NO_SAVE_FIELD_ENTRY).toString();
            boolean isExcelOrJsonImport = "excel".equals(importType) || "json".equals(importType);
            boolean isNoSaveFieldEntry = StringUtils.isNotBlank((CharSequence)noSaveFieldEntry);
            if (isExcelOrJsonImport && isNoSaveFieldEntry) {
                String message = String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b58\u5728\u672a\u7ed1\u5b9a\u6570\u636e\u5e93\u5b57\u6bb5\uff1a%s\uff0c\u4f7f\u7528Excel/JSON\u5bfc\u5165\u5bfc\u51fa\u53ef\u80fd\u4f1a\u9020\u6210\u8be5\u5b57\u6bb5\u6570\u636e\u4f20\u8f93\u4e22\u5931\u3002\u53ef\u53c2\u8003:https://vip.kingdee.com/link/s/lHE6s\u89e3\u51b3\u3002\u5982\u65e0\u9700\u4f20\u8f93\u8be5\u5b57\u6bb5\u53ef\u5ffd\u7565\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58\u3002", (String)"ImplProjectGuidePlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]), noSaveFieldEntry);
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                ConfirmTypes confirmTypes = ConfirmTypes.Default;
                ConfirmCallBackListener callBack = new ConfirmCallBackListener(SAVE_CONFIG_ITEM_CALLBACK_ID, (IFormPlugin)this);
                this.getView().showConfirm(message, options, confirmTypes, callBack);
                evt.setCancel(true);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operationKey = evt.getOperationKey();
        if (StringUtils.equals((String)"save", (String)operationKey)) {
            this.showSaveMessageBox(evt);
        }
    }
}

