/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.bdcenter.item;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.sys.ricc.business.isc.IscSyncHelper;
import kd.sys.ricc.common.util.ImplOrderUtil;
import kd.sys.ricc.common.util.ImportTemplateChangeUtil;
import kd.sys.ricc.common.util.PageChangeUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;

public class BdCenterItemPlugin
extends AbstractBasePlugIn
implements IDataModelChangeListener,
BeforeF7SelectListener {
    private static final String FIELD_GROUP = "group";
    private static final String FIELD_ORDER = "orderfield";
    private static final String ENTITYID_TREE = "ricc_basedata_tree";
    public static final String ISC_EXECUTE = "isc_execute";
    public static final String ISC_SERVICE_FLOW = "isc_service_flow";
    public static final String ISC_DATA_COPY_TRIGGER = "isc_data_copy_trigger";
    public static final String BTN_EXECUTE_CONFIRM = "btn_execute_confirm";
    public static final String SCHEME = "scheme";
    public static final String RICC_SCHEMEENTRY = "ricc_schemeentry";
    public static final String ENTRYSTATUS = "entrystatus";
    public static final String ENABLEENTRY = "enableentry";
    public static final String ISCTYPE = "isctype";
    private static final String PAGE_ENTER_PARAM = "pageenterparam";
    private static final String PAGE_ENTER_PARAM_BILL = "ricc_pageenterparam";
    private static final String PAGE_ENTER_PARAM_CALLBACKID = "pageenterparamCloseCallBack";
    public static final String PAGE = "page";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PAGE_ENTER_PARAM});
        BasedataEdit scheme = (BasedataEdit)this.getControl(SCHEME);
        scheme.addBeforeF7ViewDetailListener(event -> {
            String iscType = (String)this.getModel().getValue(ISCTYPE);
            if (ISC_SERVICE_FLOW.equals(iscType)) {
                event.setCancel(true);
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setPkId(event.getPkId());
                showParameter.setBillStatus(BillOperationStatus.VIEW);
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setBillTypeId(ISC_SERVICE_FLOW);
                showParameter.setFormId(ISC_SERVICE_FLOW);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        });
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("importtemplate");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (PAGE_ENTER_PARAM.equals(controlKey)) {
            FormShowParameter parameter = ShowParameterUtil.simpleFormShowParameter((String)PAGE_ENTER_PARAM_BILL, null);
            parameter.setCustomParam("enterParams", this.getModel().getValue(PAGE_ENTER_PARAM));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PAGE_ENTER_PARAM_CALLBACKID));
            this.getView().showForm(parameter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection schemeEntries = this.getModel().getEntryEntity(RICC_SCHEMEENTRY);
        if (!schemeEntries.isEmpty() && !"ADDNEW".equals(this.getView().getFormShowParameter().getStatus().name())) {
            for (DynamicObject entry : schemeEntries) {
                if (entry.get(SCHEME) != null) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u5b58\u5728\u65b9\u6848\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u3010\u540c\u6b65\u65b9\u6848\u914d\u7f6e\u3011\u754c\u9762\u5bfc\u5165\u65b9\u6848", (String)"BdCenterItemPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void afterLoadData(EventObject e) {
        ImportTemplateChangeUtil.importTemplateIdChange((IFormView)this.getView());
        this.batchSetEntryRowStatus();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        if (customParam.containsKey("isSynOpen")) {
            String direction = (String)customParam.get("direction");
            Label label = (Label)this.getView().getControl("datarouter");
            label.setText(direction);
        }
        this.getView().getModel().setDataChanged(false);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.batchSetEntryRowStatus();
    }

    private void batchSetEntryRowStatus() {
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity(RICC_SCHEMEENTRY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryOne = (DynamicObject)entryEntity.get(i);
            DynamicObject scheme = (DynamicObject)entryOne.get(SCHEME);
            if (Objects.isNull(scheme)) continue;
            this.setEntryRowStatus(scheme, i);
        }
    }

    public void afterCreateNewData(EventObject e) {
        ImplOrderUtil.groupChange((IFormView)this.getView(), (String)FIELD_ORDER, (String)FIELD_ORDER, (String)ENTITYID_TREE);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((String)FIELD_GROUP, (String)fieldKey)) {
            ImplOrderUtil.groupChange((IFormView)this.getView(), (String)FIELD_ORDER, (String)FIELD_ORDER, (String)ENTITYID_TREE);
        }
        if (StringUtils.equals((String)SCHEME, (String)fieldKey) && e.getChangeSet().length > 0) {
            ChangeData[] changeData = e.getChangeSet();
            int rowIndex = changeData[0].getRowIndex();
            DynamicObject selectedDy = (DynamicObject)changeData[0].getNewValue();
            if (Objects.isNull(selectedDy)) {
                return;
            }
            this.setEntryRowStatus(selectedDy, rowIndex);
        }
        if (StringUtils.equals((String)PAGE, (String)fieldKey)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            PageChangeUtil.pageChangeEvent((DynamicObject)newValue, (IFormView)this.getView());
        }
        if (StringUtils.equals((String)"importtemplate", (String)fieldKey)) {
            DynamicObject importChange = (DynamicObject)e.getChangeSet()[0].getNewValue();
            ImportTemplateChangeUtil.importTemplateChangeId((DynamicObject)importChange, (IFormView)this.getView());
        }
    }

    private void setEntryRowStatus(DynamicObject selectedScheme, int rowIndex) {
        DynamicObject schemeDy = BusinessDataServiceHelper.loadSingleFromCache((Object)selectedScheme.getPkValue(), (String)selectedScheme.getDynamicObjectType().getName());
        String status = schemeDy.getString("enable");
        this.getView().getModel().setValue(ENTRYSTATUS, (Object)status, rowIndex);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        AbstractOperate operate = (AbstractOperate)afterDoOperationEventArgs.getSource();
        String opKey = operate.getOperateKey();
        if ("modify".equals(opKey)) {
            this.getModel().setValue("status", (Object)"A");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int[] selectRows;
        EntryGrid grid;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if ("save".equals(opKey)) {
            this.getModel().setValue("status", (Object)"C");
        }
        if (ISC_EXECUTE.equalsIgnoreCase(opKey)) {
            grid = (EntryGrid)this.getView().getControl(RICC_SCHEMEENTRY);
            selectRows = grid.getSelectRows();
            if (selectRows.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u65b9\u6848\u3002", (String)"BdCenterItemPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            int selectedNum = selectRows[0];
            String status = (String)this.getView().getModel().getValue(ENTRYSTATUS, selectedNum);
            if (!"1".equalsIgnoreCase(status)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u52fe\u9009\u7684\u65b9\u6848\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u5148\u542f\u7528\u540e\u518d\u8bd5\u3002", (String)"BdCenterItemPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(BTN_EXECUTE_CONFIRM, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5373\u5c06\u542f\u52a8\u9009\u5b9a\u65b9\u6848\u8fdb\u884c\u6570\u636e\u540c\u6b65\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"BdCenterItemPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
        }
        if (ENABLEENTRY.equalsIgnoreCase(opKey) || "disableentry".equalsIgnoreCase(opKey)) {
            grid = (EntryGrid)this.getView().getControl(RICC_SCHEMEENTRY);
            selectRows = grid.getSelectRows();
            if (selectRows.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u65b9\u6848\u3002", (String)"BdCenterItemPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            this.modifyStatus(selectRows, opKey);
            this.getView().getModel().setDataChanged(false);
        }
    }

    private void modifyStatus(int[] selectRows, String opKey) {
        String statusName = ENABLEENTRY.equalsIgnoreCase(opKey) ? ResManager.loadKDString((String)"\u542f\u7528", (String)"BdCenterItemPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528", (String)"BdCenterItemPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]);
        String changeStatus = ENABLEENTRY.equalsIgnoreCase(opKey) ? "1" : "0";
        for (int i = 0; i < selectRows.length; ++i) {
            String status = (String)this.getView().getModel().getValue(ENTRYSTATUS, selectRows[i]);
            if (changeStatus.equalsIgnoreCase(status)) continue;
            DynamicObject scheme = (DynamicObject)this.getView().getModel().getValue(SCHEME, selectRows[i]);
            if (scheme == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u3010\u540c\u6b65\u65b9\u6848\u914d\u7f6e\u3011\u754c\u9762\u5bfc\u5165\u65b9\u6848\u3002", (String)"BdCenterItemPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            String entityName = scheme.getDynamicObjectType().getName();
            DynamicObject schemeDy = BusinessDataServiceHelper.loadSingle((Object)scheme.getPkValue(), (String)scheme.getDynamicObjectType().getName());
            schemeDy.set("enable", (Object)changeStatus);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)entityName, (DynamicObject[])new DynamicObject[]{schemeDy}, null);
            if (!operationResult.isSuccess()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u52fe\u9009\u7684\u7b2c%1$s\u884c\u6570\u636e\uff0c%2$s\u5931\u8d25\uff01%3$s", (String)"BdCenterItemPlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0]), selectRows[i], statusName, operationResult.getAllErrorOrValidateInfo().toString()));
                return;
            }
            this.getView().getModel().setValue(ENTRYSTATUS, (Object)changeStatus, selectRows[i]);
        }
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u529f\uff01", (String)"BdCenterItemPlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]), statusName));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (BTN_EXECUTE_CONFIRM.equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            EntryGrid grid = (EntryGrid)this.getView().getControl(RICC_SCHEMEENTRY);
            int[] selectRows = grid.getSelectRows();
            int selectedNum = selectRows[0];
            DynamicObject scheme = (DynamicObject)this.getView().getModel().getValue(SCHEME, selectedNum);
            if (Objects.isNull(scheme)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u52fe\u9009\u7684\u65b9\u6848\u53ef\u80fd\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\u91cd\u8bd5\u3002", (String)"BdCenterItemPlugin_9", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            String iscType = (String)this.getView().getModel().getValue(ISCTYPE, selectedNum);
            DynamicObject schemeInfo = BusinessDataServiceHelper.loadSingle((Object)scheme.getPkValue(), (String)iscType);
            if (ISC_DATA_COPY_TRIGGER.equalsIgnoreCase(iscType)) {
                IscSyncHelper.startDataCopyTrigger(this.getView(), schemeInfo);
            } else if (ISC_SERVICE_FLOW.equalsIgnoreCase(iscType)) {
                IscSyncHelper.startFlow(this.getView(), this.getPluginName(), schemeInfo);
            }
            Object id = this.getView().getFormShowParameter().getCustomParam("id");
            IscSyncHelper.recordLog(scheme, iscType, "ricc_basedata_item", id);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Object data = evt.getReturnData();
        if ("get_flow_params".equals(action)) {
            IscSyncHelper.parseAndStartFlow(data, this.getView());
        } else if ("execute_flow_event".equals(action) && "success".equals(data)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u63d0\u4ea4\u6d41\u7a0b\u6267\u884c\u3002", (String)"BdCenterItemPlugin_10", (String)"sys-ricc-platform", (Object[])new Object[0]));
            IscSyncHelper.openFlowInstList(null, this.getView());
        } else if (PAGE_ENTER_PARAM_CALLBACKID.equals(action) && (returnData = evt.getReturnData()) != null) {
            if ("isEmpty".equals(returnData.toString())) {
                this.getModel().setValue(PAGE_ENTER_PARAM, null);
            } else {
                this.getModel().setValue(PAGE_ENTER_PARAM, returnData);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldName = event.getProperty().getName();
        boolean equalsImportTemplate = StringUtils.equals((String)fieldName, (String)"importtemplate");
        if (equalsImportTemplate) {
            DynamicObject page = (DynamicObject)this.getModel().getValue(PAGE);
            if (page == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u914d\u7f6e\u8868\u5355", (String)"BdCenterItemPlugin_11", (String)"sys-ricc-platform", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            String billNumber = page.getString("number");
            QFilter filter = new QFilter("bizobject.number", "=", (Object)billNumber);
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }
}

