/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.datacompare;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Html;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.setter.D;
import kd.sys.ricc.formplugin.datacompare.ViewCondition;

public class DiffDataComparePlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final int MAX_TEXT_LENGTH_FOR_SHOW = 255;
    private static final String SEARCHAP = "searchap";
    private static final String NEW = "new";
    private static final String UPDATE = "update";
    private static final String DELETE = "delete";
    private static final String ALL = "all";
    private static final String NEWCOUNT = "newcount";
    private static final String UPDATECOUNT = "updatecount";
    private static final String DELETECOUNT = "deletecount";
    private static final String ENTITY = "entity";
    private static final String SRCDATA = "srcData";
    private static final String TARGETDATA = "targetData";
    private static final String BREAK_FLAG = "breakFlag";
    private static final HashMap<String, Integer> PRIORITIES = new HashMap(16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl(SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ViewCondition viewCondition = new ViewCondition(true, true, true, true);
        this.showForm(viewCondition);
    }

    private void showForm(ViewCondition viewCondition) {
        IDataEntityType entity = this.getDataEntityType();
        Map srcData = (Map)this.getView().getFormShowParameter().getCustomParam(SRCDATA);
        Map targetData = (Map)this.getView().getFormShowParameter().getCustomParam(TARGETDATA);
        StringBuilder html = new StringBuilder();
        html.append("<table padding='5' border='1'>");
        this.appendHeader(html);
        this.appendContent("", srcData, targetData, html, entity, viewCondition);
        html.append("</table>");
        ((Html)this.getControl("content")).setConent(html.toString());
        this.showCount(viewCondition);
    }

    private IDataEntityType getDataEntityType() {
        String entityName = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY);
        return EntityMetadataCache.getDataEntityType((String)entityName);
    }

    private void appendHeader(StringBuilder html) {
        String thField = ResManager.loadKDString((String)"<tr height='25px'><th width='30%'>\u5b57\u6bb5</th>", (String)"DiffDataComparePlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
        String thCurr = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3", (String)"DiffDataComparePlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
        String thTar = ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u4e2d\u5fc3", (String)"DiffDataComparePlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]);
        html.append(thField);
        html.append("<th width='336px'>").append(thCurr).append("</th>");
        html.append("<th width='336px'>").append(thTar).append("</th>");
        html.append("</tr>");
    }

    private void appendContent(String prefix, Map<String, Object> srcData, Map<String, Object> targetData, StringBuilder html, IDataEntityType entity, ViewCondition viewCondition) {
        String[] array;
        for (String key : array = this.collectKeys(srcData, targetData)) {
            boolean isNotSearchField;
            Object srcField = srcData.get(key);
            Object targetField = targetData.get(key);
            String label = this.getFieldName(entity, key);
            boolean bl = isNotSearchField = !(srcField instanceof Map) && !(srcField instanceof List) && viewCondition.isSearch() && !(prefix + label).contains(viewCondition.getKeyWord());
            if (isNotSearchField || key.startsWith("$")) continue;
            this.dataCompare(prefix, html, entity, viewCondition, key, srcField, targetField);
        }
    }

    private void appendContent(String prefix, List<Map<String, Object>> src, List<Map<String, Object>> target, StringBuilder html, IDataEntityType entity, ViewCondition viewCondition) {
        int size;
        if (this.isNotMap(src) || this.isNotMap(target)) {
            this.appendDiffContent(prefix, html, entity, null, D.s(src), D.s(target), viewCondition);
            return;
        }
        int srcSize = src.size();
        int targetSize = target.size();
        int index = 0;
        int n = size = srcSize > targetSize ? srcSize : targetSize;
        if (srcSize > targetSize) {
            for (Map<String, Object> targetMap : target) {
                Map<String, Object> srcMap = src.get(++index - 1);
                this.appendContent(this.generatePrefix(prefix, index), srcMap, targetMap, html, entity, viewCondition);
            }
            for (int i = index; i < size; ++i) {
                this.appendContent(this.generatePrefix(prefix, ++index), src.get(index - 1), Collections.emptyMap(), html, entity, viewCondition);
            }
        } else {
            for (Map<String, Object> srcMap : src) {
                Map<String, Object> targetMap = target.get(++index - 1);
                this.appendContent(this.generatePrefix(prefix, index), srcMap, targetMap, html, entity, viewCondition);
            }
            for (int i = index; i < size; ++i) {
                this.appendContent(this.generatePrefix(prefix, ++index), Collections.emptyMap(), target.get(index - 1), html, entity, viewCondition);
            }
        }
    }

    private boolean isNotMap(List<Map<String, Object>> list) {
        boolean flag = false;
        for (Map<String, Object> map : list) {
            if (map instanceof Map) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void appendDiffContent(String prefix, StringBuilder html, IDataEntityType entity, String key, Object srcField, Object targetField, ViewCondition viewCondition) {
        String srcStr = srcField.toString();
        String targetStr = targetField.toString();
        if (viewCondition.showUpdate() && !srcStr.equals(targetStr)) {
            viewCondition.incUpdateCount(1);
            html.append("<tr><td class='updatedA'>").append(prefix).append(this.getFieldName(entity, key)).append("</td>");
            html.append("<td class='updatedA'>");
            html.append(DiffDataComparePlugin.escape(srcStr));
            html.append("</td>");
            html.append("<td class='updatedA'><span style='").append("color:blue").append("'>");
            html.append(DiffDataComparePlugin.escape(targetStr));
            html.append("</span></td>");
            html.append("</tr>");
        }
    }

    private void appendSameContent(String prefix, StringBuilder html, IDataEntityType entity, String key, Object srcField, Object targetField) {
        html.append("<tr><td>").append(prefix).append(this.getFieldName(entity, key)).append("</td>");
        html.append("<td>").append(DiffDataComparePlugin.escape(srcField.toString())).append("</td>");
        html.append("<td>").append(DiffDataComparePlugin.escape(targetField.toString())).append("</td>");
        html.append("</tr>");
    }

    private String generatePrefix(String prefix, int index) {
        StringBuilder s = new StringBuilder();
        if (prefix.length() == 0) {
            s.append('[').append(index).append(']');
        } else {
            s.append(prefix.substring(0, prefix.length() - 1));
            s.append('[').append(index).append(']').append('.');
        }
        return s.toString();
    }

    private String[] collectKeys(Map<String, Object> srcData, Map<String, Object> targetData) {
        HashSet<String> keys = new HashSet<String>(srcData.size() + targetData.size());
        keys.addAll(srcData.keySet());
        keys.addAll(targetData.keySet());
        String[] array = keys.toArray(new String[keys.size()]);
        Arrays.sort(array, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int p1 = this.getPriorities(s1);
                int p2 = this.getPriorities(s2);
                return Integer.compare(p1, p2);
            }

            private int getPriorities(String s1) {
                Integer p1 = (Integer)PRIORITIES.get(s1);
                return p1 == null ? PRIORITIES.size() : p1.intValue();
            }
        });
        return array;
    }

    private String getFieldName(IDataEntityType entity, String key) {
        if (entity == null) {
            return key;
        }
        IDataEntityProperty property = (IDataEntityProperty)entity.getProperties().get((Object)key);
        if (property == null) {
            return key;
        }
        String s = D.s((Object)property.getDisplayName());
        return s == null ? key : "<span title='" + key + "'>" + s + "</span>";
    }

    private void dataCompare(String prefix, StringBuilder html, IDataEntityType entity, ViewCondition viewCondition, String key, Object srcField, Object targetField) {
        String label = this.getFieldName(entity, key);
        if (StringUtils.isBlank((Object)srcField)) {
            this.handleSrcIsNull(prefix, html, entity, viewCondition, key, targetField, label);
        } else if (StringUtils.isBlank((Object)targetField)) {
            this.handleTargetIsNull(prefix, html, entity, viewCondition, key, srcField, label);
        } else if (srcField instanceof Map && targetField instanceof Map) {
            this.appendContent(prefix + label + ".", (Map)srcField, (Map)targetField, html, this.getSubEntity(entity, key), viewCondition);
        } else if (srcField instanceof List && targetField instanceof List) {
            this.appendContent(prefix + label + ".", (List)srcField, (List)targetField, html, this.getSubEntity(entity, key), viewCondition);
        } else if (srcField.equals(targetField) && viewCondition.showSame()) {
            this.appendSameContent(prefix, html, entity, key, srcField, targetField);
        } else {
            this.appendDiffContent(prefix, html, entity, key, srcField, targetField, viewCondition);
        }
    }

    private void handleSrcIsNull(String prefix, StringBuilder html, IDataEntityType entity, ViewCondition viewCondition, String key, Object targetField, String label) {
        if (StringUtils.isBlank((Object)targetField)) {
            if (viewCondition.showSame()) {
                this.appendEmptyRow(prefix, label, html, entity);
            }
        } else if (targetField instanceof Map) {
            this.appendContent(prefix + label + ".", Collections.emptyMap(), (Map)targetField, html, this.getSubEntity(entity, key), viewCondition);
        } else if (targetField instanceof List) {
            this.appendContent(prefix + label + ".", Collections.emptyList(), (List)targetField, html, this.getSubEntity(entity, key), viewCondition);
        } else if (viewCondition.showAppend()) {
            viewCondition.incNewCount(1);
            this.appendColumnTarget(prefix, html, key, targetField, entity);
        }
    }

    private void handleTargetIsNull(String prefix, StringBuilder html, IDataEntityType entity, ViewCondition vc, String key, Object srcField, String label) {
        if (srcField instanceof Map) {
            this.appendContent(prefix + label + ".", (Map)srcField, Collections.emptyMap(), html, this.getSubEntity(entity, key), vc);
        } else if (srcField instanceof List) {
            this.appendContent(prefix + label + ".", (List)srcField, Collections.emptyList(), html, this.getSubEntity(entity, key), vc);
        } else if (vc.showDelete()) {
            vc.incDeleteCount(1);
            this.appendColumnSrc(prefix, html, key, srcField, entity);
        }
    }

    private void appendEmptyRow(String prefix, String key, StringBuilder html, IDataEntityType entity) {
        html.append("<tr><td>").append(prefix).append(this.getFieldName(entity, key)).append("</td>");
        html.append("<td></td>");
        html.append("<td></td>");
        html.append("</tr>");
    }

    private IDataEntityType getSubEntity(IDataEntityType entity, String key) {
        if (entity == null) {
            return null;
        }
        Object property = entity.getProperties().get((Object)key);
        if (property == null) {
            return null;
        }
        if (property instanceof BasedataProp) {
            String id = ((BasedataProp)property).getBaseEntityId();
            return EntityMetadataCache.getDataEntityType((String)id);
        }
        if (property instanceof EntryProp) {
            return ((EntryProp)property).getItemType();
        }
        return null;
    }

    private void appendColumnSrc(String prefix, StringBuilder html, String key, Object src, IDataEntityType entity) {
        html.append("<tr><td class='deletedA'>").append(prefix).append(this.getFieldName(entity, key)).append("</td>");
        html.append("<td class='deletedA'><span class='deleted'><span class='").append("deleted").append("'>").append(DiffDataComparePlugin.escape(src.toString())).append("</span></span></td>");
        html.append("<td class='deletedA'></td>");
        html.append("</tr>");
    }

    private void appendColumnTarget(String prefix, StringBuilder html, String key, Object target, IDataEntityType entity) {
        html.append("<tr><td class='appendedA'>").append(prefix).append(this.getFieldName(entity, key)).append("</td>");
        html.append("<td class='appendedA'></td>");
        html.append("<td class='appendedA'><span class='").append("appended").append("'>").append(DiffDataComparePlugin.escape(target.toString())).append("</span></td>");
        html.append("</tr>");
    }

    private static String escape(String s) {
        if (s == null) {
            return "";
        }
        if (s.length() > 255) {
            return ResManager.loadKDString((String)"<B>#\u5185\u5bb9\u592a\u957f\uff0c\u4e0d\u663e\u793a#</B>", (String)"DiffDataComparePlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        boolean priorIsCr = false;
        boolean priorIsBlank = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\r': {
                    sb.append("<br/>");
                    break;
                }
                case '\n': {
                    if (priorIsCr) break;
                    sb.append("<br/>");
                    break;
                }
                case '\t': {
                    sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    break;
                }
                case ' ': {
                    if (priorIsBlank) {
                        sb.append("&nbsp;");
                        break;
                    }
                    sb.append(' ');
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            priorIsCr = c == '\r';
            priorIsBlank = c == ' ';
        }
        return sb.toString();
    }

    private void showCount(ViewCondition viewCondition) {
        IPageCache pageCache = this.getPageCache();
        String newC = pageCache.get(NEWCOUNT);
        String upC = pageCache.get(UPDATECOUNT);
        String delC = pageCache.get(DELETECOUNT);
        if (StringUtils.isEmpty((String)newC)) {
            newC = D.s((Object)viewCondition.getNewCount());
            upC = D.s((Object)viewCondition.getUpdateCount());
            delC = D.s((Object)viewCondition.getDeleteCount());
            pageCache.put(NEWCOUNT, newC);
            pageCache.put(UPDATECOUNT, upC);
            pageCache.put(DELETECOUNT, delC);
        }
        this.getModel().setValue(NEWCOUNT, (Object)newC);
        this.getModel().setValue(UPDATECOUNT, (Object)upC);
        this.getModel().setValue(DELETECOUNT, (Object)delC);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String breakFlag = this.getPageCache().get(BREAK_FLAG);
        if ("1".equals(breakFlag)) {
            return;
        }
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Boolean newValue = D.x((Object)changeSet[0].getNewValue());
        boolean oldValue = D.x((Object)changeSet[0].getOldValue());
        boolean showUpdate = false;
        boolean showDelete = false;
        boolean showAppend = false;
        if (NEW.equals(name)) {
            showUpdate = D.x((Object)this.getModel().getValue(UPDATE));
            showDelete = D.x((Object)this.getModel().getValue(DELETE));
            showAppend = newValue;
        } else if (UPDATE.equals(name)) {
            showAppend = D.x((Object)this.getModel().getValue(NEW));
            showDelete = D.x((Object)this.getModel().getValue(DELETE));
            showUpdate = newValue;
        } else if (DELETE.equals(name)) {
            showUpdate = D.x((Object)this.getModel().getValue(UPDATE));
            showAppend = D.x((Object)this.getModel().getValue(NEW));
            showDelete = newValue;
        } else if (ALL.equals(name)) {
            this.getModel().setValue(NEW, (Object)newValue);
            this.getModel().setValue(UPDATE, (Object)newValue);
            this.getModel().setValue(DELETE, (Object)newValue);
        }
        if (showAppend && showDelete && showUpdate) {
            this.getModel().setValue(ALL, (Object)Boolean.TRUE);
        } else if (oldValue) {
            this.getPageCache().put(BREAK_FLAG, "1");
            this.getModel().setValue(ALL, (Object)Boolean.FALSE);
            this.getPageCache().put(BREAK_FLAG, "0");
        }
        if (!ALL.equals(name)) {
            this.showContent(showDelete, showUpdate, showAppend);
        }
    }

    private void showContent(boolean showDelete, boolean showUpdate, boolean showAppend) {
        boolean showSame = false;
        if (!(showAppend || showDelete || showUpdate)) {
            showSame = true;
            showAppend = true;
            showUpdate = true;
            showDelete = true;
        }
        String entityName = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY);
        MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityName);
        Map srcData = (Map)this.getView().getFormShowParameter().getCustomParam(SRCDATA);
        Map targetData = (Map)this.getView().getFormShowParameter().getCustomParam(TARGETDATA);
        StringBuilder html = new StringBuilder();
        html.append("<table padding='5' border='1'>");
        this.appendHeader(html);
        ViewCondition viewCondition = new ViewCondition(showSame, showUpdate, showDelete, showAppend);
        this.appendContent("", srcData, targetData, html, (IDataEntityType)entity, viewCondition);
        html.append("</table>");
        ((Html)this.getControl("content")).setConent(html.toString());
        this.showCount(viewCondition);
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        IDataEntityType entity = this.getDataEntityType();
        Map srcData = (Map)this.getView().getFormShowParameter().getCustomParam(SRCDATA);
        Map targetData = (Map)this.getView().getFormShowParameter().getCustomParam(TARGETDATA);
        StringBuilder html = new StringBuilder();
        html.append("<table padding='5' border='1'>");
        this.appendHeader(html);
        ViewCondition viewCondition = new ViewCondition(true, true, true, true);
        if (StringUtils.isNotEmpty((String)searchText)) {
            viewCondition.setKeyWord(searchText);
            viewCondition.setSearch(true);
        }
        this.appendContent("", srcData, targetData, html, entity, viewCondition);
        html.append("</table>");
        ((Html)this.getControl("content")).setConent(html.toString());
        this.showCount(viewCondition);
        this.getPageCache().put(BREAK_FLAG, "1");
        this.getModel().setValue(NEW, (Object)Boolean.FALSE);
        this.getModel().setValue(UPDATE, (Object)Boolean.FALSE);
        this.getModel().setValue(DELETE, (Object)Boolean.FALSE);
        this.getModel().setValue(ALL, (Object)Boolean.FALSE);
        this.getPageCache().put(BREAK_FLAG, "0");
    }

    static {
        PRIORITIES.put("name", PRIORITIES.size());
        PRIORITIES.put("title", PRIORITIES.size());
        PRIORITIES.put("number", PRIORITIES.size());
        PRIORITIES.put("full_name", PRIORITIES.size());
        PRIORITIES.put("type", PRIORITIES.size());
        PRIORITIES.put("version", PRIORITIES.size());
        PRIORITIES.put("modifytime", PRIORITIES.size());
        PRIORITIES.put("id", PRIORITIES.size());
        PRIORITIES.put("coordinate", 2147483547);
        PRIORITIES.put("$id", 0x7FFFFFF5);
        PRIORITIES.put("$pk", 0x7FFFFFF6);
    }
}

