/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.fasttransfer;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.sys.ricc.business.datapacket.helper.DataPacketHelper;
import kd.sys.ricc.business.sync.SyncUtil;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.query.CommonQuery;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.common.util.TransferUtil;

public class AddTransferPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(AddTransferPlugin.class);
    private static final String PACKET_NAME = "packetname";
    private static final String PACKET_VERSION = "packetversion";
    private static final String GUIDE_NAME = "guideName";
    private static final String OK = "ok";
    private static final String ADDTRANSFER_CLOSE = "addTransferClose";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"iconclick"});
        BasedataEdit targetDataCenter = (BasedataEdit)this.getControl("targetdatacenter");
        targetDataCenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String relyItemName;
        super.afterCreateNewData(e);
        TransferUtil.setDefaultCenterAndUserMulti((IFormView)this.getView());
        long packetVersionId = DataPacketHelper.getLatestPacketVersion();
        this.getModel().setValue(PACKET_VERSION, (Object)packetVersionId);
        String packetName = (String)this.getModel().getValue(PACKET_NAME);
        if (StringUtils.isEmpty((String)packetName)) {
            String guideName = (String)this.getView().getFormShowParameter().getCustomParam(GUIDE_NAME);
            String timestamp = new SimpleDateFormat("MMddHHmm").format(new Date());
            this.getModel().setValue(PACKET_NAME, (Object)String.format("%1$s-%2$s", guideName, timestamp));
        }
        String transTips = (String)this.getView().getFormShowParameter().getCustomParam("transtips");
        this.getView().setVisible(Boolean.valueOf(StringUtils.isNotEmpty((String)transTips)), new String[]{"hint2"});
        if (StringUtils.isNotEmpty((String)transTips)) {
            Label tipLabel = (Label)this.getControl("labeltranstips");
            tipLabel.setText(transTips);
        }
        boolean showTips = StringUtils.isNotEmpty((String)(relyItemName = (String)this.getView().getFormShowParameter().getCustomParam("relyitemname"))) || StringUtils.isNotEmpty((String)transTips);
        this.getView().setVisible(Boolean.valueOf(showTips), new String[]{"transferhint"});
        if (StringUtils.isEmpty((String)relyItemName)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"hint"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"hint"});
            Label label = (Label)this.getView().getControl("relyitem");
            Object[] split = relyItemName.split(",");
            String text = String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5df2\u9009\u6570\u636e\u4f9d\u8d56%s\u6570\u636e;", (String)"AddTransferPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]), Arrays.toString(split));
            label.setText(text);
        }
        TransferUtil.setEntryTransferType((IFormView)this.getView());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if ("iconclick".equalsIgnoreCase(source.getKey())) {
            boolean whetherBatchPack = CommonUtil.whetherBatchPack();
            if (!whetherBatchPack) {
                this.getView().showTipNotification(CommonConstant.getBatchPackPerm());
                return;
            }
            boolean canExportAll = (Boolean)this.getView().getFormShowParameter().getCustomParam("canexportall");
            if (canExportAll) {
                String itemNumber = (String)this.getView().getFormShowParameter().getCustomParam("number");
                BaseShowParameter showParameter = new BaseShowParameter();
                String data = (String)this.getView().getFormShowParameter().getCustomParam("selectedData");
                showParameter.setFormId("ricc_packscheme");
                showParameter.setAppId("ricc");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                String noExportAllName = (String)this.getView().getFormShowParameter().getCustomParam("noexportallname");
                showParameter.setCustomParam("noExportAllName", (Object)noExportAllName);
                showParameter.setCustomParam("ServiceAppId", (Object)"ricc");
                showParameter.setCustomParam("itemNumber", (Object)itemNumber);
                showParameter.setCustomParam("selectData", (Object)data);
                String parentPageId = this.getView().getFormShowParameter().getParentPageId();
                IFormView viewNoPlugin = this.getView().getViewNoPlugin(parentPageId);
                viewNoPlugin.showForm((FormShowParameter)showParameter);
                this.getView().sendFormAction(viewNoPlugin);
                this.getView().close();
            } else {
                String itemName = (String)this.getView().getFormShowParameter().getCustomParam(GUIDE_NAME);
                String tip = ResManager.loadKDString((String)"\u6dfb\u52a0\u4f9d\u8d56\u6570\u636e\u5931\u8d25\uff0c[%s]\u4e0d\u652f\u6301\u6279\u91cf\u6253\u5305\uff0c\u8bf7\u624b\u5de5\u9009\u62e9\u6570\u636e\u4f20\u8f93", (String)"AddTransferPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(tip, itemName));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String opKey = op.getOperateKey();
        if (StringUtils.equals((String)OK, (String)opKey)) {
            String packetName = (String)this.getModel().getValue(PACKET_NAME);
            if (StringUtils.isEmpty((String)packetName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u5efa\u4f20\u8f93\u5305\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddTransferPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection targetDataEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("targetdataentry");
            String errMsg = TransferUtil.mustInputValidate((DynamicObjectCollection)targetDataEntry);
            if (StringUtils.isNotEmpty((String)errMsg)) {
                this.getView().showTipNotification(errMsg);
                args.setCancel(true);
                return;
            }
            String msg = this.checkTransferPerm();
            if (msg != null) {
                args.setCancel(true);
                this.getView().showErrorNotification(msg);
                return;
            }
            boolean isHasSyn = TransferUtil.isHasSyn((DynamicObjectCollection)targetDataEntry);
            if (isHasSyn) {
                SyncUtil.showSyncMessageBox(this.getView(), args, this.getPluginName());
            }
        } else if (StringUtils.equals((String)"preview", (String)opKey)) {
            int focusRow = this.getFocusRow();
            Object destAccount = this.getModel().getValue("targetdatacenter", focusRow);
            Object targetCenterUser = this.getModel().getValue("targetdatacenteruser", focusRow);
            if (Objects.isNull(destAccount) || Objects.isNull(targetCenterUser)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u6216\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u7528\u6237\u3002", (String)"AddTransferPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private String checkTransferPerm() {
        boolean canCreatePacket = SysParaUtil.canCreatePacket();
        if (!canCreatePacket) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u7c7b\u578b\u4e0d\u5141\u8bb8\u65b0\u5efa\u4f20\u8f93\u5305\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4\u53c2\u6570\u914d\u7f6e\u60c5\u51b5\u3002", (String)"AddTransferPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]);
        }
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasAddPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"ricc", (String)"ricc_datapacket", (String)"47156aff000000ac");
        if (!hasAddPerm) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u521b\u5efa\u4f20\u8f93\u5305\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AddTransferPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]);
        }
        boolean hasSubmitPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"ricc", (String)"ricc_datapacket", (String)"804f6478000000ac");
        if (!hasSubmitPerm) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u63d0\u4ea4\u4f20\u8f93\u5305\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AddTransferPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]);
        }
        boolean hasAuditPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"ricc", (String)"ricc_datapacket", (String)"47162f66000000ac");
        if (!hasAuditPerm) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5ba1\u6838\u4f20\u8f93\u5305\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AddTransferPlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0]);
        }
        boolean haveTransferOnlinePerm = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"ricc", (String)"ricc_datapacket", (String)"1VXY8XGP/EFK");
        if (!haveTransferOnlinePerm) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u201c\u5728\u7ebf\u4f20\u8f93\u201d\u6216\u201c\u540c\u6b65\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AddTransferPlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]);
        }
        return null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        int focusRow = this.getFocusRow();
        if ("newentry".equals(opKey) || "deleteentry".equals(opKey)) {
            return;
        }
        boolean isSuccess = args.getOperationResult().isSuccess();
        if (isSuccess && OK.equals(opKey)) {
            this.showAddTransferProgress();
        } else if (StringUtils.equals((String)"preview", (String)opKey)) {
            this.preView(focusRow);
        }
    }

    private int getFocusRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("targetdataentry");
        return entryGrid.getEntryState().getFocusRow();
    }

    private void preView(int focusRow) {
        DynamicObject destAccount = (DynamicObject)this.getModel().getValue("targetdatacenter", focusRow);
        long destAccountPk = (Long)destAccount.getPkValue();
        String targetCenterUser = (String)this.getModel().getValue("targetdatacenteruser", focusRow);
        Map loginParams = TransferUtil.destAccountLoginParams((long)destAccountPk, (String)targetCenterUser);
        HashMap<String, String> showParam = new HashMap<String, String>(2);
        showParam.put("previewType", "curToTar");
        showParam.put("loginParams", JSON.toJSONString((Object)loginParams));
        showParam.putAll(this.getView().getFormShowParameter().getCustomParams());
        FormShowParameter formShowParameter = ShowParameterUtil.simpleFormShowParameter((String)"ricc_dapacket_preview", showParam);
        this.getView().showForm(formShowParameter);
    }

    private void showAddTransferProgress() {
        DynamicObject packetVersion = (DynamicObject)this.getModel().getValue(PACKET_VERSION);
        DynamicObjectCollection targetDataEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("targetdataentry");
        HashMap<Long, String> targetDataMap = new HashMap<Long, String>(targetDataEntry.size());
        ArrayList<String> transferTypeList = new ArrayList<String>(10);
        for (DynamicObject target : targetDataEntry) {
            if (target.getDynamicObject("targetdatacenter") == null || !StringUtils.isNotEmpty((String)target.getString("targetdatacenteruser"))) continue;
            targetDataMap.put(target.getDynamicObject("targetdatacenter").getLong("id"), target.getString("targetdatacenteruser"));
            transferTypeList.add(target.getString("transfertype"));
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("ricc_addtransferprogress");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        formShowParameter.setCustomParam("transfertype", transferTypeList);
        formShowParameter.setCustomParam(PACKET_NAME, this.getModel().getValue(PACKET_NAME));
        formShowParameter.setCustomParam(PACKET_VERSION, Optional.ofNullable(packetVersion).map(DataEntityBase::getPkValue).orElse(null));
        formShowParameter.setCustomParam("targetdata", targetDataMap);
        formShowParameter.setCustomParam("description", this.getModel().getValue("description"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADDTRANSFER_CLOSE));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (ADDTRANSFER_CLOSE.equals(actionId)) {
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("transferandsyn".equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            this.showAddTransferProgress();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String changeField = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if ("targetdatacenter".equals(changeField)) {
            DynamicObject newCenter = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newCenter == null) {
                return;
            }
            long newCenterId = newCenter.getLong("id");
            this.getModel().setValue("targetdatacenteruser", (Object)CommonQuery.getTransferLatestUserPhone((long)newCenterId), rowIndex);
            TransferUtil.setEntryTransferType((IFormView)this.getView());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propertyName = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if ("targetdatacenter".equals(propertyName)) {
            DynamicObjectCollection targetDataEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("targetdataentry");
            List selectDataCenterIds = targetDataEntrys.stream().filter(targetData -> targetData.getDynamicObject("targetdatacenter") != null).map(targetData -> targetData.getDynamicObject("targetdatacenter").getLong("id")).collect(Collectors.toList());
            if (!selectDataCenterIds.isEmpty()) {
                QFilter filter = new QFilter("id", "not in", selectDataCenterIds);
                showParameter.getListFilterParameter().getQFilters().add(filter);
            }
            showParameter.setCustomParam("openStyle", (Object)"openStyle_f7");
            showParameter.getListFilterParameter().getQFilters().add(CommonUtil.getDataCenterFilter());
        }
    }
}

