/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.metadatacompare;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.sys.ricc.business.datapacket.helper.DataPacketHelper;
import kd.sys.ricc.business.log.AbstractLogRecord;
import kd.sys.ricc.business.log.ConfigLog;
import kd.sys.ricc.business.log.LogRecorder;
import kd.sys.ricc.business.log.impl.ConfigLogImpl;
import kd.sys.ricc.business.metadata.MetaDataExportHelper;
import kd.sys.ricc.business.metadata.compare.MetaDataCompareHelper;
import kd.sys.ricc.business.metadata.compare.RuntimeMetaInfo;
import kd.sys.ricc.business.metadata.log.MetaLog;
import kd.sys.ricc.business.metadata.log.MetaLogDataHelper;
import kd.sys.ricc.common.enums.PacketDataSourceTypeEnum;
import kd.sys.ricc.common.util.ApiUtil;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FormViewUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.TransferUtil;

public class MetaDataComparePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(MetaDataComparePlugin.class);
    private static final String LAST_DYM = "lastDym";
    private static final String BASE_DYM = "baseDym";
    private static final String OP_COMPARE = "compare";
    private static final String OP_DETAIL_COMPARE = "comparedetail";
    private static final String OP_DETAIL = "detail";
    private static final String METADATACOMPAREENTRY = "metadatacompareentry";
    private static final String GENERATE = "generate";
    private static final String HASDIFF = "hasdiff";
    private static final String RICC_META_CONFIRM = "ricc_meta_confirm";
    private static final String LOGDATACENTER = "logdatacenter";
    private static final String LOGCENTER = "logcenter";
    private static final String DATATYPE = "datatype";
    private final ConfigLog configLog = new ConfigLogImpl();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TransferUtil.setDefaultCenterAndUser((IFormView)this.getView());
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String datatype = String.valueOf(customParams.get(DATATYPE));
        Object dataPacketId = customParams.get("packetId");
        if (StringUtils.isNotBlank((CharSequence)datatype) && StringUtils.equals((String)datatype, (String)"package")) {
            this.getModel().setValue(DATATYPE, (Object)datatype);
            this.getModel().setValue("datapacket", dataPacketId);
        }
        if (StringUtils.isNotBlank((CharSequence)datatype) && StringUtils.equals((String)datatype, (String)"package")) {
            this.getView().invokeOperation(OP_COMPARE);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dataPacket = (BasedataEdit)this.getView().getControl("datapacket");
        dataPacket.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit bizObjects = (MulBasedataEdit)this.getControl("bizobjects");
        bizObjects.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void initialize() {
        super.initialize();
        this.setEntryOperationVisible();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(METADATACOMPAREENTRY);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            if (this.getModel().getDataEntity().getBoolean("compareisv")) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"pack"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"pack"});
            }
            Optional<DynamicObject> hasDiff = entryEntity.stream().filter(o -> o.getBoolean(HASDIFF)).findAny();
            if (hasDiff.isPresent()) {
                this.getView().setEnable(Boolean.TRUE, new String[]{GENERATE});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{GENERATE});
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{GENERATE});
            this.getView().setEnable(Boolean.FALSE, new String[]{"pack"});
        }
        Tips tips = new Tips();
        tips.setContent(new LocaleString(String.format(ResManager.loadKDString((String)"\u5f00\u542f\u540e\u6570\u636e\u5bf9\u8c61\u5c06\u4ec5\u80fd\u9009\u62e9\u5f53\u524d\u73af\u5883\u5f00\u53d1\u5546\u7684\u5143\u6570\u636e\uff0c\u5f00\u542f\u540e\u53ef\u652f\u6301\u5bf9\u6bd4\u540e\u5feb\u901f\u6253\u5305\u3002\u5f53\u524d\u5f00\u53d1\u5546\u6807\u8bc6\u4e3a\uff1a%s", (String)"MetaDataComparePlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]), ISVServiceHelper.getISVInfo().getId())));
        tips.setType("text");
        FieldEdit fieldEdit = (FieldEdit)this.getControl("compareisv");
        fieldEdit.addTips(tips);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("compareisv".equals(key)) {
            DynamicObjectCollection entryEntity;
            DynamicObjectCollection objects;
            if (((Boolean)newValue).booleanValue() && CollectionUtils.isNotEmpty((Collection)(objects = this.getModel().getDataEntity().getDynamicObjectCollection("bizobjects")))) {
                objects.removeIf(o -> !StringUtils.equals((String)o.getString("fbasedataid.isv"), (String)ISVServiceHelper.getISVInfo().getId()));
                this.getModel().setValue("bizobjects", (Object)objects);
            }
            if (CollectionUtils.isNotEmpty((Collection)(entryEntity = this.getModel().getEntryEntity(METADATACOMPAREENTRY))) && ((Boolean)newValue).booleanValue()) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"pack"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"pack"});
            }
            this.getView().updateView();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        boolean compareIsv;
        String key = evt.getProperty().getName();
        ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
        if ("datapacket".equals(key)) {
            showParam.setShowApproved(false);
            QFilter filter = new QFilter("datasource", "=", (Object)PacketDataSourceTypeEnum.DATASOURCE_NEW.getVal()).and(new QFilter("packettype", "=", (Object)"2"));
            evt.addCustomQFilter(filter);
        } else if (StringUtils.equals((String)key, (String)"bizobjects") && (compareIsv = this.getModel().getDataEntity().getBoolean("compareisv"))) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qfilter = new QFilter("isv", "=", (Object)ISVServiceHelper.getISVInfo().getId());
            formShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if ("addPacketClose".equalsIgnoreCase(evt.getActionId())) {
            this.afterReturnPacketForm(evt);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid;
        int[] selectRows;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (StringUtils.equals((String)operate.getOperateKey(), (String)GENERATE)) {
            EntryGrid entryGrid2 = (EntryGrid)this.getControl(METADATACOMPAREENTRY);
            int[] selectRows2 = entryGrid2.getSelectRows();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(METADATACOMPAREENTRY);
            if (selectRows2.length > 0) {
                boolean isExist = false;
                for (int selectRow : selectRows2) {
                    DynamicObject obj = (DynamicObject)entryEntity.get(selectRow);
                    if (obj.getBoolean(HASDIFF)) continue;
                    isExist = true;
                    break;
                }
                if (isExist) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u6709\u5dee\u5f02\u7684\u6570\u636e\u53ef\u751f\u6210\u53d8\u66f4\u786e\u8ba4\u5355\u3002", (String)"MetaDataComparePlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        } else if (StringUtils.equals((String)operate.getOperateKey(), (String)OP_DETAIL_COMPARE) && (selectRows = (entryGrid = (EntryGrid)this.getControl(METADATACOMPAREENTRY)).getSelectRows()).length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u5bf9\u6bd4\u3002", (String)"MetaDataComparePlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((String)operateKey, (String)OP_COMPARE)) {
            String datatype = this.getModel().getDataEntity().getString(DATATYPE);
            ArrayList<String> numbers = new ArrayList();
            if (StringUtils.equals((String)"package", (String)datatype)) {
                DynamicObject datapacket = this.getModel().getDataEntity().getDynamicObject("datapacket");
                if (datapacket != null) {
                    numbers = DataPacketHelper.getMetaNumbers(Collections.singletonList(datapacket.getLong("id")));
                }
            } else {
                DynamicObjectCollection bizObjects = this.getModel().getDataEntity().getDynamicObjectCollection("bizobjects");
                if (CollectionUtils.isNotEmpty((Collection)bizObjects)) {
                    numbers = bizObjects.stream().map(o -> o.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toList());
                }
            }
            if (CollectionUtils.isNotEmpty(numbers)) {
                if (numbers.size() > 500) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u9009\u62e9500\u4e2a\u5143\u6570\u636e\u8fdb\u884c\u5bf9\u6bd4\u3002", (String)"MetaDataComparePlugin_14", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    return;
                }
                if (this.getModel().getValue("targetdatacenter") == null) {
                    return;
                }
                List<RuntimeMetaInfo> srcRuntimeMetaInfos = MetaDataCompareHelper.getRuntimeMetaInfoByNumbers(numbers, this.getModel().getDataEntity().getBoolean("compareext"));
                if (CollectionUtils.isEmpty(srcRuntimeMetaInfos)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7f16\u7801\u4e3a%s\u7684\u5143\u6570\u636e\u4fe1\u606f\u3002", (String)"MetaDataComparePlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]), numbers));
                    return;
                }
                CustomApiResult<List<RuntimeMetaInfo>> customApiResult = null;
                try {
                    customApiResult = this.getTarMetaDatas(numbers, this.getModel().getDataEntity().getBoolean("compareext"));
                }
                catch (Exception e) {
                    logger.error("\u5143\u6570\u636e\u5bf9\u6bd4\u8bbf\u95ee\u76ee\u6807\u73af\u5883\u6570\u636e\u5931\u8d25", (Throwable)e);
                    String error = String.format(ResManager.loadKDString((String)"\u8bbf\u95ee\u76ee\u6807\u73af\u5883\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u201c%2$s\u201d\uff0c\u9519\u8bef\u65e5\u5fd7TraceId\u201c%1$s\u201d", (String)"MetaDataComparePlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]), RequestContext.get().getTraceId(), e.getMessage());
                    this.getView().showErrorNotification(error);
                    return;
                }
                if (!customApiResult.isStatus()) {
                    this.getView().showErrorNotification(customApiResult.getMessage());
                    return;
                }
                List tarRuntimeMetaInfos = (List)customApiResult.getData();
                Map<String, RuntimeMetaInfo> tarRuntimeMetaInfoMap = tarRuntimeMetaInfos.stream().collect(Collectors.toMap(o -> o.getNumber(), o -> o));
                this.getModel().deleteEntryData(METADATACOMPAREENTRY);
                int[] rows = this.getModel().batchCreateNewEntryRow(METADATACOMPAREENTRY, srcRuntimeMetaInfos.size());
                ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
                for (int row : rows) {
                    RuntimeMetaInfo srcRuntimeMetaInfo = srcRuntimeMetaInfos.get(row);
                    RuntimeMetaInfo tarRuntimeMetaInfo = tarRuntimeMetaInfoMap.get(srcRuntimeMetaInfo.getNumber());
                    TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(METADATACOMPAREENTRY);
                    grid.setCollapse(false);
                    DynamicObjectCollection entry = this.getModel().getDataEntity().getDynamicObjectCollection(METADATACOMPAREENTRY);
                    if (entry.size() != rows.length) {
                        row = entry.size() - rows.length + row;
                    }
                    MetaDataCompareHelper.buildMetaEntry(srcRuntimeMetaInfo, tarRuntimeMetaInfo, row, row, this.getView(), cellStyles);
                }
                FormViewUtil.setCellStyle(cellStyles, (String)METADATACOMPAREENTRY, (IFormView)this.getView());
                this.getView().updateView();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u53ef\u5bf9\u6bd4\u7684\u5143\u6570\u636e\u4fe1\u606f\u3002", (String)"MetaDataComparePlugin_13", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
        } else if (StringUtils.equals((String)operateKey, (String)GENERATE)) {
            List<DynamicObject> entry;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            EntryGrid entryGrid = (EntryGrid)this.getControl(METADATACOMPAREENTRY);
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObjectCollection entryData = dataEntity.getDynamicObjectCollection(METADATACOMPAREENTRY);
            if (selectRows.length > 0) {
                DynamicObjectCollection entryRows = new DynamicObjectCollection();
                for (int selectRow : selectRows) {
                    entryRows.add(entryData.get(selectRow));
                }
                entry = this.createEntry(entryRows);
            } else {
                entry = this.createEntry(entryData);
            }
            if (CollectionUtils.isEmpty(entry)) {
                return;
            }
            DynamicObject metaConfirm = BusinessDataServiceHelper.newDynamicObject((String)RICC_META_CONFIRM);
            metaConfirm.set("package", dataEntity.get("datapacket"));
            metaConfirm.set("targetdatacenter", dataEntity.get("targetdatacenter"));
            metaConfirm.set("targetdatacenteruser", dataEntity.get("targetdatacenteruser"));
            metaConfirm.set(LOGDATACENTER, (Object)this.loadLogCenter());
            metaConfirm.set(DATATYPE, dataEntity.get(DATATYPE));
            metaConfirm.set("headerconfirmstatus", (Object)"0");
            metaConfirm.set("creator", (Object)RequestContext.get().getCurrUserId());
            metaConfirm.set(DATATYPE, dataEntity.get(DATATYPE));
            metaConfirm.set("entryentity", entry);
            ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
            String billno = coderule.getNumber(RICC_META_CONFIRM, metaConfirm, null);
            metaConfirm.set("billno", (Object)billno);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{metaConfirm});
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(RICC_META_CONFIRM);
            parameter.setPkId(metaConfirm.getPkValue());
            parameter.setStatus(OperationStatus.EDIT);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u53d8\u66f4\u5355\u3010%1$s\u3011\u751f\u6210\u6210\u529f", (String)"MetaDataComparePlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]), billno));
        } else if (StringUtils.equals((String)operateKey, (String)OP_DETAIL)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("ricc_meta_log");
            parameter.setStatus(OperationStatus.EDIT);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            int index = this.getModel().getEntryCurrentRowIndex(METADATACOMPAREENTRY);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(METADATACOMPAREENTRY);
            DynamicObject entryObj = (DynamicObject)entryEntity.get(index);
            long destAccountPk = this.loadLogCenter();
            String targetCenterUser = (String)this.getModel().getValue("targetdatacenteruser");
            parameter.setCustomParam("metaId", (Object)entryObj.getString("srcid"));
            parameter.setCustomParam("srcVersion", (Object)entryObj.getLong("srcversion"));
            parameter.setCustomParam("tarVersion", (Object)entryObj.getLong("tarVersion"));
            parameter.setCustomParam("destAccountPk", (Object)destAccountPk);
            parameter.setCustomParam("targetdatacenteruser", (Object)targetCenterUser);
            this.getView().showForm(parameter);
        } else if (StringUtils.equals((String)operateKey, (String)OP_DETAIL_COMPARE)) {
            int index = this.getModel().getEntryCurrentRowIndex(METADATACOMPAREENTRY);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(METADATACOMPAREENTRY);
            DynamicObject entryObj = (DynamicObject)entryEntity.get(index);
            this.compareEntry(entryObj);
        } else if (StringUtils.equals((String)operateKey, (String)"pack")) {
            this.dealConfirmMessage();
        }
    }

    private void compareEntry(DynamicObject entryData) {
        List<String> metaIds = Collections.singletonList(entryData.getString("srcid"));
        long destAccountPk = this.loadLogCenter();
        String targetCenterUser = (String)this.getModel().getValue("targetdatacenteruser");
        CustomApiResult<List<MetaLog>> customApiResult = null;
        try {
            Map<String, List<MetaLog>> metaLogMap;
            List<MetaLog> metaLogs;
            customApiResult = MetaLogDataHelper.getTarMetaLogDatas(metaIds, destAccountPk, targetCenterUser);
            if (!customApiResult.isStatus()) {
                this.getView().showErrorNotification(customApiResult.getMessage());
                return;
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)customApiResult.getData())) && CollectionUtils.isNotEmpty(metaLogs = (metaLogMap = ((List)customApiResult.getData()).stream().collect(Collectors.groupingBy(o -> o.getMetaId()))).get(entryData.getString("srcid")))) {
                Long tarVersion = entryData.getLong("tarversion");
                Long srcVersion = entryData.getLong("srcversion");
                if (CollectionUtils.isNotEmpty(metaLogs = metaLogs.stream().filter(o -> Long.parseLong(o.getMetaver()) == tarVersion || Long.parseLong(o.getMetaver()) == srcVersion).collect(Collectors.toList()))) {
                    if (metaLogs.size() > 1) {
                        this.showMerge(metaLogs.get(0), metaLogs.get(1));
                    } else {
                        this.showMerge(metaLogs.get(0), null);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5143\u6570\u636e\u5dee\u5f02\u6bd4\u5bf9\u6784\u9020\u5206\u5f55\u5931\u8d25", (Throwable)e);
            String error = String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u5dee\u5f02\u6bd4\u5bf9\u6784\u9020\u5206\u5f55\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u201c%2$s\u201d\uff0c\u9519\u8bef\u65e5\u5fd7TraceId\u201c%1$s\u201d", (String)"MetaDataComparePlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]), RequestContext.get().getTraceId(), e.getMessage());
            this.getView().showErrorNotification(error);
        }
    }

    private void showMerge(MetaLog src, MetaLog target) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ricc_metadatadiff");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(BASE_DYM, (Object)src.getData());
        parameter.setCustomParam("bizappid", (Object)EntityMetadataCache.getAppInfo((String)src.getBizAppId()).getNumber());
        parameter.setCustomParam("newCommitId", (Object)src.getMetaver());
        if (target != null) {
            parameter.setCustomParam(LAST_DYM, (Object)target.getData());
            parameter.setCustomParam("oldCommitId", (Object)target.getMetaver());
            parameter.setCustomParam("isNotShowTree", (Object)"false");
        } else {
            parameter.setCustomParam(LAST_DYM, (Object)"");
            parameter.setCustomParam("oldCommitId", (Object)"0");
            parameter.setCustomParam("isNotShowTree", (Object)"true");
            parameter.setCustomParam("name", (Object)EntityMetadataCache.getDataEntityType((String)src.getMetaNumber()).getDisplayName().getLocaleValue());
            parameter.setCustomParam("number", (Object)src.getMetaNumber());
        }
        this.getView().showForm(parameter);
    }

    private void afterReturnPacketForm(ClosedCallBackEvent closedCallBackEvent) {
        Map params = (Map)closedCallBackEvent.getReturnData();
        if (params != null) {
            ListSelectedRow selectedPacket = (ListSelectedRow)params.get("selectedPacket");
            this.exportMetadataByCloud(selectedPacket);
        }
    }

    private void dealConfirmMessage() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        EntryGrid entryGrid = (EntryGrid)this.getControl(METADATACOMPAREENTRY);
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entryData = dataEntity.getDynamicObjectCollection(METADATACOMPAREENTRY);
        DynamicObjectCollection entryRows = new DynamicObjectCollection();
        if (selectRows.length > 0) {
            for (int selectRow : selectRows) {
                entryRows.add(entryData.get(selectRow));
            }
        }
        if (selectRows.length == 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u6253\u5305\u6240\u6709\u5206\u5f55\u6570\u636e\u5143\u6570\u636e\uff0c\u82e5\u4ec5\u9700\u6253\u5305\u6709\u5dee\u5f02\u6570\u636e\u53ef\u8fc7\u6ee4\u540e\u9009\u4e2d\u9700\u8981\u5206\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6253\u5305\u6240\u6709\u6570\u636e\uff1f", (String)"MetaDataComparePlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("packConfirm", (IFormPlugin)this));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u6253\u5305\u6240\u9009\u5206\u5f55\u5143\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6253\u5305\uff1f", (String)"MetaDataComparePlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("packConfirm", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (StringUtils.equals((String)callBackId, (String)"packConfirm") && e.getResult() == MessageBoxResult.Yes) {
            this.openAddPacketForm();
        }
    }

    private void openAddPacketForm() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(METADATACOMPAREENTRY);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u5143\u6570\u636e\u5bf9\u6bd4", (String)"MetaDataComparePlugin_9", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return;
        }
        HashMap<String, String> customParams = new HashMap<String, String>(2);
        customParams.put("addDataPacketOpenFrom", "openFromMetadata");
        FormShowParameter listShowParameter = ShowParameterUtil.formShowParameter((String)"ricc_fastaddpacket", (ShowType)ShowType.Modal, customParams, null, (String)"");
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addPacketClose"));
        this.getView().showForm(listShowParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportMetadataByCloud(ListSelectedRow selectedPacket) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        EntryGrid entryGrid = (EntryGrid)this.getControl(METADATACOMPAREENTRY);
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entryData = dataEntity.getDynamicObjectCollection(METADATACOMPAREENTRY);
        DynamicObjectCollection entryObjs = new DynamicObjectCollection();
        if (selectRows.length > 0) {
            for (int selectRow : selectRows) {
                entryObjs.add(entryData.get(selectRow));
            }
        } else {
            entryObjs.addAll((Collection)entryData);
        }
        if (CollectionUtils.isNotEmpty((Collection)entryObjs)) {
            List<DynamicObject> runtimeMetaInfoObjs;
            ArrayList<String> metaNumbers = new ArrayList<String>();
            ArrayList pageIds = new ArrayList();
            entryObjs.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getString("srcnumber"))).forEach(o -> {
                metaNumbers.add(o.getString("srcnumber"));
                pageIds.add(o.getString("srcid"));
            });
            if (CollectionUtils.isNotEmpty(metaNumbers) && CollectionUtils.isNotEmpty(runtimeMetaInfoObjs = MetaDataCompareHelper.getRuntimeMetaInfoByNumbers(metaNumbers))) {
                Map<String, List<String>> bizIdToIdMap = runtimeMetaInfoObjs.stream().collect(Collectors.toMap(s -> s.getString("bizappid"), s -> {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(s.getString("id"));
                    return list;
                }, (value1, value2) -> {
                    value1.addAll(value2);
                    return value1;
                }));
                List<String> appIdList = bizIdToIdMap.keySet().stream().collect(Collectors.toList());
                this.configLog.preWriteLog("3", "0", (Long)selectedPacket.getPrimaryKeyValue(), 0L, "", null);
                MetaDataExportHelper metaDataExportHelper = new MetaDataExportHelper(this.getView(), null);
                LogRecorder message = new LogRecorder();
                String gitResult = "";
                try {
                    gitResult = metaDataExportHelper.exportMetadataByCloud(selectedPacket, appIdList, bizIdToIdMap);
                    message.setEndTime(System.currentTimeMillis());
                    this.addLog(appIdList.size(), message);
                }
                catch (Exception e) {
                    message.append(CommonUtil.getExceptionDetailInfo((Throwable)e), e);
                    this.getView().showErrorNotification(CommonUtil.getExceptionDetailInfo((Throwable)e));
                    message.setEndTime(System.currentTimeMillis());
                    this.addLog(appIdList.size(), message);
                    return;
                }
                finally {
                    if (!gitResult.contains("success")) {
                        QFilter filter = new QFilter("id", "=", selectedPacket.getPrimaryKeyValue());
                        DeleteServiceHelper.delete((String)"ricc_datapacket", (QFilter[])filter.toArray());
                    }
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u6210\u529f\u3002", (String)"MetaDataComparePlugin_10", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
        }
    }

    private String getNeedSelectedAppTip() {
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u5143\u6570\u636e\u3002", (String)"MetaDataComparePlugin_11", (String)"sys-ricc-platform", (Object[])new Object[0]);
    }

    private void addLog(int total, AbstractLogRecord logRecord) {
        int successCount = 0;
        if (logRecord.getMessageStr() == null || logRecord.getMessageStr().length() <= 0) {
            successCount = total;
        }
        this.configLog.afterWriteLog(total, successCount, logRecord);
    }

    private List<DynamicObject> createEntry(DynamicObjectCollection entryData) {
        ArrayList<DynamicObject> result;
        block5: {
            result = new ArrayList<DynamicObject>(entryData.size());
            List<String> metaIds = entryData.stream().map(o -> o.getString("srcid")).collect(Collectors.toList());
            long destAccountPk = this.loadLogCenter();
            String targetCenterUser = (String)this.getModel().getValue("targetdatacenteruser");
            CustomApiResult<List<MetaLog>> customApiResult = null;
            try {
                customApiResult = MetaLogDataHelper.getTarMetaLogDatas(metaIds, destAccountPk, targetCenterUser);
                if (!customApiResult.isStatus()) {
                    this.getView().showErrorNotification(customApiResult.getMessage());
                    return Collections.EMPTY_LIST;
                }
                if (CollectionUtils.isNotEmpty((Collection)((Collection)customApiResult.getData()))) {
                    Map<String, List<MetaLog>> metaLogMap = ((List)customApiResult.getData()).stream().collect(Collectors.groupingBy(o -> o.getMetaId()));
                    int index = 0;
                    for (DynamicObject rowData : entryData) {
                        if (!StringUtils.equals((String)rowData.getString(HASDIFF), (String)"1")) continue;
                        DynamicObject entryRow = ORM.create().newDynamicObject("ricc_meta_confirm.entryentity");
                        entryRow.set(HASDIFF, (Object)(StringUtils.equals((String)rowData.getString(HASDIFF), (String)"1") ? Boolean.TRUE : Boolean.FALSE));
                        this.createSubEntry(metaLogMap.get(rowData.getString("srcid")), entryRow, rowData);
                        entryRow.set("entryconfirmstatus", (Object)"0");
                        entryRow.set("srcnumber", rowData.get("srcnumber"));
                        entryRow.set("srcname", rowData.get("srcname"));
                        entryRow.set("srcisv", rowData.get("srcisv"));
                        entryRow.set("srcid", rowData.get("srcid"));
                        entryRow.set("srcversion", StringUtils.isBlank((Object)rowData.get("srcversion")) ? Long.valueOf(0L) : rowData.get("srcversion"));
                        entryRow.set("srcmodifytime", (Object)rowData.getDate("srcmodifytime"));
                        entryRow.set("tarnumber", rowData.get("tarnumber"));
                        entryRow.set("tarname", rowData.get("tarname"));
                        entryRow.set("tarisv", rowData.get("tarisv"));
                        entryRow.set("tarid", rowData.get("tarid"));
                        entryRow.set("tarversion", StringUtils.isBlank((Object)rowData.get("tarversion")) ? Long.valueOf(0L) : rowData.get("tarversion"));
                        entryRow.set("tarmodifytime", (Object)rowData.getDate("tarmodifytime"));
                        entryRow.set("seq", (Object)(index + 1));
                        result.add(entryRow);
                        ++index;
                    }
                    break block5;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u73af\u5883\u4e2d\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5143\u6570\u636e\u53d8\u66f4\u65e5\u5fd7\u3002", (String)"MetaDataComparePlugin_12", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return Collections.EMPTY_LIST;
            }
            catch (Exception e) {
                logger.error("\u5143\u6570\u636e\u5dee\u5f02\u6bd4\u5bf9\u6784\u9020\u5206\u5f55\u5931\u8d25", (Throwable)e);
                String error = String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u5dee\u5f02\u6bd4\u5bf9\u6784\u9020\u5206\u5f55\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u201c%2$s\u201d\uff0c\u9519\u8bef\u65e5\u5fd7TraceId\u201c%1$s\u201d", (String)"MetaDataComparePlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]), RequestContext.get().getTraceId(), e.getMessage());
                this.getView().showErrorNotification(error);
            }
        }
        return result;
    }

    private void createSubEntry(List<MetaLog> metaLogs, DynamicObject entryRow, DynamicObject rowData) {
        if (CollectionUtils.isEmpty(metaLogs)) {
            return;
        }
        Long tarVersion = rowData.getLong("tarversion");
        Long srcVersion = rowData.getLong("srcversion");
        if (tarVersion != null && tarVersion != 0L && srcVersion != null && srcVersion != 0L) {
            metaLogs = metaLogs.stream().filter(o -> MetaDataComparePlugin.isBetween(srcVersion, tarVersion, o)).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(metaLogs)) {
            DynamicObjectCollection subentryentity = entryRow.getDynamicObjectCollection("subentryentity");
            for (int index = 0; index < metaLogs.size(); ++index) {
                MetaLog metaLog = metaLogs.get(index);
                DynamicObject subObj = subentryentity.addNew();
                subObj.set("isv", (Object)metaLog.getIsv());
                subObj.set("type", (Object)metaLog.getType());
                subObj.set("operator", (Object)metaLog.getOperator());
                subObj.set("operatetime", (Object)metaLog.getOperateTime());
                subObj.set("version", (Object)metaLog.getVersion());
                subObj.set("content", (Object)metaLog.getContent());
                subObj.set("version", (Object)metaLog.getVersion());
                subObj.set("metaid", (Object)metaLog.getMetaId());
                subObj.set("metanumber", (Object)metaLog.getMetaNumber());
                subObj.set("metatype", (Object)metaLog.getMetaType());
                subObj.set("data", (Object)metaLog.getMetaNumber());
                subObj.set("data_tag", (Object)metaLog.getData());
                subObj.set("bizappid", (Object)metaLog.getBizAppId());
                subObj.set("metaver", (Object)metaLog.getMetaver());
                subObj.set("confirmstatus", (Object)"0");
                subObj.set("seq", (Object)(index + 1));
            }
        }
    }

    private static boolean isBetween(Long srcVersion, Long tarVersion, MetaLog obj) {
        return Long.parseLong(obj.getMetaver()) >= tarVersion && Long.parseLong(obj.getMetaver()) <= srcVersion || Long.parseLong(obj.getMetaver()) >= srcVersion && Long.parseLong(obj.getMetaver()) <= tarVersion;
    }

    private Long loadLogCenter() {
        DynamicObject obj = (DynamicObject)this.getModel().getValue(LOGCENTER);
        if (obj != null) {
            return obj.getLong("id");
        }
        return 0L;
    }

    private void setEntryOperationVisible() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(METADATACOMPAREENTRY);
        entryGrid.addPackageDataListener(pkgEvent -> {
            boolean hasDiff = pkgEvent.getRowData().getBoolean(HASDIFF);
            Object source = pkgEvent.getSource();
            boolean isOperationColumn = source instanceof OperationColumn;
            if (isOperationColumn) {
                List operationColItems = (List)pkgEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    if (!OP_DETAIL.equalsIgnoreCase(operationColItem.getOperationKey()) && !OP_DETAIL_COMPARE.equalsIgnoreCase(operationColItem.getOperationKey()) || hasDiff) continue;
                    operationColItem.setVisible(false);
                }
            }
        });
    }

    private CustomApiResult<List<RuntimeMetaInfo>> getTarMetaDatas(List<String> numbers, boolean isCompareExt) {
        DynamicObject desAccountObj = (DynamicObject)this.getModel().getValue("targetdatacenter");
        long destAccountPk = (Long)desAccountObj.getPkValue();
        String targetCenterUser = (String)this.getModel().getValue("targetdatacenteruser");
        Map loginParams = TransferUtil.destAccountLoginParams((long)destAccountPk, (String)targetCenterUser);
        HashMap<String, Object> formParams = new HashMap<String, Object>(1);
        formParams.put("number", numbers);
        formParams.put("iscompareext", isCompareExt);
        String response = ApiUtil.getDestAccountData(formParams, (Map)loginParams, (String)"meta");
        return (CustomApiResult)JSON.parseObject((String)response, (TypeReference)new TypeReference<CustomApiResult<List<RuntimeMetaInfo>>>(){}, (Feature[])new Feature[0]);
    }
}

