/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.metalog;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.sys.ricc.business.metadata.log.MetaLog;
import kd.sys.ricc.business.metadata.log.MetaLogDataHelper;
import kd.sys.ricc.common.util.StringUtils;

public class MetaConfirmFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(MetaConfirmFormPlugin.class);
    private static final String LAST_DYM = "lastDym";
    private static final String BASE_DYM = "baseDym";
    private static final String OP_SUB_COMPARE = "subcompare";
    private static final String OP_COMPARE = "compare";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String SUB_ENTRY_ENTITY = "subentryentity";
    private static final String OP_CONFIRM = "confirm";
    private static final String HASDIFF = "hasdiff";
    private static final String OP_CANCEL = "cancel";
    private static final String CONFIRMSTATUS = "confirmstatus";
    private static final String CONFIRMUSER = "confirmuser";
    private static final String CONFIRMDATE = "confirmdate";
    private static final String ENTRYCONFIRMSTATUS = "entryconfirmstatus";
    private static final String CONFIRM_STATUS = "1";
    private static final String CANCEL_STATUS = "0";

    public void initialize() {
        super.initialize();
        this.setEntryOperationVisible();
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"subtoolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.dealSumData();
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid;
        int[] selectRows;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (StringUtils.equals((String)operate.getOperateKey(), (String)OP_SUB_COMPARE)) {
            EntryGrid entryGrid2 = (EntryGrid)this.getControl(SUB_ENTRY_ENTITY);
            int[] selectRows2 = entryGrid2.getSelectRows();
            if (selectRows2.length != 2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e24\u884c\u6570\u636e\u8fdb\u884c\u5bf9\u6bd4\u3002", (String)"MetaConfirmFormPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (StringUtils.equals((String)operate.getOperateKey(), (String)OP_CONFIRM)) {
            EntryGrid subEntryGrid = (EntryGrid)this.getControl(SUB_ENTRY_ENTITY);
            int[] selectRows3 = subEntryGrid.getSelectRows();
            DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity(SUB_ENTRY_ENTITY);
            boolean isExist = false;
            if (selectRows3.length > 0) {
                for (int selectRow : selectRows3) {
                    DynamicObject obj = (DynamicObject)subEntryEntity.get(selectRow);
                    if (!StringUtils.equals((String)obj.getString(CONFIRMSTATUS), (String)CONFIRM_STATUS)) continue;
                    isExist = true;
                    break;
                }
            } else {
                Optional<DynamicObject> confirmstatus = subEntryEntity.stream().filter(o -> StringUtils.equals((String)o.getString(CONFIRMSTATUS), (String)CONFIRM_STATUS)).findAny();
                isExist = confirmstatus.isPresent();
            }
            if (isExist) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f85\u786e\u8ba4\u7684\u6570\u636e\u8fdb\u884c\u786e\u8ba4\u3002", (String)"MetaConfirmFormPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (StringUtils.equals((String)operate.getOperateKey(), (String)OP_CANCEL)) {
            EntryGrid subEntryGrid = (EntryGrid)this.getControl(SUB_ENTRY_ENTITY);
            int[] selectRows4 = subEntryGrid.getSelectRows();
            DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity(SUB_ENTRY_ENTITY);
            boolean isExist = false;
            if (selectRows4.length > 0) {
                for (int selectRow : selectRows4) {
                    DynamicObject obj = (DynamicObject)subEntryEntity.get(selectRow);
                    if (!StringUtils.equals((String)obj.getString(CONFIRMSTATUS), (String)CANCEL_STATUS)) continue;
                    isExist = true;
                    break;
                }
            } else {
                Optional<DynamicObject> confirmstatus = subEntryEntity.stream().filter(o -> StringUtils.equals((String)o.getString(CONFIRMSTATUS), (String)CANCEL_STATUS)).findAny();
                isExist = confirmstatus.isPresent();
            }
            if (isExist) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u786e\u8ba4\u7684\u6570\u636e\u8fdb\u884c\u53d6\u6d88\u786e\u8ba4\u3002", (String)"MetaConfirmFormPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (StringUtils.equals((String)operate.getOperateKey(), (String)OP_COMPARE) && (selectRows = (entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY)).getSelectRows()).length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u5bf9\u6bd4\u3002", (String)"MetaConfirmFormPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        boolean isSuccess;
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        boolean bl = isSuccess = evt.getOperationResult() != null && evt.getOperationResult().isSuccess();
        if (isSuccess) {
            if (StringUtils.equals((String)operateKey, (String)OP_SUB_COMPARE)) {
                long metaverTar;
                EntryGrid entryGrid = (EntryGrid)this.getControl(SUB_ENTRY_ENTITY);
                int[] selectRows = entryGrid.getSelectRows();
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(SUB_ENTRY_ENTITY);
                DynamicObject srcObj = (DynamicObject)entryEntity.get(selectRows[0]);
                DynamicObject tarObj = (DynamicObject)entryEntity.get(selectRows[1]);
                long metaverSrc = srcObj.getLong("metaver");
                if (metaverSrc > (metaverTar = tarObj.getLong("metaver"))) {
                    MetaLogDataHelper.showMerge(tarObj, srcObj, this.getView());
                } else {
                    MetaLogDataHelper.showMerge(srcObj, tarObj, this.getView());
                }
            } else if (StringUtils.equals((String)operateKey, (String)OP_CONFIRM)) {
                DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity(SUB_ENTRY_ENTITY);
                EntryGrid subEntryGrid = (EntryGrid)this.getControl(SUB_ENTRY_ENTITY);
                int[] selectRows = subEntryGrid.getSelectRows();
                if (selectRows.length > 0) {
                    for (int selectRow : selectRows) {
                        this.getModel().setValue(CONFIRMSTATUS, (Object)CONFIRM_STATUS, selectRow);
                        this.getModel().setValue(CONFIRMUSER, (Object)RequestContext.get().getCurrUserId(), selectRow);
                        this.getModel().setValue(CONFIRMDATE, (Object)new Date(), selectRow);
                    }
                } else {
                    for (int row = 0; row < subEntryEntity.size(); ++row) {
                        this.getModel().setValue(CONFIRMSTATUS, (Object)CONFIRM_STATUS, row);
                        this.getModel().setValue(CONFIRMUSER, (Object)RequestContext.get().getCurrUserId(), row);
                        this.getModel().setValue(CONFIRMDATE, (Object)new Date(), row);
                    }
                }
                int index = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
                Optional<DynamicObject> confirmStatus = subEntryEntity.stream().filter(o -> StringUtils.equals((String)o.getString(CONFIRMSTATUS), (String)CANCEL_STATUS)).findAny();
                if (!confirmStatus.isPresent()) {
                    this.getModel().setValue(ENTRYCONFIRMSTATUS, (Object)CONFIRM_STATUS, index);
                }
                OperationServiceHelper.executeOperate((String)"save", (String)"ricc_meta_confirm", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
                this.dealSumData();
            } else if (StringUtils.equals((String)operateKey, (String)OP_CANCEL)) {
                EntryGrid subEntryGrid = (EntryGrid)this.getControl(SUB_ENTRY_ENTITY);
                int[] selectRows = subEntryGrid.getSelectRows();
                DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity(SUB_ENTRY_ENTITY);
                if (selectRows.length > 0) {
                    for (int selectRow : selectRows) {
                        this.getModel().setValue(CONFIRMSTATUS, (Object)CANCEL_STATUS, selectRow);
                        this.getModel().setValue(CONFIRMUSER, null, selectRow);
                        this.getModel().setValue(CONFIRMDATE, null, selectRow);
                    }
                } else {
                    for (int row = 0; row < subEntryEntity.size(); ++row) {
                        this.getModel().setValue(CONFIRMSTATUS, (Object)CANCEL_STATUS, row);
                        this.getModel().setValue(CONFIRMUSER, null, row);
                        this.getModel().setValue(CONFIRMDATE, null, row);
                    }
                }
                int index = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
                this.getModel().setValue(ENTRYCONFIRMSTATUS, (Object)CANCEL_STATUS, index);
                OperationServiceHelper.executeOperate((String)"save", (String)"ricc_meta_confirm", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
                this.dealSumData();
            } else if (StringUtils.equals((String)operateKey, (String)OP_COMPARE)) {
                int index = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
                DynamicObject entryObj = (DynamicObject)entryEntity.get(index);
                this.compareEntry(entryObj);
            }
        }
    }

    private void compareEntry(DynamicObject entryData) {
        List<String> metaIds = Collections.singletonList(entryData.getString("srcid"));
        long destAccountPk = this.loadLogCenter();
        String targetCenterUser = (String)this.getModel().getValue("targetdatacenteruser");
        CustomApiResult<List<MetaLog>> customApiResult = null;
        try {
            Map<String, List<MetaLog>> metaLogMap;
            List<MetaLog> metaLogs;
            customApiResult = MetaLogDataHelper.getTarMetaLogDatas(metaIds, destAccountPk, targetCenterUser);
            if (!customApiResult.isStatus()) {
                this.getView().showErrorNotification(customApiResult.getMessage());
                return;
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)customApiResult.getData())) && CollectionUtils.isNotEmpty(metaLogs = (metaLogMap = ((List)customApiResult.getData()).stream().collect(Collectors.groupingBy(o -> o.getMetaId()))).get(entryData.getString("srcid")))) {
                Long tarVersion = entryData.getLong("tarversion");
                Long srcVersion = entryData.getLong("srcversion");
                if (CollectionUtils.isNotEmpty(metaLogs = metaLogs.stream().filter(o -> Long.parseLong(o.getMetaver()) == tarVersion || Long.parseLong(o.getMetaver()) == srcVersion).collect(Collectors.toList()))) {
                    if (metaLogs.size() > 1) {
                        long metaverTar;
                        long metaverSrc = Long.parseLong(metaLogs.get(0).getMetaver());
                        if (metaverSrc > (metaverTar = Long.parseLong(metaLogs.get(1).getMetaver()))) {
                            this.showMerge(metaLogs.get(0), metaLogs.get(1));
                        } else {
                            this.showMerge(metaLogs.get(1), metaLogs.get(0));
                        }
                    } else {
                        this.showMerge(metaLogs.get(0), null);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5143\u6570\u636e\u5dee\u5f02\u6bd4\u5bf9\u6784\u9020\u5206\u5f55\u5931\u8d25", (Throwable)e);
            String error = String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u5dee\u5f02\u6bd4\u5bf9\u6784\u9020\u5206\u5f55\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u201c%2$s\u201d\uff0c\u9519\u8bef\u65e5\u5fd7TraceId\u201c%1$s\u201d", (String)"MetaConfirmFormPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]), RequestContext.get().getTraceId(), e.getMessage());
            this.getView().showErrorNotification(error);
        }
    }

    private void dealSumData() {
        DynamicObjectCollection entryObjs = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        if (CollectionUtils.isNotEmpty((Collection)entryObjs)) {
            DynamicObjectCollection metaConfirmDetail = new DynamicObjectCollection();
            entryObjs.stream().forEach(o -> metaConfirmDetail.addAll((Collection)o.getDynamicObjectCollection(SUB_ENTRY_ENTITY)));
            if (CollectionUtils.isNotEmpty((Collection)metaConfirmDetail)) {
                Map<Long, List<DynamicObject>> collect = metaConfirmDetail.stream().collect(Collectors.groupingBy(o -> o.getDynamicObject("operator").getLong("id")));
                this.getModel().deleteEntryData("unconfirmentry");
                this.getModel().batchCreateNewEntryRow("unconfirmentry", collect.size());
                int index = 0;
                for (Map.Entry<Long, List<DynamicObject>> mapEntry : collect.entrySet()) {
                    this.getModel().setValue("relationuser", (Object)mapEntry.getKey(), index);
                    this.getModel().setValue("totalnum", (Object)mapEntry.getValue().size(), index);
                    long confirmStatusNum = mapEntry.getValue().stream().filter(o -> StringUtils.equals((String)o.getString(CONFIRMSTATUS), (String)CONFIRM_STATUS)).count();
                    this.getModel().setValue("confirmednum", (Object)confirmStatusNum, index);
                    this.getModel().setValue("unconfirnum", (Object)((long)mapEntry.getValue().size() - confirmStatusNum), index);
                    ++index;
                }
            }
        }
        this.getModel().setDataChanged(false);
    }

    private void showMerge(MetaLog src, MetaLog target) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ricc_metadatadiff");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(BASE_DYM, (Object)src.getData());
        parameter.setCustomParam("bizappid", (Object)EntityMetadataCache.getAppInfo((String)src.getBizAppId()).getNumber());
        parameter.setCustomParam("newCommitId", (Object)src.getMetaver());
        if (target != null) {
            parameter.setCustomParam(LAST_DYM, (Object)target.getData());
            parameter.setCustomParam("oldCommitId", (Object)target.getMetaver());
            parameter.setCustomParam("isNotShowTree", (Object)"false");
        } else {
            parameter.setCustomParam(LAST_DYM, (Object)"");
            parameter.setCustomParam("oldCommitId", (Object)CANCEL_STATUS);
            parameter.setCustomParam("isNotShowTree", (Object)"true");
        }
        this.getView().showForm(parameter);
    }

    private void setEntryOperationVisible() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addPackageDataListener(pkgEvent -> {
            boolean hasDiff = pkgEvent.getRowData().getBoolean(HASDIFF);
            Object source = pkgEvent.getSource();
            boolean isOperationColumn = source instanceof OperationColumn;
            if (isOperationColumn) {
                List operationColItems = (List)pkgEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    if (!"comparedetail".equalsIgnoreCase(operationColItem.getOperationKey()) || hasDiff) continue;
                    operationColItem.setVisible(false);
                }
            }
        });
    }

    private Long loadLogCenter() {
        DynamicObject obj = (DynamicObject)this.getModel().getValue("logdatacenter");
        if (obj != null) {
            return obj.getLong("id");
        }
        return 0L;
    }
}

