/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.metalog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.sys.ricc.business.metadata.log.MetaLogDataHelper;
import kd.sys.ricc.common.util.StringUtils;

public class MetaConfirmListPlugin
extends AbstractListPlugin {
    private static final String OP_COMPARE = "compare";
    public static final String OP_CONFIRM = "confirm";
    public static final String OP_CANCEL = "cancel";
    public static final String ENTRYENTITY = "entryentity";
    public static final String SUBENTRYENTITY = "subentryentity";
    public static final String CONFIRMSTATUS = "confirmstatus";
    public static final String CONFIRMUSER = "confirmuser";
    public static final String CONFIRMDATE = "confirmdate";
    public static final String ENTRYCONFIRMSTATUS = "entryconfirmstatus";
    public static final String CONFIRM_STATUS = "1";
    public static final String CANCEL_STATUS = "0";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRows;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (StringUtils.equals((String)operate.getOperateKey(), (String)OP_COMPARE) && (listSelectedRows = this.getSelectedRows()).size() != 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e24\u884c\u6570\u636e\u8fdb\u884c\u5bf9\u6bd4\u3002", (String)"MetaConfirmListPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("operatetime desc");
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        boolean isSuccess;
        super.afterDoOperation(evt);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.refresh();
        String operateKey = evt.getOperateKey();
        boolean bl = isSuccess = evt.getOperationResult() != null && evt.getOperationResult().isSuccess();
        if (isSuccess) {
            FormOperate operate;
            ListSelectedRow listFocusRow;
            DynamicObject[] compareDatas;
            if (StringUtils.equals((String)operateKey, (String)OP_COMPARE)) {
                long metaverTar;
                ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
                DynamicObject[] selectDatas = this.getSelectRows(listSelectedRows);
                DynamicObject srcObj = selectDatas[0];
                DynamicObject tarObj = selectDatas[1];
                long metaverSrc = srcObj.getLong("metaver");
                if (metaverSrc > (metaverTar = tarObj.getLong("metaver"))) {
                    MetaLogDataHelper.showMerge(tarObj, srcObj, this.getView());
                } else {
                    MetaLogDataHelper.showMerge(srcObj, tarObj, this.getView());
                }
            } else if (StringUtils.equals((String)operateKey, (String)OP_CONFIRM)) {
                ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
                DynamicObject[] selectDatas = this.getSelectDatas(listSelectedRows);
                if (listSelectedRows.size() > 0) {
                    ArrayList entryIdList = new ArrayList();
                    List<Object> list = Arrays.asList(listSelectedRows.getPrimaryKeyValues());
                    Arrays.stream(selectDatas).forEach(selectRow -> selectRow.getDynamicObjectCollection(ENTRYENTITY).stream().forEach(o -> {
                        AtomicBoolean isNeedDealEntry = new AtomicBoolean(false);
                        entryIdList.add(String.valueOf(o.getPkValue()));
                        if (CollectionUtils.isNotEmpty((Collection)o.getDynamicObjectCollection(SUBENTRYENTITY))) {
                            o.getDynamicObjectCollection(SUBENTRYENTITY).stream().forEach(f -> {
                                if (list.contains(f.get("id"))) {
                                    isNeedDealEntry.set(true);
                                    f.set(CONFIRMSTATUS, (Object)CONFIRM_STATUS);
                                    f.set(CONFIRMUSER, (Object)RequestContext.get().getCurrUserId());
                                    f.set(CONFIRMDATE, (Object)new Date());
                                }
                            });
                        }
                        if (isNeedDealEntry.get()) {
                            entryIdList.add(String.valueOf(o.getPkValue()));
                        }
                    }));
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("entryid", entryIdList.stream().collect(Collectors.joining(",")));
                    operateOption.setVariableValue("op_key", operateKey);
                    OperationServiceHelper.executeOperate((String)"save", (String)"ricc_meta_confirm", (DynamicObject[])selectDatas, (OperateOption)operateOption);
                }
                billList.refresh();
            } else if (StringUtils.equals((String)operateKey, (String)OP_CANCEL)) {
                ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
                DynamicObject[] selectDatas = this.getSelectDatas(listSelectedRows);
                if (listSelectedRows.size() > 0) {
                    ArrayList entryIdList = new ArrayList();
                    List<Object> list = Arrays.asList(listSelectedRows.getPrimaryKeyValues());
                    Arrays.stream(selectDatas).forEach(selectRow -> selectRow.getDynamicObjectCollection(ENTRYENTITY).stream().forEach(o -> {
                        AtomicBoolean isNeedDealEntry = new AtomicBoolean(false);
                        if (CollectionUtils.isNotEmpty((Collection)o.getDynamicObjectCollection(SUBENTRYENTITY))) {
                            o.getDynamicObjectCollection(SUBENTRYENTITY).stream().forEach(f -> {
                                if (list.contains(f.get("id"))) {
                                    isNeedDealEntry.set(true);
                                    f.set(CONFIRMSTATUS, (Object)CANCEL_STATUS);
                                    f.set(CONFIRMUSER, null);
                                    f.set(CONFIRMDATE, null);
                                }
                            });
                        }
                        if (isNeedDealEntry.get()) {
                            entryIdList.add(String.valueOf(o.getPkValue()));
                        }
                    }));
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("entryid", entryIdList.stream().collect(Collectors.joining(",")));
                    operateOption.setVariableValue("op_key", operateKey);
                    OperationServiceHelper.executeOperate((String)"save", (String)"ricc_meta_confirm", (DynamicObject[])selectDatas, (OperateOption)operateOption);
                }
                billList.refresh();
            } else if (StringUtils.equals((String)operateKey, (String)"comparedetail") && (compareDatas = this.getCompareData((listFocusRow = (operate = (FormOperate)evt.getSource()).getListFocusRow()).getPrimaryKeyValue())) != null) {
                if (compareDatas.length == 2) {
                    long metaverTar;
                    DynamicObject srcObj = compareDatas[0];
                    DynamicObject tarObj = compareDatas[1];
                    long metaverSrc = srcObj.getLong("metaver");
                    if (metaverSrc > (metaverTar = tarObj.getLong("metaver"))) {
                        MetaLogDataHelper.showMerge(tarObj, srcObj, this.getView());
                    } else {
                        MetaLogDataHelper.showMerge(srcObj, tarObj, this.getView());
                    }
                } else {
                    DynamicObject srcObj = compareDatas[0];
                    long metaverSrc = srcObj.getLong("metaver");
                    MetaLogDataHelper.showMerge(srcObj, srcObj, this.getView());
                }
            }
        }
    }

    private DynamicObject[] getSelectDatas(ListSelectedRowCollection listSelectedRows) {
        return BusinessDataServiceHelper.load((String)"ricc_meta_confirm", (String)"billno,id, headerconfirmstatus,entryentity.id,entryentity.entryconfirmstatus,entryentity.subentryentity,subentryentity.id,subentryentity.confirmstatus,subentryentity.confirmuser,subentryentity.confirmdate,subentryentity.confirmstatus", (QFilter[])new QFilter[]{new QFilter("entryentity.subentryentity.id", "in", (Object)listSelectedRows.getPrimaryKeyValues())});
    }

    private DynamicObject[] getSelectRows(ListSelectedRowCollection listSelectedRows) {
        MainEntityType itemType = EntityMetadataCache.getDataEntityType((String)"ricc_meta_confirm_detail");
        return BusinessDataServiceHelper.load((Object[])listSelectedRows.getPrimaryKeyValues(), (DynamicObjectType)itemType);
    }

    private DynamicObject[] getCompareData(Object id) {
        MainEntityType itemType = EntityMetadataCache.getDataEntityType((String)"ricc_meta_confirm_detail");
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)itemType);
        if (obj != null) {
            OptionalInt indexOption;
            String metaId = obj.getString("metaid");
            String metaVer = obj.getString("metaver");
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)"ricc_meta_confirm_detail", (String)"id, metaid,metaver,data_tag,data,bizappid", (QFilter[])new QFilter[]{new QFilter("metaid", "=", (Object)metaId)}, (String)"metaver desc");
            if (objs != null && objs.length > 0 && (indexOption = IntStream.range(0, objs.length).filter(o -> StringUtils.equals((String)objs[o].getString("metaver"), (String)metaVer)).findFirst()).isPresent()) {
                int index = indexOption.getAsInt();
                DynamicObject srcMeta = objs[index];
                if (index == objs.length - 1) {
                    return new DynamicObject[]{srcMeta};
                }
                OptionalInt tarMetaver = IntStream.range(0, objs.length).filter(o -> objs[o].getLong("metaver") < Long.parseLong(metaVer)).findFirst();
                if (tarMetaver.isPresent()) {
                    return new DynamicObject[]{srcMeta, objs[tarMetaver.getAsInt()]};
                }
                return new DynamicObject[]{srcMeta};
            }
        }
        return null;
    }
}

