/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.metalog;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.sys.ricc.business.metadata.log.MetaLog;
import kd.sys.ricc.business.metadata.log.MetaLogDataHelper;
import kd.sys.ricc.common.util.StringUtils;

public class MetaDataLogFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(MetaDataLogFormPlugin.class);
    private static final String OP_COMPARE = "compare";
    private static final String LAST_DYM = "lastDym";
    private static final String BASE_DYM = "baseDym";
    public static final String ENTRY_ENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        String targetCenterUser;
        Long destAccountPk;
        Long tarVersion;
        Long srcVersion;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String metaId = (String)customParams.get("metaId");
        List<MetaLog> metaLog = this.getMetaLog(metaId, srcVersion = Long.valueOf(String.valueOf(customParams.get("srcVersion"))), tarVersion = Long.valueOf(String.valueOf(customParams.get("tarVersion"))), destAccountPk = Long.valueOf(String.valueOf(customParams.get("destAccountPk"))), targetCenterUser = (String)customParams.get("targetdatacenteruser"));
        if (metaLog.size() < 1) {
            return;
        }
        this.initEntry(metaLog);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid;
        int[] selectRows;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (StringUtils.equals((String)operate.getOperateKey(), (String)OP_COMPARE) && (selectRows = (entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY)).getSelectRows()).length != 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e24\u884c\u6570\u636e\u8fdb\u884c\u5bf9\u6bd4\u3002", (String)"MetaDataLogFormPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (StringUtils.equals((String)operateKey, (String)OP_COMPARE)) {
            long metaverTar;
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            DynamicObject srcObj = (DynamicObject)entryEntity.get(selectRows[0]);
            DynamicObject tarObj = (DynamicObject)entryEntity.get(selectRows[1]);
            long metaverSrc = srcObj.getLong("metaver");
            if (metaverSrc > (metaverTar = tarObj.getLong("metaver"))) {
                this.showMerge(tarObj, srcObj);
            } else {
                this.showMerge(srcObj, tarObj);
            }
        }
    }

    private void showMerge(DynamicObject lastObj, DynamicObject currentObj) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ricc_metadatadiff");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(LAST_DYM, (Object)lastObj.getString("data"));
        parameter.setCustomParam(BASE_DYM, (Object)currentObj.getString("data"));
        parameter.setCustomParam("bizappid", (Object)currentObj.getDynamicObject("bizappid").getString("number"));
        parameter.setCustomParam("newCommitId", (Object)currentObj.getString("metaver"));
        parameter.setCustomParam("oldCommitId", (Object)lastObj.getString("metaver"));
        parameter.setCustomParam("isNotShowTree", (Object)"false");
        this.getView().showForm(parameter);
    }

    private List<MetaLog> getMetaLog(String metaId, Long srcVersion, Long tarVersion, Long destAccountPk, String targetCenterUser) {
        CustomApiResult<List<MetaLog>> customApiResult = null;
        try {
            customApiResult = MetaLogDataHelper.getTarMetaLogDatas(Collections.singletonList(metaId), destAccountPk, targetCenterUser);
            if (!customApiResult.isStatus()) {
                this.getView().showErrorNotification(customApiResult.getMessage());
                return Collections.EMPTY_LIST;
            }
            List dataList = (List)customApiResult.getData();
            if (tarVersion != null && tarVersion != 0L && srcVersion != null && srcVersion != 0L) {
                dataList = dataList.stream().filter(o -> MetaDataLogFormPlugin.isBetween(srcVersion, tarVersion, o)).collect(Collectors.toList());
            }
            return dataList;
        }
        catch (Exception e) {
            logger.error("\u5143\u6570\u636e\u5dee\u5f02\u6bd4\u5bf9\u8bbf\u95ee\u76ee\u6807\u73af\u5883\u6570\u636e\u5931\u8d25", (Throwable)e);
            String error = String.format(ResManager.loadKDString((String)"\u8bbf\u95ee\u76ee\u6807\u73af\u5883\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u201c%2$s\u201d\uff0c\u9519\u8bef\u65e5\u5fd7TraceId\u201c%1$s\u201d", (String)"MetaDataLogFormPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]), RequestContext.get().getTraceId(), e.getMessage());
            this.getView().showErrorNotification(error);
            return Collections.EMPTY_LIST;
        }
    }

    private static boolean isBetween(Long srcVersion, Long tarVersion, MetaLog obj) {
        return Long.parseLong(obj.getMetaver()) >= tarVersion && Long.parseLong(obj.getMetaver()) <= srcVersion || Long.parseLong(obj.getMetaver()) >= srcVersion && Long.parseLong(obj.getMetaver()) <= tarVersion;
    }

    private void initEntry(List<MetaLog> metaLogs) {
        int[] indexes;
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        for (int index : indexes = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, metaLogs.size())) {
            MetaLog metaLog = metaLogs.get(index);
            this.getModel().setValue("isv", (Object)metaLog.getIsv(), index);
            this.getModel().setValue("type", (Object)metaLog.getType(), index);
            this.getModel().setValue("operator", (Object)metaLog.getOperator(), index);
            this.getModel().setValue("operatetime", (Object)metaLog.getOperateTime(), index);
            this.getModel().setValue("version", (Object)metaLog.getVersion(), index);
            this.getModel().setValue("content", (Object)metaLog.getContent(), index);
            this.getModel().setValue("version", (Object)metaLog.getVersion(), index);
            this.getModel().setValue("metaid", (Object)metaLog.getMetaId(), index);
            this.getModel().setValue("metanumber", (Object)metaLog.getMetaNumber(), index);
            this.getModel().setValue("metatype", (Object)metaLog.getMetaType(), index);
            this.getModel().setValue("data", (Object)metaLog.getData(), index);
            this.getModel().setValue("bizappid", (Object)metaLog.getBizAppId(), index);
            this.getModel().setValue("metaver", (Object)metaLog.getMetaver(), index);
        }
        this.getView().updateView(ENTRY_ENTITY);
    }
}

