/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.setting.account;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sys.ricc.common.util.ApiUtil;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.PermissionUtil;
import kd.sys.ricc.exception.RiccBizException;

public class DestAccountManageListPlugin
extends AbstractListPlugin {
    public static final String ACCOUNT_ID = "number";
    public static final String EVN_URL = "evnurl";
    private static final String ISDEFAULT = "isdefault";
    private static final String OP_SETDEFAULT = "setdefault";
    private static final String REPLACE_CONFIRM = "replace_confirm";
    private static final int NOTIFI_TIME = 5000;
    private static final String OP_TEST = "test";
    private static final String APP_SECURET = "appsecuret";
    private static final Log logger = LogFactory.getLog(DestAccountManageListPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String openStyle = (String)e.getFormShowParameter().getCustomParam("openStyle");
        if (!StringUtils.equals((CharSequence)openStyle, (CharSequence)"openStyle_f7")) {
            PermissionUtil.preOpenFormIsAdmin((PreOpenFormEventArgs)e);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate;
        String opKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && OP_SETDEFAULT.equals(opKey = (operate = (AbstractOperate)args.getSource()).getOperateKey())) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"DestAccountManageListPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            if (selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u518d\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"DestAccountManageListPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            Object pk = selectedRows.get(0).getPrimaryKeyValue();
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"ricc_destaccount");
            boolean isdefault = dyo.getBoolean(ISDEFAULT);
            if (!isdefault) {
                boolean exist = QueryServiceHelper.exists((String)"ricc_destaccount", (QFilter[])new QFilter[]{new QFilter(ISDEFAULT, "=", (Object)"1")});
                if (exist) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u9ed8\u8ba4\u7684\u8fde\u63a5\u6570\u636e\u4e2d\u5fc3\uff0c\u662f\u5426\u8fdb\u884c\u66ff\u6362\uff1f", (String)"DestAccountManageListPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(REPLACE_CONFIRM, (IFormPlugin)this));
                    this.getPageCache().put("selectedpk", String.valueOf(dyo.getPkValue()));
                    args.setCancel(true);
                } else {
                    dyo.set(ISDEFAULT, (Object)"1");
                    dyo.set("datacenter", dyo.get(ACCOUNT_ID));
                    OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ricc_destaccount", (DynamicObject[])new DynamicObject[]{dyo}, (OperateOption)OperateOption.create());
                    if (!result.isSuccess()) {
                        StringBuilder errorMessage = new StringBuilder();
                        errorMessage.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"DestAccountManageListPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0])).append(result.getMessage());
                        result.getAllErrorOrValidateInfo().forEach(errorMessage::append);
                        this.getView().showErrorNotification(errorMessage.toString());
                        return;
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f\u3002", (String)"DestAccountManageListPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    this.getView().updateView();
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u5df2\u7ecf\u662f\u9ed8\u8ba4\u6570\u636e\u4e86\u3002", (String)"DestAccountManageListPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.contains(REPLACE_CONFIRM) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String pk = this.getPageCache().get("selectedpk");
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"ricc_destaccount");
            dyo.set(ISDEFAULT, (Object)"1");
            dyo.set("datacenter", dyo.get(ACCOUNT_ID));
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ricc_destaccount", (DynamicObject[])new DynamicObject[]{dyo}, (OperateOption)OperateOption.create());
            List successPkIds = result.getSuccessPkIds();
            if (successPkIds != null && !successPkIds.isEmpty()) {
                DynamicObject[] accounts;
                QFilter filter = new QFilter("id", "!=", (Object)Long.parseLong(successPkIds.get(0).toString()));
                filter.and(ISDEFAULT, "=", (Object)"1");
                for (DynamicObject account : accounts = BusinessDataServiceHelper.load((String)"ricc_destaccount", (String)"id, isdefault", (QFilter[])filter.toArray())) {
                    account.set(ISDEFAULT, (Object)"0");
                }
                SaveServiceHelper.update((DynamicObject[])accounts);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f\u3002", (String)"DestAccountManageListPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
                this.getView().updateView();
            } else {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"DestAccountManageListPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0])).append(result.getMessage());
                result.getAllErrorOrValidateInfo().forEach(errorMessage::append);
                this.getView().showErrorNotification(errorMessage.toString());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)OP_TEST, (CharSequence)operateKey)) {
            ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
            if (listSelectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"DestAccountManageListPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            QFilter[] qFilter = new QFilter[]{new QFilter("id", "in", (Object)listSelectedRows.getPrimaryKeyValues())};
            DynamicObject destAccount = BusinessDataServiceHelper.loadSingle((String)"ricc_destaccount", (String)"id,name,number,appsecuret,evnurl", (QFilter[])qFilter);
            if (destAccount == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u52fe\u9009\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u4e86\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\u3002", (String)"DestAccountManageListPlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            String accountId = destAccount.getString(ACCOUNT_ID);
            String appsecuret = destAccount.getString(APP_SECURET);
            String evnurl = destAccount.getString(EVN_URL);
            try {
                ApiUtil.getAppToken((String)accountId, (String)evnurl, (String)appsecuret);
            }
            catch (RiccBizException e) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25,\u8bf7\u68c0\u67e5\u8fde\u63a5\u4fe1\u606f\u662f\u5426\u6b63\u786e\u3002", (String)"DestAccountManageListPlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]), CommonUtil.getExceptionDetailInfo((Throwable)e), MessageTypes.Default);
                logger.error(CommonUtil.getExceptionDetailInfo((Throwable)e));
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u6210\u529f\u3002", (String)"DestAccountManageListPlugin_9", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
    }
}

