/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.training;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sys.ricc.business.training.TrainCommonMethod;
import kd.sys.ricc.business.training.TrainConfigUtils;
import kd.sys.ricc.business.training.TrainCourseUtils;
import kd.sys.ricc.business.training.TrainInterfaceUtils;

public class ConsumerSecretConfigPlugin
extends AbstractFormPlugin
implements TrainCommonMethod {
    private static final Long CONFIG_ID = 2149986466523230208L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_confirm", "btn_copy", "btn_code"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("firststep", (Object)ResManager.loadKDString((String)"\u590d\u5236\u5f53\u524d\u4ea7\u54c1\u5e8f\u5217\u53f7", (String)"ConsumerSecretConfigPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
        this.getModel().setValue("secondstep", (Object)ResManager.loadKDString((String)"\u524d\u5f80\u91d1\u8776\u4e91\u00b7\u793e\u533a\uff0c\u901a\u8fc7\u4ea7\u54c1\u5e8f\u5217\u53f7\u83b7\u53d6\u5bc6\u94a5", (String)"ConsumerSecretConfigPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
        this.getModel().setValue("thirdstep", (Object)ResManager.loadKDString((String)"\u586b\u5199\u5bc6\u94a5", (String)"ConsumerSecretConfigPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "btn_confirm": {
                this.confirmBind();
                break;
            }
            case "btn_copy": {
                this.copyProduct();
                break;
            }
            case "btn_code": {
                this.skipCodePage();
                break;
            }
        }
    }

    private void confirmBind() {
        String secret = (String)this.getModel().getValue("secret");
        if (StringUtils.isEmpty((CharSequence)secret)) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("secret", secret);
        JSONObject jsonObject = TrainInterfaceUtils.doPostHttp(param, "/space-checklist/env-bind");
        if (TrainCourseUtils.checkIsInvokeFail(jsonObject)) {
            this.getView().showErrorNotification(jsonObject == null ? "" : jsonObject.getString("message"));
            return;
        }
        JSONObject dataMap = jsonObject.getJSONObject("data");
        String envId = dataMap.getString("envId");
        DynamicObject trainConfig = TrainConfigUtils.getTrainConfig();
        if (trainConfig == null) {
            trainConfig = BusinessDataServiceHelper.newDynamicObject((String)"ricc_trainconfig");
            trainConfig.set("id", (Object)CONFIG_ID);
        }
        trainConfig.set("secret", (Object)TrainConfigUtils.getEncryptString(secret));
        trainConfig.set("environmentid", (Object)TrainConfigUtils.getEncryptString(envId));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trainConfig});
        this.getView().returnDataToParent((Object)"success");
        this.getView().close();
    }

    private void copyProduct() {
        Map productInfo = LicenseServiceHelper.getProductInfo();
        String productNo = (String)productInfo.get("productNo");
        this.invokeFrontMethod("customcontrol", "copyText", productNo, "showSuccessText");
    }

    @Override
    public Map<String, Supplier<String>> getExecMap() {
        return new HashMap<String, Supplier<String>>(16);
    }

    private void skipCodePage() {
        this.getView().openUrl(TrainCourseUtils.skipLearnListPage());
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        if ("showSuccessText".equals(eventName)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"ConsumerSecretConfigPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
    }
}

