/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.training;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.sys.ricc.business.training.TrainCommonMethod;
import kd.sys.ricc.business.training.TrainCourseUtils;
import kd.sys.ricc.common.entity.ViewCourse;

public class ViewCoursePlugin
extends AbstractFormPlugin
implements TrainCommonMethod {
    private static final Log log = LogFactory.getLog(ViewCoursePlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        QFilter qFilter = new QFilter("id", "=", e.getFormShowParameter().getCustomParam("courseId"));
        if (!QueryServiceHelper.exists((String)"ricc_course", (QFilter[])qFilter.toArray())) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u83b7\u53d6\u8bfe\u7a0b\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u540c\u6b65\u8bfe\u7a0b\u540e\u91cd\u8bd5\u3002", (String)"ViewCoursePlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        String viewCourseJson = (String)this.getCustomFormParam("viewCourse");
        ViewCourse viewCourse = (ViewCourse)JSONObject.parseObject((String)viewCourseJson, ViewCourse.class);
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("sdkArgs", viewCourse);
        param.put("closeEvent", "close");
        this.updateFrontData("videocontrol", param);
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        if (eventName.startsWith("close_")) {
            this.getView().close();
        } else if (eventName.startsWith("updateCourseStatus_")) {
            QFilter qFilter;
            DynamicObject course;
            String courseId;
            JSONObject args = JSONObject.parseObject((String)eventArgs);
            Integer statusIndex = args.getInteger("status");
            String status = "";
            if (statusIndex != null) {
                switch (statusIndex) {
                    case 0: {
                        status = "unstart";
                        break;
                    }
                    case 1: {
                        status = "complete";
                        break;
                    }
                    case 2: {
                        status = "learning";
                        break;
                    }
                }
            }
            if (StringUtils.isNotEmpty((String)(courseId = (String)this.getCustomFormParam("course"))) && StringUtils.isNotEmpty((String)status) && !"unstart".equals(status) && (course = QueryServiceHelper.queryOne((String)"ricc_course", (String)"id", (QFilter[])(qFilter = new QFilter("courseid", "=", (Object)courseId)).toArray())) != null) {
                TrainCourseUtils.updateCourseStatus(course.getLong("id"), UserServiceHelper.getCurrentUserId(), status);
            }
        }
    }

    @Override
    public Map<String, Supplier<String>> getExecMap() {
        return new HashMap<String, Supplier<String>>(16);
    }
}

