/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.opplugin;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.common.enums.BaseDataRightEnum;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.PermissionUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;

public class ImplProjectGuideOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ImplProjectGuideOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("ispreset");
        e.getFieldKeys().add("controlled");
        e.getFieldKeys().add("page");
        e.getFieldKeys().add("rightpage");
        e.getFieldKeys().add("rely");
        e.getFieldKeys().add("relylevel");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        for (DynamicObject obj : e.getDataEntities()) {
            try {
                this.doProceesAppControlledList(operationKey, obj);
                successObjs.add(obj);
            }
            catch (KDBizException exp) {
                this.operationResult.addErrorInfo((OperateErrorInfo)CommonUtil.buildOpErrMessage((DynamicObject)obj, (KDBizException)exp));
            }
        }
        try (TXHandle txHandle = TX.required();){
            try {
                this.doBizRoleUpdate(e.getDataEntities(), e.getOperationKey());
            }
            catch (KDBizException exp) {
                txHandle.markRollback();
                logger.error("\u5904\u7406\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e\u9879\u52a0\u5165\u7981\u7528\u65b0\u589e\u548c\u7981\u7528\u4fee\u6539\u4e1a\u52a1\u89d2\u8272\u51fa\u9519\u3002", (Throwable)exp);
                this.operationResult.addErrorInfo((OperateErrorInfo)CommonUtil.buildOpErrMessage(null, (KDBizException)exp));
            }
            catch (Exception ec) {
                txHandle.markRollback();
                logger.error("\u5904\u7406\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e\u9879\u52a0\u5165\u7981\u7528\u65b0\u589e\u548c\u7981\u7528\u4fee\u6539\u4e1a\u52a1\u89d2\u8272\u51fa\u9519\u3002", (Throwable)ec);
                String message = ResManager.loadKDString((String)"\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e\u9879\u52a0\u5165\u7981\u7528\u65b0\u589e\u548c\u7981\u7528\u4fee\u6539\u4e1a\u52a1\u89d2\u8272\u5931\u8d25\u3002", (String)"ImplProjectGuideOp_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
                KDBizException kdBizException = new KDBizException(new ErrorCode("save_impguide_error", message + ec.getMessage()), new Object[0]);
                this.operationResult.addErrorInfo((OperateErrorInfo)CommonUtil.buildOpErrMessage(null, (KDBizException)kdBizException));
            }
        }
        e.setDataEntities(successObjs.toArray(new DynamicObject[0]));
    }

    private void doBizRoleUpdate(DynamicObject[] datas, String operationKey) {
        String basicsetchange = SysParaUtil.getChangePermType();
        if (BaseDataRightEnum.HAVE_NEWANDCHANGE_PERM.getVal().equals(basicsetchange) || BaseDataRightEnum.NO_DATA.getVal().equals(basicsetchange)) {
            return;
        }
        Map busRoleMap = PermissionUtil.getRiccBizRole();
        if (busRoleMap.size() < 2) {
            throw new KDBizException(new ErrorCode("save_impguide_error", ResManager.loadKDString((String)"\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e\u9879\u52a0\u5165\u7981\u7528\u65b0\u589e\u548c\u7981\u7528\u4fee\u6539\u4e1a\u52a1\u89d2\u8272\u5931\u8d25,\u53ef\u80fd\u662f\u73af\u5883\u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u5316\u914d\u7f6e\uff0c\u8bf7\u5148\u524d\u5f80\u3010\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u3011->\u3010\u57fa\u7840\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u914d\u7f6e\u76f8\u5173\u73af\u5883\u89d2\u8272\u540e\uff0c\u5728\u8fdb\u884c\u4fdd\u5b58", (String)"ImplProjectGuideOp_1", (String)"sys-ricc-platform", (Object[])new Object[0])), new Object[0]);
        }
        DynamicObject bizroledisAddPerm = (DynamicObject)busRoleMap.get(1407814994422136832L);
        DynamicObjectCollection bizroledisAddPermCollecction = bizroledisAddPerm.getDynamicObjectCollection("bizroledisperm");
        DynamicObject bizroledisEditPerm = (DynamicObject)busRoleMap.get(1407809474541912064L);
        DynamicObjectCollection bizroledisEditPermCollecction = bizroledisEditPerm.getDynamicObjectCollection("bizroledisperm");
        ArrayList<String> guidePageList = new ArrayList<String>(datas.length);
        for (DynamicObject oneGuide : datas) {
            guidePageList.add(oneGuide.getString("rightpage.id"));
        }
        DynamicObject[] bizPublishAppCollection = PermissionUtil.getPublishAppCollection(guidePageList);
        for (DynamicObject obj : datas) {
            String pageId = obj.getString("rightpage.id");
            String appId = obj.getString("rightpage.bizappid");
            if (obj.getBoolean("controlled") && !"delete".equals(operationKey) && !"disable".equals(operationKey)) {
                PermissionUtil.addOneGuideToDisablePerm((String)pageId, (String)appId, (DynamicObjectCollection)bizroledisEditPermCollecction, (String)"4715a0df000000ac");
                PermissionUtil.bizObjPublishAppToDisblePerm((String)pageId, (String)appId, (DynamicObject[])bizPublishAppCollection, (DynamicObjectCollection)bizroledisEditPermCollecction, (String)"4715a0df000000ac");
                PermissionUtil.addOneGuideToDisablePerm((String)pageId, (String)appId, (DynamicObjectCollection)bizroledisAddPermCollecction, (String)"47156aff000000ac");
                PermissionUtil.bizObjPublishAppToDisblePerm((String)pageId, (String)appId, (DynamicObject[])bizPublishAppCollection, (DynamicObjectCollection)bizroledisAddPermCollecction, (String)"47156aff000000ac");
                continue;
            }
            PermissionUtil.removeoneGuideFromDisablePerm((String)pageId, (DynamicObjectCollection)bizroledisEditPermCollecction);
            PermissionUtil.removeoneGuideFromDisablePerm((String)pageId, (DynamicObjectCollection)bizroledisAddPermCollecction);
        }
        bizroledisAddPerm.set("bizroledisperm", (Object)bizroledisAddPermCollecction);
        bizroledisEditPerm.set("bizroledisperm", (Object)bizroledisEditPermCollecction);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"perm_busirole", (DynamicObject[])new DynamicObject[]{bizroledisAddPerm, bizroledisEditPerm}, (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            String message = ResManager.loadKDString((String)"\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e\u9879\u52a0\u5165\u7981\u7528\u65b0\u589e\u548c\u7981\u7528\u4fee\u6539\u4e1a\u52a1\u89d2\u8272\u5931\u8d25\uff01\u8bf7\u91cd\u65b0\u4fdd\u5b58\uff0c\u5982\u8fd8\u662f\u62a5\u9519\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u9519\u8bef\u539f\u56e0\uff1a", (String)"ImplProjectGuideOp_2", (String)"sys-ricc-platform", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("save_impguide_error", message + operationResult.getMessage() + (operationResult.getAllErrorOrValidateInfo().isEmpty() ? "" : operationResult.getAllErrorOrValidateInfo().toString())), new Object[0]);
        }
    }

    private void doProceesAppControlledList(String operationKey, DynamicObject obj) {
        String number = obj.getString("number");
        String name = obj.getString("name");
        boolean controlled = obj.getBoolean("controlled");
        if (controlled) {
            QFilter delFilter;
            int delNumber;
            DynamicObject pageInfo = (DynamicObject)obj.get("page");
            if (pageInfo == null) {
                throw new KDBizException(new ErrorCode("error", String.format(ResManager.loadKDString((String)"\u7f16\u7801\uff1a%1$s \u540d\u79f0\uff1a%2$s \u7684\u5355\u636e\u672a\u7ed1\u5b9a\u9875\u9762", (String)"ImplProjectGuideOp_3", (String)"sys-ricc-platform", (Object[])new Object[0]), number, name)), new Object[0]);
            }
            String pageNumber = pageInfo.getString("number");
            String bizappid = pageInfo.getString("bizappid");
            DynamicObject appInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)bizappid, (String)"bos_devportal_bizapp");
            String appId = appInfo.getString("id");
            Set permSet = EntityMetadataCache.getPermissionItems((String)pageNumber);
            QFilter qFilter = new QFilter("page", "=", (Object)pageNumber);
            DynamicObject appcontrolledlist = BusinessDataServiceHelper.loadSingle((String)"ricc_appcontrolledlist", (String)"id,app,page,perm,opuser,createtime", (QFilter[])qFilter.toArray());
            if (!"delete".equals(operationKey)) {
                if (appcontrolledlist == null) {
                    appcontrolledlist = BusinessDataServiceHelper.newDynamicObject((String)"ricc_appcontrolledlist");
                }
                appcontrolledlist.set("app", (Object)appId);
                appcontrolledlist.set("page", (Object)pageNumber);
                appcontrolledlist.set("perm", (Object)StringUtils.join((Object[])permSet.toArray(), (String)","));
                appcontrolledlist.set("opuser", (Object)UserServiceHelper.getCurrentUserId());
                appcontrolledlist.set("createtime", (Object)System.currentTimeMillis());
                OperateOption option = OperateOption.create();
                OperationResult appOperationResult = SaveServiceHelper.saveOperate((String)"ricc_appcontrolledlist", (DynamicObject[])new DynamicObject[]{appcontrolledlist}, (OperateOption)option);
                if (!appOperationResult.isSuccess()) {
                    throw new KDBizException(new ErrorCode("save_impguide_error", String.format(ResManager.loadKDString((String)"\u7f16\u7801\uff1a%$1s \u540d\u79f0\uff1a%$2s \u751f\u6210\u53d7\u63a7\u6e05\u5355\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (String)"ImplProjectGuideOp_4", (String)"sys-ricc-platform", (Object[])new Object[0]), number, name)), new Object[0]);
                }
            } else if (appcontrolledlist != null && (delNumber = DeleteServiceHelper.delete((String)"ricc_appcontrolledlist", (QFilter[])(delFilter = new QFilter("id", "=", (Object)appcontrolledlist.getLong("id"))).toArray())) <= 0) {
                throw new KDBizException(new ErrorCode("save_impguide_error", String.format(ResManager.loadKDString((String)"\u7f16\u7801\uff1a%$1s \u540d\u79f0\uff1a%%2s \u53d7\u63a7\u6e05\u5355\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (String)"ImplProjectGuideOp_5", (String)"sys-ricc-platform", (Object[])new Object[0]), number, name)), new Object[0]);
            }
        }
    }
}

