/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.UrlUtil;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.bos.zip.ZipFile;
import kd.bos.zip.model.ZipParameters;
import kd.bos.zip.model.enums.AesKeyStrength;
import kd.bos.zip.model.enums.EncryptionMethod;
import kd.sys.ricc.exception.RiccBizException;
import org.apache.commons.io.FilenameUtils;

public class FileUtils {
    private static final int BUFFER_SIZE = 2048;

    private FileUtils() {
    }

    public static File createFile(String path) {
        return new File(path);
    }

    public static void addDownloadPermission(String formId, String urls, String appId) {
        String tempFileId = UrlUtil.getParam((String)urls, (String)"id");
        HashMap<String, String> refEntitiyMap = new HashMap<String, String>(3);
        refEntitiyMap.put("entityNum", formId);
        refEntitiyMap.put("appId", appId);
        refEntitiyMap.put("permissionItemId", "4730fc9f000007ae");
        DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(formId);
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 600);
    }

    public static String generateLocalPath() {
        String userHome = System.getProperty("user.home");
        String tempPath = String.valueOf(DB.genGlobalLongId());
        String localPath = userHome + File.separator + "KINGDEEDOWNLOAD" + File.separator + tempPath;
        return FileUtils.checkFilePath(localPath);
    }

    public static String checkFilePath(String path) {
        return path.replace("../", "#");
    }

    public static String getFileNameFromPath(String path) {
        return FilenameUtils.getName((String)path);
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name, boolean keepDirStructure) throws Exception {
        byte[] buf = new byte[2048];
        if (sourceFile.isFile()) {
            zos.putNextEntry(new ZipEntry(name));
            try (FileInputStream in = new FileInputStream(sourceFile);){
                int len;
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
            }
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (keepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if ("attach".equals(name)) {
                        keepDirStructure = true;
                    }
                    if (keepDirStructure) {
                        FileUtils.compress(file, zos, name + "/" + file.getName(), keepDirStructure);
                        continue;
                    }
                    FileUtils.compress(file, zos, file.getName(), keepDirStructure);
                }
            }
        }
    }

    public static void toZip(String srcDir, OutputStream out, boolean keepDirStructure) {
        try (ZipOutputStream zos = new ZipOutputStream(out, Charset.forName("GBK"));){
            File sourceFile = FileUtils.createFile(srcDir);
            FileUtils.compress(sourceFile, zos, sourceFile.getName(), keepDirStructure);
        }
        catch (Exception e) {
            throw new RiccBizException("zip error from CommonUtil", (Throwable)e);
        }
    }

    public static String dirToZip(String dirPath, String zipName) {
        String zipPath = FileUtils.generateLocalPath();
        File file = FileUtils.checkAndCreateDir(zipPath);
        String zipFullPath = zipPath + File.separator + zipName + ".zip";
        File zipfile = FileUtils.createFile(zipFullPath);
        try (FileOutputStream fos = new FileOutputStream(zipfile);){
            FileUtils.toZip(dirPath, fos, false);
        }
        catch (Exception e) {
            FileUtils.deleteLocalFile(file);
            String msgTpl = ResManager.loadKDString((String)"\u76ee\u5f55\u6253\u5305\u4e3azip\u5931\u8d25\uff1a", (String)"FileUtils_0", (String)"sys-ricc-common", (Object[])new Object[0]);
            throw new RiccBizException(msgTpl, (Throwable)e);
        }
        return zipFullPath;
    }

    public static ByteArrayOutputStream getFileOutputStream(String fileUrl) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        FileServiceFactory.getAttachmentFileService().download(fileUrl, (OutputStream)outputStream, "icc_httpclient");
        return outputStream;
    }

    public static File checkAndCreateDir(String path) {
        File file = FileUtils.createFile(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static void deleteLocalFile(File fileTemp) {
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)fileTemp);
        }
        catch (IOException e) {
            String msgTpl = ResManager.loadKDString((String)"\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5939\u5931\u8d25\u3002", (String)"FileUtils_1", (String)"sys-ricc-common", (Object[])new Object[0]);
            throw new RiccBizException(msgTpl, (Throwable)e);
        }
    }

    public static String getTempUrlFormFileUrl(String fileUrl, int timeout) {
        if (timeout <= 0) {
            timeout = 18000;
        }
        String tempFileUrl = null;
        try (ByteArrayOutputStream outputStream = FileUtils.getFileOutputStream(fileUrl);){
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            tempFileUrl = cache.saveAsUrl(fileUrl, outputStream.toByteArray(), timeout);
            if (tempFileUrl.startsWith("tempfile") && !tempFileUrl.contains("http")) {
                tempFileUrl = UrlService.getDomainContextUrl() + "/" + tempFileUrl;
            }
        }
        catch (Exception e) {
            String msgTpl = ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u6d41\u5931\u8d25\u3002", (String)"FileUtils_2", (String)"sys-ricc-common", (Object[])new Object[0]);
            throw new RiccBizException(msgTpl, (Throwable)e);
        }
        return tempFileUrl;
    }

    public static String getTempUrlFormLocalFile(String localFilePath, int timeout) {
        String tempFileUrl;
        if (timeout <= 0) {
            timeout = 18000;
        }
        String fileName = FileUtils.getFileNameFromPath(localFilePath);
        try (FileInputStream in = new FileInputStream(localFilePath);){
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            tempFileUrl = cache.saveAsUrl(fileName, (InputStream)in, timeout);
            if (tempFileUrl.startsWith("tempfile") && !tempFileUrl.contains("http")) {
                tempFileUrl = UrlService.getDomainContextUrl() + "/" + tempFileUrl;
            }
        }
        catch (Exception e) {
            String msgTpl = ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u6d41\u5931\u8d25\u3002", (String)"FileUtils_2", (String)"sys-ricc-common", (Object[])new Object[0]);
            throw new RiccBizException(msgTpl, (Throwable)e);
        }
        return tempFileUrl;
    }

    public static TempFileCacheDownloadable.Content getCacheContentFromTempUrl(String url) {
        String[] queryParams;
        if (StringUtils.isEmpty((CharSequence)url)) {
            String msgTpl = ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6url\u4e3a\u7a7a\u3002", (String)"FileUtils_3", (String)"sys-ricc-common", (Object[])new Object[0]);
            throw new RiccBizException(msgTpl);
        }
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        try {
            queryParams = new URL(url).getQuery().split("&");
        }
        catch (MalformedURLException e) {
            String msgTpl = ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6url\u89e3\u6790\u5931\u8d25\u3002%s", (String)"FileUtils_4", (String)"sys-ricc-common", (Object[])new Object[0]);
            throw new RiccBizException(msgTpl, (Throwable)e);
        }
        HashMap<String, String> downloadFileParams = new HashMap<String, String>(queryParams.length);
        for (String queryParam : queryParams) {
            String[] p = queryParam.split("=");
            downloadFileParams.put(p[0], p[1]);
        }
        return downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
    }

    public static String inputStreamToString(InputStream inputStream) {
        String resultStr = "";
        try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            resultStr = result.toString("UTF-8");
        }
        catch (IOException e) {
            String msgTpl = ResManager.loadKDString((String)"inputStream\u8f6c\u5b57\u7b26\u4e32\u5f02\u5e38\uff1a", (String)"FileUtils_5", (String)"sys-ricc-common", (Object[])new Object[0]);
            throw new RiccBizException(msgTpl, (Throwable)e);
        }
        return resultStr;
    }

    public static byte[] inputStreamToByte(InputStream is) {
        byte[] resBytes;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] bytes = new byte[1024];
            int i = -1;
            while ((i = is.read(bytes)) != -1) {
                bos.write(bytes, 0, i);
            }
            resBytes = bos.toByteArray();
        }
        catch (Exception e) {
            String msgTpl = ResManager.loadKDString((String)"inputStream\u8f6cbyte\u6570\u7ec4\u5f02\u5e38\u3002", (String)"FileUtils_8", (String)"sys-ricc-common", (Object[])new Object[0]);
            throw new RiccBizException(msgTpl, (Throwable)e);
        }
        return resBytes;
    }

    public static void writeMap2File(String fullFilePath, Map<String, Object> objectMap) {
        String jsonStr = JSON.toJSONString(objectMap);
        FileUtils.writeStr2File(fullFilePath, jsonStr);
    }

    public static void writeStr2File(String fullFilePath, String str) {
        File jsonFile = FileUtils.createFile(fullFilePath);
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();
             FileOutputStream out = new FileOutputStream(jsonFile);){
            output.write(str.getBytes(StandardCharsets.UTF_8));
            output.write(10);
            byte[] objBytes = output.toByteArray();
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(objBytes);){
                FileUtils.inputStreamToOutputStream(inputStream, out);
            }
        }
        catch (Exception e) {
            String msgTpl = ResManager.loadKDString((String)"----\u5199\u5165\u6587\u4ef6\u5931\u8d25----", (String)"FileUtils_6", (String)"sys-ricc-common", (Object[])new Object[0]);
            throw new RiccBizException(msgTpl, (Throwable)e);
        }
    }

    public static void inputStreamToOutputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int index;
        byte[] bytes = new byte[4096];
        while ((index = inputStream.read(bytes)) != -1) {
            outputStream.write(bytes, 0, index);
        }
    }

    public static void copyInputStreamToFile(InputStream source, File destination) throws IOException {
        org.apache.commons.io.FileUtils.copyToFile((InputStream)source, (File)destination);
    }

    public static String upload2FileService(String fileName, String formId, String appId, FileService fileService, InputStream in) {
        String path = FileUtils.getRandomFilePath(fileName, formId, appId);
        try {
            FileItem fi = new FileItem(fileName, path, in);
            path = fileService.upload(fi);
        }
        catch (Exception e) {
            String msgTpl = ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25: ", (String)"FileUtils_7", (String)"sys-ricc-common", (Object[])new Object[0]);
            throw new RiccBizException(msgTpl, (Throwable)e);
        }
        return path;
    }

    public static String getRandomFilePath(String fileName, String formId, String appId) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        return FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)appId, (String)formId, (Object)uuid, (String)FileUtils.replaceSpeSymbol(fileName));
    }

    private static String replaceSpeSymbol(String str) {
        for (int i = 0; i < AttachmentServiceHelper.SPECIAL_SYMBOLS.length; ++i) {
            if (!str.contains(AttachmentServiceHelper.SPECIAL_SYMBOLS[i])) continue;
            str = str.replace(AttachmentServiceHelper.SPECIAL_SYMBOLS[i], "_");
        }
        return str;
    }

    public static String getUploadPrefixPath() {
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMM"));
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        return String.format("/%s/%s/%s", tenantId, accountId, date);
    }

    public static void dirToZipAndEncrypt(String dirPath, String zipFullPath, String password) throws Exception {
        ZipFile zipFile = new ZipFile(zipFullPath);
        zipFile.setCharset(Charset.forName("GBK"));
        ZipParameters zipParameters = new ZipParameters();
        if (StringUtils.isNotBlank((CharSequence)password)) {
            zipFile.setPassword(password.toCharArray());
            zipParameters.setEncryptFiles(true);
            zipParameters.setEncryptionMethod(EncryptionMethod.AES);
            zipParameters.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_256);
        }
        File sourceFile = FileUtils.createFile(dirPath);
        FileUtils.addFileToZipFile(sourceFile, zipFile, sourceFile.getName(), false, zipParameters);
    }

    public static void addFileToZipFile(File sourceFile, ZipFile zipFile, String name, boolean keepDirStructure, ZipParameters zipParameters) throws Exception {
        if (sourceFile.isFile()) {
            zipFile.addFile(sourceFile, zipParameters);
        } else {
            File[] listFiles;
            if (keepDirStructure && !sourceFile.getName().equals(name)) {
                zipFile.addFolder(sourceFile, zipParameters);
            }
            if ((listFiles = sourceFile.listFiles()) == null || listFiles.length == 0) {
                return;
            }
            for (File file : listFiles) {
                FileUtils.addFileToZipFile(file, zipFile, name + File.separator + file.getName(), keepDirStructure, zipParameters);
            }
        }
    }

    public static String cleanString(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace("../", "#");
        StringBuilder cleanString = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            cleanString.append(FileUtils.cleanChar(str.charAt(i)));
        }
        return cleanString.toString();
    }

    private static char cleanChar(char c) {
        int i;
        for (i = 48; i < 58; ++i) {
            if (c != i) continue;
            return (char)i;
        }
        for (i = 65; i < 91; ++i) {
            if (c != i) continue;
            return (char)i;
        }
        for (i = 97; i < 123; ++i) {
            if (c != i) continue;
            return (char)i;
        }
        switch (c) {
            case 58: {
                return ':';
            }
            case 47: {
                return '/';
            }
            case 46: {
                return '.';
            }
            case 45: {
                return '-';
            }
            case 95: {
                return '_';
            }
            case 32: {
                return ' ';
            }
            case 126: {
                return '~';
            }
        }
        if ("\\".equals((char)c + "")) {
            return (char)c;
        }
        return '%';
    }
}

