/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kd.bos.dataentity.resource.ResManager;
import kd.sys.ricc.exception.RiccBizException;
import org.apache.commons.codec.binary.Hex;

public class Sha256Util {
    public static final String SHA_256 = "SHA-256";

    public static boolean signCheckForFile(File file, String sign) {
        if (file == null || sign == null || "".equals(sign)) {
            return false;
        }
        return sign.equals(Sha256Util.fileToSha256(file));
    }

    public static boolean signCheckForInputStream(InputStream inputStream, String sign) {
        if (inputStream == null || sign == null || "".equals(sign)) {
            return false;
        }
        return sign.equals(Sha256Util.inStreamToSha256(inputStream));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fileToSha256(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int length;
            MessageDigest sha256 = MessageDigest.getInstance(SHA_256);
            byte[] buffer = new byte[8192];
            while ((length = fileInputStream.read(buffer)) != -1) {
                sha256.update(buffer, 0, length);
            }
            String string = new String(Hex.encodeHex((byte[])sha256.digest()));
            return string;
        }
        catch (Exception e) {
            String msgTpl = ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6[%s]\u7684sha256\u7b7e\u540d\u5931\u8d25", (String)"Sha256Util_0", (String)"sys-ricc-common", (Object[])new Object[0]);
            throw new RiccBizException(String.format(msgTpl, file.getName()), (Throwable)e);
        }
    }

    public static String inStreamToSha256(InputStream in) {
        try {
            int length;
            MessageDigest sha256 = MessageDigest.getInstance(SHA_256);
            byte[] buffer = new byte[8192];
            while ((length = in.read(buffer)) != -1) {
                sha256.update(buffer, 0, length);
            }
            return new String(Hex.encodeHex((byte[])sha256.digest()));
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u8f93\u5165\u6d41\u7684sha256\u7b7e\u540d\u5931\u8d25\u3002", (String)"Sha256Util_1", (String)"sys-ricc-common", (Object[])new Object[0]);
            throw new RiccBizException(msg, (Throwable)e);
        }
    }

    public String digest(byte[] message) {
        try {
            MessageDigest sha = MessageDigest.getInstance(SHA_256);
            return new String(sha.digest(message), StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException e) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u4e0d\u652f\u6301SHA-256\u52a0\u5bc6\u7b97\u6cd5\u3002", (String)"Sha256Util_2", (String)"sys-ricc-common", (Object[])new Object[0]);
            throw new RuntimeException(msg, e);
        }
    }
}

