(function (KDApi, $) {
    //构造函数
    function MyComponent(model) {
        this._setModel(model)
    }

    MyComponent.prototype = {
        //绑定model
        _setModel: function (model) {
            this.model = model
        },
        //生命周期：初始化
        init: function (props) {
            setHtml(this.model, props);
        },
        //生命周期：更新
        update: function (props) {
            //页面加载的时候第一次不用执行
            if (this.model.inited) {
                updateHtml(this.model, props);
            } else {
                this.model.inited = true;
            }
        },
        //生命周期：销毁
        destoryed: function () {
        }
    }

    //初始化页面,该方法只会执行一次
    var setHtml = function (model, props) {
        KDApi.loadFile('./css/index.css', model, function () {
            KDApi.getTemplateStringByFilePath('./custom.html', model, {
                text: 'Hello, World!'
            }).then(function (result) {
                console.log(result);
                console.log("jsField Ok");
                model.dom.innerHTML = result;
                updateHtml(model, props);
            })
        })
    }

    //监听对象发生变化则更新页面
    var updateHtml = function (model, props) {
        console.log("updatehtml: " + writeObj(props.data));
        if (!props || !props.data || !props.data.frontMethod) {
            console.log("return");
            return;
        }
        console.log("getFrontMethod: " + props.data.frontMethod);
        //调用前端方法
        invokeFrontMethod(model, props.data);
    }

    var writeObj = function(obj){
        var description = "";
        for(var i in obj){
            var property=obj[i];
            description+=i+" = "+property+"\n";
        }
        return description;
    }

    var invokeFrontMethod = function (model, propData) {
        var frontMethod = propData.frontMethod;
        var retCallBackData;
        switch (frontMethod) {
            case "copyText":
                copyText(propData.dataObject);
                break;
            default:
                break;
        }
        console.log("invokeFrontMethod: " + frontMethod);

        if (propData.callbackEndMethod) {
            console.log("propData.callbackEndMethod: " + propData.callbackEndMethod);
            if (retCallBackData == "" || retCallBackData == undefined || typeof(retCallBackData) == undefined) {
                console.log("propData.callbackEndMethod: without retCallBackData");
                model.invoke(propData.callbackEndMethod);
            } else {
                console.log("propData.callbackEndMethod：with retCallBackData");
                model.invoke(propData.callbackEndMethod, retCallBackData);
            }
        }
    }

    var copyText = function (copyInfo) {
        var copyInput = document.createElement("input");
        copyInput.type = "text";
        copyInput.value = copyInfo;
        document.body.appendChild(copyInput);
        copyInput.select();

        document.execCommand('Copy');
        document.body.removeChild(copyInput);
    }

    //注册自定义控件
    window.KDApi.register('ricc_common_method', MyComponent, {
        isMulLang: true
    })
})(window.KDApi, jQuery)