﻿(function (KDApi, $) {
  // 构造函数
  function MyComponent (model) {
    this._setModel(model)
  }

  var themeColor
  MyComponent.prototype = {
    // 绑定model
    _setModel: function (model) {
      this.model = model
    },
    // 生命周期：初始化
    init: function (props) {
      console.log('-----init', this.model, props)
      themeColor = getThemeColor(props.themeColor)
      setHtml(this.model, props)
    },
    // 生命周期：更新
    update: function (props) {
      console.log('-----update', this.model, props)
      themeColor = getThemeColor(props.theme)
      updateHtml(this.model, props)
    },
    // 生命周期：销毁
    destoryed: function () {
      console.log('-----destoryed', this.model)
    }

  }

  // 加载文件和模板
  var setHtml = function (model, props, isUpdate) {
    var cssHref = KDApi.getNameSpace(model) + './css/delLabel.css'
    if ($('link[href="' + cssHref + '"]').length === 0) {
      // 加载css文件
      KDApi.loadFile('./css/delLabel.css', model, function () {
        updateHtml(model, props)
      })
    }
    // 加载模板
    updateHtml(model, props)
  }

  var updateHtml = function (model, props) {
    // 模板字符串
    var template = '<div class="hr-delLabel" title="<%= text %>">' +
                            '<div class="hr-delLabel-text">' +
                                '<%= text %>' +
                            '</div>' +
                            '<div class="hr-delLabel-icon"></div>' +
                        '</div>'
    // 根据接收的参数将字符串模板转为innerHTML
    var result = KDApi.getHTMLStringBytemplate(template, {
      text: props.data && props.data.get('text') ? props.data.get('text') : model.configItems ? model.configItems.getIn([0, 'value']) : '标签'
    })
    model.dom.innerHTML = result
    // 绑定DOM操作事件
    initEvent(model, props)
  }

  // 获取主题色
  function getThemeColor (themeColor) {
    switch (themeColor) {
      case 'blue':
        return '#5582F3'
      case 'green':
        return '#29C392'
      case 'orange':
        return '#FC8555'
      case 'purple':
        return '#6869FB'
      default:
        return '#5582F3'
    }
  }
  // DOM节点操作函数
  var initEvent = function (model, props) {
    $(model.dom).css({
      'overflow': 'visible'
    })
    $('.hr-delLabel', model.dom).css({
      'width': model.dom.style.width,
      'height': model.dom.style.height,
      'font-size': model.dom.style.fontSize !== '' ? model.dom.style.fontSize : '12px',
      'text-align': model.dom.style.textAlign,
      'overflow': 'visible'
    }).click(function () {
      model.invoke('click', '')
    }).mouseenter(function () {
      $('.hr-delLabel-icon', model.dom).css({
        'background-color': themeColor,
        'color': '#ffffff'
      })
      $('.hr-delLabel', model.dom).css({
        'border-color': themeColor
      })
    }).mouseleave(function () {
      $('.hr-delLabel-icon', model.dom).css({
        'background-color': 'transparent',
        'color': '#838383'
      })
      $('.hr-delLabel', model.dom).css({
        'border-color': '#CCCCCC'
      })
    })
    $('.hr-delLabel-text', model.dom).css({
      'width': parseInt(model.dom.style.width) - 19 + 'px',
      'line-height': model.dom.style.height
    })
  }
  console.log('-----------------init')
  // 注册自定义控件
  KDApi.register('dellabel', MyComponent)
})(window.KDApi, jQuery)
